/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * A machine type resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MachineType extends GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * The deprecation status associated with this machine type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeprecationStatus deprecated;

  /**
   * An optional textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Count of CPUs exposed to the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer guestCpus;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Space allotted for the image, defined in GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer imageSpaceGb;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Maximum persistent disks allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer maximumPersistentDisks;

  /**
   * Maximum total persistent disks size (GB) allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long maximumPersistentDisksSizeGb;

  /**
   * Physical memory assigned to the instance, defined in MB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer memoryMb;

  /**
   * Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * List of extended scratch disks assigned to the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ScratchDisks> scratchDisks;

  static {
    // hack to force ProGuard to consider ScratchDisks used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ScratchDisks.class);
  }

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Url of the zone where the machine type resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String zone;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public MachineType setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * The deprecation status associated with this machine type.
   * The value returned may be {@code null}.
   */
  public DeprecationStatus getDeprecated() {
    return deprecated;
  }

  /**
   * The deprecation status associated with this machine type.
   * The value set may be {@code null}.
   */
  public MachineType setDeprecated(DeprecationStatus deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * An optional textual description of the resource.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource.
   * The value set may be {@code null}.
   */
  public MachineType setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Count of CPUs exposed to the instance.
   * The value returned may be {@code null}.
   */
  public Integer getGuestCpus() {
    return guestCpus;
  }

  /**
   * Count of CPUs exposed to the instance.
   * The value set may be {@code null}.
   */
  public MachineType setGuestCpus(Integer guestCpus) {
    this.guestCpus = guestCpus;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public MachineType setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Space allotted for the image, defined in GB.
   * The value returned may be {@code null}.
   */
  public Integer getImageSpaceGb() {
    return imageSpaceGb;
  }

  /**
   * Space allotted for the image, defined in GB.
   * The value set may be {@code null}.
   */
  public MachineType setImageSpaceGb(Integer imageSpaceGb) {
    this.imageSpaceGb = imageSpaceGb;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public MachineType setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Maximum persistent disks allowed.
   * The value returned may be {@code null}.
   */
  public Integer getMaximumPersistentDisks() {
    return maximumPersistentDisks;
  }

  /**
   * Maximum persistent disks allowed.
   * The value set may be {@code null}.
   */
  public MachineType setMaximumPersistentDisks(Integer maximumPersistentDisks) {
    this.maximumPersistentDisks = maximumPersistentDisks;
    return this;
  }

  /**
   * Maximum total persistent disks size (GB) allowed.
   * The value returned may be {@code null}.
   */
  public Long getMaximumPersistentDisksSizeGb() {
    return maximumPersistentDisksSizeGb;
  }

  /**
   * Maximum total persistent disks size (GB) allowed.
   * The value set may be {@code null}.
   */
  public MachineType setMaximumPersistentDisksSizeGb(Long maximumPersistentDisksSizeGb) {
    this.maximumPersistentDisksSizeGb = maximumPersistentDisksSizeGb;
    return this;
  }

  /**
   * Physical memory assigned to the instance, defined in MB.
   * The value returned may be {@code null}.
   */
  public Integer getMemoryMb() {
    return memoryMb;
  }

  /**
   * Physical memory assigned to the instance, defined in MB.
   * The value set may be {@code null}.
   */
  public MachineType setMemoryMb(Integer memoryMb) {
    this.memoryMb = memoryMb;
    return this;
  }

  /**
   * Name of the resource.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource.
   * The value set may be {@code null}.
   */
  public MachineType setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * List of extended scratch disks assigned to the instance.
   * The value returned may be {@code null}.
   */
  public java.util.List<ScratchDisks> getScratchDisks() {
    return scratchDisks;
  }

  /**
   * List of extended scratch disks assigned to the instance.
   * The value set may be {@code null}.
   */
  public MachineType setScratchDisks(java.util.List<ScratchDisks> scratchDisks) {
    this.scratchDisks = scratchDisks;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public MachineType setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Url of the zone where the machine type resides (output only).
   * The value returned may be {@code null}.
   */
  public String getZone() {
    return zone;
  }

  /**
   * Url of the zone where the machine type resides (output only).
   * The value set may be {@code null}.
   */
  public MachineType setZone(String zone) {
    this.zone = zone;
    return this;
  }

  /**
   * Model definition for MachineTypeScratchDisks.
   */
  public static final class ScratchDisks extends GenericJson {

    /**
     * Size of the scratch disk, defined in GB.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Integer diskGb;

    /**
     * Size of the scratch disk, defined in GB.
     * The value returned may be {@code null}.
     */
    public Integer getDiskGb() {
      return diskGb;
    }

    /**
     * Size of the scratch disk, defined in GB.
     * The value set may be {@code null}.
     */
    public ScratchDisks setDiskGb(Integer diskGb) {
      this.diskGb = diskGb;
      return this;
    }

  }

}
