/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * An operation resource, used to manage asynchronous API requests.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Operation extends GenericJson {

  /**
   * An optional identifier specified by the client when the mutation was initiated. Must be unique
   * for all operation resources in the project (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String clientOperationId;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * The time that this operation was completed. This is in RFC 3339 format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * If errors occurred during processing of this operation, this field will be populated (output
   * only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Error error;

  /**
   * If operation fails, the HTTP error message returned, e.g. NOT FOUND. (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String httpErrorMessage;

  /**
   * If operation fails, the HTTP error status code returned, e.g. 404. (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer httpErrorStatusCode;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * The time that this operation was requested. This is in RFC 3339 format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String insertTime;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Type of the operation. Examples include "insert", "update", and "delete" (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String operationType;

  /**
   * An optional progress indicator that ranges from 0 to 100. There is no requirement that this be
   * linear or support any granularity of operations. This should not be used to guess at when the
   * operation will be complete. This number should be monotonically increasing as the operation
   * progresses (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer progress;

  /**
   * URL of the region where the operation resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String region;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The time that this operation was started by the server. This is in RFC 3339 format (output
   * only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * Status of the operation. Can be one of the following: "PENDING", "RUNNING", or "DONE" (output
   * only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String status;

  /**
   * An optional textual description of the current status of the operation (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String statusMessage;

  /**
   * Unique target id which identifies a particular incarnation of the target (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong targetId;

  /**
   * URL of the resource the operation is mutating (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String targetLink;

  /**
   * User who requested the operation, for example "user@example.com" (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String user;

  /**
   * If warning messages generated during processing of this operation, this field will be populated
   * (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Warnings> warnings;

  static {
    // hack to force ProGuard to consider Warnings used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Warnings.class);
  }

  /**
   * URL of the zone where the operation resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String zone;

  /**
   * An optional identifier specified by the client when the mutation was initiated. Must be unique
   * for all operation resources in the project (output only).
   * The value returned may be {@code null}.
   */
  public String getClientOperationId() {
    return clientOperationId;
  }

  /**
   * An optional identifier specified by the client when the mutation was initiated. Must be unique
   * for all operation resources in the project (output only).
   * The value set may be {@code null}.
   */
  public Operation setClientOperationId(String clientOperationId) {
    this.clientOperationId = clientOperationId;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Operation setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * The time that this operation was completed. This is in RFC 3339 format (output only).
   * The value returned may be {@code null}.
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * The time that this operation was completed. This is in RFC 3339 format (output only).
   * The value set may be {@code null}.
   */
  public Operation setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * If errors occurred during processing of this operation, this field will be populated (output
   * only).
   * The value returned may be {@code null}.
   */
  public Error getError() {
    return error;
  }

  /**
   * If errors occurred during processing of this operation, this field will be populated (output
   * only).
   * The value set may be {@code null}.
   */
  public Operation setError(Error error) {
    this.error = error;
    return this;
  }

  /**
   * If operation fails, the HTTP error message returned, e.g. NOT FOUND. (output only).
   * The value returned may be {@code null}.
   */
  public String getHttpErrorMessage() {
    return httpErrorMessage;
  }

  /**
   * If operation fails, the HTTP error message returned, e.g. NOT FOUND. (output only).
   * The value set may be {@code null}.
   */
  public Operation setHttpErrorMessage(String httpErrorMessage) {
    this.httpErrorMessage = httpErrorMessage;
    return this;
  }

  /**
   * If operation fails, the HTTP error status code returned, e.g. 404. (output only).
   * The value returned may be {@code null}.
   */
  public Integer getHttpErrorStatusCode() {
    return httpErrorStatusCode;
  }

  /**
   * If operation fails, the HTTP error status code returned, e.g. 404. (output only).
   * The value set may be {@code null}.
   */
  public Operation setHttpErrorStatusCode(Integer httpErrorStatusCode) {
    this.httpErrorStatusCode = httpErrorStatusCode;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Operation setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * The time that this operation was requested. This is in RFC 3339 format (output only).
   * The value returned may be {@code null}.
   */
  public String getInsertTime() {
    return insertTime;
  }

  /**
   * The time that this operation was requested. This is in RFC 3339 format (output only).
   * The value set may be {@code null}.
   */
  public Operation setInsertTime(String insertTime) {
    this.insertTime = insertTime;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Operation setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource (output only).
   * The value set may be {@code null}.
   */
  public Operation setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Type of the operation. Examples include "insert", "update", and "delete" (output only).
   * The value returned may be {@code null}.
   */
  public String getOperationType() {
    return operationType;
  }

  /**
   * Type of the operation. Examples include "insert", "update", and "delete" (output only).
   * The value set may be {@code null}.
   */
  public Operation setOperationType(String operationType) {
    this.operationType = operationType;
    return this;
  }

  /**
   * An optional progress indicator that ranges from 0 to 100. There is no requirement that this be
   * linear or support any granularity of operations. This should not be used to guess at when the
   * operation will be complete. This number should be monotonically increasing as the operation
   * progresses (output only).
   * The value returned may be {@code null}.
   */
  public Integer getProgress() {
    return progress;
  }

  /**
   * An optional progress indicator that ranges from 0 to 100. There is no requirement that this be
   * linear or support any granularity of operations. This should not be used to guess at when the
   * operation will be complete. This number should be monotonically increasing as the operation
   * progresses (output only).
   * The value set may be {@code null}.
   */
  public Operation setProgress(Integer progress) {
    this.progress = progress;
    return this;
  }

  /**
   * URL of the region where the operation resides (output only).
   * The value returned may be {@code null}.
   */
  public String getRegion() {
    return region;
  }

  /**
   * URL of the region where the operation resides (output only).
   * The value set may be {@code null}.
   */
  public Operation setRegion(String region) {
    this.region = region;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Operation setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The time that this operation was started by the server. This is in RFC 3339 format (output
   * only).
   * The value returned may be {@code null}.
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * The time that this operation was started by the server. This is in RFC 3339 format (output
   * only).
   * The value set may be {@code null}.
   */
  public Operation setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Status of the operation. Can be one of the following: "PENDING", "RUNNING", or "DONE" (output
   * only).
   * The value returned may be {@code null}.
   */
  public String getStatus() {
    return status;
  }

  /**
   * Status of the operation. Can be one of the following: "PENDING", "RUNNING", or "DONE" (output
   * only).
   * The value set may be {@code null}.
   */
  public Operation setStatus(String status) {
    this.status = status;
    return this;
  }

  /**
   * An optional textual description of the current status of the operation (output only).
   * The value returned may be {@code null}.
   */
  public String getStatusMessage() {
    return statusMessage;
  }

  /**
   * An optional textual description of the current status of the operation (output only).
   * The value set may be {@code null}.
   */
  public Operation setStatusMessage(String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

  /**
   * Unique target id which identifies a particular incarnation of the target (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getTargetId() {
    return targetId;
  }

  /**
   * Unique target id which identifies a particular incarnation of the target (output only).
   * The value set may be {@code null}.
   */
  public Operation setTargetId(UnsignedLong targetId) {
    this.targetId = targetId;
    return this;
  }

  /**
   * URL of the resource the operation is mutating (output only).
   * The value returned may be {@code null}.
   */
  public String getTargetLink() {
    return targetLink;
  }

  /**
   * URL of the resource the operation is mutating (output only).
   * The value set may be {@code null}.
   */
  public Operation setTargetLink(String targetLink) {
    this.targetLink = targetLink;
    return this;
  }

  /**
   * User who requested the operation, for example "user@example.com" (output only).
   * The value returned may be {@code null}.
   */
  public String getUser() {
    return user;
  }

  /**
   * User who requested the operation, for example "user@example.com" (output only).
   * The value set may be {@code null}.
   */
  public Operation setUser(String user) {
    this.user = user;
    return this;
  }

  /**
   * If warning messages generated during processing of this operation, this field will be populated
   * (output only).
   * The value returned may be {@code null}.
   */
  public java.util.List<Warnings> getWarnings() {
    return warnings;
  }

  /**
   * If warning messages generated during processing of this operation, this field will be populated
   * (output only).
   * The value set may be {@code null}.
   */
  public Operation setWarnings(java.util.List<Warnings> warnings) {
    this.warnings = warnings;
    return this;
  }

  /**
   * URL of the zone where the operation resides (output only).
   * The value returned may be {@code null}.
   */
  public String getZone() {
    return zone;
  }

  /**
   * URL of the zone where the operation resides (output only).
   * The value set may be {@code null}.
   */
  public Operation setZone(String zone) {
    this.zone = zone;
    return this;
  }

  /**
   * If errors occurred during processing of this operation, this field will be populated (output
   * only).
   */
  public static final class Error extends GenericJson {

    /**
     * The array of errors encountered while processing this operation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Errors> errors;

    static {
      // hack to force ProGuard to consider Errors used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Errors.class);
    }

    /**
     * The array of errors encountered while processing this operation.
     * The value returned may be {@code null}.
     */
    public java.util.List<Errors> getErrors() {
      return errors;
    }

    /**
     * The array of errors encountered while processing this operation.
     * The value set may be {@code null}.
     */
    public Error setErrors(java.util.List<Errors> errors) {
      this.errors = errors;
      return this;
    }

    /**
     * Model definition for OperationErrorErrors.
     */
    public static final class Errors extends GenericJson {

      /**
       * The error type identifier for this error.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String code;

      /**
       * Indicates the field in the request which caused the error. This property is optional.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String location;

      /**
       * An optional, human-readable error message.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String message;

      /**
       * The error type identifier for this error.
       * The value returned may be {@code null}.
       */
      public String getCode() {
        return code;
      }

      /**
       * The error type identifier for this error.
       * The value set may be {@code null}.
       */
      public Errors setCode(String code) {
        this.code = code;
        return this;
      }

      /**
       * Indicates the field in the request which caused the error. This property is optional.
       * The value returned may be {@code null}.
       */
      public String getLocation() {
        return location;
      }

      /**
       * Indicates the field in the request which caused the error. This property is optional.
       * The value set may be {@code null}.
       */
      public Errors setLocation(String location) {
        this.location = location;
        return this;
      }

      /**
       * An optional, human-readable error message.
       * The value returned may be {@code null}.
       */
      public String getMessage() {
        return message;
      }

      /**
       * An optional, human-readable error message.
       * The value set may be {@code null}.
       */
      public Errors setMessage(String message) {
        this.message = message;
        return this;
      }

    }
  }

  /**
   * Model definition for OperationWarnings.
   */
  public static final class Warnings extends GenericJson {

    /**
     * The warning type identifier for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String code;

    /**
     * Metadata for this warning in 'key: value' format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Data> data;

    static {
      // hack to force ProGuard to consider Data used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Data.class);
    }

    /**
     * Optional human-readable details for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String message;

    /**
     * The warning type identifier for this warning.
     * The value returned may be {@code null}.
     */
    public String getCode() {
      return code;
    }

    /**
     * The warning type identifier for this warning.
     * The value set may be {@code null}.
     */
    public Warnings setCode(String code) {
      this.code = code;
      return this;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * The value returned may be {@code null}.
     */
    public java.util.List<Data> getData() {
      return data;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * The value set may be {@code null}.
     */
    public Warnings setData(java.util.List<Data> data) {
      this.data = data;
      return this;
    }

    /**
     * Optional human-readable details for this warning.
     * The value returned may be {@code null}.
     */
    public String getMessage() {
      return message;
    }

    /**
     * Optional human-readable details for this warning.
     * The value set may be {@code null}.
     */
    public Warnings setMessage(String message) {
      this.message = message;
      return this;
    }

    /**
     * Model definition for OperationWarningsData.
     */
    public static final class Data extends GenericJson {

      /**
       * A key for the warning data.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String key;

      /**
       * A warning data value corresponding to the key.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String value;

      /**
       * A key for the warning data.
       * The value returned may be {@code null}.
       */
      public String getKey() {
        return key;
      }

      /**
       * A key for the warning data.
       * The value set may be {@code null}.
       */
      public Data setKey(String key) {
        this.key = key;
        return this;
      }

      /**
       * A warning data value corresponding to the key.
       * The value returned may be {@code null}.
       */
      public String getValue() {
        return value;
      }

      /**
       * A warning data value corresponding to the key.
       * The value set may be {@code null}.
       */
      public Data setValue(String value) {
        this.value = value;
        return this;
      }

    }
  }

}
