/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * A zone resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Zone extends GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * The deprecation status associated with this zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeprecationStatus deprecated;

  /**
   * Textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Scheduled maintenance windows for the zone. When the zone is in a maintenance window, all
   * resources which reside in the zone will be unavailable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MaintenanceWindows> maintenanceWindows;

  static {
    // hack to force ProGuard to consider MaintenanceWindows used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(MaintenanceWindows.class);
  }

  /**
   * Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Quotas assigned to this zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Quota> quotas;

  static {
    // hack to force ProGuard to consider Quota used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Quota.class);
  }

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Status of the zone. "UP" or "DOWN".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String status;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Zone setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * The deprecation status associated with this zone.
   * The value returned may be {@code null}.
   */
  public DeprecationStatus getDeprecated() {
    return deprecated;
  }

  /**
   * The deprecation status associated with this zone.
   * The value set may be {@code null}.
   */
  public Zone setDeprecated(DeprecationStatus deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * Textual description of the resource.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * Textual description of the resource.
   * The value set may be {@code null}.
   */
  public Zone setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Zone setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Zone setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Scheduled maintenance windows for the zone. When the zone is in a maintenance window, all
   * resources which reside in the zone will be unavailable.
   * The value returned may be {@code null}.
   */
  public java.util.List<MaintenanceWindows> getMaintenanceWindows() {
    return maintenanceWindows;
  }

  /**
   * Scheduled maintenance windows for the zone. When the zone is in a maintenance window, all
   * resources which reside in the zone will be unavailable.
   * The value set may be {@code null}.
   */
  public Zone setMaintenanceWindows(java.util.List<MaintenanceWindows> maintenanceWindows) {
    this.maintenanceWindows = maintenanceWindows;
    return this;
  }

  /**
   * Name of the resource.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource.
   * The value set may be {@code null}.
   */
  public Zone setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Quotas assigned to this zone.
   * The value returned may be {@code null}.
   */
  public java.util.List<Quota> getQuotas() {
    return quotas;
  }

  /**
   * Quotas assigned to this zone.
   * The value set may be {@code null}.
   */
  public Zone setQuotas(java.util.List<Quota> quotas) {
    this.quotas = quotas;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Zone setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Status of the zone. "UP" or "DOWN".
   * The value returned may be {@code null}.
   */
  public String getStatus() {
    return status;
  }

  /**
   * Status of the zone. "UP" or "DOWN".
   * The value set may be {@code null}.
   */
  public Zone setStatus(String status) {
    this.status = status;
    return this;
  }

  /**
   * Model definition for ZoneMaintenanceWindows.
   */
  public static final class MaintenanceWindows extends GenericJson {

    /**
     * Begin time of the maintenance window, in RFC 3339 format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String beginTime;

    /**
     * Textual description of the maintenance window.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String description;

    /**
     * End time of the maintenance window, in RFC 3339 format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String endTime;

    /**
     * Name of the maintenance window.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String name;

    /**
     * Begin time of the maintenance window, in RFC 3339 format.
     * The value returned may be {@code null}.
     */
    public String getBeginTime() {
      return beginTime;
    }

    /**
     * Begin time of the maintenance window, in RFC 3339 format.
     * The value set may be {@code null}.
     */
    public MaintenanceWindows setBeginTime(String beginTime) {
      this.beginTime = beginTime;
      return this;
    }

    /**
     * Textual description of the maintenance window.
     * The value returned may be {@code null}.
     */
    public String getDescription() {
      return description;
    }

    /**
     * Textual description of the maintenance window.
     * The value set may be {@code null}.
     */
    public MaintenanceWindows setDescription(String description) {
      this.description = description;
      return this;
    }

    /**
     * End time of the maintenance window, in RFC 3339 format.
     * The value returned may be {@code null}.
     */
    public String getEndTime() {
      return endTime;
    }

    /**
     * End time of the maintenance window, in RFC 3339 format.
     * The value set may be {@code null}.
     */
    public MaintenanceWindows setEndTime(String endTime) {
      this.endTime = endTime;
      return this;
    }

    /**
     * Name of the maintenance window.
     * The value returned may be {@code null}.
     */
    public String getName() {
      return name;
    }

    /**
     * Name of the maintenance window.
     * The value set may be {@code null}.
     */
    public MaintenanceWindows setName(String name) {
      this.name = name;
      return this;
    }

  }

}
