/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This file was generated.
 *  with google-apis-code-generator 1.4.1 (build: 2013-08-14 15:32:06 UTC)
 *  on 2013-08-19 at 21:27:44 UTC 
 */

package com.google.api.services.compute;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.common.base.Preconditions;

/**
 * Service definition for Compute (v1beta15).
 *
 * <p>
 * API for the Google Compute Engine service.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/compute/docs/reference/v1beta15" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link ComputeRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * <p>
 * Upgrade warning: this class now extends {@link AbstractGoogleJsonClient}, whereas in prior
 * version 1.8 it extended {@link com.google.api.client.googleapis.services.GoogleClient}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Compute extends AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    Preconditions.checkState(GoogleUtils.VERSION.equals("1.13.2-beta"),
        "You are currently running with version %s of google-api-client. " +
        "You need version 1.13.2-beta of google-api-client to run version " +
        "1.13.2-beta of the Compute Engine API library.", GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "compute/v1beta15/projects/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   * @deprecated (scheduled to be removed in 1.13)
   */
  @Deprecated
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport
   * @param jsonFactory JSON factory
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Compute(HttpTransport transport, JsonFactory jsonFactory,
      HttpRequestInitializer httpRequestInitializer) {
    super(transport,
        jsonFactory,
        DEFAULT_ROOT_URL,
        DEFAULT_SERVICE_PATH,
        httpRequestInitializer,
        false);
  }

  /**
   * @param transport HTTP transport
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @param rootUrl root URL of the service
   * @param servicePath service path
   * @param jsonObjectParser JSON object parser
   * @param googleClientRequestInitializer Google request initializer or {@code null} for none
   * @param applicationName application name to be sent in the User-Agent header of requests or
   *        {@code null} for none
   * @param suppressPatternChecks whether discovery pattern checks should be suppressed on required
   *        parameters
   */
  Compute(HttpTransport transport,
      HttpRequestInitializer httpRequestInitializer,
      String rootUrl,
      String servicePath,
      JsonObjectParser jsonObjectParser,
      GoogleClientRequestInitializer googleClientRequestInitializer,
      String applicationName,
      boolean suppressPatternChecks) {
    super(transport,
        httpRequestInitializer,
        rootUrl,
        servicePath,
        jsonObjectParser,
        googleClientRequestInitializer,
        applicationName,
        suppressPatternChecks);
  }

  @Override
  protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Addresses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Addresses.List request = compute.addresses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Addresses addresses() {
    return new Addresses();
  }

  /**
   * The "addresses" collection of methods.
   */
  public class Addresses {

    /**
     * Retrieves the list of addresses grouped by scope.
     *
     * Create a request for the method "addresses.aggregatedList".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AddressAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of addresses grouped by scope.
       *
       * Create a request for the method "addresses.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressAggregatedList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public AggregatedList setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public AggregatedList setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Deletes the specified address resource.
     *
     * Create a request for the method "addresses.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param address Name of the address resource to delete.
     * @return the request
     */
    public Delete delete(String project, String region, String address) throws java.io.IOException {
      Delete result = new Delete(project, region, address);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified address resource.
       *
       * Create a request for the method "addresses.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param address Name of the address resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String region, String address) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to delete. */
      @com.google.api.client.util.Key
      private String address;

      /** Name of the address resource to delete.
       */
      public String getAddress() {
        return address;
      }

      /** Name of the address resource to delete. */
      public Delete setAddress(String address) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

    }
    /**
     * Returns the specified address resource.
     *
     * Create a request for the method "addresses.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param address Name of the address resource to return.
     * @return the request
     */
    public Get get(String project, String region, String address) throws java.io.IOException {
      Get result = new Get(project, region, address);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Address> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified address resource.
       *
       * Create a request for the method "addresses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param address Name of the address resource to return.
       * @since 1.13
       */
      protected Get(String project, String region, String address) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Address.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to return. */
      @com.google.api.client.util.Key
      private String address;

      /** Name of the address resource to return.
       */
      public String getAddress() {
        return address;
      }

      /** Name of the address resource to return. */
      public Get setAddress(String address) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

    }
    /**
     * Creates an address resource in the specified project using the data included in the request.
     *
     * Create a request for the method "addresses.insert".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Address}
     * @return the request
     */
    public Insert insert(String project, String region, com.google.api.services.compute.model.Address content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an address resource in the specified project using the data included in the request.
       *
       * Create a request for the method "addresses.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Address}
       * @since 1.13
       */
      protected Insert(String project, String region, com.google.api.services.compute.model.Address content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

    }
    /**
     * Retrieves the list of address resources contained within the specified region.
     *
     * Create a request for the method "addresses.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(String project, String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AddressList> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of address resources contained within the specified region.
       *
       * Create a request for the method "addresses.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(String project, String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Disks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Disks.List request = compute.disks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Disks disks() {
    return new Disks();
  }

  /**
   * The "disks" collection of methods.
   */
  public class Disks {

    /**
     * Retrieves the list of disks grouped by scope.
     *
     * Create a request for the method "disks.aggregatedList".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.DiskAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of disks grouped by scope.
       *
       * Create a request for the method "disks.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskAggregatedList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public AggregatedList setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public AggregatedList setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Create a request for the method "disks.createSnapshot".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param disk Name of the persistent disk resource to delete.
     * @param content the {@link com.google.api.services.compute.model.Snapshot}
     * @return the request
     */
    public CreateSnapshot createSnapshot(String project, String zone, String disk, com.google.api.services.compute.model.Snapshot content) throws java.io.IOException {
      CreateSnapshot result = new CreateSnapshot(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class CreateSnapshot extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}/createSnapshot";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Create a request for the method "disks.createSnapshot".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
       * <p> {@link CreateSnapshot#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param disk Name of the persistent disk resource to delete.
       * @param content the {@link com.google.api.services.compute.model.Snapshot}
       * @since 1.13
       */
      protected CreateSnapshot(String project, String zone, String disk, com.google.api.services.compute.model.Snapshot content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public CreateSnapshot setAlt(String alt) {
        return (CreateSnapshot) super.setAlt(alt);
      }

      @Override
      public CreateSnapshot setFields(String fields) {
        return (CreateSnapshot) super.setFields(fields);
      }

      @Override
      public CreateSnapshot setKey(String key) {
        return (CreateSnapshot) super.setKey(key);
      }

      @Override
      public CreateSnapshot setOauthToken(String oauthToken) {
        return (CreateSnapshot) super.setOauthToken(oauthToken);
      }

      @Override
      public CreateSnapshot setPrettyPrint(Boolean prettyPrint) {
        return (CreateSnapshot) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CreateSnapshot setQuotaUser(String quotaUser) {
        return (CreateSnapshot) super.setQuotaUser(quotaUser);
      }

      @Override
      public CreateSnapshot setUserIp(String userIp) {
        return (CreateSnapshot) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public CreateSnapshot setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public CreateSnapshot setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk resource to delete. */
      @com.google.api.client.util.Key
      private String disk;

      /** Name of the persistent disk resource to delete.
       */
      public String getDisk() {
        return disk;
      }

      /** Name of the persistent disk resource to delete. */
      public CreateSnapshot setDisk(String disk) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

    }
    /**
     * Deletes the specified persistent disk resource.
     *
     * Create a request for the method "disks.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param disk Name of the persistent disk resource to delete.
     * @return the request
     */
    public Delete delete(String project, String zone, String disk) throws java.io.IOException {
      Delete result = new Delete(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified persistent disk resource.
       *
       * Create a request for the method "disks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param disk Name of the persistent disk resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String zone, String disk) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Delete setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk resource to delete. */
      @com.google.api.client.util.Key
      private String disk;

      /** Name of the persistent disk resource to delete.
       */
      public String getDisk() {
        return disk;
      }

      /** Name of the persistent disk resource to delete. */
      public Delete setDisk(String disk) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

    }
    /**
     * Returns the specified persistent disk resource.
     *
     * Create a request for the method "disks.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param disk Name of the persistent disk resource to return.
     * @return the request
     */
    public Get get(String project, String zone, String disk) throws java.io.IOException {
      Get result = new Get(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Disk> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified persistent disk resource.
       *
       * Create a request for the method "disks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param disk Name of the persistent disk resource to return.
       * @since 1.13
       */
      protected Get(String project, String zone, String disk) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Disk.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Get setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk resource to return. */
      @com.google.api.client.util.Key
      private String disk;

      /** Name of the persistent disk resource to return.
       */
      public String getDisk() {
        return disk;
      }

      /** Name of the persistent disk resource to return. */
      public Get setDisk(String disk) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

    }
    /**
     * Creates a persistent disk resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "disks.insert".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Disk}
     * @return the request
     */
    public Insert insert(String project, String zone, com.google.api.services.compute.model.Disk content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a persistent disk resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "disks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Disk}
       * @since 1.13
       */
      protected Insert(String project, String zone, com.google.api.services.compute.model.Disk content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Insert setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Source image to restore onto a disk. */
      @com.google.api.client.util.Key
      private String sourceImage;

      /** Optional. Source image to restore onto a disk.
       */
      public String getSourceImage() {
        return sourceImage;
      }

      /** Optional. Source image to restore onto a disk. */
      public Insert setSourceImage(String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
      }

    }
    /**
     * Retrieves the list of persistent disk resources contained within the specified zone.
     *
     * Create a request for the method "disks.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @return the request
     */
    public List list(String project, String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.DiskList> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of persistent disk resources contained within the specified zone.
       *
       * Create a request for the method "disks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @since 1.13
       */
      protected List(String project, String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public List setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Firewalls collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Firewalls.List request = compute.firewalls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Firewalls firewalls() {
    return new Firewalls();
  }

  /**
   * The "firewalls" collection of methods.
   */
  public class Firewalls {

    /**
     * Deletes the specified firewall resource.
     *
     * Create a request for the method "firewalls.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param firewall Name of the firewall resource to delete.
     * @return the request
     */
    public Delete delete(String project, String firewall) throws java.io.IOException {
      Delete result = new Delete(project, firewall);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified firewall resource.
       *
       * Create a request for the method "firewalls.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param firewall Name of the firewall resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String firewall) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to delete. */
      @com.google.api.client.util.Key
      private String firewall;

      /** Name of the firewall resource to delete.
       */
      public String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to delete. */
      public Delete setFirewall(String firewall) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

    }
    /**
     * Returns the specified firewall resource.
     *
     * Create a request for the method "firewalls.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param firewall Name of the firewall resource to return.
     * @return the request
     */
    public Get get(String project, String firewall) throws java.io.IOException {
      Get result = new Get(project, firewall);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Firewall> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified firewall resource.
       *
       * Create a request for the method "firewalls.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param firewall Name of the firewall resource to return.
       * @since 1.13
       */
      protected Get(String project, String firewall) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Firewall.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to return. */
      @com.google.api.client.util.Key
      private String firewall;

      /** Name of the firewall resource to return.
       */
      public String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to return. */
      public Get setFirewall(String firewall) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

    }
    /**
     * Creates a firewall resource in the specified project using the data included in the request.
     *
     * Create a request for the method "firewalls.insert".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Insert insert(String project, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a firewall resource in the specified project using the data included in the request.
       *
       * Create a request for the method "firewalls.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Insert(String project, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

    }
    /**
     * Retrieves the list of firewall resources available to the specified project.
     *
     * Create a request for the method "firewalls.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.FirewallList> {

      private static final String REST_PATH = "{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of firewall resources available to the specified project.
       *
       * Create a request for the method "firewalls.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Updates the specified firewall resource with the data included in the request. This method
     * supports patch semantics.
     *
     * Create a request for the method "firewalls.patch".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param firewall Name of the firewall resource to update.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Patch patch(String project, String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Patch result = new Patch(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified firewall resource with the data included in the request. This method
       * supports patch semantics.
       *
       * Create a request for the method "firewalls.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param firewall Name of the firewall resource to update.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Patch(String project, String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Patch setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to update. */
      @com.google.api.client.util.Key
      private String firewall;

      /** Name of the firewall resource to update.
       */
      public String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to update. */
      public Patch setFirewall(String firewall) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

    }
    /**
     * Updates the specified firewall resource with the data included in the request.
     *
     * Create a request for the method "firewalls.update".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param firewall Name of the firewall resource to update.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Update update(String project, String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Update result = new Update(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified firewall resource with the data included in the request.
       *
       * Create a request for the method "firewalls.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param firewall Name of the firewall resource to update.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Update(String project, String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Update setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to update. */
      @com.google.api.client.util.Key
      private String firewall;

      /** Name of the firewall resource to update.
       */
      public String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to update. */
      public Update setFirewall(String firewall) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the ForwardingRules collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.ForwardingRules.List request = compute.forwardingRules().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ForwardingRules forwardingRules() {
    return new ForwardingRules();
  }

  /**
   * The "forwardingRules" collection of methods.
   */
  public class ForwardingRules {

    /**
     * Retrieves the list of forwarding rules grouped by scope.
     *
     * Create a request for the method "forwardingRules.aggregatedList".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of forwarding rules grouped by scope.
       *
       * Create a request for the method "forwardingRules.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleAggregatedList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public AggregatedList setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public AggregatedList setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Deletes the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to delete.
     * @return the request
     */
    public Delete delete(String project, String region, String forwardingRule) throws java.io.IOException {
      Delete result = new Delete(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDINGRULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String region, String forwardingRule) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to delete. */
      @com.google.api.client.util.Key
      private String forwardingRule;

      /** Name of the ForwardingRule resource to delete.
       */
      public String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to delete. */
      public Delete setForwardingRule(String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

    }
    /**
     * Returns the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to return.
     * @return the request
     */
    public Get get(String project, String region, String forwardingRule) throws java.io.IOException {
      Get result = new Get(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.ForwardingRule> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDINGRULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to return.
       * @since 1.13
       */
      protected Get(String project, String region, String forwardingRule) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRule.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to return. */
      @com.google.api.client.util.Key
      private String forwardingRule;

      /** Name of the ForwardingRule resource to return.
       */
      public String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to return. */
      public Get setForwardingRule(String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

    }
    /**
     * Creates a ForwardingRule resource in the specified project and region using the data included in
     * the request.
     *
     * Create a request for the method "forwardingRules.insert".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
     * @return the request
     */
    public Insert insert(String project, String region, com.google.api.services.compute.model.ForwardingRule content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a ForwardingRule resource in the specified project and region using the data included
       * in the request.
       *
       * Create a request for the method "forwardingRules.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
       * @since 1.13
       */
      protected Insert(String project, String region, com.google.api.services.compute.model.ForwardingRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

    }
    /**
     * Retrieves the list of ForwardingRule resources available to the specified project and region.
     *
     * Create a request for the method "forwardingRules.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(String project, String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleList> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of ForwardingRule resources available to the specified project and region.
       *
       * Create a request for the method "forwardingRules.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(String project, String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Changes target url for forwarding rule.
     *
     * Create a request for the method "forwardingRules.setTarget".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
     * @param content the {@link com.google.api.services.compute.model.TargetReference}
     * @return the request
     */
    public SetTarget setTarget(String project, String region, String forwardingRule, com.google.api.services.compute.model.TargetReference content) throws java.io.IOException {
      SetTarget result = new SetTarget(project, region, forwardingRule, content);
      initialize(result);
      return result;
    }

    public class SetTarget extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDINGRULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes target url for forwarding rule.
       *
       * Create a request for the method "forwardingRules.setTarget".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation. <p>
       * {@link SetTarget#initialize(AbstractGoogleClientRequest)} must be called to initialize this
       * instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
       * @param content the {@link com.google.api.services.compute.model.TargetReference}
       * @since 1.13
       */
      protected SetTarget(String project, String region, String forwardingRule, com.google.api.services.compute.model.TargetReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTarget setAlt(String alt) {
        return (SetTarget) super.setAlt(alt);
      }

      @Override
      public SetTarget setFields(String fields) {
        return (SetTarget) super.setFields(fields);
      }

      @Override
      public SetTarget setKey(String key) {
        return (SetTarget) super.setKey(key);
      }

      @Override
      public SetTarget setOauthToken(String oauthToken) {
        return (SetTarget) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTarget setPrettyPrint(Boolean prettyPrint) {
        return (SetTarget) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTarget setQuotaUser(String quotaUser) {
        return (SetTarget) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTarget setUserIp(String userIp) {
        return (SetTarget) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetTarget setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public SetTarget setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      @com.google.api.client.util.Key
      private String forwardingRule;

      /** Name of the ForwardingRule resource in which target is to be set.
       */
      public String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      public SetTarget setForwardingRule(String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the GlobalOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalOperations.List request = compute.globalOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalOperations globalOperations() {
    return new GlobalOperations();
  }

  /**
   * The "globalOperations" collection of methods.
   */
  public class GlobalOperations {

    /**
     * Retrieves the list of all operations grouped by scope.
     *
     * Create a request for the method "globalOperations.aggregatedList".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.OperationAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of all operations grouped by scope.
       *
       * Create a request for the method "globalOperations.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationAggregatedList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public AggregatedList setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public AggregatedList setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Deletes the specified operation resource.
     *
     * Create a request for the method "globalOperations.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param operation Name of the operation resource to delete.
     * @return the request
     */
    public Delete delete(String project, String operation) throws java.io.IOException {
      Delete result = new Delete(project, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/global/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified operation resource.
       *
       * Create a request for the method "globalOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param operation Name of the operation resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.operation = Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the operation resource to delete. */
      @com.google.api.client.util.Key
      private String operation;

      /** Name of the operation resource to delete.
       */
      public String getOperation() {
        return operation;
      }

      /** Name of the operation resource to delete. */
      public Delete setOperation(String operation) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

    }
    /**
     * Retrieves the specified operation resource.
     *
     * Create a request for the method "globalOperations.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param operation Name of the operation resource to return.
     * @return the request
     */
    public Get get(String project, String operation) throws java.io.IOException {
      Get result = new Get(project, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified operation resource.
       *
       * Create a request for the method "globalOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param operation Name of the operation resource to return.
       * @since 1.13
       */
      protected Get(String project, String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.operation = Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the operation resource to return. */
      @com.google.api.client.util.Key
      private String operation;

      /** Name of the operation resource to return.
       */
      public String getOperation() {
        return operation;
      }

      /** Name of the operation resource to return. */
      public Get setOperation(String operation) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

    }
    /**
     * Retrieves the list of operation resources contained within the specified project.
     *
     * Create a request for the method "globalOperations.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/global/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of operation resources contained within the specified project.
       *
       * Create a request for the method "globalOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the HttpHealthChecks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.HttpHealthChecks.List request = compute.httpHealthChecks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public HttpHealthChecks httpHealthChecks() {
    return new HttpHealthChecks();
  }

  /**
   * The "httpHealthChecks" collection of methods.
   */
  public class HttpHealthChecks {

    /**
     * Deletes the specified HttpHealthCheck resource.
     *
     * Create a request for the method "httpHealthChecks.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to delete.
     * @return the request
     */
    public Delete delete(String project, String httpHealthCheck) throws java.io.IOException {
      Delete result = new Delete(project, httpHealthCheck);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPHEALTHCHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified HttpHealthCheck resource.
       *
       * Create a request for the method "httpHealthChecks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String httpHealthCheck) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to delete. */
      @com.google.api.client.util.Key
      private String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to delete.
       */
      public String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to delete. */
      public Delete setHttpHealthCheck(String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

    }
    /**
     * Returns the specified HttpHealthCheck resource.
     *
     * Create a request for the method "httpHealthChecks.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to return.
     * @return the request
     */
    public Get get(String project, String httpHealthCheck) throws java.io.IOException {
      Get result = new Get(project, httpHealthCheck);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.HttpHealthCheck> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPHEALTHCHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified HttpHealthCheck resource.
       *
       * Create a request for the method "httpHealthChecks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to return.
       * @since 1.13
       */
      protected Get(String project, String httpHealthCheck) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpHealthCheck.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to return. */
      @com.google.api.client.util.Key
      private String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to return.
       */
      public String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to return. */
      public Get setHttpHealthCheck(String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

    }
    /**
     * Creates a HttpHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpHealthChecks.insert".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Insert insert(String project, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a HttpHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpHealthChecks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Insert(String project, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

    }
    /**
     * Retrieves the list of HttpHealthCheck resources available to the specified project.
     *
     * Create a request for the method "httpHealthChecks.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.HttpHealthCheckList> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of HttpHealthCheck resources available to the specified project.
       *
       * Create a request for the method "httpHealthChecks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpHealthCheckList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Updates a HttpHealthCheck resource in the specified project using the data included in the
     * request. This method supports patch semantics.
     *
     * Create a request for the method "httpHealthChecks.patch".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Patch patch(String project, String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Patch result = new Patch(project, httpHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPHEALTHCHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpHealthCheck resource in the specified project using the data included in the
       * request. This method supports patch semantics.
       *
       * Create a request for the method "httpHealthChecks.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Patch(String project, String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Patch setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to update.
       */
      public String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to update. */
      public Patch setHttpHealthCheck(String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

    }
    /**
     * Updates a HttpHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpHealthChecks.update".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Update update(String project, String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Update result = new Update(project, httpHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPHEALTHCHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpHealthChecks.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Update(String project, String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Update setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to update.
       */
      public String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to update. */
      public Update setHttpHealthCheck(String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Images collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Images.List request = compute.images().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Images images() {
    return new Images();
  }

  /**
   * The "images" collection of methods.
   */
  public class Images {

    /**
     * Deletes the specified image resource.
     *
     * Create a request for the method "images.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param image Name of the image resource to delete.
     * @return the request
     */
    public Delete delete(String project, String image) throws java.io.IOException {
      Delete result = new Delete(project, image);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{image}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified image resource.
       *
       * Create a request for the method "images.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param image Name of the image resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String image) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to delete. */
      @com.google.api.client.util.Key
      private String image;

      /** Name of the image resource to delete.
       */
      public String getImage() {
        return image;
      }

      /** Name of the image resource to delete. */
      public Delete setImage(String image) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

    }
    /**
     * Sets the deprecation status of an image. If no message body is given, clears the deprecation
     * status instead.
     *
     * Create a request for the method "images.deprecate".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Deprecate#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param image Image name.
     * @param content the {@link com.google.api.services.compute.model.DeprecationStatus}
     * @return the request
     */
    public Deprecate deprecate(String project, String image, com.google.api.services.compute.model.DeprecationStatus content) throws java.io.IOException {
      Deprecate result = new Deprecate(project, image, content);
      initialize(result);
      return result;
    }

    public class Deprecate extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{image}/deprecate";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets the deprecation status of an image. If no message body is given, clears the deprecation
       * status instead.
       *
       * Create a request for the method "images.deprecate".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Deprecate#execute()} method to invoke the remote operation. <p>
       * {@link Deprecate#initialize(AbstractGoogleClientRequest)} must be called to initialize this
       * instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param image Image name.
       * @param content the {@link com.google.api.services.compute.model.DeprecationStatus}
       * @since 1.13
       */
      protected Deprecate(String project, String image, com.google.api.services.compute.model.DeprecationStatus content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Deprecate setAlt(String alt) {
        return (Deprecate) super.setAlt(alt);
      }

      @Override
      public Deprecate setFields(String fields) {
        return (Deprecate) super.setFields(fields);
      }

      @Override
      public Deprecate setKey(String key) {
        return (Deprecate) super.setKey(key);
      }

      @Override
      public Deprecate setOauthToken(String oauthToken) {
        return (Deprecate) super.setOauthToken(oauthToken);
      }

      @Override
      public Deprecate setPrettyPrint(Boolean prettyPrint) {
        return (Deprecate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Deprecate setQuotaUser(String quotaUser) {
        return (Deprecate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Deprecate setUserIp(String userIp) {
        return (Deprecate) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Deprecate setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Image name. */
      @com.google.api.client.util.Key
      private String image;

      /** Image name.
       */
      public String getImage() {
        return image;
      }

      /** Image name. */
      public Deprecate setImage(String image) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

    }
    /**
     * Returns the specified image resource.
     *
     * Create a request for the method "images.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param image Name of the image resource to return.
     * @return the request
     */
    public Get get(String project, String image) throws java.io.IOException {
      Get result = new Get(project, image);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Image> {

      private static final String REST_PATH = "{project}/global/images/{image}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified image resource.
       *
       * Create a request for the method "images.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param image Name of the image resource to return.
       * @since 1.13
       */
      protected Get(String project, String image) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Image.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to return. */
      @com.google.api.client.util.Key
      private String image;

      /** Name of the image resource to return.
       */
      public String getImage() {
        return image;
      }

      /** Name of the image resource to return. */
      public Get setImage(String image) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

    }
    /**
     * Creates an image resource in the specified project using the data included in the request.
     *
     * Create a request for the method "images.insert".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Image}
     * @return the request
     */
    public Insert insert(String project, com.google.api.services.compute.model.Image content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an image resource in the specified project using the data included in the request.
       *
       * Create a request for the method "images.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Image}
       * @since 1.13
       */
      protected Insert(String project, com.google.api.services.compute.model.Image content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

    }
    /**
     * Retrieves the list of image resources available to the specified project.
     *
     * Create a request for the method "images.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ImageList> {

      private static final String REST_PATH = "{project}/global/images";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of image resources available to the specified project.
       *
       * Create a request for the method "images.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ImageList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Instances collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Instances.List request = compute.instances().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Instances instances() {
    return new Instances();
  }

  /**
   * The "instances" collection of methods.
   */
  public class Instances {

    /**
     * Adds an access config to an instance's network interface.
     *
     * Create a request for the method "instances.addAccessConfig".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AddAccessConfig#execute()} method to invoke the remote operation.
     *
     * @param project Project name.
     * @param zone Name of the zone scoping this request.
     * @param instance Instance name.
     * @param networkInterface Network interface name.
     * @param content the {@link com.google.api.services.compute.model.AccessConfig}
     * @return the request
     */
    public AddAccessConfig addAccessConfig(String project, String zone, String instance, String networkInterface, com.google.api.services.compute.model.AccessConfig content) throws java.io.IOException {
      AddAccessConfig result = new AddAccessConfig(project, zone, instance, networkInterface, content);
      initialize(result);
      return result;
    }

    public class AddAccessConfig extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/addAccessConfig";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Adds an access config to an instance's network interface.
       *
       * Create a request for the method "instances.addAccessConfig".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddAccessConfig#execute()} method to invoke the remote operation.
       * <p> {@link AddAccessConfig#initialize(AbstractGoogleClientRequest)} must be called to
       * initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project name.
       * @param zone Name of the zone scoping this request.
       * @param instance Instance name.
       * @param networkInterface Network interface name.
       * @param content the {@link com.google.api.services.compute.model.AccessConfig}
       * @since 1.13
       */
      protected AddAccessConfig(String project, String zone, String instance, String networkInterface, com.google.api.services.compute.model.AccessConfig content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.networkInterface = Preconditions.checkNotNull(networkInterface, "Required parameter networkInterface must be specified.");
      }

      @Override
      public AddAccessConfig setAlt(String alt) {
        return (AddAccessConfig) super.setAlt(alt);
      }

      @Override
      public AddAccessConfig setFields(String fields) {
        return (AddAccessConfig) super.setFields(fields);
      }

      @Override
      public AddAccessConfig setKey(String key) {
        return (AddAccessConfig) super.setKey(key);
      }

      @Override
      public AddAccessConfig setOauthToken(String oauthToken) {
        return (AddAccessConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public AddAccessConfig setPrettyPrint(Boolean prettyPrint) {
        return (AddAccessConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddAccessConfig setQuotaUser(String quotaUser) {
        return (AddAccessConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddAccessConfig setUserIp(String userIp) {
        return (AddAccessConfig) super.setUserIp(userIp);
      }

      /** Project name. */
      @com.google.api.client.util.Key
      private String project;

      /** Project name.
       */
      public String getProject() {
        return project;
      }

      /** Project name. */
      public AddAccessConfig setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public AddAccessConfig setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private String instance;

      /** Instance name.
       */
      public String getInstance() {
        return instance;
      }

      /** Instance name. */
      public AddAccessConfig setInstance(String instance) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Network interface name. */
      @com.google.api.client.util.Key
      private String networkInterface;

      /** Network interface name.
       */
      public String getNetworkInterface() {
        return networkInterface;
      }

      /** Network interface name. */
      public AddAccessConfig setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
      }

    }
    /**
     * Create a request for the method "instances.aggregatedList".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.InstanceAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Create a request for the method "instances.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceAggregatedList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public AggregatedList setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public AggregatedList setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Attaches a disk resource to an instance.
     *
     * Create a request for the method "instances.attachDisk".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AttachDisk#execute()} method to invoke the remote operation.
     *
     * @param project Project name.
     * @param zone Name of the zone scoping this request.
     * @param instance Instance name.
     * @param content the {@link com.google.api.services.compute.model.AttachedDisk}
     * @return the request
     */
    public AttachDisk attachDisk(String project, String zone, String instance, com.google.api.services.compute.model.AttachedDisk content) throws java.io.IOException {
      AttachDisk result = new AttachDisk(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class AttachDisk extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/attachDisk";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Attaches a disk resource to an instance.
       *
       * Create a request for the method "instances.attachDisk".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AttachDisk#execute()} method to invoke the remote operation. <p>
       * {@link AttachDisk#initialize(AbstractGoogleClientRequest)} must be called to initialize this
       * instance immediately after invoking the constructor. </p>
       *
       * @param project Project name.
       * @param zone Name of the zone scoping this request.
       * @param instance Instance name.
       * @param content the {@link com.google.api.services.compute.model.AttachedDisk}
       * @since 1.13
       */
      protected AttachDisk(String project, String zone, String instance, com.google.api.services.compute.model.AttachedDisk content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public AttachDisk setAlt(String alt) {
        return (AttachDisk) super.setAlt(alt);
      }

      @Override
      public AttachDisk setFields(String fields) {
        return (AttachDisk) super.setFields(fields);
      }

      @Override
      public AttachDisk setKey(String key) {
        return (AttachDisk) super.setKey(key);
      }

      @Override
      public AttachDisk setOauthToken(String oauthToken) {
        return (AttachDisk) super.setOauthToken(oauthToken);
      }

      @Override
      public AttachDisk setPrettyPrint(Boolean prettyPrint) {
        return (AttachDisk) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AttachDisk setQuotaUser(String quotaUser) {
        return (AttachDisk) super.setQuotaUser(quotaUser);
      }

      @Override
      public AttachDisk setUserIp(String userIp) {
        return (AttachDisk) super.setUserIp(userIp);
      }

      /** Project name. */
      @com.google.api.client.util.Key
      private String project;

      /** Project name.
       */
      public String getProject() {
        return project;
      }

      /** Project name. */
      public AttachDisk setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public AttachDisk setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private String instance;

      /** Instance name.
       */
      public String getInstance() {
        return instance;
      }

      /** Instance name. */
      public AttachDisk setInstance(String instance) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

    }
    /**
     * Deletes the specified instance resource.
     *
     * Create a request for the method "instances.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance resource to delete.
     * @return the request
     */
    public Delete delete(String project, String zone, String instance) throws java.io.IOException {
      Delete result = new Delete(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified instance resource.
       *
       * Create a request for the method "instances.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String zone, String instance) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Delete setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to delete. */
      @com.google.api.client.util.Key
      private String instance;

      /** Name of the instance resource to delete.
       */
      public String getInstance() {
        return instance;
      }

      /** Name of the instance resource to delete. */
      public Delete setInstance(String instance) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

    }
    /**
     * Deletes an access config from an instance's network interface.
     *
     * Create a request for the method "instances.deleteAccessConfig".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link DeleteAccessConfig#execute()} method to invoke the remote operation.
     *
     * @param project Project name.
     * @param zone Name of the zone scoping this request.
     * @param instance Instance name.
     * @param accessConfig Access config name.
     * @param networkInterface Network interface name.
     * @return the request
     */
    public DeleteAccessConfig deleteAccessConfig(String project, String zone, String instance, String accessConfig, String networkInterface) throws java.io.IOException {
      DeleteAccessConfig result = new DeleteAccessConfig(project, zone, instance, accessConfig, networkInterface);
      initialize(result);
      return result;
    }

    public class DeleteAccessConfig extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/deleteAccessConfig";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes an access config from an instance's network interface.
       *
       * Create a request for the method "instances.deleteAccessConfig".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DeleteAccessConfig#execute()} method to invoke the remote
       * operation. <p> {@link DeleteAccessConfig#initialize(AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project name.
       * @param zone Name of the zone scoping this request.
       * @param instance Instance name.
       * @param accessConfig Access config name.
       * @param networkInterface Network interface name.
       * @since 1.13
       */
      protected DeleteAccessConfig(String project, String zone, String instance, String accessConfig, String networkInterface) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.accessConfig = Preconditions.checkNotNull(accessConfig, "Required parameter accessConfig must be specified.");
        this.networkInterface = Preconditions.checkNotNull(networkInterface, "Required parameter networkInterface must be specified.");
      }

      @Override
      public DeleteAccessConfig setAlt(String alt) {
        return (DeleteAccessConfig) super.setAlt(alt);
      }

      @Override
      public DeleteAccessConfig setFields(String fields) {
        return (DeleteAccessConfig) super.setFields(fields);
      }

      @Override
      public DeleteAccessConfig setKey(String key) {
        return (DeleteAccessConfig) super.setKey(key);
      }

      @Override
      public DeleteAccessConfig setOauthToken(String oauthToken) {
        return (DeleteAccessConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteAccessConfig setPrettyPrint(Boolean prettyPrint) {
        return (DeleteAccessConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteAccessConfig setQuotaUser(String quotaUser) {
        return (DeleteAccessConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteAccessConfig setUserIp(String userIp) {
        return (DeleteAccessConfig) super.setUserIp(userIp);
      }

      /** Project name. */
      @com.google.api.client.util.Key
      private String project;

      /** Project name.
       */
      public String getProject() {
        return project;
      }

      /** Project name. */
      public DeleteAccessConfig setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public DeleteAccessConfig setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private String instance;

      /** Instance name.
       */
      public String getInstance() {
        return instance;
      }

      /** Instance name. */
      public DeleteAccessConfig setInstance(String instance) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Access config name. */
      @com.google.api.client.util.Key
      private String accessConfig;

      /** Access config name.
       */
      public String getAccessConfig() {
        return accessConfig;
      }

      /** Access config name. */
      public DeleteAccessConfig setAccessConfig(String accessConfig) {
        this.accessConfig = accessConfig;
        return this;
      }

      /** Network interface name. */
      @com.google.api.client.util.Key
      private String networkInterface;

      /** Network interface name.
       */
      public String getNetworkInterface() {
        return networkInterface;
      }

      /** Network interface name. */
      public DeleteAccessConfig setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
      }

    }
    /**
     * Detaches a disk from an instance.
     *
     * Create a request for the method "instances.detachDisk".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link DetachDisk#execute()} method to invoke the remote operation.
     *
     * @param project Project name.
     * @param zone Name of the zone scoping this request.
     * @param instance Instance name.
     * @param deviceName Disk device name to detach.
     * @return the request
     */
    public DetachDisk detachDisk(String project, String zone, String instance, String deviceName) throws java.io.IOException {
      DetachDisk result = new DetachDisk(project, zone, instance, deviceName);
      initialize(result);
      return result;
    }

    public class DetachDisk extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/detachDisk";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DEVICENAME_PATTERN =
          java.util.regex.Pattern.compile("\\w[\\w.-]{0,254}");

      /**
       * Detaches a disk from an instance.
       *
       * Create a request for the method "instances.detachDisk".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DetachDisk#execute()} method to invoke the remote operation. <p>
       * {@link DetachDisk#initialize(AbstractGoogleClientRequest)} must be called to initialize this
       * instance immediately after invoking the constructor. </p>
       *
       * @param project Project name.
       * @param zone Name of the zone scoping this request.
       * @param instance Instance name.
       * @param deviceName Disk device name to detach.
       * @since 1.13
       */
      protected DetachDisk(String project, String zone, String instance, String deviceName) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.deviceName = Preconditions.checkNotNull(deviceName, "Required parameter deviceName must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(DEVICENAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
      }

      @Override
      public DetachDisk setAlt(String alt) {
        return (DetachDisk) super.setAlt(alt);
      }

      @Override
      public DetachDisk setFields(String fields) {
        return (DetachDisk) super.setFields(fields);
      }

      @Override
      public DetachDisk setKey(String key) {
        return (DetachDisk) super.setKey(key);
      }

      @Override
      public DetachDisk setOauthToken(String oauthToken) {
        return (DetachDisk) super.setOauthToken(oauthToken);
      }

      @Override
      public DetachDisk setPrettyPrint(Boolean prettyPrint) {
        return (DetachDisk) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DetachDisk setQuotaUser(String quotaUser) {
        return (DetachDisk) super.setQuotaUser(quotaUser);
      }

      @Override
      public DetachDisk setUserIp(String userIp) {
        return (DetachDisk) super.setUserIp(userIp);
      }

      /** Project name. */
      @com.google.api.client.util.Key
      private String project;

      /** Project name.
       */
      public String getProject() {
        return project;
      }

      /** Project name. */
      public DetachDisk setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public DetachDisk setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private String instance;

      /** Instance name.
       */
      public String getInstance() {
        return instance;
      }

      /** Instance name. */
      public DetachDisk setInstance(String instance) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Disk device name to detach. */
      @com.google.api.client.util.Key
      private String deviceName;

      /** Disk device name to detach.
       */
      public String getDeviceName() {
        return deviceName;
      }

      /** Disk device name to detach. */
      public DetachDisk setDeviceName(String deviceName) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(DEVICENAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
        this.deviceName = deviceName;
        return this;
      }

    }
    /**
     * Returns the specified instance resource.
     *
     * Create a request for the method "instances.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance resource to return.
     * @return the request
     */
    public Get get(String project, String zone, String instance) throws java.io.IOException {
      Get result = new Get(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Instance> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified instance resource.
       *
       * Create a request for the method "instances.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance resource to return.
       * @since 1.13
       */
      protected Get(String project, String zone, String instance) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Instance.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Get setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to return. */
      @com.google.api.client.util.Key
      private String instance;

      /** Name of the instance resource to return.
       */
      public String getInstance() {
        return instance;
      }

      /** Name of the instance resource to return. */
      public Get setInstance(String instance) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

    }
    /**
     * Returns the specified instance's serial port output.
     *
     * Create a request for the method "instances.getSerialPortOutput".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link GetSerialPortOutput#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance scoping this request.
     * @return the request
     */
    public GetSerialPortOutput getSerialPortOutput(String project, String zone, String instance) throws java.io.IOException {
      GetSerialPortOutput result = new GetSerialPortOutput(project, zone, instance);
      initialize(result);
      return result;
    }

    public class GetSerialPortOutput extends ComputeRequest<com.google.api.services.compute.model.SerialPortOutput> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/serialPort";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified instance's serial port output.
       *
       * Create a request for the method "instances.getSerialPortOutput".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetSerialPortOutput#execute()} method to invoke the remote
       * operation. <p> {@link GetSerialPortOutput#initialize(AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance scoping this request.
       * @since 1.13
       */
      protected GetSerialPortOutput(String project, String zone, String instance) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.SerialPortOutput.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetSerialPortOutput setAlt(String alt) {
        return (GetSerialPortOutput) super.setAlt(alt);
      }

      @Override
      public GetSerialPortOutput setFields(String fields) {
        return (GetSerialPortOutput) super.setFields(fields);
      }

      @Override
      public GetSerialPortOutput setKey(String key) {
        return (GetSerialPortOutput) super.setKey(key);
      }

      @Override
      public GetSerialPortOutput setOauthToken(String oauthToken) {
        return (GetSerialPortOutput) super.setOauthToken(oauthToken);
      }

      @Override
      public GetSerialPortOutput setPrettyPrint(Boolean prettyPrint) {
        return (GetSerialPortOutput) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetSerialPortOutput setQuotaUser(String quotaUser) {
        return (GetSerialPortOutput) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetSerialPortOutput setUserIp(String userIp) {
        return (GetSerialPortOutput) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public GetSerialPortOutput setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public GetSerialPortOutput setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private String instance;

      /** Name of the instance scoping this request.
       */
      public String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public GetSerialPortOutput setInstance(String instance) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

    }
    /**
     * Creates an instance resource in the specified project using the data included in the request.
     *
     * Create a request for the method "instances.insert".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Instance}
     * @return the request
     */
    public Insert insert(String project, String zone, com.google.api.services.compute.model.Instance content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an instance resource in the specified project using the data included in the request.
       *
       * Create a request for the method "instances.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Instance}
       * @since 1.13
       */
      protected Insert(String project, String zone, com.google.api.services.compute.model.Instance content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Insert setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

    }
    /**
     * Retrieves the list of instance resources contained within the specified zone.
     *
     * Create a request for the method "instances.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @return the request
     */
    public List list(String project, String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.InstanceList> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of instance resources contained within the specified zone.
       *
       * Create a request for the method "instances.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @since 1.13
       */
      protected List(String project, String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public List setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Performs a hard reset on the instance.
     *
     * Create a request for the method "instances.reset".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Reset#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance scoping this request.
     * @return the request
     */
    public Reset reset(String project, String zone, String instance) throws java.io.IOException {
      Reset result = new Reset(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Reset extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/reset";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Performs a hard reset on the instance.
       *
       * Create a request for the method "instances.reset".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Reset#execute()} method to invoke the remote operation. <p> {@link
       * Reset#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance scoping this request.
       * @since 1.13
       */
      protected Reset(String project, String zone, String instance) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Reset setAlt(String alt) {
        return (Reset) super.setAlt(alt);
      }

      @Override
      public Reset setFields(String fields) {
        return (Reset) super.setFields(fields);
      }

      @Override
      public Reset setKey(String key) {
        return (Reset) super.setKey(key);
      }

      @Override
      public Reset setOauthToken(String oauthToken) {
        return (Reset) super.setOauthToken(oauthToken);
      }

      @Override
      public Reset setPrettyPrint(Boolean prettyPrint) {
        return (Reset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reset setQuotaUser(String quotaUser) {
        return (Reset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reset setUserIp(String userIp) {
        return (Reset) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Reset setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Reset setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private String instance;

      /** Name of the instance scoping this request.
       */
      public String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public Reset setInstance(String instance) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

    }
    /**
     * Sets metadata for the specified instance to the data included in the request.
     *
     * Create a request for the method "instances.setMetadata".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link SetMetadata#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Metadata}
     * @return the request
     */
    public SetMetadata setMetadata(String project, String zone, String instance, com.google.api.services.compute.model.Metadata content) throws java.io.IOException {
      SetMetadata result = new SetMetadata(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetMetadata extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setMetadata";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets metadata for the specified instance to the data included in the request.
       *
       * Create a request for the method "instances.setMetadata".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetMetadata#execute()} method to invoke the remote operation. <p>
       * {@link SetMetadata#initialize(AbstractGoogleClientRequest)} must be called to initialize this
       * instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Metadata}
       * @since 1.13
       */
      protected SetMetadata(String project, String zone, String instance, com.google.api.services.compute.model.Metadata content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetMetadata setAlt(String alt) {
        return (SetMetadata) super.setAlt(alt);
      }

      @Override
      public SetMetadata setFields(String fields) {
        return (SetMetadata) super.setFields(fields);
      }

      @Override
      public SetMetadata setKey(String key) {
        return (SetMetadata) super.setKey(key);
      }

      @Override
      public SetMetadata setOauthToken(String oauthToken) {
        return (SetMetadata) super.setOauthToken(oauthToken);
      }

      @Override
      public SetMetadata setPrettyPrint(Boolean prettyPrint) {
        return (SetMetadata) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetMetadata setQuotaUser(String quotaUser) {
        return (SetMetadata) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetMetadata setUserIp(String userIp) {
        return (SetMetadata) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetMetadata setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public SetMetadata setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private String instance;

      /** Name of the instance scoping this request.
       */
      public String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public SetMetadata setInstance(String instance) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

    }
    /**
     * Sets tags for the specified instance to the data included in the request.
     *
     * Create a request for the method "instances.setTags".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link SetTags#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Tags}
     * @return the request
     */
    public SetTags setTags(String project, String zone, String instance, com.google.api.services.compute.model.Tags content) throws java.io.IOException {
      SetTags result = new SetTags(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetTags extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setTags";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets tags for the specified instance to the data included in the request.
       *
       * Create a request for the method "instances.setTags".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTags#execute()} method to invoke the remote operation. <p>
       * {@link SetTags#initialize(AbstractGoogleClientRequest)} must be called to initialize this
       * instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Tags}
       * @since 1.13
       */
      protected SetTags(String project, String zone, String instance, com.google.api.services.compute.model.Tags content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTags setAlt(String alt) {
        return (SetTags) super.setAlt(alt);
      }

      @Override
      public SetTags setFields(String fields) {
        return (SetTags) super.setFields(fields);
      }

      @Override
      public SetTags setKey(String key) {
        return (SetTags) super.setKey(key);
      }

      @Override
      public SetTags setOauthToken(String oauthToken) {
        return (SetTags) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTags setPrettyPrint(Boolean prettyPrint) {
        return (SetTags) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTags setQuotaUser(String quotaUser) {
        return (SetTags) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTags setUserIp(String userIp) {
        return (SetTags) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetTags setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public SetTags setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private String instance;

      /** Name of the instance scoping this request.
       */
      public String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public SetTags setInstance(String instance) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Kernels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Kernels.List request = compute.kernels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Kernels kernels() {
    return new Kernels();
  }

  /**
   * The "kernels" collection of methods.
   */
  public class Kernels {

    /**
     * Returns the specified kernel resource.
     *
     * Create a request for the method "kernels.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param kernel Name of the kernel resource to return.
     * @return the request
     */
    public Get get(String project, String kernel) throws java.io.IOException {
      Get result = new Get(project, kernel);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Kernel> {

      private static final String REST_PATH = "{project}/global/kernels/{kernel}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern KERNEL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified kernel resource.
       *
       * Create a request for the method "kernels.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param kernel Name of the kernel resource to return.
       * @since 1.13
       */
      protected Get(String project, String kernel) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Kernel.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.kernel = Preconditions.checkNotNull(kernel, "Required parameter kernel must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(KERNEL_PATTERN.matcher(kernel).matches(),
              "Parameter kernel must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the kernel resource to return. */
      @com.google.api.client.util.Key
      private String kernel;

      /** Name of the kernel resource to return.
       */
      public String getKernel() {
        return kernel;
      }

      /** Name of the kernel resource to return. */
      public Get setKernel(String kernel) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(KERNEL_PATTERN.matcher(kernel).matches(),
              "Parameter kernel must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.kernel = kernel;
        return this;
      }

    }
    /**
     * Retrieves the list of kernel resources available to the specified project.
     *
     * Create a request for the method "kernels.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.KernelList> {

      private static final String REST_PATH = "{project}/global/kernels";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of kernel resources available to the specified project.
       *
       * Create a request for the method "kernels.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.KernelList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the MachineTypes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.MachineTypes.List request = compute.machineTypes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public MachineTypes machineTypes() {
    return new MachineTypes();
  }

  /**
   * The "machineTypes" collection of methods.
   */
  public class MachineTypes {

    /**
     * Retrieves the list of machine type resources grouped by scope.
     *
     * Create a request for the method "machineTypes.aggregatedList".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.MachineTypeAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/machineTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of machine type resources grouped by scope.
       *
       * Create a request for the method "machineTypes.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineTypeAggregatedList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public AggregatedList setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public AggregatedList setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Returns the specified machine type resource.
     *
     * Create a request for the method "machineTypes.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param machineType Name of the machine type resource to return.
     * @return the request
     */
    public Get get(String project, String zone, String machineType) throws java.io.IOException {
      Get result = new Get(project, zone, machineType);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.MachineType> {

      private static final String REST_PATH = "{project}/zones/{zone}/machineTypes/{machineType}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern MACHINETYPE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified machine type resource.
       *
       * Create a request for the method "machineTypes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param machineType Name of the machine type resource to return.
       * @since 1.13
       */
      protected Get(String project, String zone, String machineType) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineType.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.machineType = Preconditions.checkNotNull(machineType, "Required parameter machineType must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(MACHINETYPE_PATTERN.matcher(machineType).matches(),
              "Parameter machineType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Get setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the machine type resource to return. */
      @com.google.api.client.util.Key
      private String machineType;

      /** Name of the machine type resource to return.
       */
      public String getMachineType() {
        return machineType;
      }

      /** Name of the machine type resource to return. */
      public Get setMachineType(String machineType) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(MACHINETYPE_PATTERN.matcher(machineType).matches(),
              "Parameter machineType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.machineType = machineType;
        return this;
      }

    }
    /**
     * Retrieves the list of machine type resources available to the specified project.
     *
     * Create a request for the method "machineTypes.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @return the request
     */
    public List list(String project, String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.MachineTypeList> {

      private static final String REST_PATH = "{project}/zones/{zone}/machineTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of machine type resources available to the specified project.
       *
       * Create a request for the method "machineTypes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @since 1.13
       */
      protected List(String project, String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineTypeList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public List setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Networks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Networks.List request = compute.networks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Networks networks() {
    return new Networks();
  }

  /**
   * The "networks" collection of methods.
   */
  public class Networks {

    /**
     * Deletes the specified network resource.
     *
     * Create a request for the method "networks.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param network Name of the network resource to delete.
     * @return the request
     */
    public Delete delete(String project, String network) throws java.io.IOException {
      Delete result = new Delete(project, network);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/networks/{network}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern NETWORK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified network resource.
       *
       * Create a request for the method "networks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param network Name of the network resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String network) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.network = Preconditions.checkNotNull(network, "Required parameter network must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the network resource to delete. */
      @com.google.api.client.util.Key
      private String network;

      /** Name of the network resource to delete.
       */
      public String getNetwork() {
        return network;
      }

      /** Name of the network resource to delete. */
      public Delete setNetwork(String network) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.network = network;
        return this;
      }

    }
    /**
     * Returns the specified network resource.
     *
     * Create a request for the method "networks.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param network Name of the network resource to return.
     * @return the request
     */
    public Get get(String project, String network) throws java.io.IOException {
      Get result = new Get(project, network);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Network> {

      private static final String REST_PATH = "{project}/global/networks/{network}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern NETWORK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified network resource.
       *
       * Create a request for the method "networks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param network Name of the network resource to return.
       * @since 1.13
       */
      protected Get(String project, String network) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Network.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.network = Preconditions.checkNotNull(network, "Required parameter network must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the network resource to return. */
      @com.google.api.client.util.Key
      private String network;

      /** Name of the network resource to return.
       */
      public String getNetwork() {
        return network;
      }

      /** Name of the network resource to return. */
      public Get setNetwork(String network) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.network = network;
        return this;
      }

    }
    /**
     * Creates a network resource in the specified project using the data included in the request.
     *
     * Create a request for the method "networks.insert".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Network}
     * @return the request
     */
    public Insert insert(String project, com.google.api.services.compute.model.Network content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/networks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a network resource in the specified project using the data included in the request.
       *
       * Create a request for the method "networks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Network}
       * @since 1.13
       */
      protected Insert(String project, com.google.api.services.compute.model.Network content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

    }
    /**
     * Retrieves the list of network resources available to the specified project.
     *
     * Create a request for the method "networks.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.NetworkList> {

      private static final String REST_PATH = "{project}/global/networks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of network resources available to the specified project.
       *
       * Create a request for the method "networks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.NetworkList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Projects.List request = compute.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Returns the specified project resource.
     *
     * Create a request for the method "projects.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project resource to retrieve.
     * @return the request
     */
    public Get get(String project) throws java.io.IOException {
      Get result = new Get(project);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Project> {

      private static final String REST_PATH = "{project}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Returns the specified project resource.
       *
       * Create a request for the method "projects.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project resource to retrieve.
       * @since 1.13
       */
      protected Get(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Project.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project resource to retrieve. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project resource to retrieve.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project resource to retrieve. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

    }
    /**
     * Sets metadata common to all instances within the specified project using the data included in the
     * request.
     *
     * Create a request for the method "projects.setCommonInstanceMetadata".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link SetCommonInstanceMetadata#execute()} method to invoke the remote
     * operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Metadata}
     * @return the request
     */
    public SetCommonInstanceMetadata setCommonInstanceMetadata(String project, com.google.api.services.compute.model.Metadata content) throws java.io.IOException {
      SetCommonInstanceMetadata result = new SetCommonInstanceMetadata(project, content);
      initialize(result);
      return result;
    }

    public class SetCommonInstanceMetadata extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/setCommonInstanceMetadata";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Sets metadata common to all instances within the specified project using the data included in
       * the request.
       *
       * Create a request for the method "projects.setCommonInstanceMetadata".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetCommonInstanceMetadata#execute()} method to invoke the remote
       * operation. <p> {@link SetCommonInstanceMetadata#initialize(AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Metadata}
       * @since 1.13
       */
      protected SetCommonInstanceMetadata(String project, com.google.api.services.compute.model.Metadata content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public SetCommonInstanceMetadata setAlt(String alt) {
        return (SetCommonInstanceMetadata) super.setAlt(alt);
      }

      @Override
      public SetCommonInstanceMetadata setFields(String fields) {
        return (SetCommonInstanceMetadata) super.setFields(fields);
      }

      @Override
      public SetCommonInstanceMetadata setKey(String key) {
        return (SetCommonInstanceMetadata) super.setKey(key);
      }

      @Override
      public SetCommonInstanceMetadata setOauthToken(String oauthToken) {
        return (SetCommonInstanceMetadata) super.setOauthToken(oauthToken);
      }

      @Override
      public SetCommonInstanceMetadata setPrettyPrint(Boolean prettyPrint) {
        return (SetCommonInstanceMetadata) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetCommonInstanceMetadata setQuotaUser(String quotaUser) {
        return (SetCommonInstanceMetadata) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetCommonInstanceMetadata setUserIp(String userIp) {
        return (SetCommonInstanceMetadata) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetCommonInstanceMetadata setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the RegionOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.RegionOperations.List request = compute.regionOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public RegionOperations regionOperations() {
    return new RegionOperations();
  }

  /**
   * The "regionOperations" collection of methods.
   */
  public class RegionOperations {

    /**
     * Deletes the specified region-specific operation resource.
     *
     * Create a request for the method "regionOperations.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param operation Name of the operation resource to delete.
     * @return the request
     */
    public Delete delete(String project, String region, String operation) throws java.io.IOException {
      Delete result = new Delete(project, region, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/regions/{region}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified region-specific operation resource.
       *
       * Create a request for the method "regionOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param operation Name of the operation resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String region, String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the operation resource to delete. */
      @com.google.api.client.util.Key
      private String operation;

      /** Name of the operation resource to delete.
       */
      public String getOperation() {
        return operation;
      }

      /** Name of the operation resource to delete. */
      public Delete setOperation(String operation) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

    }
    /**
     * Retrieves the specified region-specific operation resource.
     *
     * Create a request for the method "regionOperations.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the zone scoping this request.
     * @param operation Name of the operation resource to return.
     * @return the request
     */
    public Get get(String project, String region, String operation) throws java.io.IOException {
      Get result = new Get(project, region, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified region-specific operation resource.
       *
       * Create a request for the method "regionOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the zone scoping this request.
       * @param operation Name of the operation resource to return.
       * @since 1.13
       */
      protected Get(String project, String region, String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the zone scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the zone scoping this request. */
      public Get setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the operation resource to return. */
      @com.google.api.client.util.Key
      private String operation;

      /** Name of the operation resource to return.
       */
      public String getOperation() {
        return operation;
      }

      /** Name of the operation resource to return. */
      public Get setOperation(String operation) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

    }
    /**
     * Retrieves the list of operation resources contained within the specified region.
     *
     * Create a request for the method "regionOperations.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(String project, String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/regions/{region}/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of operation resources contained within the specified region.
       *
       * Create a request for the method "regionOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(String project, String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Regions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Regions.List request = compute.regions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Regions regions() {
    return new Regions();
  }

  /**
   * The "regions" collection of methods.
   */
  public class Regions {

    /**
     * Returns the specified region resource.
     *
     * Create a request for the method "regions.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region resource to return.
     * @return the request
     */
    public Get get(String project, String region) throws java.io.IOException {
      Get result = new Get(project, region);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Region> {

      private static final String REST_PATH = "{project}/regions/{region}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified region resource.
       *
       * Create a request for the method "regions.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region resource to return.
       * @since 1.13
       */
      protected Get(String project, String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Region.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region resource to return. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region resource to return.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region resource to return. */
      public Get setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

    }
    /**
     * Retrieves the list of region resources available to the specified project.
     *
     * Create a request for the method "regions.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.RegionList> {

      private static final String REST_PATH = "{project}/regions";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of region resources available to the specified project.
       *
       * Create a request for the method "regions.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.RegionList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Routes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Routes.List request = compute.routes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Routes routes() {
    return new Routes();
  }

  /**
   * The "routes" collection of methods.
   */
  public class Routes {

    /**
     * Deletes the specified route resource.
     *
     * Create a request for the method "routes.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param route Name of the route resource to delete.
     * @return the request
     */
    public Delete delete(String project, String route) throws java.io.IOException {
      Delete result = new Delete(project, route);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/routes/{route}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ROUTE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified route resource.
       *
       * Create a request for the method "routes.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param route Name of the route resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String route) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.route = Preconditions.checkNotNull(route, "Required parameter route must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the route resource to delete. */
      @com.google.api.client.util.Key
      private String route;

      /** Name of the route resource to delete.
       */
      public String getRoute() {
        return route;
      }

      /** Name of the route resource to delete. */
      public Delete setRoute(String route) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.route = route;
        return this;
      }

    }
    /**
     * Returns the specified route resource.
     *
     * Create a request for the method "routes.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param route Name of the route resource to return.
     * @return the request
     */
    public Get get(String project, String route) throws java.io.IOException {
      Get result = new Get(project, route);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Route> {

      private static final String REST_PATH = "{project}/global/routes/{route}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ROUTE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified route resource.
       *
       * Create a request for the method "routes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param route Name of the route resource to return.
       * @since 1.13
       */
      protected Get(String project, String route) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Route.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.route = Preconditions.checkNotNull(route, "Required parameter route must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the route resource to return. */
      @com.google.api.client.util.Key
      private String route;

      /** Name of the route resource to return.
       */
      public String getRoute() {
        return route;
      }

      /** Name of the route resource to return. */
      public Get setRoute(String route) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.route = route;
        return this;
      }

    }
    /**
     * Creates a route resource in the specified project using the data included in the request.
     *
     * Create a request for the method "routes.insert".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Route}
     * @return the request
     */
    public Insert insert(String project, com.google.api.services.compute.model.Route content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/routes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a route resource in the specified project using the data included in the request.
       *
       * Create a request for the method "routes.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Route}
       * @since 1.13
       */
      protected Insert(String project, com.google.api.services.compute.model.Route content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

    }
    /**
     * Retrieves the list of route resources available to the specified project.
     *
     * Create a request for the method "routes.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.RouteList> {

      private static final String REST_PATH = "{project}/global/routes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of route resources available to the specified project.
       *
       * Create a request for the method "routes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.RouteList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Snapshots collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Snapshots.List request = compute.snapshots().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Snapshots snapshots() {
    return new Snapshots();
  }

  /**
   * The "snapshots" collection of methods.
   */
  public class Snapshots {

    /**
     * Deletes the specified persistent disk snapshot resource.
     *
     * Create a request for the method "snapshots.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param snapshot Name of the persistent disk snapshot resource to delete.
     * @return the request
     */
    public Delete delete(String project, String snapshot) throws java.io.IOException {
      Delete result = new Delete(project, snapshot);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/snapshots/{snapshot}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern SNAPSHOT_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified persistent disk snapshot resource.
       *
       * Create a request for the method "snapshots.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param snapshot Name of the persistent disk snapshot resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String snapshot) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.snapshot = Preconditions.checkNotNull(snapshot, "Required parameter snapshot must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the persistent disk snapshot resource to delete. */
      @com.google.api.client.util.Key
      private String snapshot;

      /** Name of the persistent disk snapshot resource to delete.
       */
      public String getSnapshot() {
        return snapshot;
      }

      /** Name of the persistent disk snapshot resource to delete. */
      public Delete setSnapshot(String snapshot) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.snapshot = snapshot;
        return this;
      }

    }
    /**
     * Returns the specified persistent disk snapshot resource.
     *
     * Create a request for the method "snapshots.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param snapshot Name of the persistent disk snapshot resource to return.
     * @return the request
     */
    public Get get(String project, String snapshot) throws java.io.IOException {
      Get result = new Get(project, snapshot);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Snapshot> {

      private static final String REST_PATH = "{project}/global/snapshots/{snapshot}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern SNAPSHOT_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified persistent disk snapshot resource.
       *
       * Create a request for the method "snapshots.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param snapshot Name of the persistent disk snapshot resource to return.
       * @since 1.13
       */
      protected Get(String project, String snapshot) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Snapshot.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.snapshot = Preconditions.checkNotNull(snapshot, "Required parameter snapshot must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the persistent disk snapshot resource to return. */
      @com.google.api.client.util.Key
      private String snapshot;

      /** Name of the persistent disk snapshot resource to return.
       */
      public String getSnapshot() {
        return snapshot;
      }

      /** Name of the persistent disk snapshot resource to return. */
      public Get setSnapshot(String snapshot) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.snapshot = snapshot;
        return this;
      }

    }
    /**
     * Retrieves the list of persistent disk snapshot resources contained within the specified project.
     *
     * Create a request for the method "snapshots.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.SnapshotList> {

      private static final String REST_PATH = "{project}/global/snapshots";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of persistent disk snapshot resources contained within the specified
       * project.
       *
       * Create a request for the method "snapshots.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.SnapshotList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the TargetPools collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.TargetPools.List request = compute.targetPools().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public TargetPools targetPools() {
    return new TargetPools();
  }

  /**
   * The "targetPools" collection of methods.
   */
  public class TargetPools {

    /**
     * Adds health check URL to targetPool.
     *
     * Create a request for the method "targetPools.addHealthCheck".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AddHealthCheck#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which health_check_url is to be added.
     * @param content the {@link com.google.api.services.compute.model.HealthCheckReference}
     * @return the request
     */
    public AddHealthCheck addHealthCheck(String project, String region, String targetPool, com.google.api.services.compute.model.HealthCheckReference content) throws java.io.IOException {
      AddHealthCheck result = new AddHealthCheck(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class AddHealthCheck extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/addHealthCheck";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Adds health check URL to targetPool.
       *
       * Create a request for the method "targetPools.addHealthCheck".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddHealthCheck#execute()} method to invoke the remote operation.
       * <p> {@link AddHealthCheck#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which health_check_url is to be added.
       * @param content the {@link com.google.api.services.compute.model.HealthCheckReference}
       * @since 1.13
       */
      protected AddHealthCheck(String project, String region, String targetPool, com.google.api.services.compute.model.HealthCheckReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public AddHealthCheck setAlt(String alt) {
        return (AddHealthCheck) super.setAlt(alt);
      }

      @Override
      public AddHealthCheck setFields(String fields) {
        return (AddHealthCheck) super.setFields(fields);
      }

      @Override
      public AddHealthCheck setKey(String key) {
        return (AddHealthCheck) super.setKey(key);
      }

      @Override
      public AddHealthCheck setOauthToken(String oauthToken) {
        return (AddHealthCheck) super.setOauthToken(oauthToken);
      }

      @Override
      public AddHealthCheck setPrettyPrint(Boolean prettyPrint) {
        return (AddHealthCheck) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddHealthCheck setQuotaUser(String quotaUser) {
        return (AddHealthCheck) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddHealthCheck setUserIp(String userIp) {
        return (AddHealthCheck) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AddHealthCheck setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public AddHealthCheck setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which health_check_url is to be added. */
      @com.google.api.client.util.Key
      private String targetPool;

      /** Name of the TargetPool resource to which health_check_url is to be added.
       */
      public String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which health_check_url is to be added. */
      public AddHealthCheck setTargetPool(String targetPool) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

    }
    /**
     * Adds instance url to targetPool.
     *
     * Create a request for the method "targetPools.addInstance".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AddInstance#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which instance_url is to be added.
     * @param content the {@link com.google.api.services.compute.model.InstanceReference}
     * @return the request
     */
    public AddInstance addInstance(String project, String region, String targetPool, com.google.api.services.compute.model.InstanceReference content) throws java.io.IOException {
      AddInstance result = new AddInstance(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class AddInstance extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/addInstance";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Adds instance url to targetPool.
       *
       * Create a request for the method "targetPools.addInstance".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddInstance#execute()} method to invoke the remote operation. <p>
       * {@link AddInstance#initialize(AbstractGoogleClientRequest)} must be called to initialize this
       * instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which instance_url is to be added.
       * @param content the {@link com.google.api.services.compute.model.InstanceReference}
       * @since 1.13
       */
      protected AddInstance(String project, String region, String targetPool, com.google.api.services.compute.model.InstanceReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public AddInstance setAlt(String alt) {
        return (AddInstance) super.setAlt(alt);
      }

      @Override
      public AddInstance setFields(String fields) {
        return (AddInstance) super.setFields(fields);
      }

      @Override
      public AddInstance setKey(String key) {
        return (AddInstance) super.setKey(key);
      }

      @Override
      public AddInstance setOauthToken(String oauthToken) {
        return (AddInstance) super.setOauthToken(oauthToken);
      }

      @Override
      public AddInstance setPrettyPrint(Boolean prettyPrint) {
        return (AddInstance) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddInstance setQuotaUser(String quotaUser) {
        return (AddInstance) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddInstance setUserIp(String userIp) {
        return (AddInstance) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AddInstance setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public AddInstance setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which instance_url is to be added. */
      @com.google.api.client.util.Key
      private String targetPool;

      /** Name of the TargetPool resource to which instance_url is to be added.
       */
      public String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which instance_url is to be added. */
      public AddInstance setTargetPool(String targetPool) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

    }
    /**
     * Retrieves the list of target pools grouped by scope.
     *
     * Create a request for the method "targetPools.aggregatedList".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.TargetPoolAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/targetPools";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of target pools grouped by scope.
       *
       * Create a request for the method "targetPools.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetPoolAggregatedList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public AggregatedList setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public AggregatedList setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Deletes the specified TargetPool resource.
     *
     * Create a request for the method "targetPools.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to delete.
     * @return the request
     */
    public Delete delete(String project, String region, String targetPool) throws java.io.IOException {
      Delete result = new Delete(project, region, targetPool);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified TargetPool resource.
       *
       * Create a request for the method "targetPools.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String region, String targetPool) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to delete. */
      @com.google.api.client.util.Key
      private String targetPool;

      /** Name of the TargetPool resource to delete.
       */
      public String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to delete. */
      public Delete setTargetPool(String targetPool) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

    }
    /**
     * Returns the specified TargetPool resource.
     *
     * Create a request for the method "targetPools.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to return.
     * @return the request
     */
    public Get get(String project, String region, String targetPool) throws java.io.IOException {
      Get result = new Get(project, region, targetPool);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.TargetPool> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified TargetPool resource.
       *
       * Create a request for the method "targetPools.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to return.
       * @since 1.13
       */
      protected Get(String project, String region, String targetPool) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetPool.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to return. */
      @com.google.api.client.util.Key
      private String targetPool;

      /** Name of the TargetPool resource to return.
       */
      public String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to return. */
      public Get setTargetPool(String targetPool) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

    }
    /**
     * Gets the most recent health check results for each IP for the given instance that is referenced
     * by given TargetPool.
     *
     * Create a request for the method "targetPools.getHealth".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which the queried instance belongs.
     * @param content the {@link com.google.api.services.compute.model.InstanceReference}
     * @return the request
     */
    public GetHealth getHealth(String project, String region, String targetPool, com.google.api.services.compute.model.InstanceReference content) throws java.io.IOException {
      GetHealth result = new GetHealth(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class GetHealth extends ComputeRequest<com.google.api.services.compute.model.TargetPoolInstanceHealth> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/getHealth";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Gets the most recent health check results for each IP for the given instance that is referenced
       * by given TargetPool.
       *
       * Create a request for the method "targetPools.getHealth".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation. <p>
       * {@link GetHealth#initialize(AbstractGoogleClientRequest)} must be called to initialize this
       * instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which the queried instance belongs.
       * @param content the {@link com.google.api.services.compute.model.InstanceReference}
       * @since 1.13
       */
      protected GetHealth(String project, String region, String targetPool, com.google.api.services.compute.model.InstanceReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TargetPoolInstanceHealth.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public GetHealth setAlt(String alt) {
        return (GetHealth) super.setAlt(alt);
      }

      @Override
      public GetHealth setFields(String fields) {
        return (GetHealth) super.setFields(fields);
      }

      @Override
      public GetHealth setKey(String key) {
        return (GetHealth) super.setKey(key);
      }

      @Override
      public GetHealth setOauthToken(String oauthToken) {
        return (GetHealth) super.setOauthToken(oauthToken);
      }

      @Override
      public GetHealth setPrettyPrint(Boolean prettyPrint) {
        return (GetHealth) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetHealth setQuotaUser(String quotaUser) {
        return (GetHealth) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetHealth setUserIp(String userIp) {
        return (GetHealth) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public GetHealth setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public GetHealth setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which the queried instance belongs. */
      @com.google.api.client.util.Key
      private String targetPool;

      /** Name of the TargetPool resource to which the queried instance belongs.
       */
      public String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which the queried instance belongs. */
      public GetHealth setTargetPool(String targetPool) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

    }
    /**
     * Creates a TargetPool resource in the specified project and region using the data included in the
     * request.
     *
     * Create a request for the method "targetPools.insert".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.TargetPool}
     * @return the request
     */
    public Insert insert(String project, String region, com.google.api.services.compute.model.TargetPool content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a TargetPool resource in the specified project and region using the data included in
       * the request.
       *
       * Create a request for the method "targetPools.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.TargetPool}
       * @since 1.13
       */
      protected Insert(String project, String region, com.google.api.services.compute.model.TargetPool content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

    }
    /**
     * Retrieves the list of TargetPool resources available to the specified project and region.
     *
     * Create a request for the method "targetPools.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(String project, String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.TargetPoolList> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of TargetPool resources available to the specified project and region.
       *
       * Create a request for the method "targetPools.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(String project, String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetPoolList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Removes health check URL from targetPool.
     *
     * Create a request for the method "targetPools.removeHealthCheck".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link RemoveHealthCheck#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which health_check_url is to be removed.
     * @param content the {@link com.google.api.services.compute.model.HealthCheckReference}
     * @return the request
     */
    public RemoveHealthCheck removeHealthCheck(String project, String region, String targetPool, com.google.api.services.compute.model.HealthCheckReference content) throws java.io.IOException {
      RemoveHealthCheck result = new RemoveHealthCheck(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class RemoveHealthCheck extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/removeHealthCheck";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Removes health check URL from targetPool.
       *
       * Create a request for the method "targetPools.removeHealthCheck".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RemoveHealthCheck#execute()} method to invoke the remote operation.
       * <p> {@link RemoveHealthCheck#initialize(AbstractGoogleClientRequest)} must be called to
       * initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which health_check_url is to be removed.
       * @param content the {@link com.google.api.services.compute.model.HealthCheckReference}
       * @since 1.13
       */
      protected RemoveHealthCheck(String project, String region, String targetPool, com.google.api.services.compute.model.HealthCheckReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public RemoveHealthCheck setAlt(String alt) {
        return (RemoveHealthCheck) super.setAlt(alt);
      }

      @Override
      public RemoveHealthCheck setFields(String fields) {
        return (RemoveHealthCheck) super.setFields(fields);
      }

      @Override
      public RemoveHealthCheck setKey(String key) {
        return (RemoveHealthCheck) super.setKey(key);
      }

      @Override
      public RemoveHealthCheck setOauthToken(String oauthToken) {
        return (RemoveHealthCheck) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveHealthCheck setPrettyPrint(Boolean prettyPrint) {
        return (RemoveHealthCheck) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveHealthCheck setQuotaUser(String quotaUser) {
        return (RemoveHealthCheck) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveHealthCheck setUserIp(String userIp) {
        return (RemoveHealthCheck) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public RemoveHealthCheck setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public RemoveHealthCheck setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which health_check_url is to be removed. */
      @com.google.api.client.util.Key
      private String targetPool;

      /** Name of the TargetPool resource to which health_check_url is to be removed.
       */
      public String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which health_check_url is to be removed. */
      public RemoveHealthCheck setTargetPool(String targetPool) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

    }
    /**
     * Removes instance URL from targetPool.
     *
     * Create a request for the method "targetPools.removeInstance".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link RemoveInstance#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which instance_url is to be removed.
     * @param content the {@link com.google.api.services.compute.model.InstanceReference}
     * @return the request
     */
    public RemoveInstance removeInstance(String project, String region, String targetPool, com.google.api.services.compute.model.InstanceReference content) throws java.io.IOException {
      RemoveInstance result = new RemoveInstance(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class RemoveInstance extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/removeInstance";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Removes instance URL from targetPool.
       *
       * Create a request for the method "targetPools.removeInstance".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RemoveInstance#execute()} method to invoke the remote operation.
       * <p> {@link RemoveInstance#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which instance_url is to be removed.
       * @param content the {@link com.google.api.services.compute.model.InstanceReference}
       * @since 1.13
       */
      protected RemoveInstance(String project, String region, String targetPool, com.google.api.services.compute.model.InstanceReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public RemoveInstance setAlt(String alt) {
        return (RemoveInstance) super.setAlt(alt);
      }

      @Override
      public RemoveInstance setFields(String fields) {
        return (RemoveInstance) super.setFields(fields);
      }

      @Override
      public RemoveInstance setKey(String key) {
        return (RemoveInstance) super.setKey(key);
      }

      @Override
      public RemoveInstance setOauthToken(String oauthToken) {
        return (RemoveInstance) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveInstance setPrettyPrint(Boolean prettyPrint) {
        return (RemoveInstance) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveInstance setQuotaUser(String quotaUser) {
        return (RemoveInstance) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveInstance setUserIp(String userIp) {
        return (RemoveInstance) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public RemoveInstance setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private String region;

      /** Name of the region scoping this request.
       */
      public String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public RemoveInstance setRegion(String region) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which instance_url is to be removed. */
      @com.google.api.client.util.Key
      private String targetPool;

      /** Name of the TargetPool resource to which instance_url is to be removed.
       */
      public String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which instance_url is to be removed. */
      public RemoveInstance setTargetPool(String targetPool) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the ZoneOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.ZoneOperations.List request = compute.zoneOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ZoneOperations zoneOperations() {
    return new ZoneOperations();
  }

  /**
   * The "zoneOperations" collection of methods.
   */
  public class ZoneOperations {

    /**
     * Deletes the specified zone-specific operation resource.
     *
     * Create a request for the method "zoneOperations.delete".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param operation Name of the operation resource to delete.
     * @return the request
     */
    public Delete delete(String project, String zone, String operation) throws java.io.IOException {
      Delete result = new Delete(project, zone, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/zones/{zone}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified zone-specific operation resource.
       *
       * Create a request for the method "zoneOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param operation Name of the operation resource to delete.
       * @since 1.13
       */
      protected Delete(String project, String zone, String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Delete setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the operation resource to delete. */
      @com.google.api.client.util.Key
      private String operation;

      /** Name of the operation resource to delete.
       */
      public String getOperation() {
        return operation;
      }

      /** Name of the operation resource to delete. */
      public Delete setOperation(String operation) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

    }
    /**
     * Retrieves the specified zone-specific operation resource.
     *
     * Create a request for the method "zoneOperations.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param operation Name of the operation resource to return.
     * @return the request
     */
    public Get get(String project, String zone, String operation) throws java.io.IOException {
      Get result = new Get(project, zone, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified zone-specific operation resource.
       *
       * Create a request for the method "zoneOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param operation Name of the operation resource to return.
       * @since 1.13
       */
      protected Get(String project, String zone, String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Get setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the operation resource to return. */
      @com.google.api.client.util.Key
      private String operation;

      /** Name of the operation resource to return.
       */
      public String getOperation() {
        return operation;
      }

      /** Name of the operation resource to return. */
      public Get setOperation(String operation) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

    }
    /**
     * Retrieves the list of operation resources contained within the specified zone.
     *
     * Create a request for the method "zoneOperations.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @return the request
     */
    public List list(String project, String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/zones/{zone}/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of operation resources contained within the specified zone.
       *
       * Create a request for the method "zoneOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @since 1.13
       */
      protected List(String project, String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone scoping this request.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public List setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Zones collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Zones.List request = compute.zones().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Zones zones() {
    return new Zones();
  }

  /**
   * The "zones" collection of methods.
   */
  public class Zones {

    /**
     * Returns the specified zone resource.
     *
     * Create a request for the method "zones.get".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone resource to return.
     * @return the request
     */
    public Get get(String project, String zone) throws java.io.IOException {
      Get result = new Get(project, zone);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Zone> {

      private static final String REST_PATH = "{project}/zones/{zone}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified zone resource.
       *
       * Create a request for the method "zones.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone resource to return.
       * @since 1.13
       */
      protected Get(String project, String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Zone.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone resource to return. */
      @com.google.api.client.util.Key
      private String zone;

      /** Name of the zone resource to return.
       */
      public String getZone() {
        return zone;
      }

      /** Name of the zone resource to return. */
      public Get setZone(String zone) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

    }
    /**
     * Retrieves the list of zone resources available to the specified project.
     *
     * Create a request for the method "zones.list".
     *
     * This request holds the parameters needed by the the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ZoneList> {

      private static final String REST_PATH = "{project}/zones";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of zone resources available to the specified project.
       *
       * Create a request for the method "zones.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ZoneList.class);
        this.project = Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private String project;

      /** Name of the project scoping this request.
       */
      public String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(String project) {
        if (!getSuppressPatternChecks()) {
          Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(String filter) {
        this.filter = filter;
        return this;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     * previous list request.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. [default: 100]
     [minimum: 0] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Optional. Maximum count of results to be returned. Maximum and default value is 100. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * Builder for {@link Compute}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport
     * @param jsonFactory JSON factory
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(HttpTransport transport, JsonFactory jsonFactory,
        HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Compute}. */
    @Override
    public Compute build() {
      return new Compute(getTransport(),
          getHttpRequestInitializer(),
          getRootUrl(),
          getServicePath(),
          getObjectParser(),
          getGoogleClientRequestInitializer(),
          getApplicationName(),
          getSuppressPatternChecks());
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    /**
     * Set the {@link ComputeRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setComputeRequestInitializer(
        ComputeRequestInitializer computeRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(computeRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
