/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * A ForwardingRule resource. A ForwardingRule resource specifies which pool of target VMs to
 * forward a packet to if it matches the given [IPAddress, IPProtocol, portRange] tuple.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ForwardingRule extends GenericJson {

  /**
   * Value of the reserved IP address that this forwarding rule is serving on behalf of. The address
   * resource must live in the same region as the forwarding rule. If left empty (default value), an
   * ephemeral IP will be assigned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("IPAddress")
  private String iPAddress;

  /**
   * The IP protocol to which this rule applies, can be either 'TCP' or 'UDP' (If left empty, will
   * use TCP by default).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("IPProtocol")
  private String iPProtocol;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * If 'IPProtocol' is 'TCP' or 'UDP', only packets addressed to ports in the specified range will
   * be forwarded to 'target'. If left empty (default value), all ports are forwarded. Forwarding
   * rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String portRange;

  /**
   * URL of the region where the forwarding rule resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String region;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The URL of the target resource to receive the matched traffic. It must live in the same region
   * as this forwarding rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String target;

  /**
   * Value of the reserved IP address that this forwarding rule is serving on behalf of. The address
   * resource must live in the same region as the forwarding rule. If left empty (default value), an
   * ephemeral IP will be assigned.
   * The value returned may be {@code null}.
   */
  public String getIPAddress() {
    return iPAddress;
  }

  /**
   * Value of the reserved IP address that this forwarding rule is serving on behalf of. The address
   * resource must live in the same region as the forwarding rule. If left empty (default value), an
   * ephemeral IP will be assigned.
   * The value set may be {@code null}.
   */
  public ForwardingRule setIPAddress(String iPAddress) {
    this.iPAddress = iPAddress;
    return this;
  }

  /**
   * The IP protocol to which this rule applies, can be either 'TCP' or 'UDP' (If left empty, will
   * use TCP by default).
   * The value returned may be {@code null}.
   */
  public String getIPProtocol() {
    return iPProtocol;
  }

  /**
   * The IP protocol to which this rule applies, can be either 'TCP' or 'UDP' (If left empty, will
   * use TCP by default).
   * The value set may be {@code null}.
   */
  public ForwardingRule setIPProtocol(String iPProtocol) {
    this.iPProtocol = iPProtocol;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public ForwardingRule setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value set may be {@code null}.
   */
  public ForwardingRule setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public ForwardingRule setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public ForwardingRule setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public ForwardingRule setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * If 'IPProtocol' is 'TCP' or 'UDP', only packets addressed to ports in the specified range will
   * be forwarded to 'target'. If left empty (default value), all ports are forwarded. Forwarding
   * rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
   * The value returned may be {@code null}.
   */
  public String getPortRange() {
    return portRange;
  }

  /**
   * If 'IPProtocol' is 'TCP' or 'UDP', only packets addressed to ports in the specified range will
   * be forwarded to 'target'. If left empty (default value), all ports are forwarded. Forwarding
   * rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
   * The value set may be {@code null}.
   */
  public ForwardingRule setPortRange(String portRange) {
    this.portRange = portRange;
    return this;
  }

  /**
   * URL of the region where the forwarding rule resides (output only).
   * The value returned may be {@code null}.
   */
  public String getRegion() {
    return region;
  }

  /**
   * URL of the region where the forwarding rule resides (output only).
   * The value set may be {@code null}.
   */
  public ForwardingRule setRegion(String region) {
    this.region = region;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public ForwardingRule setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The URL of the target resource to receive the matched traffic. It must live in the same region
   * as this forwarding rule.
   * The value returned may be {@code null}.
   */
  public String getTarget() {
    return target;
  }

  /**
   * The URL of the target resource to receive the matched traffic. It must live in the same region
   * as this forwarding rule.
   * The value set may be {@code null}.
   */
  public ForwardingRule setTarget(String target) {
    this.target = target;
    return this;
  }

}
