/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-08-26 17:13:51 UTC)
 * on 2013-09-06 at 01:13:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A TargetPool resource. This resource defines a pool of VMs, associated HttpHealthCheck resources,
 * and the fallback TargetPool.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetPool extends com.google.api.client.json.GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A list of URLs to the HttpHealthCheck resource. A member VM in this pool is considered healthy
   * if and only if all specified health checks pass. An empty list means all member VMs will be
   * considered healthy at all times.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> healthChecks;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * A list of resource URLs to the member VMs serving this pool. They must live in zones contained
   * in the same region as this pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> instances;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * URL of the region where the target pool resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public TargetPool setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public TargetPool setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A list of URLs to the HttpHealthCheck resource. A member VM in this pool is considered healthy
   * if and only if all specified health checks pass. An empty list means all member VMs will be
   * considered healthy at all times.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getHealthChecks() {
    return healthChecks;
  }

  /**
   * A list of URLs to the HttpHealthCheck resource. A member VM in this pool is considered healthy
   * if and only if all specified health checks pass. An empty list means all member VMs will be
   * considered healthy at all times.
   * @param healthChecks healthChecks or {@code null} for none
   */
  public TargetPool setHealthChecks(java.util.List<java.lang.String> healthChecks) {
    this.healthChecks = healthChecks;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public TargetPool setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * A list of resource URLs to the member VMs serving this pool. They must live in zones contained
   * in the same region as this pool.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInstances() {
    return instances;
  }

  /**
   * A list of resource URLs to the member VMs serving this pool. They must live in zones contained
   * in the same region as this pool.
   * @param instances instances or {@code null} for none
   */
  public TargetPool setInstances(java.util.List<java.lang.String> instances) {
    this.instances = instances;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public TargetPool setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public TargetPool setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the region where the target pool resides (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * URL of the region where the target pool resides (output only).
   * @param region region or {@code null} for none
   */
  public TargetPool setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public TargetPool setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public TargetPool set(String fieldName, Object value) {
    return (TargetPool) super.set(fieldName, value);
  }

  @Override
  public TargetPool clone() {
    return (TargetPool) super.clone();
  }

}
