/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;

/**
 * Deprecation status for a public resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeprecationStatus extends GenericJson {

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DELETED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String deleted;

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DEPRECATED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String deprecated;

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to OBSOLETE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String obsolete;

  /**
   * A URL of the suggested replacement for the deprecated resource. The deprecated resource and its
   * replacement must be resources of the same kind.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String replacement;

  /**
   * The deprecation state. Can be "DEPRECATED", "OBSOLETE", or "DELETED". Operations which create a
   * new resource using a "DEPRECATED" resource will return successfully, but with a warning
   * indicating the deprecated resource and recommending its replacement. New uses of "OBSOLETE" or
   * "DELETED" resources will result in an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String state;

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DELETED.
   * The value returned may be {@code null}.
   */
  public String getDeleted() {
    return deleted;
  }

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DELETED.
   * The value set may be {@code null}.
   */
  public DeprecationStatus setDeleted(String deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DEPRECATED.
   * The value returned may be {@code null}.
   */
  public String getDeprecated() {
    return deprecated;
  }

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DEPRECATED.
   * The value set may be {@code null}.
   */
  public DeprecationStatus setDeprecated(String deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to OBSOLETE.
   * The value returned may be {@code null}.
   */
  public String getObsolete() {
    return obsolete;
  }

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to OBSOLETE.
   * The value set may be {@code null}.
   */
  public DeprecationStatus setObsolete(String obsolete) {
    this.obsolete = obsolete;
    return this;
  }

  /**
   * A URL of the suggested replacement for the deprecated resource. The deprecated resource and its
   * replacement must be resources of the same kind.
   * The value returned may be {@code null}.
   */
  public String getReplacement() {
    return replacement;
  }

  /**
   * A URL of the suggested replacement for the deprecated resource. The deprecated resource and its
   * replacement must be resources of the same kind.
   * The value set may be {@code null}.
   */
  public DeprecationStatus setReplacement(String replacement) {
    this.replacement = replacement;
    return this;
  }

  /**
   * The deprecation state. Can be "DEPRECATED", "OBSOLETE", or "DELETED". Operations which create a
   * new resource using a "DEPRECATED" resource will return successfully, but with a warning
   * indicating the deprecated resource and recommending its replacement. New uses of "OBSOLETE" or
   * "DELETED" resources will result in an error.
   * The value returned may be {@code null}.
   */
  public String getState() {
    return state;
  }

  /**
   * The deprecation state. Can be "DEPRECATED", "OBSOLETE", or "DELETED". Operations which create a
   * new resource using a "DEPRECATED" resource will return successfully, but with a warning
   * indicating the deprecated resource and recommending its replacement. New uses of "OBSOLETE" or
   * "DELETED" resources will result in an error.
   * The value set may be {@code null}.
   */
  public DeprecationStatus setState(String state) {
    this.state = state;
    return this;
  }

}
