/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * A reserved address resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Address extends GenericJson {

  /**
   * The IP address represented by this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String address;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * URL of the region where the address resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String region;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The status of the address (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String status;

  /**
   * URL of the resource currently using this address (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String user;

  /**
   * The IP address represented by this resource.
   * The value returned may be {@code null}.
   */
  public String getAddress() {
    return address;
  }

  /**
   * The IP address represented by this resource.
   * The value set may be {@code null}.
   */
  public Address setAddress(String address) {
    this.address = address;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Address setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value set may be {@code null}.
   */
  public Address setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Address setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Address setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public Address setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the region where the address resides (output only).
   * The value returned may be {@code null}.
   */
  public String getRegion() {
    return region;
  }

  /**
   * URL of the region where the address resides (output only).
   * The value set may be {@code null}.
   */
  public Address setRegion(String region) {
    this.region = region;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Address setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The status of the address (output only).
   * The value returned may be {@code null}.
   */
  public String getStatus() {
    return status;
  }

  /**
   * The status of the address (output only).
   * The value set may be {@code null}.
   */
  public Address setStatus(String status) {
    this.status = status;
    return this;
  }

  /**
   * URL of the resource currently using this address (output only).
   * The value returned may be {@code null}.
   */
  public String getUser() {
    return user;
  }

  /**
   * URL of the resource currently using this address (output only).
   * The value set may be {@code null}.
   */
  public Address setUser(String user) {
    this.user = user;
    return this;
  }

}
