/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * An HttpHealthCheck resource. This resource defines a template for how individual VMs should be
 * checked for health, via HTTP.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpHealthCheck extends GenericJson {

  /**
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer checkIntervalSec;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * A so-far unhealthy VM will be marked healthy after this many consecutive successes. The default
   * value is 2.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer healthyThreshold;

  /**
   * The host name of the HTTP health check request. If left empty (default value), the public IP on
   * behalf of which this health check is performed will be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String host;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * The TCP port number for the HTTP health check request. The default value is 80.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer port;

  /**
   * The request path of the HTTP health check request. The default value is "/".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String requestPath;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer timeoutSec;

  /**
   * A so-far healthy VM will be marked unhealthy after this many consecutive failures. The default
   * value is 2.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer unhealthyThreshold;

  /**
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * The value returned may be {@code null}.
   */
  public Integer getCheckIntervalSec() {
    return checkIntervalSec;
  }

  /**
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setCheckIntervalSec(Integer checkIntervalSec) {
    this.checkIntervalSec = checkIntervalSec;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * A so-far unhealthy VM will be marked healthy after this many consecutive successes. The default
   * value is 2.
   * The value returned may be {@code null}.
   */
  public Integer getHealthyThreshold() {
    return healthyThreshold;
  }

  /**
   * A so-far unhealthy VM will be marked healthy after this many consecutive successes. The default
   * value is 2.
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setHealthyThreshold(Integer healthyThreshold) {
    this.healthyThreshold = healthyThreshold;
    return this;
  }

  /**
   * The host name of the HTTP health check request. If left empty (default value), the public IP on
   * behalf of which this health check is performed will be used.
   * The value returned may be {@code null}.
   */
  public String getHost() {
    return host;
  }

  /**
   * The host name of the HTTP health check request. If left empty (default value), the public IP on
   * behalf of which this health check is performed will be used.
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setHost(String host) {
    this.host = host;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * The TCP port number for the HTTP health check request. The default value is 80.
   * The value returned may be {@code null}.
   */
  public Integer getPort() {
    return port;
  }

  /**
   * The TCP port number for the HTTP health check request. The default value is 80.
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setPort(Integer port) {
    this.port = port;
    return this;
  }

  /**
   * The request path of the HTTP health check request. The default value is "/".
   * The value returned may be {@code null}.
   */
  public String getRequestPath() {
    return requestPath;
  }

  /**
   * The request path of the HTTP health check request. The default value is "/".
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setRequestPath(String requestPath) {
    this.requestPath = requestPath;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds.
   * The value returned may be {@code null}.
   */
  public Integer getTimeoutSec() {
    return timeoutSec;
  }

  /**
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds.
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setTimeoutSec(Integer timeoutSec) {
    this.timeoutSec = timeoutSec;
    return this;
  }

  /**
   * A so-far healthy VM will be marked unhealthy after this many consecutive failures. The default
   * value is 2.
   * The value returned may be {@code null}.
   */
  public Integer getUnhealthyThreshold() {
    return unhealthyThreshold;
  }

  /**
   * A so-far healthy VM will be marked unhealthy after this many consecutive failures. The default
   * value is 2.
   * The value set may be {@code null}.
   */
  public HttpHealthCheck setUnhealthyThreshold(Integer unhealthyThreshold) {
    this.unhealthyThreshold = unhealthyThreshold;
    return this;
  }

}
