/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * A project resource. Projects can be created only in the APIs Console. Unless marked otherwise,
 * values can only be modified in the console.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Project extends GenericJson {

  /**
   * Metadata key/value pairs available to all instances contained in this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata commonInstanceMetadata;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * An optional textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Quotas assigned to this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Quota> quotas;

  static {
    // hack to force ProGuard to consider Quota used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Quota.class);
  }

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Metadata key/value pairs available to all instances contained in this project.
   * The value returned may be {@code null}.
   */
  public Metadata getCommonInstanceMetadata() {
    return commonInstanceMetadata;
  }

  /**
   * Metadata key/value pairs available to all instances contained in this project.
   * The value set may be {@code null}.
   */
  public Project setCommonInstanceMetadata(Metadata commonInstanceMetadata) {
    this.commonInstanceMetadata = commonInstanceMetadata;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Project setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource.
   * The value set may be {@code null}.
   */
  public Project setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Project setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Project setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource.
   * The value set may be {@code null}.
   */
  public Project setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Quotas assigned to this project.
   * The value returned may be {@code null}.
   */
  public java.util.List<Quota> getQuotas() {
    return quotas;
  }

  /**
   * Quotas assigned to this project.
   * The value set may be {@code null}.
   */
  public Project setQuotas(java.util.List<Quota> quotas) {
    this.quotas = quotas;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Project setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

}
