/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * The route resource. A Route is a rule that specifies how certain packets should be handled by the
 * virtual network. Routes are associated with VMs by tag and the set of Routes for a particular VM
 * is called its routing table. For each packet leaving a VM, the system searches that VM's routing
 * table for a single best matching Route. Routes match packets by destination IP address,
 * preferring smaller or more specific ranges over larger ones. If there is a tie, the system
 * selects the Route with the smallest priority value. If there is still a tie, it uses the layer
 * three and four packet headers to select just one of the remaining matching Routes. The packet is
 * then forwarded as specified by the next_hop field of the winning Route -- either to another VM
 * destination, a VM gateway or a GCE operated gateway. Packets that do not match any Route in the
 * sending VM's routing table will be dropped.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Route extends GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Which packets does this route apply to?
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String destRange;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * URL of the network to which this route is applied; provided by the client when the route is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String network;

  /**
   * The URL to a gateway that should handle matching packets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextHopGateway;

  /**
   * The URL to an instance that should handle matching packets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextHopInstance;

  /**
   * The network IP address of an instance that should handle matching packets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextHopIp;

  /**
   * The URL of the local network if it should handle matching packets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextHopNetwork;

  /**
   * Breaks ties between Routes of equal specificity. Routes with smaller values win when tied with
   * routes with larger values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Long priority;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * A list of instance tags to which this route applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> tags;

  /**
   * If potential misconfigurations are detected for this route, this field will be populated with
   * warning messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Warnings> warnings;

  static {
    // hack to force ProGuard to consider Warnings used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Warnings.class);
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Route setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value set may be {@code null}.
   */
  public Route setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Which packets does this route apply to?
   * The value returned may be {@code null}.
   */
  public String getDestRange() {
    return destRange;
  }

  /**
   * Which packets does this route apply to?
   * The value set may be {@code null}.
   */
  public Route setDestRange(String destRange) {
    this.destRange = destRange;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Route setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Route setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public Route setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the network to which this route is applied; provided by the client when the route is
   * created.
   * The value returned may be {@code null}.
   */
  public String getNetwork() {
    return network;
  }

  /**
   * URL of the network to which this route is applied; provided by the client when the route is
   * created.
   * The value set may be {@code null}.
   */
  public Route setNetwork(String network) {
    this.network = network;
    return this;
  }

  /**
   * The URL to a gateway that should handle matching packets.
   * The value returned may be {@code null}.
   */
  public String getNextHopGateway() {
    return nextHopGateway;
  }

  /**
   * The URL to a gateway that should handle matching packets.
   * The value set may be {@code null}.
   */
  public Route setNextHopGateway(String nextHopGateway) {
    this.nextHopGateway = nextHopGateway;
    return this;
  }

  /**
   * The URL to an instance that should handle matching packets.
   * The value returned may be {@code null}.
   */
  public String getNextHopInstance() {
    return nextHopInstance;
  }

  /**
   * The URL to an instance that should handle matching packets.
   * The value set may be {@code null}.
   */
  public Route setNextHopInstance(String nextHopInstance) {
    this.nextHopInstance = nextHopInstance;
    return this;
  }

  /**
   * The network IP address of an instance that should handle matching packets.
   * The value returned may be {@code null}.
   */
  public String getNextHopIp() {
    return nextHopIp;
  }

  /**
   * The network IP address of an instance that should handle matching packets.
   * The value set may be {@code null}.
   */
  public Route setNextHopIp(String nextHopIp) {
    this.nextHopIp = nextHopIp;
    return this;
  }

  /**
   * The URL of the local network if it should handle matching packets.
   * The value returned may be {@code null}.
   */
  public String getNextHopNetwork() {
    return nextHopNetwork;
  }

  /**
   * The URL of the local network if it should handle matching packets.
   * The value set may be {@code null}.
   */
  public Route setNextHopNetwork(String nextHopNetwork) {
    this.nextHopNetwork = nextHopNetwork;
    return this;
  }

  /**
   * Breaks ties between Routes of equal specificity. Routes with smaller values win when tied with
   * routes with larger values.
   * The value returned may be {@code null}.
   */
  public Long getPriority() {
    return priority;
  }

  /**
   * Breaks ties between Routes of equal specificity. Routes with smaller values win when tied with
   * routes with larger values.
   * The value set may be {@code null}.
   */
  public Route setPriority(Long priority) {
    this.priority = priority;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Route setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * A list of instance tags to which this route applies.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getTags() {
    return tags;
  }

  /**
   * A list of instance tags to which this route applies.
   * The value set may be {@code null}.
   */
  public Route setTags(java.util.List<String> tags) {
    this.tags = tags;
    return this;
  }

  /**
   * If potential misconfigurations are detected for this route, this field will be populated with
   * warning messages.
   * The value returned may be {@code null}.
   */
  public java.util.List<Warnings> getWarnings() {
    return warnings;
  }

  /**
   * If potential misconfigurations are detected for this route, this field will be populated with
   * warning messages.
   * The value set may be {@code null}.
   */
  public Route setWarnings(java.util.List<Warnings> warnings) {
    this.warnings = warnings;
    return this;
  }

  /**
   * Model definition for RouteWarnings.
   */
  public static final class Warnings extends GenericJson {

    /**
     * The warning type identifier for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String code;

    /**
     * Metadata for this warning in 'key: value' format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Data> data;

    static {
      // hack to force ProGuard to consider Data used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Data.class);
    }

    /**
     * Optional human-readable details for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String message;

    /**
     * The warning type identifier for this warning.
     * The value returned may be {@code null}.
     */
    public String getCode() {
      return code;
    }

    /**
     * The warning type identifier for this warning.
     * The value set may be {@code null}.
     */
    public Warnings setCode(String code) {
      this.code = code;
      return this;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * The value returned may be {@code null}.
     */
    public java.util.List<Data> getData() {
      return data;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * The value set may be {@code null}.
     */
    public Warnings setData(java.util.List<Data> data) {
      this.data = data;
      return this;
    }

    /**
     * Optional human-readable details for this warning.
     * The value returned may be {@code null}.
     */
    public String getMessage() {
      return message;
    }

    /**
     * Optional human-readable details for this warning.
     * The value set may be {@code null}.
     */
    public Warnings setMessage(String message) {
      this.message = message;
      return this;
    }

    /**
     * Model definition for RouteWarningsData.
     */
    public static final class Data extends GenericJson {

      /**
       * A key for the warning data.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String key;

      /**
       * A warning data value corresponding to the key.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String value;

      /**
       * A key for the warning data.
       * The value returned may be {@code null}.
       */
      public String getKey() {
        return key;
      }

      /**
       * A key for the warning data.
       * The value set may be {@code null}.
       */
      public Data setKey(String key) {
        this.key = key;
        return this;
      }

      /**
       * A warning data value corresponding to the key.
       * The value returned may be {@code null}.
       */
      public String getValue() {
        return value;
      }

      /**
       * A warning data value corresponding to the key.
       * The value set may be {@code null}.
       */
      public Data setValue(String value) {
        this.value = value;
        return this;
      }

    }
  }

}
