/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * Region resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Region extends GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * The deprecation status associated with this region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeprecationStatus deprecated;

  /**
   * Textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Quotas assigned to this region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Quota> quotas;

  static {
    // hack to force ProGuard to consider Quota used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Quota.class);
  }

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Status of the region, "UP" or "DOWN".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String status;

  /**
   * A list of zones homed in this region, in the form of resource URLs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> zones;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Region setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * The deprecation status associated with this region.
   * The value returned may be {@code null}.
   */
  public DeprecationStatus getDeprecated() {
    return deprecated;
  }

  /**
   * The deprecation status associated with this region.
   * The value set may be {@code null}.
   */
  public Region setDeprecated(DeprecationStatus deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * Textual description of the resource.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * Textual description of the resource.
   * The value set may be {@code null}.
   */
  public Region setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Region setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Region setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource.
   * The value set may be {@code null}.
   */
  public Region setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Quotas assigned to this region.
   * The value returned may be {@code null}.
   */
  public java.util.List<Quota> getQuotas() {
    return quotas;
  }

  /**
   * Quotas assigned to this region.
   * The value set may be {@code null}.
   */
  public Region setQuotas(java.util.List<Quota> quotas) {
    this.quotas = quotas;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Region setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Status of the region, "UP" or "DOWN".
   * The value returned may be {@code null}.
   */
  public String getStatus() {
    return status;
  }

  /**
   * Status of the region, "UP" or "DOWN".
   * The value set may be {@code null}.
   */
  public Region setStatus(String status) {
    this.status = status;
    return this;
  }

  /**
   * A list of zones homed in this region, in the form of resource URLs.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getZones() {
    return zones;
  }

  /**
   * A list of zones homed in this region, in the form of resource URLs.
   * The value set may be {@code null}.
   */
  public Region setZones(java.util.List<String> zones) {
    this.zones = zones;
    return this;
  }

}
