/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;

/**
 * Model definition for TargetPoolsScopedList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetPoolsScopedList extends GenericJson {

  /**
   * List of target pools contained in this scope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TargetPool> targetPools;

  static {
    // hack to force ProGuard to consider TargetPool used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(TargetPool.class);
  }

  /**
   * Informational warning which replaces the list of addresses when the list is empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Warning warning;

  /**
   * List of target pools contained in this scope.
   * The value returned may be {@code null}.
   */
  public java.util.List<TargetPool> getTargetPools() {
    return targetPools;
  }

  /**
   * List of target pools contained in this scope.
   * The value set may be {@code null}.
   */
  public TargetPoolsScopedList setTargetPools(java.util.List<TargetPool> targetPools) {
    this.targetPools = targetPools;
    return this;
  }

  /**
   * Informational warning which replaces the list of addresses when the list is empty.
   * The value returned may be {@code null}.
   */
  public Warning getWarning() {
    return warning;
  }

  /**
   * Informational warning which replaces the list of addresses when the list is empty.
   * The value set may be {@code null}.
   */
  public TargetPoolsScopedList setWarning(Warning warning) {
    this.warning = warning;
    return this;
  }

  /**
   * Informational warning which replaces the list of addresses when the list is empty.
   */
  public static final class Warning extends GenericJson {

    /**
     * The warning type identifier for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String code;

    /**
     * Metadata for this warning in 'key: value' format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Data> data;

    static {
      // hack to force ProGuard to consider Data used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Data.class);
    }

    /**
     * Optional human-readable details for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String message;

    /**
     * The warning type identifier for this warning.
     * The value returned may be {@code null}.
     */
    public String getCode() {
      return code;
    }

    /**
     * The warning type identifier for this warning.
     * The value set may be {@code null}.
     */
    public Warning setCode(String code) {
      this.code = code;
      return this;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * The value returned may be {@code null}.
     */
    public java.util.List<Data> getData() {
      return data;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * The value set may be {@code null}.
     */
    public Warning setData(java.util.List<Data> data) {
      this.data = data;
      return this;
    }

    /**
     * Optional human-readable details for this warning.
     * The value returned may be {@code null}.
     */
    public String getMessage() {
      return message;
    }

    /**
     * Optional human-readable details for this warning.
     * The value set may be {@code null}.
     */
    public Warning setMessage(String message) {
      this.message = message;
      return this;
    }

    /**
     * Model definition for TargetPoolsScopedListWarningData.
     */
    public static final class Data extends GenericJson {

      /**
       * A key for the warning data.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String key;

      /**
       * A warning data value corresponding to the key.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String value;

      /**
       * A key for the warning data.
       * The value returned may be {@code null}.
       */
      public String getKey() {
        return key;
      }

      /**
       * A key for the warning data.
       * The value set may be {@code null}.
       */
      public Data setKey(String key) {
        this.key = key;
        return this;
      }

      /**
       * A warning data value corresponding to the key.
       * The value returned may be {@code null}.
       */
      public String getValue() {
        return value;
      }

      /**
       * A warning data value corresponding to the key.
       * The value set may be {@code null}.
       */
      public Data setValue(String value) {
        this.value = value;
        return this;
      }

    }
  }
}
