/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-12-19 23:55:21 UTC)
 * on 2014-02-10 at 17:38:48 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The route resource. A Route is a rule that specifies how certain packets should be handled by the
 * virtual network. Routes are associated with VMs by tag and the set of Routes for a particular VM
 * is called its routing table. For each packet leaving a VM, the system searches that VM's routing
 * table for a single best matching Route. Routes match packets by destination IP address,
 * preferring smaller or more specific ranges over larger ones. If there is a tie, the system
 * selects the Route with the smallest priority value. If there is still a tie, it uses the layer
 * three and four packet headers to select just one of the remaining matching Routes. The packet is
 * then forwarded as specified by the next_hop field of the winning Route -- either to another VM
 * destination, a VM gateway or a GCE operated gateway. Packets that do not match any Route in the
 * sending VM's routing table will be dropped.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Route extends com.google.api.client.json.GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Which packets does this route apply to?
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destRange;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * URL of the network to which this route is applied; provided by the client when the route is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * The URL to a gateway that should handle matching packets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextHopGateway;

  /**
   * The URL to an instance that should handle matching packets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextHopInstance;

  /**
   * The network IP address of an instance that should handle matching packets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextHopIp;

  /**
   * The URL of the local network if it should handle matching packets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextHopNetwork;

  /**
   * Breaks ties between Routes of equal specificity. Routes with smaller values win when tied with
   * routes with larger values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long priority;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * A list of instance tags to which this route applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * If potential misconfigurations are detected for this route, this field will be populated with
   * warning messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Warnings> warnings;

  static {
    // hack to force ProGuard to consider Warnings used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Warnings.class);
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Route setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public Route setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Which packets does this route apply to?
   * @return value or {@code null} for none
   */
  public java.lang.String getDestRange() {
    return destRange;
  }

  /**
   * Which packets does this route apply to?
   * @param destRange destRange or {@code null} for none
   */
  public Route setDestRange(java.lang.String destRange) {
    this.destRange = destRange;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public Route setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public Route setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public Route setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the network to which this route is applied; provided by the client when the route is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * URL of the network to which this route is applied; provided by the client when the route is
   * created.
   * @param network network or {@code null} for none
   */
  public Route setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * The URL to a gateway that should handle matching packets.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextHopGateway() {
    return nextHopGateway;
  }

  /**
   * The URL to a gateway that should handle matching packets.
   * @param nextHopGateway nextHopGateway or {@code null} for none
   */
  public Route setNextHopGateway(java.lang.String nextHopGateway) {
    this.nextHopGateway = nextHopGateway;
    return this;
  }

  /**
   * The URL to an instance that should handle matching packets.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextHopInstance() {
    return nextHopInstance;
  }

  /**
   * The URL to an instance that should handle matching packets.
   * @param nextHopInstance nextHopInstance or {@code null} for none
   */
  public Route setNextHopInstance(java.lang.String nextHopInstance) {
    this.nextHopInstance = nextHopInstance;
    return this;
  }

  /**
   * The network IP address of an instance that should handle matching packets.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextHopIp() {
    return nextHopIp;
  }

  /**
   * The network IP address of an instance that should handle matching packets.
   * @param nextHopIp nextHopIp or {@code null} for none
   */
  public Route setNextHopIp(java.lang.String nextHopIp) {
    this.nextHopIp = nextHopIp;
    return this;
  }

  /**
   * The URL of the local network if it should handle matching packets.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextHopNetwork() {
    return nextHopNetwork;
  }

  /**
   * The URL of the local network if it should handle matching packets.
   * @param nextHopNetwork nextHopNetwork or {@code null} for none
   */
  public Route setNextHopNetwork(java.lang.String nextHopNetwork) {
    this.nextHopNetwork = nextHopNetwork;
    return this;
  }

  /**
   * Breaks ties between Routes of equal specificity. Routes with smaller values win when tied with
   * routes with larger values.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPriority() {
    return priority;
  }

  /**
   * Breaks ties between Routes of equal specificity. Routes with smaller values win when tied with
   * routes with larger values.
   * @param priority priority or {@code null} for none
   */
  public Route setPriority(java.lang.Long priority) {
    this.priority = priority;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public Route setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * A list of instance tags to which this route applies.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * A list of instance tags to which this route applies.
   * @param tags tags or {@code null} for none
   */
  public Route setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  /**
   * If potential misconfigurations are detected for this route, this field will be populated with
   * warning messages.
   * @return value or {@code null} for none
   */
  public java.util.List<Warnings> getWarnings() {
    return warnings;
  }

  /**
   * If potential misconfigurations are detected for this route, this field will be populated with
   * warning messages.
   * @param warnings warnings or {@code null} for none
   */
  public Route setWarnings(java.util.List<Warnings> warnings) {
    this.warnings = warnings;
    return this;
  }

  @Override
  public Route set(String fieldName, Object value) {
    return (Route) super.set(fieldName, value);
  }

  @Override
  public Route clone() {
    return (Route) super.clone();
  }

  /**
   * Model definition for RouteWarnings.
   */
  public static final class Warnings extends com.google.api.client.json.GenericJson {

    /**
     * The warning type identifier for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String code;

    /**
     * Metadata for this warning in 'key: value' format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Data> data;

    static {
      // hack to force ProGuard to consider Data used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Data.class);
    }

    /**
     * Optional human-readable details for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String message;

    /**
     * The warning type identifier for this warning.
     * @return value or {@code null} for none
     */
    public java.lang.String getCode() {
      return code;
    }

    /**
     * The warning type identifier for this warning.
     * @param code code or {@code null} for none
     */
    public Warnings setCode(java.lang.String code) {
      this.code = code;
      return this;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * @return value or {@code null} for none
     */
    public java.util.List<Data> getData() {
      return data;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * @param data data or {@code null} for none
     */
    public Warnings setData(java.util.List<Data> data) {
      this.data = data;
      return this;
    }

    /**
     * Optional human-readable details for this warning.
     * @return value or {@code null} for none
     */
    public java.lang.String getMessage() {
      return message;
    }

    /**
     * Optional human-readable details for this warning.
     * @param message message or {@code null} for none
     */
    public Warnings setMessage(java.lang.String message) {
      this.message = message;
      return this;
    }

    @Override
    public Warnings set(String fieldName, Object value) {
      return (Warnings) super.set(fieldName, value);
    }

    @Override
    public Warnings clone() {
      return (Warnings) super.clone();
    }

    /**
     * Model definition for RouteWarningsData.
     */
    public static final class Data extends com.google.api.client.json.GenericJson {

      /**
       * A key for the warning data.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String key;

      /**
       * A warning data value corresponding to the key.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String value;

      /**
       * A key for the warning data.
       * @return value or {@code null} for none
       */
      public java.lang.String getKey() {
        return key;
      }

      /**
       * A key for the warning data.
       * @param key key or {@code null} for none
       */
      public Data setKey(java.lang.String key) {
        this.key = key;
        return this;
      }

      /**
       * A warning data value corresponding to the key.
       * @return value or {@code null} for none
       */
      public java.lang.String getValue() {
        return value;
      }

      /**
       * A warning data value corresponding to the key.
       * @param value value or {@code null} for none
       */
      public Data setValue(java.lang.String value) {
        this.value = value;
        return this;
      }

      @Override
      public Data set(String fieldName, Object value) {
        return (Data) super.set(fieldName, value);
      }

      @Override
      public Data clone() {
        return (Data) super.clone();
      }

    }
  }

}
