/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-02-14 18:40:25 UTC)
 * on 2014-03-12 at 01:16:25 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute;

/**
 * Service definition for Compute (v1beta16).
 *
 * <p>
 * API for the Google Compute Engine service.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/compute/docs/reference/v1beta16" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link ComputeRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Compute extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.17.0-rc of the Compute Engine API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "compute/v1beta16/projects/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Compute(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Compute(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Addresses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Addresses.List request = compute.addresses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Addresses addresses() {
    return new Addresses();
  }

  /**
   * The "addresses" collection of methods.
   */
  public class Addresses {

    /**
     * Retrieves the list of addresses grouped by scope.
     *
     * Create a request for the method "addresses.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AddressAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of addresses grouped by scope.
       *
       * Create a request for the method "addresses.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified address resource.
     *
     * Create a request for the method "addresses.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param address Name of the address resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String address) throws java.io.IOException {
      Delete result = new Delete(project, region, address);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified address resource.
       *
       * Create a request for the method "addresses.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param address Name of the address resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String address) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to delete.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to delete. */
      public Delete setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified address resource.
     *
     * Create a request for the method "addresses.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param address Name of the address resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String address) throws java.io.IOException {
      Get result = new Get(project, region, address);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Address> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified address resource.
       *
       * Create a request for the method "addresses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param address Name of the address resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String address) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Address.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to return.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to return. */
      public Get setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an address resource in the specified project using the data included in the request.
     *
     * Create a request for the method "addresses.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Address}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.Address content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an address resource in the specified project using the data included in the request.
       *
       * Create a request for the method "addresses.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Address}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.Address content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of address resources contained within the specified region.
     *
     * Create a request for the method "addresses.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AddressList> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of address resources contained within the specified region.
       *
       * Create a request for the method "addresses.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Disks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Disks.List request = compute.disks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Disks disks() {
    return new Disks();
  }

  /**
   * The "disks" collection of methods.
   */
  public class Disks {

    /**
     * Retrieves the list of disks grouped by scope.
     *
     * Create a request for the method "disks.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.DiskAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of disks grouped by scope.
       *
       * Create a request for the method "disks.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Create a request for the method "disks.createSnapshot".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param disk Name of the persistent disk resource to snapshot.
     * @param content the {@link com.google.api.services.compute.model.Snapshot}
     * @return the request
     */
    public CreateSnapshot createSnapshot(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Snapshot content) throws java.io.IOException {
      CreateSnapshot result = new CreateSnapshot(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class CreateSnapshot extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}/createSnapshot";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Create a request for the method "disks.createSnapshot".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
       * <p> {@link CreateSnapshot#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param disk Name of the persistent disk resource to snapshot.
       * @param content the {@link com.google.api.services.compute.model.Snapshot}
       * @since 1.13
       */
      protected CreateSnapshot(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Snapshot content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public CreateSnapshot setAlt(java.lang.String alt) {
        return (CreateSnapshot) super.setAlt(alt);
      }

      @Override
      public CreateSnapshot setFields(java.lang.String fields) {
        return (CreateSnapshot) super.setFields(fields);
      }

      @Override
      public CreateSnapshot setKey(java.lang.String key) {
        return (CreateSnapshot) super.setKey(key);
      }

      @Override
      public CreateSnapshot setOauthToken(java.lang.String oauthToken) {
        return (CreateSnapshot) super.setOauthToken(oauthToken);
      }

      @Override
      public CreateSnapshot setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CreateSnapshot) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CreateSnapshot setQuotaUser(java.lang.String quotaUser) {
        return (CreateSnapshot) super.setQuotaUser(quotaUser);
      }

      @Override
      public CreateSnapshot setUserIp(java.lang.String userIp) {
        return (CreateSnapshot) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public CreateSnapshot setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public CreateSnapshot setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk resource to snapshot. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk resource to snapshot.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk resource to snapshot. */
      public CreateSnapshot setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public CreateSnapshot set(String parameterName, Object value) {
        return (CreateSnapshot) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified persistent disk resource.
     *
     * Create a request for the method "disks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param disk Name of the persistent disk resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String disk) throws java.io.IOException {
      Delete result = new Delete(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified persistent disk resource.
       *
       * Create a request for the method "disks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param disk Name of the persistent disk resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String disk) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk resource to delete.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk resource to delete. */
      public Delete setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified persistent disk resource.
     *
     * Create a request for the method "disks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param disk Name of the persistent disk resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String disk) throws java.io.IOException {
      Get result = new Get(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Disk> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified persistent disk resource.
       *
       * Create a request for the method "disks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param disk Name of the persistent disk resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String disk) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Disk.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk resource to return.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk resource to return. */
      public Get setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a persistent disk resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "disks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Disk}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Disk content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a persistent disk resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "disks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Disk}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Disk content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Source image to restore onto a disk. */
      @com.google.api.client.util.Key
      private java.lang.String sourceImage;

      /** Optional. Source image to restore onto a disk.
       */
      public java.lang.String getSourceImage() {
        return sourceImage;
      }

      /** Optional. Source image to restore onto a disk. */
      public Insert setSourceImage(java.lang.String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of persistent disk resources contained within the specified zone.
     *
     * Create a request for the method "disks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.DiskList> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of persistent disk resources contained within the specified zone.
       *
       * Create a request for the method "disks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Firewalls collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Firewalls.List request = compute.firewalls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Firewalls firewalls() {
    return new Firewalls();
  }

  /**
   * The "firewalls" collection of methods.
   */
  public class Firewalls {

    /**
     * Deletes the specified firewall resource.
     *
     * Create a request for the method "firewalls.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param firewall Name of the firewall resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String firewall) throws java.io.IOException {
      Delete result = new Delete(project, firewall);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified firewall resource.
       *
       * Create a request for the method "firewalls.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param firewall Name of the firewall resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String firewall) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall resource to delete.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to delete. */
      public Delete setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified firewall resource.
     *
     * Create a request for the method "firewalls.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param firewall Name of the firewall resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String firewall) throws java.io.IOException {
      Get result = new Get(project, firewall);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Firewall> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified firewall resource.
       *
       * Create a request for the method "firewalls.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param firewall Name of the firewall resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String firewall) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Firewall.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall resource to return.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to return. */
      public Get setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a firewall resource in the specified project using the data included in the request.
     *
     * Create a request for the method "firewalls.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a firewall resource in the specified project using the data included in the request.
       *
       * Create a request for the method "firewalls.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of firewall resources available to the specified project.
     *
     * Create a request for the method "firewalls.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.FirewallList> {

      private static final String REST_PATH = "{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of firewall resources available to the specified project.
       *
       * Create a request for the method "firewalls.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified firewall resource with the data included in the request. This method
     * supports patch semantics.
     *
     * Create a request for the method "firewalls.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param firewall Name of the firewall resource to update.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Patch result = new Patch(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified firewall resource with the data included in the request. This method
       * supports patch semantics.
       *
       * Create a request for the method "firewalls.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param firewall Name of the firewall resource to update.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall resource to update.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to update. */
      public Patch setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified firewall resource with the data included in the request.
     *
     * Create a request for the method "firewalls.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param firewall Name of the firewall resource to update.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Update result = new Update(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified firewall resource with the data included in the request.
       *
       * Create a request for the method "firewalls.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param firewall Name of the firewall resource to update.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall resource to update.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to update. */
      public Update setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ForwardingRules collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.ForwardingRules.List request = compute.forwardingRules().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ForwardingRules forwardingRules() {
    return new ForwardingRules();
  }

  /**
   * The "forwardingRules" collection of methods.
   */
  public class ForwardingRules {

    /**
     * Retrieves the list of forwarding rules grouped by scope.
     *
     * Create a request for the method "forwardingRules.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of forwarding rules grouped by scope.
       *
       * Create a request for the method "forwardingRules.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) throws java.io.IOException {
      Delete result = new Delete(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDINGRULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to delete.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to delete. */
      public Delete setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) throws java.io.IOException {
      Get result = new Get(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.ForwardingRule> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDINGRULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRule.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to return.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to return. */
      public Get setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a ForwardingRule resource in the specified project and region using the data included in
     * the request.
     *
     * Create a request for the method "forwardingRules.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.ForwardingRule content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a ForwardingRule resource in the specified project and region using the data included
       * in the request.
       *
       * Create a request for the method "forwardingRules.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.ForwardingRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of ForwardingRule resources available to the specified project and region.
     *
     * Create a request for the method "forwardingRules.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleList> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of ForwardingRule resources available to the specified project and region.
       *
       * Create a request for the method "forwardingRules.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Changes target url for forwarding rule.
     *
     * Create a request for the method "forwardingRules.setTarget".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
     * @param content the {@link com.google.api.services.compute.model.TargetReference}
     * @return the request
     */
    public SetTarget setTarget(java.lang.String project, java.lang.String region, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) throws java.io.IOException {
      SetTarget result = new SetTarget(project, region, forwardingRule, content);
      initialize(result);
      return result;
    }

    public class SetTarget extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDINGRULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes target url for forwarding rule.
       *
       * Create a request for the method "forwardingRules.setTarget".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetTarget#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
       * @param content the {@link com.google.api.services.compute.model.TargetReference}
       * @since 1.13
       */
      protected SetTarget(java.lang.String project, java.lang.String region, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTarget setAlt(java.lang.String alt) {
        return (SetTarget) super.setAlt(alt);
      }

      @Override
      public SetTarget setFields(java.lang.String fields) {
        return (SetTarget) super.setFields(fields);
      }

      @Override
      public SetTarget setKey(java.lang.String key) {
        return (SetTarget) super.setKey(key);
      }

      @Override
      public SetTarget setOauthToken(java.lang.String oauthToken) {
        return (SetTarget) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTarget setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTarget) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTarget setQuotaUser(java.lang.String quotaUser) {
        return (SetTarget) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTarget setUserIp(java.lang.String userIp) {
        return (SetTarget) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetTarget setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public SetTarget setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource in which target is to be set.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      public SetTarget setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDINGRULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public SetTarget set(String parameterName, Object value) {
        return (SetTarget) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GlobalOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalOperations.List request = compute.globalOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalOperations globalOperations() {
    return new GlobalOperations();
  }

  /**
   * The "globalOperations" collection of methods.
   */
  public class GlobalOperations {

    /**
     * Retrieves the list of all operations grouped by scope.
     *
     * Create a request for the method "globalOperations.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.OperationAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of all operations grouped by scope.
       *
       * Create a request for the method "globalOperations.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified operation resource.
     *
     * Create a request for the method "globalOperations.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param operation Name of the operation resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String operation) throws java.io.IOException {
      Delete result = new Delete(project, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/global/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified operation resource.
       *
       * Create a request for the method "globalOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param operation Name of the operation resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the operation resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to delete.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to delete. */
      public Delete setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the specified operation resource.
     *
     * Create a request for the method "globalOperations.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param operation Name of the operation resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String operation) throws java.io.IOException {
      Get result = new Get(project, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified operation resource.
       *
       * Create a request for the method "globalOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param operation Name of the operation resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the operation resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to return.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to return. */
      public Get setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of operation resources contained within the specified project.
     *
     * Create a request for the method "globalOperations.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/global/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of operation resources contained within the specified project.
       *
       * Create a request for the method "globalOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the HttpHealthChecks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.HttpHealthChecks.List request = compute.httpHealthChecks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public HttpHealthChecks httpHealthChecks() {
    return new HttpHealthChecks();
  }

  /**
   * The "httpHealthChecks" collection of methods.
   */
  public class HttpHealthChecks {

    /**
     * Deletes the specified HttpHealthCheck resource.
     *
     * Create a request for the method "httpHealthChecks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String httpHealthCheck) throws java.io.IOException {
      Delete result = new Delete(project, httpHealthCheck);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPHEALTHCHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified HttpHealthCheck resource.
       *
       * Create a request for the method "httpHealthChecks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String httpHealthCheck) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to delete.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to delete. */
      public Delete setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified HttpHealthCheck resource.
     *
     * Create a request for the method "httpHealthChecks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String httpHealthCheck) throws java.io.IOException {
      Get result = new Get(project, httpHealthCheck);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.HttpHealthCheck> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPHEALTHCHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified HttpHealthCheck resource.
       *
       * Create a request for the method "httpHealthChecks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String httpHealthCheck) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpHealthCheck.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to return.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to return. */
      public Get setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a HttpHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpHealthChecks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a HttpHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpHealthChecks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of HttpHealthCheck resources available to the specified project.
     *
     * Create a request for the method "httpHealthChecks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.HttpHealthCheckList> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of HttpHealthCheck resources available to the specified project.
       *
       * Create a request for the method "httpHealthChecks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpHealthCheckList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpHealthCheck resource in the specified project using the data included in the
     * request. This method supports patch semantics.
     *
     * Create a request for the method "httpHealthChecks.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Patch result = new Patch(project, httpHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPHEALTHCHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpHealthCheck resource in the specified project using the data included in the
       * request. This method supports patch semantics.
       *
       * Create a request for the method "httpHealthChecks.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to update.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to update. */
      public Patch setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpHealthChecks.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Update result = new Update(project, httpHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTPHEALTHCHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpHealthChecks.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to update.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to update. */
      public Update setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTPHEALTHCHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Images collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Images.List request = compute.images().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Images images() {
    return new Images();
  }

  /**
   * The "images" collection of methods.
   */
  public class Images {

    /**
     * Deletes the specified image resource.
     *
     * Create a request for the method "images.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param image Name of the image resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String image) throws java.io.IOException {
      Delete result = new Delete(project, image);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{image}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified image resource.
       *
       * Create a request for the method "images.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param image Name of the image resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String image) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Name of the image resource to delete.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Name of the image resource to delete. */
      public Delete setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Sets the deprecation status of an image. If no message body is given, clears the deprecation
     * status instead.
     *
     * Create a request for the method "images.deprecate".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Deprecate#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param image Image name.
     * @param content the {@link com.google.api.services.compute.model.DeprecationStatus}
     * @return the request
     */
    public Deprecate deprecate(java.lang.String project, java.lang.String image, com.google.api.services.compute.model.DeprecationStatus content) throws java.io.IOException {
      Deprecate result = new Deprecate(project, image, content);
      initialize(result);
      return result;
    }

    public class Deprecate extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{image}/deprecate";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets the deprecation status of an image. If no message body is given, clears the deprecation
       * status instead.
       *
       * Create a request for the method "images.deprecate".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Deprecate#execute()} method to invoke the remote operation. <p>
       * {@link
       * Deprecate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param image Image name.
       * @param content the {@link com.google.api.services.compute.model.DeprecationStatus}
       * @since 1.13
       */
      protected Deprecate(java.lang.String project, java.lang.String image, com.google.api.services.compute.model.DeprecationStatus content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Deprecate setAlt(java.lang.String alt) {
        return (Deprecate) super.setAlt(alt);
      }

      @Override
      public Deprecate setFields(java.lang.String fields) {
        return (Deprecate) super.setFields(fields);
      }

      @Override
      public Deprecate setKey(java.lang.String key) {
        return (Deprecate) super.setKey(key);
      }

      @Override
      public Deprecate setOauthToken(java.lang.String oauthToken) {
        return (Deprecate) super.setOauthToken(oauthToken);
      }

      @Override
      public Deprecate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Deprecate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Deprecate setQuotaUser(java.lang.String quotaUser) {
        return (Deprecate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Deprecate setUserIp(java.lang.String userIp) {
        return (Deprecate) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Deprecate setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Image name. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Image name.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Image name. */
      public Deprecate setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      @Override
      public Deprecate set(String parameterName, Object value) {
        return (Deprecate) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified image resource.
     *
     * Create a request for the method "images.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param image Name of the image resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String image) throws java.io.IOException {
      Get result = new Get(project, image);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Image> {

      private static final String REST_PATH = "{project}/global/images/{image}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified image resource.
       *
       * Create a request for the method "images.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param image Name of the image resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String image) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Image.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Name of the image resource to return.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Name of the image resource to return. */
      public Get setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an image resource in the specified project using the data included in the request.
     *
     * Create a request for the method "images.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Image}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Image content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an image resource in the specified project using the data included in the request.
       *
       * Create a request for the method "images.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Image}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Image content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of image resources available to the specified project.
     *
     * Create a request for the method "images.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ImageList> {

      private static final String REST_PATH = "{project}/global/images";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of image resources available to the specified project.
       *
       * Create a request for the method "images.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ImageList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Instances collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Instances.List request = compute.instances().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Instances instances() {
    return new Instances();
  }

  /**
   * The "instances" collection of methods.
   */
  public class Instances {

    /**
     * Adds an access config to an instance's network interface.
     *
     * Create a request for the method "instances.addAccessConfig".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddAccessConfig#execute()} method to invoke the remote operation.
     *
     * @param project Project name.
     * @param zone Name of the zone scoping this request.
     * @param instance Instance name.
     * @param networkInterface Network interface name.
     * @param content the {@link com.google.api.services.compute.model.AccessConfig}
     * @return the request
     */
    public AddAccessConfig addAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String networkInterface, com.google.api.services.compute.model.AccessConfig content) throws java.io.IOException {
      AddAccessConfig result = new AddAccessConfig(project, zone, instance, networkInterface, content);
      initialize(result);
      return result;
    }

    public class AddAccessConfig extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/addAccessConfig";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Adds an access config to an instance's network interface.
       *
       * Create a request for the method "instances.addAccessConfig".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddAccessConfig#execute()} method to invoke the remote operation.
       * <p> {@link AddAccessConfig#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project name.
       * @param zone Name of the zone scoping this request.
       * @param instance Instance name.
       * @param networkInterface Network interface name.
       * @param content the {@link com.google.api.services.compute.model.AccessConfig}
       * @since 1.13
       */
      protected AddAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String networkInterface, com.google.api.services.compute.model.AccessConfig content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.networkInterface = com.google.api.client.util.Preconditions.checkNotNull(networkInterface, "Required parameter networkInterface must be specified.");
      }

      @Override
      public AddAccessConfig setAlt(java.lang.String alt) {
        return (AddAccessConfig) super.setAlt(alt);
      }

      @Override
      public AddAccessConfig setFields(java.lang.String fields) {
        return (AddAccessConfig) super.setFields(fields);
      }

      @Override
      public AddAccessConfig setKey(java.lang.String key) {
        return (AddAccessConfig) super.setKey(key);
      }

      @Override
      public AddAccessConfig setOauthToken(java.lang.String oauthToken) {
        return (AddAccessConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public AddAccessConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddAccessConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddAccessConfig setQuotaUser(java.lang.String quotaUser) {
        return (AddAccessConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddAccessConfig setUserIp(java.lang.String userIp) {
        return (AddAccessConfig) super.setUserIp(userIp);
      }

      /** Project name. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project name.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project name. */
      public AddAccessConfig setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public AddAccessConfig setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Instance name. */
      public AddAccessConfig setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Network interface name. */
      @com.google.api.client.util.Key
      private java.lang.String networkInterface;

      /** Network interface name.
       */
      public java.lang.String getNetworkInterface() {
        return networkInterface;
      }

      /** Network interface name. */
      public AddAccessConfig setNetworkInterface(java.lang.String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
      }

      @Override
      public AddAccessConfig set(String parameterName, Object value) {
        return (AddAccessConfig) super.set(parameterName, value);
      }
    }
    /**
     * Create a request for the method "instances.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.InstanceAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Create a request for the method "instances.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Attaches a disk resource to an instance.
     *
     * Create a request for the method "instances.attachDisk".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AttachDisk#execute()} method to invoke the remote operation.
     *
     * @param project Project name.
     * @param zone Name of the zone scoping this request.
     * @param instance Instance name.
     * @param content the {@link com.google.api.services.compute.model.AttachedDisk}
     * @return the request
     */
    public AttachDisk attachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.AttachedDisk content) throws java.io.IOException {
      AttachDisk result = new AttachDisk(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class AttachDisk extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/attachDisk";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Attaches a disk resource to an instance.
       *
       * Create a request for the method "instances.attachDisk".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AttachDisk#execute()} method to invoke the remote operation. <p>
       * {@link
       * AttachDisk#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project name.
       * @param zone Name of the zone scoping this request.
       * @param instance Instance name.
       * @param content the {@link com.google.api.services.compute.model.AttachedDisk}
       * @since 1.13
       */
      protected AttachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.AttachedDisk content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public AttachDisk setAlt(java.lang.String alt) {
        return (AttachDisk) super.setAlt(alt);
      }

      @Override
      public AttachDisk setFields(java.lang.String fields) {
        return (AttachDisk) super.setFields(fields);
      }

      @Override
      public AttachDisk setKey(java.lang.String key) {
        return (AttachDisk) super.setKey(key);
      }

      @Override
      public AttachDisk setOauthToken(java.lang.String oauthToken) {
        return (AttachDisk) super.setOauthToken(oauthToken);
      }

      @Override
      public AttachDisk setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AttachDisk) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AttachDisk setQuotaUser(java.lang.String quotaUser) {
        return (AttachDisk) super.setQuotaUser(quotaUser);
      }

      @Override
      public AttachDisk setUserIp(java.lang.String userIp) {
        return (AttachDisk) super.setUserIp(userIp);
      }

      /** Project name. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project name.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project name. */
      public AttachDisk setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public AttachDisk setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Instance name. */
      public AttachDisk setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public AttachDisk set(String parameterName, Object value) {
        return (AttachDisk) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified instance resource.
     *
     * Create a request for the method "instances.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Delete result = new Delete(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified instance resource.
       *
       * Create a request for the method "instances.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance resource to delete.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance resource to delete. */
      public Delete setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Deletes an access config from an instance's network interface.
     *
     * Create a request for the method "instances.deleteAccessConfig".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DeleteAccessConfig#execute()} method to invoke the remote operation.
     *
     * @param project Project name.
     * @param zone Name of the zone scoping this request.
     * @param instance Instance name.
     * @param accessConfig Access config name.
     * @param networkInterface Network interface name.
     * @return the request
     */
    public DeleteAccessConfig deleteAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String accessConfig, java.lang.String networkInterface) throws java.io.IOException {
      DeleteAccessConfig result = new DeleteAccessConfig(project, zone, instance, accessConfig, networkInterface);
      initialize(result);
      return result;
    }

    public class DeleteAccessConfig extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/deleteAccessConfig";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes an access config from an instance's network interface.
       *
       * Create a request for the method "instances.deleteAccessConfig".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DeleteAccessConfig#execute()} method to invoke the remote
       * operation. <p> {@link DeleteAccessConfig#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project name.
       * @param zone Name of the zone scoping this request.
       * @param instance Instance name.
       * @param accessConfig Access config name.
       * @param networkInterface Network interface name.
       * @since 1.13
       */
      protected DeleteAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String accessConfig, java.lang.String networkInterface) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.accessConfig = com.google.api.client.util.Preconditions.checkNotNull(accessConfig, "Required parameter accessConfig must be specified.");
        this.networkInterface = com.google.api.client.util.Preconditions.checkNotNull(networkInterface, "Required parameter networkInterface must be specified.");
      }

      @Override
      public DeleteAccessConfig setAlt(java.lang.String alt) {
        return (DeleteAccessConfig) super.setAlt(alt);
      }

      @Override
      public DeleteAccessConfig setFields(java.lang.String fields) {
        return (DeleteAccessConfig) super.setFields(fields);
      }

      @Override
      public DeleteAccessConfig setKey(java.lang.String key) {
        return (DeleteAccessConfig) super.setKey(key);
      }

      @Override
      public DeleteAccessConfig setOauthToken(java.lang.String oauthToken) {
        return (DeleteAccessConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteAccessConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteAccessConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteAccessConfig setQuotaUser(java.lang.String quotaUser) {
        return (DeleteAccessConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteAccessConfig setUserIp(java.lang.String userIp) {
        return (DeleteAccessConfig) super.setUserIp(userIp);
      }

      /** Project name. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project name.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project name. */
      public DeleteAccessConfig setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public DeleteAccessConfig setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Instance name. */
      public DeleteAccessConfig setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Access config name. */
      @com.google.api.client.util.Key
      private java.lang.String accessConfig;

      /** Access config name.
       */
      public java.lang.String getAccessConfig() {
        return accessConfig;
      }

      /** Access config name. */
      public DeleteAccessConfig setAccessConfig(java.lang.String accessConfig) {
        this.accessConfig = accessConfig;
        return this;
      }

      /** Network interface name. */
      @com.google.api.client.util.Key
      private java.lang.String networkInterface;

      /** Network interface name.
       */
      public java.lang.String getNetworkInterface() {
        return networkInterface;
      }

      /** Network interface name. */
      public DeleteAccessConfig setNetworkInterface(java.lang.String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
      }

      @Override
      public DeleteAccessConfig set(String parameterName, Object value) {
        return (DeleteAccessConfig) super.set(parameterName, value);
      }
    }
    /**
     * Detaches a disk from an instance.
     *
     * Create a request for the method "instances.detachDisk".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DetachDisk#execute()} method to invoke the remote operation.
     *
     * @param project Project name.
     * @param zone Name of the zone scoping this request.
     * @param instance Instance name.
     * @param deviceName Disk device name to detach.
     * @return the request
     */
    public DetachDisk detachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String deviceName) throws java.io.IOException {
      DetachDisk result = new DetachDisk(project, zone, instance, deviceName);
      initialize(result);
      return result;
    }

    public class DetachDisk extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/detachDisk";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DEVICENAME_PATTERN =
          java.util.regex.Pattern.compile("\\w[\\w.-]{0,254}");

      /**
       * Detaches a disk from an instance.
       *
       * Create a request for the method "instances.detachDisk".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DetachDisk#execute()} method to invoke the remote operation. <p>
       * {@link
       * DetachDisk#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project name.
       * @param zone Name of the zone scoping this request.
       * @param instance Instance name.
       * @param deviceName Disk device name to detach.
       * @since 1.13
       */
      protected DetachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String deviceName) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.deviceName = com.google.api.client.util.Preconditions.checkNotNull(deviceName, "Required parameter deviceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DEVICENAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
      }

      @Override
      public DetachDisk setAlt(java.lang.String alt) {
        return (DetachDisk) super.setAlt(alt);
      }

      @Override
      public DetachDisk setFields(java.lang.String fields) {
        return (DetachDisk) super.setFields(fields);
      }

      @Override
      public DetachDisk setKey(java.lang.String key) {
        return (DetachDisk) super.setKey(key);
      }

      @Override
      public DetachDisk setOauthToken(java.lang.String oauthToken) {
        return (DetachDisk) super.setOauthToken(oauthToken);
      }

      @Override
      public DetachDisk setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DetachDisk) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DetachDisk setQuotaUser(java.lang.String quotaUser) {
        return (DetachDisk) super.setQuotaUser(quotaUser);
      }

      @Override
      public DetachDisk setUserIp(java.lang.String userIp) {
        return (DetachDisk) super.setUserIp(userIp);
      }

      /** Project name. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project name.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project name. */
      public DetachDisk setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public DetachDisk setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Instance name. */
      public DetachDisk setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Disk device name to detach. */
      @com.google.api.client.util.Key
      private java.lang.String deviceName;

      /** Disk device name to detach.
       */
      public java.lang.String getDeviceName() {
        return deviceName;
      }

      /** Disk device name to detach. */
      public DetachDisk setDeviceName(java.lang.String deviceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DEVICENAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
        this.deviceName = deviceName;
        return this;
      }

      @Override
      public DetachDisk set(String parameterName, Object value) {
        return (DetachDisk) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified instance resource.
     *
     * Create a request for the method "instances.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Get result = new Get(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Instance> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified instance resource.
       *
       * Create a request for the method "instances.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Instance.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance resource to return.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance resource to return. */
      public Get setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified instance's serial port output.
     *
     * Create a request for the method "instances.getSerialPortOutput".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetSerialPortOutput#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance scoping this request.
     * @return the request
     */
    public GetSerialPortOutput getSerialPortOutput(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      GetSerialPortOutput result = new GetSerialPortOutput(project, zone, instance);
      initialize(result);
      return result;
    }

    public class GetSerialPortOutput extends ComputeRequest<com.google.api.services.compute.model.SerialPortOutput> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/serialPort";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified instance's serial port output.
       *
       * Create a request for the method "instances.getSerialPortOutput".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetSerialPortOutput#execute()} method to invoke the remote
       * operation. <p> {@link GetSerialPortOutput#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance scoping this request.
       * @since 1.13
       */
      protected GetSerialPortOutput(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.SerialPortOutput.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetSerialPortOutput setAlt(java.lang.String alt) {
        return (GetSerialPortOutput) super.setAlt(alt);
      }

      @Override
      public GetSerialPortOutput setFields(java.lang.String fields) {
        return (GetSerialPortOutput) super.setFields(fields);
      }

      @Override
      public GetSerialPortOutput setKey(java.lang.String key) {
        return (GetSerialPortOutput) super.setKey(key);
      }

      @Override
      public GetSerialPortOutput setOauthToken(java.lang.String oauthToken) {
        return (GetSerialPortOutput) super.setOauthToken(oauthToken);
      }

      @Override
      public GetSerialPortOutput setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetSerialPortOutput) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetSerialPortOutput setQuotaUser(java.lang.String quotaUser) {
        return (GetSerialPortOutput) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetSerialPortOutput setUserIp(java.lang.String userIp) {
        return (GetSerialPortOutput) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public GetSerialPortOutput setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public GetSerialPortOutput setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public GetSerialPortOutput setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public GetSerialPortOutput set(String parameterName, Object value) {
        return (GetSerialPortOutput) super.set(parameterName, value);
      }
    }
    /**
     * Creates an instance resource in the specified project using the data included in the request.
     *
     * Create a request for the method "instances.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Instance}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Instance content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an instance resource in the specified project using the data included in the request.
       *
       * Create a request for the method "instances.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Instance}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Instance content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of instance resources contained within the specified zone.
     *
     * Create a request for the method "instances.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.InstanceList> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of instance resources contained within the specified zone.
       *
       * Create a request for the method "instances.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Performs a hard reset on the instance.
     *
     * Create a request for the method "instances.reset".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Reset#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance scoping this request.
     * @return the request
     */
    public Reset reset(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Reset result = new Reset(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Reset extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/reset";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Performs a hard reset on the instance.
       *
       * Create a request for the method "instances.reset".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Reset#execute()} method to invoke the remote operation. <p> {@link
       * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance scoping this request.
       * @since 1.13
       */
      protected Reset(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Reset setAlt(java.lang.String alt) {
        return (Reset) super.setAlt(alt);
      }

      @Override
      public Reset setFields(java.lang.String fields) {
        return (Reset) super.setFields(fields);
      }

      @Override
      public Reset setKey(java.lang.String key) {
        return (Reset) super.setKey(key);
      }

      @Override
      public Reset setOauthToken(java.lang.String oauthToken) {
        return (Reset) super.setOauthToken(oauthToken);
      }

      @Override
      public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reset setQuotaUser(java.lang.String quotaUser) {
        return (Reset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reset setUserIp(java.lang.String userIp) {
        return (Reset) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Reset setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Reset setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public Reset setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Reset set(String parameterName, Object value) {
        return (Reset) super.set(parameterName, value);
      }
    }
    /**
     * Sets metadata for the specified instance to the data included in the request.
     *
     * Create a request for the method "instances.setMetadata".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetMetadata#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Metadata}
     * @return the request
     */
    public SetMetadata setMetadata(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Metadata content) throws java.io.IOException {
      SetMetadata result = new SetMetadata(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetMetadata extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setMetadata";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets metadata for the specified instance to the data included in the request.
       *
       * Create a request for the method "instances.setMetadata".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetMetadata#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetMetadata#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Metadata}
       * @since 1.13
       */
      protected SetMetadata(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Metadata content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetMetadata setAlt(java.lang.String alt) {
        return (SetMetadata) super.setAlt(alt);
      }

      @Override
      public SetMetadata setFields(java.lang.String fields) {
        return (SetMetadata) super.setFields(fields);
      }

      @Override
      public SetMetadata setKey(java.lang.String key) {
        return (SetMetadata) super.setKey(key);
      }

      @Override
      public SetMetadata setOauthToken(java.lang.String oauthToken) {
        return (SetMetadata) super.setOauthToken(oauthToken);
      }

      @Override
      public SetMetadata setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetMetadata) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetMetadata setQuotaUser(java.lang.String quotaUser) {
        return (SetMetadata) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetMetadata setUserIp(java.lang.String userIp) {
        return (SetMetadata) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetMetadata setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public SetMetadata setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public SetMetadata setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public SetMetadata set(String parameterName, Object value) {
        return (SetMetadata) super.set(parameterName, value);
      }
    }
    /**
     * Sets an instance's scheduling options.
     *
     * Create a request for the method "instances.setScheduling".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetScheduling#execute()} method to invoke the remote operation.
     *
     * @param project Project name.
     * @param zone Name of the zone scoping this request.
     * @param instance Instance name.
     * @param content the {@link com.google.api.services.compute.model.Scheduling}
     * @return the request
     */
    public SetScheduling setScheduling(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Scheduling content) throws java.io.IOException {
      SetScheduling result = new SetScheduling(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetScheduling extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setScheduling";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets an instance's scheduling options.
       *
       * Create a request for the method "instances.setScheduling".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetScheduling#execute()} method to invoke the remote operation. <p>
       * {@link SetScheduling#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param project Project name.
       * @param zone Name of the zone scoping this request.
       * @param instance Instance name.
       * @param content the {@link com.google.api.services.compute.model.Scheduling}
       * @since 1.13
       */
      protected SetScheduling(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Scheduling content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetScheduling setAlt(java.lang.String alt) {
        return (SetScheduling) super.setAlt(alt);
      }

      @Override
      public SetScheduling setFields(java.lang.String fields) {
        return (SetScheduling) super.setFields(fields);
      }

      @Override
      public SetScheduling setKey(java.lang.String key) {
        return (SetScheduling) super.setKey(key);
      }

      @Override
      public SetScheduling setOauthToken(java.lang.String oauthToken) {
        return (SetScheduling) super.setOauthToken(oauthToken);
      }

      @Override
      public SetScheduling setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetScheduling) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetScheduling setQuotaUser(java.lang.String quotaUser) {
        return (SetScheduling) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetScheduling setUserIp(java.lang.String userIp) {
        return (SetScheduling) super.setUserIp(userIp);
      }

      /** Project name. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project name.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project name. */
      public SetScheduling setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public SetScheduling setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Instance name. */
      public SetScheduling setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public SetScheduling set(String parameterName, Object value) {
        return (SetScheduling) super.set(parameterName, value);
      }
    }
    /**
     * Sets tags for the specified instance to the data included in the request.
     *
     * Create a request for the method "instances.setTags".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTags#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param instance Name of the instance scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Tags}
     * @return the request
     */
    public SetTags setTags(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Tags content) throws java.io.IOException {
      SetTags result = new SetTags(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetTags extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setTags";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets tags for the specified instance to the data included in the request.
       *
       * Create a request for the method "instances.setTags".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTags#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetTags#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param instance Name of the instance scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Tags}
       * @since 1.13
       */
      protected SetTags(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Tags content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTags setAlt(java.lang.String alt) {
        return (SetTags) super.setAlt(alt);
      }

      @Override
      public SetTags setFields(java.lang.String fields) {
        return (SetTags) super.setFields(fields);
      }

      @Override
      public SetTags setKey(java.lang.String key) {
        return (SetTags) super.setKey(key);
      }

      @Override
      public SetTags setOauthToken(java.lang.String oauthToken) {
        return (SetTags) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTags setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTags) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTags setQuotaUser(java.lang.String quotaUser) {
        return (SetTags) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTags setUserIp(java.lang.String userIp) {
        return (SetTags) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetTags setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public SetTags setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public SetTags setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public SetTags set(String parameterName, Object value) {
        return (SetTags) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Kernels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Kernels.List request = compute.kernels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Kernels kernels() {
    return new Kernels();
  }

  /**
   * The "kernels" collection of methods.
   */
  public class Kernels {

    /**
     * Returns the specified kernel resource.
     *
     * Create a request for the method "kernels.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param kernel Name of the kernel resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String kernel) throws java.io.IOException {
      Get result = new Get(project, kernel);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Kernel> {

      private static final String REST_PATH = "{project}/global/kernels/{kernel}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern KERNEL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified kernel resource.
       *
       * Create a request for the method "kernels.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param kernel Name of the kernel resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String kernel) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Kernel.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.kernel = com.google.api.client.util.Preconditions.checkNotNull(kernel, "Required parameter kernel must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(KERNEL_PATTERN.matcher(kernel).matches(),
              "Parameter kernel must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the kernel resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String kernel;

      /** Name of the kernel resource to return.
       */
      public java.lang.String getKernel() {
        return kernel;
      }

      /** Name of the kernel resource to return. */
      public Get setKernel(java.lang.String kernel) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(KERNEL_PATTERN.matcher(kernel).matches(),
              "Parameter kernel must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.kernel = kernel;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of kernel resources available to the specified project.
     *
     * Create a request for the method "kernels.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.KernelList> {

      private static final String REST_PATH = "{project}/global/kernels";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of kernel resources available to the specified project.
       *
       * Create a request for the method "kernels.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.KernelList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the MachineTypes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.MachineTypes.List request = compute.machineTypes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public MachineTypes machineTypes() {
    return new MachineTypes();
  }

  /**
   * The "machineTypes" collection of methods.
   */
  public class MachineTypes {

    /**
     * Retrieves the list of machine type resources grouped by scope.
     *
     * Create a request for the method "machineTypes.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.MachineTypeAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/machineTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of machine type resources grouped by scope.
       *
       * Create a request for the method "machineTypes.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineTypeAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified machine type resource.
     *
     * Create a request for the method "machineTypes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param machineType Name of the machine type resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String machineType) throws java.io.IOException {
      Get result = new Get(project, zone, machineType);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.MachineType> {

      private static final String REST_PATH = "{project}/zones/{zone}/machineTypes/{machineType}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern MACHINETYPE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified machine type resource.
       *
       * Create a request for the method "machineTypes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param machineType Name of the machine type resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String machineType) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineType.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.machineType = com.google.api.client.util.Preconditions.checkNotNull(machineType, "Required parameter machineType must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MACHINETYPE_PATTERN.matcher(machineType).matches(),
              "Parameter machineType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the machine type resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String machineType;

      /** Name of the machine type resource to return.
       */
      public java.lang.String getMachineType() {
        return machineType;
      }

      /** Name of the machine type resource to return. */
      public Get setMachineType(java.lang.String machineType) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MACHINETYPE_PATTERN.matcher(machineType).matches(),
              "Parameter machineType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.machineType = machineType;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of machine type resources available to the specified project.
     *
     * Create a request for the method "machineTypes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.MachineTypeList> {

      private static final String REST_PATH = "{project}/zones/{zone}/machineTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of machine type resources available to the specified project.
       *
       * Create a request for the method "machineTypes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineTypeList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Networks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Networks.List request = compute.networks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Networks networks() {
    return new Networks();
  }

  /**
   * The "networks" collection of methods.
   */
  public class Networks {

    /**
     * Deletes the specified network resource.
     *
     * Create a request for the method "networks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param network Name of the network resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String network) throws java.io.IOException {
      Delete result = new Delete(project, network);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/networks/{network}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern NETWORK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified network resource.
       *
       * Create a request for the method "networks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param network Name of the network resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String network) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.network = com.google.api.client.util.Preconditions.checkNotNull(network, "Required parameter network must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the network resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String network;

      /** Name of the network resource to delete.
       */
      public java.lang.String getNetwork() {
        return network;
      }

      /** Name of the network resource to delete. */
      public Delete setNetwork(java.lang.String network) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.network = network;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified network resource.
     *
     * Create a request for the method "networks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param network Name of the network resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String network) throws java.io.IOException {
      Get result = new Get(project, network);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Network> {

      private static final String REST_PATH = "{project}/global/networks/{network}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern NETWORK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified network resource.
       *
       * Create a request for the method "networks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param network Name of the network resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String network) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Network.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.network = com.google.api.client.util.Preconditions.checkNotNull(network, "Required parameter network must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the network resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String network;

      /** Name of the network resource to return.
       */
      public java.lang.String getNetwork() {
        return network;
      }

      /** Name of the network resource to return. */
      public Get setNetwork(java.lang.String network) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.network = network;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a network resource in the specified project using the data included in the request.
     *
     * Create a request for the method "networks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Network}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Network content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/networks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a network resource in the specified project using the data included in the request.
       *
       * Create a request for the method "networks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Network}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Network content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of network resources available to the specified project.
     *
     * Create a request for the method "networks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.NetworkList> {

      private static final String REST_PATH = "{project}/global/networks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of network resources available to the specified project.
       *
       * Create a request for the method "networks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.NetworkList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Projects.List request = compute.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Returns the specified project resource.
     *
     * Create a request for the method "projects.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project resource to retrieve.
     * @return the request
     */
    public Get get(java.lang.String project) throws java.io.IOException {
      Get result = new Get(project);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Project> {

      private static final String REST_PATH = "{project}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Returns the specified project resource.
       *
       * Create a request for the method "projects.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project resource to retrieve.
       * @since 1.13
       */
      protected Get(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Project.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project resource to retrieve. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project resource to retrieve.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project resource to retrieve. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Sets metadata common to all instances within the specified project using the data included in the
     * request.
     *
     * Create a request for the method "projects.setCommonInstanceMetadata".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetCommonInstanceMetadata#execute()} method to invoke the remote
     * operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Metadata}
     * @return the request
     */
    public SetCommonInstanceMetadata setCommonInstanceMetadata(java.lang.String project, com.google.api.services.compute.model.Metadata content) throws java.io.IOException {
      SetCommonInstanceMetadata result = new SetCommonInstanceMetadata(project, content);
      initialize(result);
      return result;
    }

    public class SetCommonInstanceMetadata extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/setCommonInstanceMetadata";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Sets metadata common to all instances within the specified project using the data included in
       * the request.
       *
       * Create a request for the method "projects.setCommonInstanceMetadata".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetCommonInstanceMetadata#execute()} method to invoke the remote
       * operation. <p> {@link SetCommonInstanceMetadata#initialize(com.google.api.client.googleapis.ser
       * vices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Metadata}
       * @since 1.13
       */
      protected SetCommonInstanceMetadata(java.lang.String project, com.google.api.services.compute.model.Metadata content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public SetCommonInstanceMetadata setAlt(java.lang.String alt) {
        return (SetCommonInstanceMetadata) super.setAlt(alt);
      }

      @Override
      public SetCommonInstanceMetadata setFields(java.lang.String fields) {
        return (SetCommonInstanceMetadata) super.setFields(fields);
      }

      @Override
      public SetCommonInstanceMetadata setKey(java.lang.String key) {
        return (SetCommonInstanceMetadata) super.setKey(key);
      }

      @Override
      public SetCommonInstanceMetadata setOauthToken(java.lang.String oauthToken) {
        return (SetCommonInstanceMetadata) super.setOauthToken(oauthToken);
      }

      @Override
      public SetCommonInstanceMetadata setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetCommonInstanceMetadata) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetCommonInstanceMetadata setQuotaUser(java.lang.String quotaUser) {
        return (SetCommonInstanceMetadata) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetCommonInstanceMetadata setUserIp(java.lang.String userIp) {
        return (SetCommonInstanceMetadata) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetCommonInstanceMetadata setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public SetCommonInstanceMetadata set(String parameterName, Object value) {
        return (SetCommonInstanceMetadata) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the RegionOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.RegionOperations.List request = compute.regionOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public RegionOperations regionOperations() {
    return new RegionOperations();
  }

  /**
   * The "regionOperations" collection of methods.
   */
  public class RegionOperations {

    /**
     * Deletes the specified region-specific operation resource.
     *
     * Create a request for the method "regionOperations.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param operation Name of the operation resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String operation) throws java.io.IOException {
      Delete result = new Delete(project, region, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/regions/{region}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified region-specific operation resource.
       *
       * Create a request for the method "regionOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param operation Name of the operation resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the operation resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to delete.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to delete. */
      public Delete setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the specified region-specific operation resource.
     *
     * Create a request for the method "regionOperations.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the zone scoping this request.
     * @param operation Name of the operation resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String operation) throws java.io.IOException {
      Get result = new Get(project, region, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified region-specific operation resource.
       *
       * Create a request for the method "regionOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the zone scoping this request.
       * @param operation Name of the operation resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the zone scoping this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the operation resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to return.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to return. */
      public Get setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of operation resources contained within the specified region.
     *
     * Create a request for the method "regionOperations.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/regions/{region}/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of operation resources contained within the specified region.
       *
       * Create a request for the method "regionOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Regions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Regions.List request = compute.regions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Regions regions() {
    return new Regions();
  }

  /**
   * The "regions" collection of methods.
   */
  public class Regions {

    /**
     * Returns the specified region resource.
     *
     * Create a request for the method "regions.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region) throws java.io.IOException {
      Get result = new Get(project, region);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Region> {

      private static final String REST_PATH = "{project}/regions/{region}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified region resource.
       *
       * Create a request for the method "regions.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Region.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region resource to return.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region resource to return. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of region resources available to the specified project.
     *
     * Create a request for the method "regions.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.RegionList> {

      private static final String REST_PATH = "{project}/regions";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of region resources available to the specified project.
       *
       * Create a request for the method "regions.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.RegionList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Routes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Routes.List request = compute.routes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Routes routes() {
    return new Routes();
  }

  /**
   * The "routes" collection of methods.
   */
  public class Routes {

    /**
     * Deletes the specified route resource.
     *
     * Create a request for the method "routes.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param route Name of the route resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String route) throws java.io.IOException {
      Delete result = new Delete(project, route);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/routes/{route}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ROUTE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified route resource.
       *
       * Create a request for the method "routes.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param route Name of the route resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String route) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.route = com.google.api.client.util.Preconditions.checkNotNull(route, "Required parameter route must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the route resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String route;

      /** Name of the route resource to delete.
       */
      public java.lang.String getRoute() {
        return route;
      }

      /** Name of the route resource to delete. */
      public Delete setRoute(java.lang.String route) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.route = route;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified route resource.
     *
     * Create a request for the method "routes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param route Name of the route resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String route) throws java.io.IOException {
      Get result = new Get(project, route);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Route> {

      private static final String REST_PATH = "{project}/global/routes/{route}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ROUTE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified route resource.
       *
       * Create a request for the method "routes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param route Name of the route resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String route) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Route.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.route = com.google.api.client.util.Preconditions.checkNotNull(route, "Required parameter route must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the route resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String route;

      /** Name of the route resource to return.
       */
      public java.lang.String getRoute() {
        return route;
      }

      /** Name of the route resource to return. */
      public Get setRoute(java.lang.String route) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.route = route;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a route resource in the specified project using the data included in the request.
     *
     * Create a request for the method "routes.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Route}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Route content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/routes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a route resource in the specified project using the data included in the request.
       *
       * Create a request for the method "routes.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Route}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Route content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of route resources available to the specified project.
     *
     * Create a request for the method "routes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.RouteList> {

      private static final String REST_PATH = "{project}/global/routes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of route resources available to the specified project.
       *
       * Create a request for the method "routes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.RouteList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Snapshots collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Snapshots.List request = compute.snapshots().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Snapshots snapshots() {
    return new Snapshots();
  }

  /**
   * The "snapshots" collection of methods.
   */
  public class Snapshots {

    /**
     * Deletes the specified persistent disk snapshot resource.
     *
     * Create a request for the method "snapshots.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param snapshot Name of the persistent disk snapshot resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String snapshot) throws java.io.IOException {
      Delete result = new Delete(project, snapshot);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/snapshots/{snapshot}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern SNAPSHOT_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified persistent disk snapshot resource.
       *
       * Create a request for the method "snapshots.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param snapshot Name of the persistent disk snapshot resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String snapshot) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.snapshot = com.google.api.client.util.Preconditions.checkNotNull(snapshot, "Required parameter snapshot must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the persistent disk snapshot resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String snapshot;

      /** Name of the persistent disk snapshot resource to delete.
       */
      public java.lang.String getSnapshot() {
        return snapshot;
      }

      /** Name of the persistent disk snapshot resource to delete. */
      public Delete setSnapshot(java.lang.String snapshot) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.snapshot = snapshot;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified persistent disk snapshot resource.
     *
     * Create a request for the method "snapshots.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param snapshot Name of the persistent disk snapshot resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String snapshot) throws java.io.IOException {
      Get result = new Get(project, snapshot);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Snapshot> {

      private static final String REST_PATH = "{project}/global/snapshots/{snapshot}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern SNAPSHOT_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified persistent disk snapshot resource.
       *
       * Create a request for the method "snapshots.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param snapshot Name of the persistent disk snapshot resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String snapshot) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Snapshot.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.snapshot = com.google.api.client.util.Preconditions.checkNotNull(snapshot, "Required parameter snapshot must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the persistent disk snapshot resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String snapshot;

      /** Name of the persistent disk snapshot resource to return.
       */
      public java.lang.String getSnapshot() {
        return snapshot;
      }

      /** Name of the persistent disk snapshot resource to return. */
      public Get setSnapshot(java.lang.String snapshot) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.snapshot = snapshot;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of persistent disk snapshot resources contained within the specified project.
     *
     * Create a request for the method "snapshots.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.SnapshotList> {

      private static final String REST_PATH = "{project}/global/snapshots";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of persistent disk snapshot resources contained within the specified
       * project.
       *
       * Create a request for the method "snapshots.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.SnapshotList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the TargetPools collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.TargetPools.List request = compute.targetPools().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public TargetPools targetPools() {
    return new TargetPools();
  }

  /**
   * The "targetPools" collection of methods.
   */
  public class TargetPools {

    /**
     * Adds health check URL to targetPool.
     *
     * Create a request for the method "targetPools.addHealthCheck".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddHealthCheck#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which health_check_url is to be added.
     * @param content the {@link com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest}
     * @return the request
     */
    public AddHealthCheck addHealthCheck(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest content) throws java.io.IOException {
      AddHealthCheck result = new AddHealthCheck(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class AddHealthCheck extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/addHealthCheck";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Adds health check URL to targetPool.
       *
       * Create a request for the method "targetPools.addHealthCheck".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddHealthCheck#execute()} method to invoke the remote operation.
       * <p> {@link AddHealthCheck#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which health_check_url is to be added.
       * @param content the {@link com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest}
       * @since 1.13
       */
      protected AddHealthCheck(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public AddHealthCheck setAlt(java.lang.String alt) {
        return (AddHealthCheck) super.setAlt(alt);
      }

      @Override
      public AddHealthCheck setFields(java.lang.String fields) {
        return (AddHealthCheck) super.setFields(fields);
      }

      @Override
      public AddHealthCheck setKey(java.lang.String key) {
        return (AddHealthCheck) super.setKey(key);
      }

      @Override
      public AddHealthCheck setOauthToken(java.lang.String oauthToken) {
        return (AddHealthCheck) super.setOauthToken(oauthToken);
      }

      @Override
      public AddHealthCheck setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddHealthCheck) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddHealthCheck setQuotaUser(java.lang.String quotaUser) {
        return (AddHealthCheck) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddHealthCheck setUserIp(java.lang.String userIp) {
        return (AddHealthCheck) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public AddHealthCheck setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public AddHealthCheck setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which health_check_url is to be added. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to which health_check_url is to be added.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which health_check_url is to be added. */
      public AddHealthCheck setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public AddHealthCheck set(String parameterName, Object value) {
        return (AddHealthCheck) super.set(parameterName, value);
      }
    }
    /**
     * Adds instance url to targetPool.
     *
     * Create a request for the method "targetPools.addInstance".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddInstance#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which instance_url is to be added.
     * @param content the {@link com.google.api.services.compute.model.TargetPoolsAddInstanceRequest}
     * @return the request
     */
    public AddInstance addInstance(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsAddInstanceRequest content) throws java.io.IOException {
      AddInstance result = new AddInstance(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class AddInstance extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/addInstance";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Adds instance url to targetPool.
       *
       * Create a request for the method "targetPools.addInstance".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddInstance#execute()} method to invoke the remote operation. <p>
       * {@link
       * AddInstance#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which instance_url is to be added.
       * @param content the {@link com.google.api.services.compute.model.TargetPoolsAddInstanceRequest}
       * @since 1.13
       */
      protected AddInstance(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsAddInstanceRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public AddInstance setAlt(java.lang.String alt) {
        return (AddInstance) super.setAlt(alt);
      }

      @Override
      public AddInstance setFields(java.lang.String fields) {
        return (AddInstance) super.setFields(fields);
      }

      @Override
      public AddInstance setKey(java.lang.String key) {
        return (AddInstance) super.setKey(key);
      }

      @Override
      public AddInstance setOauthToken(java.lang.String oauthToken) {
        return (AddInstance) super.setOauthToken(oauthToken);
      }

      @Override
      public AddInstance setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddInstance) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddInstance setQuotaUser(java.lang.String quotaUser) {
        return (AddInstance) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddInstance setUserIp(java.lang.String userIp) {
        return (AddInstance) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public AddInstance setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public AddInstance setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which instance_url is to be added. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to which instance_url is to be added.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which instance_url is to be added. */
      public AddInstance setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public AddInstance set(String parameterName, Object value) {
        return (AddInstance) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of target pools grouped by scope.
     *
     * Create a request for the method "targetPools.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.TargetPoolAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/targetPools";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of target pools grouped by scope.
       *
       * Create a request for the method "targetPools.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetPoolAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified TargetPool resource.
     *
     * Create a request for the method "targetPools.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String targetPool) throws java.io.IOException {
      Delete result = new Delete(project, region, targetPool);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified TargetPool resource.
       *
       * Create a request for the method "targetPools.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String targetPool) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to delete.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to delete. */
      public Delete setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified TargetPool resource.
     *
     * Create a request for the method "targetPools.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String targetPool) throws java.io.IOException {
      Get result = new Get(project, region, targetPool);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.TargetPool> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified TargetPool resource.
       *
       * Create a request for the method "targetPools.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String targetPool) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetPool.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to return.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to return. */
      public Get setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the most recent health check results for each IP for the given instance that is referenced
     * by given TargetPool.
     *
     * Create a request for the method "targetPools.getHealth".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which the queried instance belongs.
     * @param content the {@link com.google.api.services.compute.model.InstanceReference}
     * @return the request
     */
    public GetHealth getHealth(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.InstanceReference content) throws java.io.IOException {
      GetHealth result = new GetHealth(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class GetHealth extends ComputeRequest<com.google.api.services.compute.model.TargetPoolInstanceHealth> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/getHealth";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Gets the most recent health check results for each IP for the given instance that is referenced
       * by given TargetPool.
       *
       * Create a request for the method "targetPools.getHealth".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetHealth#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which the queried instance belongs.
       * @param content the {@link com.google.api.services.compute.model.InstanceReference}
       * @since 1.13
       */
      protected GetHealth(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.InstanceReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TargetPoolInstanceHealth.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public GetHealth setAlt(java.lang.String alt) {
        return (GetHealth) super.setAlt(alt);
      }

      @Override
      public GetHealth setFields(java.lang.String fields) {
        return (GetHealth) super.setFields(fields);
      }

      @Override
      public GetHealth setKey(java.lang.String key) {
        return (GetHealth) super.setKey(key);
      }

      @Override
      public GetHealth setOauthToken(java.lang.String oauthToken) {
        return (GetHealth) super.setOauthToken(oauthToken);
      }

      @Override
      public GetHealth setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetHealth) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetHealth setQuotaUser(java.lang.String quotaUser) {
        return (GetHealth) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetHealth setUserIp(java.lang.String userIp) {
        return (GetHealth) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public GetHealth setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public GetHealth setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which the queried instance belongs. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to which the queried instance belongs.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which the queried instance belongs. */
      public GetHealth setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public GetHealth set(String parameterName, Object value) {
        return (GetHealth) super.set(parameterName, value);
      }
    }
    /**
     * Creates a TargetPool resource in the specified project and region using the data included in the
     * request.
     *
     * Create a request for the method "targetPools.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.TargetPool}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.TargetPool content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a TargetPool resource in the specified project and region using the data included in
       * the request.
       *
       * Create a request for the method "targetPools.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.TargetPool}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.TargetPool content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of TargetPool resources available to the specified project and region.
     *
     * Create a request for the method "targetPools.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.TargetPoolList> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of TargetPool resources available to the specified project and region.
       *
       * Create a request for the method "targetPools.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetPoolList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Removes health check URL from targetPool.
     *
     * Create a request for the method "targetPools.removeHealthCheck".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link RemoveHealthCheck#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which health_check_url is to be removed.
     * @param content the {@link com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest}
     * @return the request
     */
    public RemoveHealthCheck removeHealthCheck(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest content) throws java.io.IOException {
      RemoveHealthCheck result = new RemoveHealthCheck(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class RemoveHealthCheck extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/removeHealthCheck";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Removes health check URL from targetPool.
       *
       * Create a request for the method "targetPools.removeHealthCheck".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RemoveHealthCheck#execute()} method to invoke the remote operation.
       * <p> {@link RemoveHealthCheck#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which health_check_url is to be removed.
       * @param content the {@link com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest}
       * @since 1.13
       */
      protected RemoveHealthCheck(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public RemoveHealthCheck setAlt(java.lang.String alt) {
        return (RemoveHealthCheck) super.setAlt(alt);
      }

      @Override
      public RemoveHealthCheck setFields(java.lang.String fields) {
        return (RemoveHealthCheck) super.setFields(fields);
      }

      @Override
      public RemoveHealthCheck setKey(java.lang.String key) {
        return (RemoveHealthCheck) super.setKey(key);
      }

      @Override
      public RemoveHealthCheck setOauthToken(java.lang.String oauthToken) {
        return (RemoveHealthCheck) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveHealthCheck setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RemoveHealthCheck) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveHealthCheck setQuotaUser(java.lang.String quotaUser) {
        return (RemoveHealthCheck) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveHealthCheck setUserIp(java.lang.String userIp) {
        return (RemoveHealthCheck) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public RemoveHealthCheck setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public RemoveHealthCheck setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which health_check_url is to be removed. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to which health_check_url is to be removed.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which health_check_url is to be removed. */
      public RemoveHealthCheck setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public RemoveHealthCheck set(String parameterName, Object value) {
        return (RemoveHealthCheck) super.set(parameterName, value);
      }
    }
    /**
     * Removes instance URL from targetPool.
     *
     * Create a request for the method "targetPools.removeInstance".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link RemoveInstance#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which instance_url is to be removed.
     * @param content the {@link com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest}
     * @return the request
     */
    public RemoveInstance removeInstance(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest content) throws java.io.IOException {
      RemoveInstance result = new RemoveInstance(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class RemoveInstance extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/removeInstance";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Removes instance URL from targetPool.
       *
       * Create a request for the method "targetPools.removeInstance".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RemoveInstance#execute()} method to invoke the remote operation.
       * <p> {@link RemoveInstance#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which instance_url is to be removed.
       * @param content the {@link com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest}
       * @since 1.13
       */
      protected RemoveInstance(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public RemoveInstance setAlt(java.lang.String alt) {
        return (RemoveInstance) super.setAlt(alt);
      }

      @Override
      public RemoveInstance setFields(java.lang.String fields) {
        return (RemoveInstance) super.setFields(fields);
      }

      @Override
      public RemoveInstance setKey(java.lang.String key) {
        return (RemoveInstance) super.setKey(key);
      }

      @Override
      public RemoveInstance setOauthToken(java.lang.String oauthToken) {
        return (RemoveInstance) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveInstance setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RemoveInstance) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveInstance setQuotaUser(java.lang.String quotaUser) {
        return (RemoveInstance) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveInstance setUserIp(java.lang.String userIp) {
        return (RemoveInstance) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public RemoveInstance setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public RemoveInstance setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which instance_url is to be removed. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to which instance_url is to be removed.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which instance_url is to be removed. */
      public RemoveInstance setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public RemoveInstance set(String parameterName, Object value) {
        return (RemoveInstance) super.set(parameterName, value);
      }
    }
    /**
     * Changes backup pool configurations.
     *
     * Create a request for the method "targetPools.setBackup".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetBackup#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource for which the backup is to be set.
     * @param content the {@link com.google.api.services.compute.model.TargetReference}
     * @return the request
     */
    public SetBackup setBackup(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetReference content) throws java.io.IOException {
      SetBackup result = new SetBackup(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class SetBackup extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/setBackup";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGETPOOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes backup pool configurations.
       *
       * Create a request for the method "targetPools.setBackup".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetBackup#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetBackup#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource for which the backup is to be set.
       * @param content the {@link com.google.api.services.compute.model.TargetReference}
       * @since 1.13
       */
      protected SetBackup(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetBackup setAlt(java.lang.String alt) {
        return (SetBackup) super.setAlt(alt);
      }

      @Override
      public SetBackup setFields(java.lang.String fields) {
        return (SetBackup) super.setFields(fields);
      }

      @Override
      public SetBackup setKey(java.lang.String key) {
        return (SetBackup) super.setKey(key);
      }

      @Override
      public SetBackup setOauthToken(java.lang.String oauthToken) {
        return (SetBackup) super.setOauthToken(oauthToken);
      }

      @Override
      public SetBackup setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetBackup) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetBackup setQuotaUser(java.lang.String quotaUser) {
        return (SetBackup) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetBackup setUserIp(java.lang.String userIp) {
        return (SetBackup) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetBackup setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public SetBackup setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource for which the backup is to be set. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource for which the backup is to be set.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource for which the backup is to be set. */
      public SetBackup setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGETPOOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      /** New failoverRatio value for the containing target pool. */
      @com.google.api.client.util.Key
      private java.lang.Float failoverRatio;

      /** New failoverRatio value for the containing target pool.
       */
      public java.lang.Float getFailoverRatio() {
        return failoverRatio;
      }

      /** New failoverRatio value for the containing target pool. */
      public SetBackup setFailoverRatio(java.lang.Float failoverRatio) {
        this.failoverRatio = failoverRatio;
        return this;
      }

      @Override
      public SetBackup set(String parameterName, Object value) {
        return (SetBackup) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ZoneOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.ZoneOperations.List request = compute.zoneOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ZoneOperations zoneOperations() {
    return new ZoneOperations();
  }

  /**
   * The "zoneOperations" collection of methods.
   */
  public class ZoneOperations {

    /**
     * Deletes the specified zone-specific operation resource.
     *
     * Create a request for the method "zoneOperations.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param operation Name of the operation resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String operation) throws java.io.IOException {
      Delete result = new Delete(project, zone, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/zones/{zone}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified zone-specific operation resource.
       *
       * Create a request for the method "zoneOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param operation Name of the operation resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the operation resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to delete.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to delete. */
      public Delete setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the specified zone-specific operation resource.
     *
     * Create a request for the method "zoneOperations.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param operation Name of the operation resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String operation) throws java.io.IOException {
      Get result = new Get(project, zone, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified zone-specific operation resource.
       *
       * Create a request for the method "zoneOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param operation Name of the operation resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the operation resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to return.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to return. */
      public Get setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of operation resources contained within the specified zone.
     *
     * Create a request for the method "zoneOperations.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/zones/{zone}/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of operation resources contained within the specified zone.
       *
       * Create a request for the method "zoneOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Zones collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Zones.List request = compute.zones().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Zones zones() {
    return new Zones();
  }

  /**
   * The "zones" collection of methods.
   */
  public class Zones {

    /**
     * Returns the specified zone resource.
     *
     * Create a request for the method "zones.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      Get result = new Get(project, zone);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Zone> {

      private static final String REST_PATH = "{project}/zones/{zone}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified zone resource.
       *
       * Create a request for the method "zones.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Zone.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone resource to return.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone resource to return. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of zone resources available to the specified project.
     *
     * Create a request for the method "zones.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ZoneList> {

      private static final String REST_PATH = "{project}/zones";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of zone resources available to the specified project.
       *
       * Create a request for the method "zones.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ZoneList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Optional. Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Optional. Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. Tag returned by a previous list request truncated by maxResults. Used to continue a
     previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. Tag returned by a previous list request truncated by maxResults. Used to continue
       * a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Optional. Maximum count of results to be returned. Maximum value is 500 and default value is 500.
     [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Optional. Maximum count of results to be returned. Maximum value is 500 and default value
       * is 500.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Compute}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Compute}. */
    @Override
    public Compute build() {
      return new Compute(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link ComputeRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setComputeRequestInitializer(
        ComputeRequestInitializer computeRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(computeRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
