/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-02-14 18:40:25 UTC)
 * on 2014-03-30 at 15:59:39 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * An instance resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Instance extends com.google.api.client.json.GenericJson {

  /**
   * Allows this instance to send packets with source IP addresses other than its own and receive
   * packets with destination IP addresses other than its own. If this instance will be used as an
   * IP gateway or it will be set as the next-hop in a Route resource, say true. If unsure, leave
   * this set to false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canIpForward;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Array of disks associated with this instance. Persistent disks must be created before you can
   * assign them.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AttachedDisk> disks;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * An optional URL of the disk image resource to be installed on this instance; provided by the
   * client when the instance is created. Alternatively to passing the image, the client may choose
   * to boot from a persistent disk, by setting boot=true flag on one of the entries in disks[]
   * collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String image;

  /**
   * URL of the kernel resource to use when booting. In case of booting from persistent disk, this
   * parameter is required. When booting from a disk image, it is optional, but may be provided to
   * use a different kernel than the one associated with the image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kernel;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * URL of the machine type resource describing which machine type to use to host the instance;
   * provided by the client when the instance is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String machineType;

  /**
   * Metadata key/value pairs assigned to this instance. Consists of custom metadata or predefined
   * keys; see Instance documentation for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata metadata;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instance will have no external internet access.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NetworkInterface> networkInterfaces;

  /**
   * Scheduling options for this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Scheduling scheduling;

  /**
   * Server defined URL for this resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * A list of service accounts each with specified scopes, for which access tokens are to be made
   * available to the instance through metadata queries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceAccount> serviceAccounts;

  /**
   * Instance status. One of the following values: "PROVISIONING", "STAGING", "RUNNING", "STOPPING",
   * "STOPPED", "TERMINATED" (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * An optional, human-readable explanation of the status (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statusMessage;

  /**
   * A list of tags to be applied to this instance. Used to identify valid sources or targets for
   * network firewalls. Provided by the client on instance creation. The tags can be later modified
   * by the setTags method. Each tag within the list must comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Tags tags;

  /**
   * URL of the zone where the instance resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * Allows this instance to send packets with source IP addresses other than its own and receive
   * packets with destination IP addresses other than its own. If this instance will be used as an
   * IP gateway or it will be set as the next-hop in a Route resource, say true. If unsure, leave
   * this set to false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanIpForward() {
    return canIpForward;
  }

  /**
   * Allows this instance to send packets with source IP addresses other than its own and receive
   * packets with destination IP addresses other than its own. If this instance will be used as an
   * IP gateway or it will be set as the next-hop in a Route resource, say true. If unsure, leave
   * this set to false.
   * @param canIpForward canIpForward or {@code null} for none
   */
  public Instance setCanIpForward(java.lang.Boolean canIpForward) {
    this.canIpForward = canIpForward;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Instance setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public Instance setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Array of disks associated with this instance. Persistent disks must be created before you can
   * assign them.
   * @return value or {@code null} for none
   */
  public java.util.List<AttachedDisk> getDisks() {
    return disks;
  }

  /**
   * Array of disks associated with this instance. Persistent disks must be created before you can
   * assign them.
   * @param disks disks or {@code null} for none
   */
  public Instance setDisks(java.util.List<AttachedDisk> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public Instance setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * An optional URL of the disk image resource to be installed on this instance; provided by the
   * client when the instance is created. Alternatively to passing the image, the client may choose
   * to boot from a persistent disk, by setting boot=true flag on one of the entries in disks[]
   * collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getImage() {
    return image;
  }

  /**
   * An optional URL of the disk image resource to be installed on this instance; provided by the
   * client when the instance is created. Alternatively to passing the image, the client may choose
   * to boot from a persistent disk, by setting boot=true flag on one of the entries in disks[]
   * collection.
   * @param image image or {@code null} for none
   */
  public Instance setImage(java.lang.String image) {
    this.image = image;
    return this;
  }

  /**
   * URL of the kernel resource to use when booting. In case of booting from persistent disk, this
   * parameter is required. When booting from a disk image, it is optional, but may be provided to
   * use a different kernel than the one associated with the image.
   * @return value or {@code null} for none
   */
  public java.lang.String getKernel() {
    return kernel;
  }

  /**
   * URL of the kernel resource to use when booting. In case of booting from persistent disk, this
   * parameter is required. When booting from a disk image, it is optional, but may be provided to
   * use a different kernel than the one associated with the image.
   * @param kernel kernel or {@code null} for none
   */
  public Instance setKernel(java.lang.String kernel) {
    this.kernel = kernel;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public Instance setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * URL of the machine type resource describing which machine type to use to host the instance;
   * provided by the client when the instance is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getMachineType() {
    return machineType;
  }

  /**
   * URL of the machine type resource describing which machine type to use to host the instance;
   * provided by the client when the instance is created.
   * @param machineType machineType or {@code null} for none
   */
  public Instance setMachineType(java.lang.String machineType) {
    this.machineType = machineType;
    return this;
  }

  /**
   * Metadata key/value pairs assigned to this instance. Consists of custom metadata or predefined
   * keys; see Instance documentation for more information.
   * @return value or {@code null} for none
   */
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata key/value pairs assigned to this instance. Consists of custom metadata or predefined
   * keys; see Instance documentation for more information.
   * @param metadata metadata or {@code null} for none
   */
  public Instance setMetadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public Instance setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instance will have no external internet access.
   * @return value or {@code null} for none
   */
  public java.util.List<NetworkInterface> getNetworkInterfaces() {
    return networkInterfaces;
  }

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instance will have no external internet access.
   * @param networkInterfaces networkInterfaces or {@code null} for none
   */
  public Instance setNetworkInterfaces(java.util.List<NetworkInterface> networkInterfaces) {
    this.networkInterfaces = networkInterfaces;
    return this;
  }

  /**
   * Scheduling options for this instance.
   * @return value or {@code null} for none
   */
  public Scheduling getScheduling() {
    return scheduling;
  }

  /**
   * Scheduling options for this instance.
   * @param scheduling scheduling or {@code null} for none
   */
  public Instance setScheduling(Scheduling scheduling) {
    this.scheduling = scheduling;
    return this;
  }

  /**
   * Server defined URL for this resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for this resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public Instance setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * A list of service accounts each with specified scopes, for which access tokens are to be made
   * available to the instance through metadata queries.
   * @return value or {@code null} for none
   */
  public java.util.List<ServiceAccount> getServiceAccounts() {
    return serviceAccounts;
  }

  /**
   * A list of service accounts each with specified scopes, for which access tokens are to be made
   * available to the instance through metadata queries.
   * @param serviceAccounts serviceAccounts or {@code null} for none
   */
  public Instance setServiceAccounts(java.util.List<ServiceAccount> serviceAccounts) {
    this.serviceAccounts = serviceAccounts;
    return this;
  }

  /**
   * Instance status. One of the following values: "PROVISIONING", "STAGING", "RUNNING", "STOPPING",
   * "STOPPED", "TERMINATED" (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Instance status. One of the following values: "PROVISIONING", "STAGING", "RUNNING", "STOPPING",
   * "STOPPED", "TERMINATED" (output only).
   * @param status status or {@code null} for none
   */
  public Instance setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * An optional, human-readable explanation of the status (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getStatusMessage() {
    return statusMessage;
  }

  /**
   * An optional, human-readable explanation of the status (output only).
   * @param statusMessage statusMessage or {@code null} for none
   */
  public Instance setStatusMessage(java.lang.String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

  /**
   * A list of tags to be applied to this instance. Used to identify valid sources or targets for
   * network firewalls. Provided by the client on instance creation. The tags can be later modified
   * by the setTags method. Each tag within the list must comply with RFC1035.
   * @return value or {@code null} for none
   */
  public Tags getTags() {
    return tags;
  }

  /**
   * A list of tags to be applied to this instance. Used to identify valid sources or targets for
   * network firewalls. Provided by the client on instance creation. The tags can be later modified
   * by the setTags method. Each tag within the list must comply with RFC1035.
   * @param tags tags or {@code null} for none
   */
  public Instance setTags(Tags tags) {
    this.tags = tags;
    return this;
  }

  /**
   * URL of the zone where the instance resides (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * URL of the zone where the instance resides (output only).
   * @param zone zone or {@code null} for none
   */
  public Instance setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public Instance set(String fieldName, Object value) {
    return (Instance) super.set(fieldName, value);
  }

  @Override
  public Instance clone() {
    return (Instance) super.clone();
  }

}
