/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-11-22 19:59:01 UTC)
 * on 2013-12-11 at 22:40:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A zone resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Zone extends com.google.api.client.json.GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * The deprecation status associated with this zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeprecationStatus deprecated;

  /**
   * Textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Scheduled maintenance windows for the zone. When the zone is in a maintenance window, all
   * resources which reside in the zone will be unavailable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MaintenanceWindows> maintenanceWindows;

  static {
    // hack to force ProGuard to consider MaintenanceWindows used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(MaintenanceWindows.class);
  }

  /**
   * Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Full URL reference to the region which hosts the zone (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Status of the zone. "UP" or "DOWN".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Zone setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * The deprecation status associated with this zone.
   * @return value or {@code null} for none
   */
  public DeprecationStatus getDeprecated() {
    return deprecated;
  }

  /**
   * The deprecation status associated with this zone.
   * @param deprecated deprecated or {@code null} for none
   */
  public Zone setDeprecated(DeprecationStatus deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * Textual description of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Textual description of the resource.
   * @param description description or {@code null} for none
   */
  public Zone setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public Zone setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public Zone setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Scheduled maintenance windows for the zone. When the zone is in a maintenance window, all
   * resources which reside in the zone will be unavailable.
   * @return value or {@code null} for none
   */
  public java.util.List<MaintenanceWindows> getMaintenanceWindows() {
    return maintenanceWindows;
  }

  /**
   * Scheduled maintenance windows for the zone. When the zone is in a maintenance window, all
   * resources which reside in the zone will be unavailable.
   * @param maintenanceWindows maintenanceWindows or {@code null} for none
   */
  public Zone setMaintenanceWindows(java.util.List<MaintenanceWindows> maintenanceWindows) {
    this.maintenanceWindows = maintenanceWindows;
    return this;
  }

  /**
   * Name of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource.
   * @param name name or {@code null} for none
   */
  public Zone setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Full URL reference to the region which hosts the zone (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * Full URL reference to the region which hosts the zone (output only).
   * @param region region or {@code null} for none
   */
  public Zone setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public Zone setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Status of the zone. "UP" or "DOWN".
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the zone. "UP" or "DOWN".
   * @param status status or {@code null} for none
   */
  public Zone setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public Zone set(String fieldName, Object value) {
    return (Zone) super.set(fieldName, value);
  }

  @Override
  public Zone clone() {
    return (Zone) super.clone();
  }

  /**
   * Model definition for ZoneMaintenanceWindows.
   */
  public static final class MaintenanceWindows extends com.google.api.client.json.GenericJson {

    /**
     * Begin time of the maintenance window, in RFC 3339 format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String beginTime;

    /**
     * Textual description of the maintenance window.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String description;

    /**
     * End time of the maintenance window, in RFC 3339 format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String endTime;

    /**
     * Name of the maintenance window.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String name;

    /**
     * Begin time of the maintenance window, in RFC 3339 format.
     * @return value or {@code null} for none
     */
    public java.lang.String getBeginTime() {
      return beginTime;
    }

    /**
     * Begin time of the maintenance window, in RFC 3339 format.
     * @param beginTime beginTime or {@code null} for none
     */
    public MaintenanceWindows setBeginTime(java.lang.String beginTime) {
      this.beginTime = beginTime;
      return this;
    }

    /**
     * Textual description of the maintenance window.
     * @return value or {@code null} for none
     */
    public java.lang.String getDescription() {
      return description;
    }

    /**
     * Textual description of the maintenance window.
     * @param description description or {@code null} for none
     */
    public MaintenanceWindows setDescription(java.lang.String description) {
      this.description = description;
      return this;
    }

    /**
     * End time of the maintenance window, in RFC 3339 format.
     * @return value or {@code null} for none
     */
    public java.lang.String getEndTime() {
      return endTime;
    }

    /**
     * End time of the maintenance window, in RFC 3339 format.
     * @param endTime endTime or {@code null} for none
     */
    public MaintenanceWindows setEndTime(java.lang.String endTime) {
      this.endTime = endTime;
      return this;
    }

    /**
     * Name of the maintenance window.
     * @return value or {@code null} for none
     */
    public java.lang.String getName() {
      return name;
    }

    /**
     * Name of the maintenance window.
     * @param name name or {@code null} for none
     */
    public MaintenanceWindows setName(java.lang.String name) {
      this.name = name;
      return this;
    }

    @Override
    public MaintenanceWindows set(String fieldName, Object value) {
      return (MaintenanceWindows) super.set(fieldName, value);
    }

    @Override
    public MaintenanceWindows clone() {
      return (MaintenanceWindows) super.clone();
    }

  }

}
