/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * Configuration for returning group information from authenticators.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AuthenticatorGroupsConfig extends com.google.api.client.json.GenericJson {

  /**
   * Whether this cluster should return group membership lookups during authentication using a group
   * of security groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enabled;

  /**
   * The name of the security group-of-groups to be used. Only relevant if enabled = true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String securityGroup;

  /**
   * Whether this cluster should return group membership lookups during authentication using a group
   * of security groups.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnabled() {
    return enabled;
  }

  /**
   * Whether this cluster should return group membership lookups during authentication using a group
   * of security groups.
   * @param enabled enabled or {@code null} for none
   */
  public AuthenticatorGroupsConfig setEnabled(java.lang.Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * The name of the security group-of-groups to be used. Only relevant if enabled = true.
   * @return value or {@code null} for none
   */
  public java.lang.String getSecurityGroup() {
    return securityGroup;
  }

  /**
   * The name of the security group-of-groups to be used. Only relevant if enabled = true.
   * @param securityGroup securityGroup or {@code null} for none
   */
  public AuthenticatorGroupsConfig setSecurityGroup(java.lang.String securityGroup) {
    this.securityGroup = securityGroup;
    return this;
  }

  @Override
  public AuthenticatorGroupsConfig set(String fieldName, Object value) {
    return (AuthenticatorGroupsConfig) super.set(fieldName, value);
  }

  @Override
  public AuthenticatorGroupsConfig clone() {
    return (AuthenticatorGroupsConfig) super.clone();
  }

}
