/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * A Google Kubernetes Engine cluster.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Cluster extends com.google.api.client.json.GenericJson {

  /**
   * Configurations for the various addons available to run in the cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AddonsConfig addonsConfig;

  /**
   * Configuration controlling RBAC group membership information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AuthenticatorGroupsConfig authenticatorGroupsConfig;

  /**
   * Cluster-level autoscaling configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClusterAutoscaling autoscaling;

  /**
   * Configuration for Binary Authorization.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BinaryAuthorization binaryAuthorization;

  /**
   * The IP address range of the container pods in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
   * `10.96.0.0/14`). Leave blank to have one automatically chosen or specify a `/14` block in
   * `10.0.0.0/8`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clusterIpv4Cidr;

  /**
   * Which conditions caused the current cluster state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StatusCondition> conditions;

  /**
   * [Output only] The time the cluster was created, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String createTime;

  /**
   * [Output only] The current software version of the master endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currentMasterVersion;

  /**
   * [Output only]  The number of nodes currently in the cluster. Deprecated. Call Kubernetes API
   * directly to retrieve node information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer currentNodeCount;

  /**
   * [Output only] Deprecated, use [NodePools.version](/kubernetes-
   * engine/docs/reference/rest/v1/projects.zones.clusters.nodePools) instead. The current version
   * of the node software components. If they are currently at multiple versions because they're in
   * the process of being upgraded, this reflects the minimum version of all nodes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currentNodeVersion;

  /**
   * Configuration of etcd encryption.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatabaseEncryption databaseEncryption;

  /**
   * The default constraint on the maximum number of pods that can be run simultaneously on a node
   * in the node pool of this cluster. Only honored if cluster created with IP Alias support.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MaxPodsConstraint defaultMaxPodsConstraint;

  /**
   * An optional description of this cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Kubernetes alpha features are enabled on this cluster. This includes alpha API groups (e.g.
   * v1alpha1) and features that may not be production ready in the kubernetes version of the master
   * and nodes. The cluster has no SLA for uptime and master/node upgrades are disabled. Alpha
   * enabled clusters are automatically deleted thirty days after creation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableKubernetesAlpha;

  /**
   * Enable the ability to use Cloud TPUs in this cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableTpu;

  /**
   * [Output only] The IP address of this cluster's master endpoint. The endpoint can be accessed
   * from the internet at `https://username:password@endpoint/`.
   *
   * See the `masterAuth` property of this resource for username and password information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endpoint;

  /**
   * [Output only] The time the cluster will be automatically deleted in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expireTime;

  /**
   * The initial Kubernetes version for this cluster.  Valid versions are those found in
   * validMasterVersions returned by getServerConfig.  The version can be upgraded over time; such
   * upgrades are reflected in currentMasterVersion and currentNodeVersion.
   *
   * Users may specify either explicit versions offered by Kubernetes Engine or version aliases,
   * which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version - "1.X": picks the highest valid
   * patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid gke.N patch in the
   * 1.X.Y version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "","-": picks the default
   * Kubernetes version
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String initialClusterVersion;

  /**
   * The number of nodes to create in this cluster. You must ensure that your Compute Engine
   * resource quota is sufficient for this number of instances. You must also have available
   * firewall and routes quota. For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the "node_config") will be used to
   * create a "NodePool" object with an auto-generated name. Do not use this and a node_pool at the
   * same time.
   *
   * This field is deprecated, use node_pool.initial_node_count instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer initialNodeCount;

  /**
   * Deprecated. Use node_pools.instance_group_urls.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> instanceGroupUrls;

  /**
   * Configuration for cluster IP allocation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IPAllocationPolicy ipAllocationPolicy;

  /**
   * The fingerprint of the set of labels for this cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String labelFingerprint;

  /**
   * Configuration for the legacy ABAC authorization mode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LegacyAbac legacyAbac;

  /**
   * [Output only] The name of the Google Compute Engine [zone](/compute/docs/regions-zones/regions-
   * zones#available) or [region](/compute/docs/regions-zones/regions-zones#available) in which the
   * cluster resides.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * The list of Google Compute Engine [zones](/compute/docs/zones#available) in which the cluster's
   * nodes should be located.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> locations;

  /**
   * The logging service the cluster should use to write logs. Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging service with a Kubernetes-native
   * resource model * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   * available as of GKE 1.15). * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be used for GKE 1.14+ or
   * `logging.googleapis.com` for earlier versions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String loggingService;

  /**
   * Configure the maintenance policy for this cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MaintenancePolicy maintenancePolicy;

  /**
   * The authentication information for accessing the master endpoint. If unspecified, the defaults
   * are used: For clusters before v1.12, if master_auth is unspecified, `username` will be set to
   * "admin", a random password will be generated, and a client certificate will be issued.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MasterAuth masterAuth;

  /**
   * The configuration options for master authorized networks feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MasterAuthorizedNetworksConfig masterAuthorizedNetworksConfig;

  /**
   * The monitoring service the cluster should use to write metrics. Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring service with a Kubernetes-
   * native resource model * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   * longer available as of GKE 1.15). * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be used for GKE 1.14+ or
   * `monitoring.googleapis.com` for earlier versions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String monitoringService;

  /**
   * The name of this cluster. The name must be unique within this project and location (e.g. zone
   * or region), and can be up to 40 characters with the following restrictions:
   *
   * * Lowercase letters, numbers, and hyphens only. * Must start with a letter. * Must end with a
   * number or a letter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The name of the Google Compute Engine [network](/compute/docs/networks-and-firewalls#networks)
   * to which the cluster is connected. If left unspecified, the `default` network will be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * Configuration for cluster networking.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NetworkConfig networkConfig;

  /**
   * Configuration options for the NetworkPolicy feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NetworkPolicy networkPolicy;

  /**
   * Parameters used in creating the cluster's nodes. For requests, this field should only be used
   * in lieu of a "node_pool" object, since this configuration (along with the "initial_node_count")
   * will be used to create a "NodePool" object with an auto-generated name. Do not use this and a
   * node_pool at the same time. For responses, this field will be populated with the node
   * configuration of the first node pool. (For configuration of each node pool, see
   * `node_pool.config`)
   *
   * If unspecified, the defaults are used. This field is deprecated, use node_pool.config instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NodeConfig nodeConfig;

  /**
   * [Output only] The size of the address space on each node for hosting containers. This is
   * provisioned from within the `container_ipv4_cidr` range. This field will only be set when
   * cluster is in route-based network mode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer nodeIpv4CidrSize;

  /**
   * The node pools associated with this cluster. This field should not be set if "node_config" or
   * "initial_node_count" are specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NodePool> nodePools;

  /**
   * Configuration for private cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PrivateClusterConfig privateClusterConfig;

  /**
   * The resource labels for the cluster to use to annotate any related Google Compute Engine
   * resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> resourceLabels;

  /**
   * Configuration for exporting resource usages. Resource usage export is disabled when this config
   * is unspecified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceUsageExportConfig resourceUsageExportConfig;

  /**
   * [Output only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output only] The IP address range of the Kubernetes services in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
   * `1.2.3.4/29`). Service addresses are typically put in the last `/16` from the container CIDR.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String servicesIpv4Cidr;

  /**
   * Shielded Nodes configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ShieldedNodes shieldedNodes;

  /**
   * [Output only] The current status of this cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * [Output only] Additional information about the current status of this cluster, if available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statusMessage;

  /**
   * The name of the Google Compute Engine [subnetwork](/compute/docs/subnetworks) to which the
   * cluster is connected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subnetwork;

  /**
   * [Output only] The IP address range of the Cloud TPUs in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
   * `1.2.3.4/29`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tpuIpv4CidrBlock;

  /**
   * Cluster-level Vertical Pod Autoscaling configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VerticalPodAutoscaling verticalPodAutoscaling;

  /**
   * Configuration for the use of Kubernetes Service Accounts in GCP IAM policies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WorkloadIdentityConfig workloadIdentityConfig;

  /**
   * [Output only] The name of the Google Compute Engine [zone](/compute/docs/zones#available) in
   * which the cluster resides. This field is deprecated, use location instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * Configurations for the various addons available to run in the cluster.
   * @return value or {@code null} for none
   */
  public AddonsConfig getAddonsConfig() {
    return addonsConfig;
  }

  /**
   * Configurations for the various addons available to run in the cluster.
   * @param addonsConfig addonsConfig or {@code null} for none
   */
  public Cluster setAddonsConfig(AddonsConfig addonsConfig) {
    this.addonsConfig = addonsConfig;
    return this;
  }

  /**
   * Configuration controlling RBAC group membership information.
   * @return value or {@code null} for none
   */
  public AuthenticatorGroupsConfig getAuthenticatorGroupsConfig() {
    return authenticatorGroupsConfig;
  }

  /**
   * Configuration controlling RBAC group membership information.
   * @param authenticatorGroupsConfig authenticatorGroupsConfig or {@code null} for none
   */
  public Cluster setAuthenticatorGroupsConfig(AuthenticatorGroupsConfig authenticatorGroupsConfig) {
    this.authenticatorGroupsConfig = authenticatorGroupsConfig;
    return this;
  }

  /**
   * Cluster-level autoscaling configuration.
   * @return value or {@code null} for none
   */
  public ClusterAutoscaling getAutoscaling() {
    return autoscaling;
  }

  /**
   * Cluster-level autoscaling configuration.
   * @param autoscaling autoscaling or {@code null} for none
   */
  public Cluster setAutoscaling(ClusterAutoscaling autoscaling) {
    this.autoscaling = autoscaling;
    return this;
  }

  /**
   * Configuration for Binary Authorization.
   * @return value or {@code null} for none
   */
  public BinaryAuthorization getBinaryAuthorization() {
    return binaryAuthorization;
  }

  /**
   * Configuration for Binary Authorization.
   * @param binaryAuthorization binaryAuthorization or {@code null} for none
   */
  public Cluster setBinaryAuthorization(BinaryAuthorization binaryAuthorization) {
    this.binaryAuthorization = binaryAuthorization;
    return this;
  }

  /**
   * The IP address range of the container pods in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
   * `10.96.0.0/14`). Leave blank to have one automatically chosen or specify a `/14` block in
   * `10.0.0.0/8`.
   * @return value or {@code null} for none
   */
  public java.lang.String getClusterIpv4Cidr() {
    return clusterIpv4Cidr;
  }

  /**
   * The IP address range of the container pods in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
   * `10.96.0.0/14`). Leave blank to have one automatically chosen or specify a `/14` block in
   * `10.0.0.0/8`.
   * @param clusterIpv4Cidr clusterIpv4Cidr or {@code null} for none
   */
  public Cluster setClusterIpv4Cidr(java.lang.String clusterIpv4Cidr) {
    this.clusterIpv4Cidr = clusterIpv4Cidr;
    return this;
  }

  /**
   * Which conditions caused the current cluster state.
   * @return value or {@code null} for none
   */
  public java.util.List<StatusCondition> getConditions() {
    return conditions;
  }

  /**
   * Which conditions caused the current cluster state.
   * @param conditions conditions or {@code null} for none
   */
  public Cluster setConditions(java.util.List<StatusCondition> conditions) {
    this.conditions = conditions;
    return this;
  }

  /**
   * [Output only] The time the cluster was created, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreateTime() {
    return createTime;
  }

  /**
   * [Output only] The time the cluster was created, in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * @param createTime createTime or {@code null} for none
   */
  public Cluster setCreateTime(java.lang.String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * [Output only] The current software version of the master endpoint.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrentMasterVersion() {
    return currentMasterVersion;
  }

  /**
   * [Output only] The current software version of the master endpoint.
   * @param currentMasterVersion currentMasterVersion or {@code null} for none
   */
  public Cluster setCurrentMasterVersion(java.lang.String currentMasterVersion) {
    this.currentMasterVersion = currentMasterVersion;
    return this;
  }

  /**
   * [Output only]  The number of nodes currently in the cluster. Deprecated. Call Kubernetes API
   * directly to retrieve node information.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCurrentNodeCount() {
    return currentNodeCount;
  }

  /**
   * [Output only]  The number of nodes currently in the cluster. Deprecated. Call Kubernetes API
   * directly to retrieve node information.
   * @param currentNodeCount currentNodeCount or {@code null} for none
   */
  public Cluster setCurrentNodeCount(java.lang.Integer currentNodeCount) {
    this.currentNodeCount = currentNodeCount;
    return this;
  }

  /**
   * [Output only] Deprecated, use [NodePools.version](/kubernetes-
   * engine/docs/reference/rest/v1/projects.zones.clusters.nodePools) instead. The current version
   * of the node software components. If they are currently at multiple versions because they're in
   * the process of being upgraded, this reflects the minimum version of all nodes.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrentNodeVersion() {
    return currentNodeVersion;
  }

  /**
   * [Output only] Deprecated, use [NodePools.version](/kubernetes-
   * engine/docs/reference/rest/v1/projects.zones.clusters.nodePools) instead. The current version
   * of the node software components. If they are currently at multiple versions because they're in
   * the process of being upgraded, this reflects the minimum version of all nodes.
   * @param currentNodeVersion currentNodeVersion or {@code null} for none
   */
  public Cluster setCurrentNodeVersion(java.lang.String currentNodeVersion) {
    this.currentNodeVersion = currentNodeVersion;
    return this;
  }

  /**
   * Configuration of etcd encryption.
   * @return value or {@code null} for none
   */
  public DatabaseEncryption getDatabaseEncryption() {
    return databaseEncryption;
  }

  /**
   * Configuration of etcd encryption.
   * @param databaseEncryption databaseEncryption or {@code null} for none
   */
  public Cluster setDatabaseEncryption(DatabaseEncryption databaseEncryption) {
    this.databaseEncryption = databaseEncryption;
    return this;
  }

  /**
   * The default constraint on the maximum number of pods that can be run simultaneously on a node
   * in the node pool of this cluster. Only honored if cluster created with IP Alias support.
   * @return value or {@code null} for none
   */
  public MaxPodsConstraint getDefaultMaxPodsConstraint() {
    return defaultMaxPodsConstraint;
  }

  /**
   * The default constraint on the maximum number of pods that can be run simultaneously on a node
   * in the node pool of this cluster. Only honored if cluster created with IP Alias support.
   * @param defaultMaxPodsConstraint defaultMaxPodsConstraint or {@code null} for none
   */
  public Cluster setDefaultMaxPodsConstraint(MaxPodsConstraint defaultMaxPodsConstraint) {
    this.defaultMaxPodsConstraint = defaultMaxPodsConstraint;
    return this;
  }

  /**
   * An optional description of this cluster.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this cluster.
   * @param description description or {@code null} for none
   */
  public Cluster setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Kubernetes alpha features are enabled on this cluster. This includes alpha API groups (e.g.
   * v1alpha1) and features that may not be production ready in the kubernetes version of the master
   * and nodes. The cluster has no SLA for uptime and master/node upgrades are disabled. Alpha
   * enabled clusters are automatically deleted thirty days after creation.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableKubernetesAlpha() {
    return enableKubernetesAlpha;
  }

  /**
   * Kubernetes alpha features are enabled on this cluster. This includes alpha API groups (e.g.
   * v1alpha1) and features that may not be production ready in the kubernetes version of the master
   * and nodes. The cluster has no SLA for uptime and master/node upgrades are disabled. Alpha
   * enabled clusters are automatically deleted thirty days after creation.
   * @param enableKubernetesAlpha enableKubernetesAlpha or {@code null} for none
   */
  public Cluster setEnableKubernetesAlpha(java.lang.Boolean enableKubernetesAlpha) {
    this.enableKubernetesAlpha = enableKubernetesAlpha;
    return this;
  }

  /**
   * Enable the ability to use Cloud TPUs in this cluster.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableTpu() {
    return enableTpu;
  }

  /**
   * Enable the ability to use Cloud TPUs in this cluster.
   * @param enableTpu enableTpu or {@code null} for none
   */
  public Cluster setEnableTpu(java.lang.Boolean enableTpu) {
    this.enableTpu = enableTpu;
    return this;
  }

  /**
   * [Output only] The IP address of this cluster's master endpoint. The endpoint can be accessed
   * from the internet at `https://username:password@endpoint/`.
   *
   * See the `masterAuth` property of this resource for username and password information.
   * @return value or {@code null} for none
   */
  public java.lang.String getEndpoint() {
    return endpoint;
  }

  /**
   * [Output only] The IP address of this cluster's master endpoint. The endpoint can be accessed
   * from the internet at `https://username:password@endpoint/`.
   *
   * See the `masterAuth` property of this resource for username and password information.
   * @param endpoint endpoint or {@code null} for none
   */
  public Cluster setEndpoint(java.lang.String endpoint) {
    this.endpoint = endpoint;
    return this;
  }

  /**
   * [Output only] The time the cluster will be automatically deleted in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpireTime() {
    return expireTime;
  }

  /**
   * [Output only] The time the cluster will be automatically deleted in
   * [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * @param expireTime expireTime or {@code null} for none
   */
  public Cluster setExpireTime(java.lang.String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * The initial Kubernetes version for this cluster.  Valid versions are those found in
   * validMasterVersions returned by getServerConfig.  The version can be upgraded over time; such
   * upgrades are reflected in currentMasterVersion and currentNodeVersion.
   *
   * Users may specify either explicit versions offered by Kubernetes Engine or version aliases,
   * which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version - "1.X": picks the highest valid
   * patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid gke.N patch in the
   * 1.X.Y version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "","-": picks the default
   * Kubernetes version
   * @return value or {@code null} for none
   */
  public java.lang.String getInitialClusterVersion() {
    return initialClusterVersion;
  }

  /**
   * The initial Kubernetes version for this cluster.  Valid versions are those found in
   * validMasterVersions returned by getServerConfig.  The version can be upgraded over time; such
   * upgrades are reflected in currentMasterVersion and currentNodeVersion.
   *
   * Users may specify either explicit versions offered by Kubernetes Engine or version aliases,
   * which have the following behavior:
   *
   * - "latest": picks the highest valid Kubernetes version - "1.X": picks the highest valid
   * patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid gke.N patch in the
   * 1.X.Y version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "","-": picks the default
   * Kubernetes version
   * @param initialClusterVersion initialClusterVersion or {@code null} for none
   */
  public Cluster setInitialClusterVersion(java.lang.String initialClusterVersion) {
    this.initialClusterVersion = initialClusterVersion;
    return this;
  }

  /**
   * The number of nodes to create in this cluster. You must ensure that your Compute Engine
   * resource quota is sufficient for this number of instances. You must also have available
   * firewall and routes quota. For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the "node_config") will be used to
   * create a "NodePool" object with an auto-generated name. Do not use this and a node_pool at the
   * same time.
   *
   * This field is deprecated, use node_pool.initial_node_count instead.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInitialNodeCount() {
    return initialNodeCount;
  }

  /**
   * The number of nodes to create in this cluster. You must ensure that your Compute Engine
   * resource quota is sufficient for this number of instances. You must also have available
   * firewall and routes quota. For requests, this field should only be used in lieu of a
   * "node_pool" object, since this configuration (along with the "node_config") will be used to
   * create a "NodePool" object with an auto-generated name. Do not use this and a node_pool at the
   * same time.
   *
   * This field is deprecated, use node_pool.initial_node_count instead.
   * @param initialNodeCount initialNodeCount or {@code null} for none
   */
  public Cluster setInitialNodeCount(java.lang.Integer initialNodeCount) {
    this.initialNodeCount = initialNodeCount;
    return this;
  }

  /**
   * Deprecated. Use node_pools.instance_group_urls.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInstanceGroupUrls() {
    return instanceGroupUrls;
  }

  /**
   * Deprecated. Use node_pools.instance_group_urls.
   * @param instanceGroupUrls instanceGroupUrls or {@code null} for none
   */
  public Cluster setInstanceGroupUrls(java.util.List<java.lang.String> instanceGroupUrls) {
    this.instanceGroupUrls = instanceGroupUrls;
    return this;
  }

  /**
   * Configuration for cluster IP allocation.
   * @return value or {@code null} for none
   */
  public IPAllocationPolicy getIpAllocationPolicy() {
    return ipAllocationPolicy;
  }

  /**
   * Configuration for cluster IP allocation.
   * @param ipAllocationPolicy ipAllocationPolicy or {@code null} for none
   */
  public Cluster setIpAllocationPolicy(IPAllocationPolicy ipAllocationPolicy) {
    this.ipAllocationPolicy = ipAllocationPolicy;
    return this;
  }

  /**
   * The fingerprint of the set of labels for this cluster.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabelFingerprint() {
    return labelFingerprint;
  }

  /**
   * The fingerprint of the set of labels for this cluster.
   * @param labelFingerprint labelFingerprint or {@code null} for none
   */
  public Cluster setLabelFingerprint(java.lang.String labelFingerprint) {
    this.labelFingerprint = labelFingerprint;
    return this;
  }

  /**
   * Configuration for the legacy ABAC authorization mode.
   * @return value or {@code null} for none
   */
  public LegacyAbac getLegacyAbac() {
    return legacyAbac;
  }

  /**
   * Configuration for the legacy ABAC authorization mode.
   * @param legacyAbac legacyAbac or {@code null} for none
   */
  public Cluster setLegacyAbac(LegacyAbac legacyAbac) {
    this.legacyAbac = legacyAbac;
    return this;
  }

  /**
   * [Output only] The name of the Google Compute Engine [zone](/compute/docs/regions-zones/regions-
   * zones#available) or [region](/compute/docs/regions-zones/regions-zones#available) in which the
   * cluster resides.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * [Output only] The name of the Google Compute Engine [zone](/compute/docs/regions-zones/regions-
   * zones#available) or [region](/compute/docs/regions-zones/regions-zones#available) in which the
   * cluster resides.
   * @param location location or {@code null} for none
   */
  public Cluster setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * The list of Google Compute Engine [zones](/compute/docs/zones#available) in which the cluster's
   * nodes should be located.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLocations() {
    return locations;
  }

  /**
   * The list of Google Compute Engine [zones](/compute/docs/zones#available) in which the cluster's
   * nodes should be located.
   * @param locations locations or {@code null} for none
   */
  public Cluster setLocations(java.util.List<java.lang.String> locations) {
    this.locations = locations;
    return this;
  }

  /**
   * The logging service the cluster should use to write logs. Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging service with a Kubernetes-native
   * resource model * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   * available as of GKE 1.15). * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be used for GKE 1.14+ or
   * `logging.googleapis.com` for earlier versions.
   * @return value or {@code null} for none
   */
  public java.lang.String getLoggingService() {
    return loggingService;
  }

  /**
   * The logging service the cluster should use to write logs. Currently available options:
   *
   * * `logging.googleapis.com/kubernetes` - The Cloud Logging service with a Kubernetes-native
   * resource model * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
   * available as of GKE 1.15). * `none` - no logs will be exported from the cluster.
   *
   * If left as an empty string,`logging.googleapis.com/kubernetes` will be used for GKE 1.14+ or
   * `logging.googleapis.com` for earlier versions.
   * @param loggingService loggingService or {@code null} for none
   */
  public Cluster setLoggingService(java.lang.String loggingService) {
    this.loggingService = loggingService;
    return this;
  }

  /**
   * Configure the maintenance policy for this cluster.
   * @return value or {@code null} for none
   */
  public MaintenancePolicy getMaintenancePolicy() {
    return maintenancePolicy;
  }

  /**
   * Configure the maintenance policy for this cluster.
   * @param maintenancePolicy maintenancePolicy or {@code null} for none
   */
  public Cluster setMaintenancePolicy(MaintenancePolicy maintenancePolicy) {
    this.maintenancePolicy = maintenancePolicy;
    return this;
  }

  /**
   * The authentication information for accessing the master endpoint. If unspecified, the defaults
   * are used: For clusters before v1.12, if master_auth is unspecified, `username` will be set to
   * "admin", a random password will be generated, and a client certificate will be issued.
   * @return value or {@code null} for none
   */
  public MasterAuth getMasterAuth() {
    return masterAuth;
  }

  /**
   * The authentication information for accessing the master endpoint. If unspecified, the defaults
   * are used: For clusters before v1.12, if master_auth is unspecified, `username` will be set to
   * "admin", a random password will be generated, and a client certificate will be issued.
   * @param masterAuth masterAuth or {@code null} for none
   */
  public Cluster setMasterAuth(MasterAuth masterAuth) {
    this.masterAuth = masterAuth;
    return this;
  }

  /**
   * The configuration options for master authorized networks feature.
   * @return value or {@code null} for none
   */
  public MasterAuthorizedNetworksConfig getMasterAuthorizedNetworksConfig() {
    return masterAuthorizedNetworksConfig;
  }

  /**
   * The configuration options for master authorized networks feature.
   * @param masterAuthorizedNetworksConfig masterAuthorizedNetworksConfig or {@code null} for none
   */
  public Cluster setMasterAuthorizedNetworksConfig(MasterAuthorizedNetworksConfig masterAuthorizedNetworksConfig) {
    this.masterAuthorizedNetworksConfig = masterAuthorizedNetworksConfig;
    return this;
  }

  /**
   * The monitoring service the cluster should use to write metrics. Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring service with a Kubernetes-
   * native resource model * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   * longer available as of GKE 1.15). * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be used for GKE 1.14+ or
   * `monitoring.googleapis.com` for earlier versions.
   * @return value or {@code null} for none
   */
  public java.lang.String getMonitoringService() {
    return monitoringService;
  }

  /**
   * The monitoring service the cluster should use to write metrics. Currently available options:
   *
   * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring service with a Kubernetes-
   * native resource model * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
   * longer available as of GKE 1.15). * `none` - No metrics will be exported from the cluster.
   *
   * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be used for GKE 1.14+ or
   * `monitoring.googleapis.com` for earlier versions.
   * @param monitoringService monitoringService or {@code null} for none
   */
  public Cluster setMonitoringService(java.lang.String monitoringService) {
    this.monitoringService = monitoringService;
    return this;
  }

  /**
   * The name of this cluster. The name must be unique within this project and location (e.g. zone
   * or region), and can be up to 40 characters with the following restrictions:
   *
   * * Lowercase letters, numbers, and hyphens only. * Must start with a letter. * Must end with a
   * number or a letter.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this cluster. The name must be unique within this project and location (e.g. zone
   * or region), and can be up to 40 characters with the following restrictions:
   *
   * * Lowercase letters, numbers, and hyphens only. * Must start with a letter. * Must end with a
   * number or a letter.
   * @param name name or {@code null} for none
   */
  public Cluster setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the Google Compute Engine [network](/compute/docs/networks-and-firewalls#networks)
   * to which the cluster is connected. If left unspecified, the `default` network will be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * The name of the Google Compute Engine [network](/compute/docs/networks-and-firewalls#networks)
   * to which the cluster is connected. If left unspecified, the `default` network will be used.
   * @param network network or {@code null} for none
   */
  public Cluster setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * Configuration for cluster networking.
   * @return value or {@code null} for none
   */
  public NetworkConfig getNetworkConfig() {
    return networkConfig;
  }

  /**
   * Configuration for cluster networking.
   * @param networkConfig networkConfig or {@code null} for none
   */
  public Cluster setNetworkConfig(NetworkConfig networkConfig) {
    this.networkConfig = networkConfig;
    return this;
  }

  /**
   * Configuration options for the NetworkPolicy feature.
   * @return value or {@code null} for none
   */
  public NetworkPolicy getNetworkPolicy() {
    return networkPolicy;
  }

  /**
   * Configuration options for the NetworkPolicy feature.
   * @param networkPolicy networkPolicy or {@code null} for none
   */
  public Cluster setNetworkPolicy(NetworkPolicy networkPolicy) {
    this.networkPolicy = networkPolicy;
    return this;
  }

  /**
   * Parameters used in creating the cluster's nodes. For requests, this field should only be used
   * in lieu of a "node_pool" object, since this configuration (along with the "initial_node_count")
   * will be used to create a "NodePool" object with an auto-generated name. Do not use this and a
   * node_pool at the same time. For responses, this field will be populated with the node
   * configuration of the first node pool. (For configuration of each node pool, see
   * `node_pool.config`)
   *
   * If unspecified, the defaults are used. This field is deprecated, use node_pool.config instead.
   * @return value or {@code null} for none
   */
  public NodeConfig getNodeConfig() {
    return nodeConfig;
  }

  /**
   * Parameters used in creating the cluster's nodes. For requests, this field should only be used
   * in lieu of a "node_pool" object, since this configuration (along with the "initial_node_count")
   * will be used to create a "NodePool" object with an auto-generated name. Do not use this and a
   * node_pool at the same time. For responses, this field will be populated with the node
   * configuration of the first node pool. (For configuration of each node pool, see
   * `node_pool.config`)
   *
   * If unspecified, the defaults are used. This field is deprecated, use node_pool.config instead.
   * @param nodeConfig nodeConfig or {@code null} for none
   */
  public Cluster setNodeConfig(NodeConfig nodeConfig) {
    this.nodeConfig = nodeConfig;
    return this;
  }

  /**
   * [Output only] The size of the address space on each node for hosting containers. This is
   * provisioned from within the `container_ipv4_cidr` range. This field will only be set when
   * cluster is in route-based network mode.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNodeIpv4CidrSize() {
    return nodeIpv4CidrSize;
  }

  /**
   * [Output only] The size of the address space on each node for hosting containers. This is
   * provisioned from within the `container_ipv4_cidr` range. This field will only be set when
   * cluster is in route-based network mode.
   * @param nodeIpv4CidrSize nodeIpv4CidrSize or {@code null} for none
   */
  public Cluster setNodeIpv4CidrSize(java.lang.Integer nodeIpv4CidrSize) {
    this.nodeIpv4CidrSize = nodeIpv4CidrSize;
    return this;
  }

  /**
   * The node pools associated with this cluster. This field should not be set if "node_config" or
   * "initial_node_count" are specified.
   * @return value or {@code null} for none
   */
  public java.util.List<NodePool> getNodePools() {
    return nodePools;
  }

  /**
   * The node pools associated with this cluster. This field should not be set if "node_config" or
   * "initial_node_count" are specified.
   * @param nodePools nodePools or {@code null} for none
   */
  public Cluster setNodePools(java.util.List<NodePool> nodePools) {
    this.nodePools = nodePools;
    return this;
  }

  /**
   * Configuration for private cluster.
   * @return value or {@code null} for none
   */
  public PrivateClusterConfig getPrivateClusterConfig() {
    return privateClusterConfig;
  }

  /**
   * Configuration for private cluster.
   * @param privateClusterConfig privateClusterConfig or {@code null} for none
   */
  public Cluster setPrivateClusterConfig(PrivateClusterConfig privateClusterConfig) {
    this.privateClusterConfig = privateClusterConfig;
    return this;
  }

  /**
   * The resource labels for the cluster to use to annotate any related Google Compute Engine
   * resources.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getResourceLabels() {
    return resourceLabels;
  }

  /**
   * The resource labels for the cluster to use to annotate any related Google Compute Engine
   * resources.
   * @param resourceLabels resourceLabels or {@code null} for none
   */
  public Cluster setResourceLabels(java.util.Map<String, java.lang.String> resourceLabels) {
    this.resourceLabels = resourceLabels;
    return this;
  }

  /**
   * Configuration for exporting resource usages. Resource usage export is disabled when this config
   * is unspecified.
   * @return value or {@code null} for none
   */
  public ResourceUsageExportConfig getResourceUsageExportConfig() {
    return resourceUsageExportConfig;
  }

  /**
   * Configuration for exporting resource usages. Resource usage export is disabled when this config
   * is unspecified.
   * @param resourceUsageExportConfig resourceUsageExportConfig or {@code null} for none
   */
  public Cluster setResourceUsageExportConfig(ResourceUsageExportConfig resourceUsageExportConfig) {
    this.resourceUsageExportConfig = resourceUsageExportConfig;
    return this;
  }

  /**
   * [Output only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public Cluster setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output only] The IP address range of the Kubernetes services in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
   * `1.2.3.4/29`). Service addresses are typically put in the last `/16` from the container CIDR.
   * @return value or {@code null} for none
   */
  public java.lang.String getServicesIpv4Cidr() {
    return servicesIpv4Cidr;
  }

  /**
   * [Output only] The IP address range of the Kubernetes services in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
   * `1.2.3.4/29`). Service addresses are typically put in the last `/16` from the container CIDR.
   * @param servicesIpv4Cidr servicesIpv4Cidr or {@code null} for none
   */
  public Cluster setServicesIpv4Cidr(java.lang.String servicesIpv4Cidr) {
    this.servicesIpv4Cidr = servicesIpv4Cidr;
    return this;
  }

  /**
   * Shielded Nodes configuration.
   * @return value or {@code null} for none
   */
  public ShieldedNodes getShieldedNodes() {
    return shieldedNodes;
  }

  /**
   * Shielded Nodes configuration.
   * @param shieldedNodes shieldedNodes or {@code null} for none
   */
  public Cluster setShieldedNodes(ShieldedNodes shieldedNodes) {
    this.shieldedNodes = shieldedNodes;
    return this;
  }

  /**
   * [Output only] The current status of this cluster.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output only] The current status of this cluster.
   * @param status status or {@code null} for none
   */
  public Cluster setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * [Output only] Additional information about the current status of this cluster, if available.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatusMessage() {
    return statusMessage;
  }

  /**
   * [Output only] Additional information about the current status of this cluster, if available.
   * @param statusMessage statusMessage or {@code null} for none
   */
  public Cluster setStatusMessage(java.lang.String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

  /**
   * The name of the Google Compute Engine [subnetwork](/compute/docs/subnetworks) to which the
   * cluster is connected.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubnetwork() {
    return subnetwork;
  }

  /**
   * The name of the Google Compute Engine [subnetwork](/compute/docs/subnetworks) to which the
   * cluster is connected.
   * @param subnetwork subnetwork or {@code null} for none
   */
  public Cluster setSubnetwork(java.lang.String subnetwork) {
    this.subnetwork = subnetwork;
    return this;
  }

  /**
   * [Output only] The IP address range of the Cloud TPUs in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
   * `1.2.3.4/29`).
   * @return value or {@code null} for none
   */
  public java.lang.String getTpuIpv4CidrBlock() {
    return tpuIpv4CidrBlock;
  }

  /**
   * [Output only] The IP address range of the Cloud TPUs in this cluster, in
   * [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g.
   * `1.2.3.4/29`).
   * @param tpuIpv4CidrBlock tpuIpv4CidrBlock or {@code null} for none
   */
  public Cluster setTpuIpv4CidrBlock(java.lang.String tpuIpv4CidrBlock) {
    this.tpuIpv4CidrBlock = tpuIpv4CidrBlock;
    return this;
  }

  /**
   * Cluster-level Vertical Pod Autoscaling configuration.
   * @return value or {@code null} for none
   */
  public VerticalPodAutoscaling getVerticalPodAutoscaling() {
    return verticalPodAutoscaling;
  }

  /**
   * Cluster-level Vertical Pod Autoscaling configuration.
   * @param verticalPodAutoscaling verticalPodAutoscaling or {@code null} for none
   */
  public Cluster setVerticalPodAutoscaling(VerticalPodAutoscaling verticalPodAutoscaling) {
    this.verticalPodAutoscaling = verticalPodAutoscaling;
    return this;
  }

  /**
   * Configuration for the use of Kubernetes Service Accounts in GCP IAM policies.
   * @return value or {@code null} for none
   */
  public WorkloadIdentityConfig getWorkloadIdentityConfig() {
    return workloadIdentityConfig;
  }

  /**
   * Configuration for the use of Kubernetes Service Accounts in GCP IAM policies.
   * @param workloadIdentityConfig workloadIdentityConfig or {@code null} for none
   */
  public Cluster setWorkloadIdentityConfig(WorkloadIdentityConfig workloadIdentityConfig) {
    this.workloadIdentityConfig = workloadIdentityConfig;
    return this;
  }

  /**
   * [Output only] The name of the Google Compute Engine [zone](/compute/docs/zones#available) in
   * which the cluster resides. This field is deprecated, use location instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output only] The name of the Google Compute Engine [zone](/compute/docs/zones#available) in
   * which the cluster resides. This field is deprecated, use location instead.
   * @param zone zone or {@code null} for none
   */
  public Cluster setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public Cluster set(String fieldName, Object value) {
    return (Cluster) super.set(fieldName, value);
  }

  @Override
  public Cluster clone() {
    return (Cluster) super.clone();
  }

}
