/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * Configuration options for the horizontal pod autoscaling feature, which increases or decreases
 * the number of replica pods a replication controller has based on the resource usage of the
 * existing pods.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HorizontalPodAutoscaling extends com.google.api.client.json.GenericJson {

  /**
   * Whether the Horizontal Pod Autoscaling feature is enabled in the cluster. When enabled, it
   * ensures that metrics are collected into Stackdriver Monitoring.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * Whether the Horizontal Pod Autoscaling feature is enabled in the cluster. When enabled, it
   * ensures that metrics are collected into Stackdriver Monitoring.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * Whether the Horizontal Pod Autoscaling feature is enabled in the cluster. When enabled, it
   * ensures that metrics are collected into Stackdriver Monitoring.
   * @param disabled disabled or {@code null} for none
   */
  public HorizontalPodAutoscaling setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  @Override
  public HorizontalPodAutoscaling set(String fieldName, Object value) {
    return (HorizontalPodAutoscaling) super.set(fieldName, value);
  }

  @Override
  public HorizontalPodAutoscaling clone() {
    return (HorizontalPodAutoscaling) super.clone();
  }

}
