/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * Jwk is a JSON Web Key as specified in RFC 7517
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Jwk extends com.google.api.client.json.GenericJson {

  /**
   * Algorithm.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String alg;

  /**
   * Used for ECDSA keys.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String crv;

  /**
   * Used for RSA keys.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String e;

  /**
   * Key ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kid;

  /**
   * Key Type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kty;

  /**
   * Used for RSA keys.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String n;

  /**
   * Permitted uses for the public keys.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String use;

  /**
   * Used for ECDSA keys.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String x;

  /**
   * Used for ECDSA keys.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String y;

  /**
   * Algorithm.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlg() {
    return alg;
  }

  /**
   * Algorithm.
   * @param alg alg or {@code null} for none
   */
  public Jwk setAlg(java.lang.String alg) {
    this.alg = alg;
    return this;
  }

  /**
   * Used for ECDSA keys.
   * @return value or {@code null} for none
   */
  public java.lang.String getCrv() {
    return crv;
  }

  /**
   * Used for ECDSA keys.
   * @param crv crv or {@code null} for none
   */
  public Jwk setCrv(java.lang.String crv) {
    this.crv = crv;
    return this;
  }

  /**
   * Used for RSA keys.
   * @return value or {@code null} for none
   */
  public java.lang.String getE() {
    return e;
  }

  /**
   * Used for RSA keys.
   * @param e e or {@code null} for none
   */
  public Jwk setE(java.lang.String e) {
    this.e = e;
    return this;
  }

  /**
   * Key ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getKid() {
    return kid;
  }

  /**
   * Key ID.
   * @param kid kid or {@code null} for none
   */
  public Jwk setKid(java.lang.String kid) {
    this.kid = kid;
    return this;
  }

  /**
   * Key Type.
   * @return value or {@code null} for none
   */
  public java.lang.String getKty() {
    return kty;
  }

  /**
   * Key Type.
   * @param kty kty or {@code null} for none
   */
  public Jwk setKty(java.lang.String kty) {
    this.kty = kty;
    return this;
  }

  /**
   * Used for RSA keys.
   * @return value or {@code null} for none
   */
  public java.lang.String getN() {
    return n;
  }

  /**
   * Used for RSA keys.
   * @param n n or {@code null} for none
   */
  public Jwk setN(java.lang.String n) {
    this.n = n;
    return this;
  }

  /**
   * Permitted uses for the public keys.
   * @return value or {@code null} for none
   */
  public java.lang.String getUse() {
    return use;
  }

  /**
   * Permitted uses for the public keys.
   * @param use use or {@code null} for none
   */
  public Jwk setUse(java.lang.String use) {
    this.use = use;
    return this;
  }

  /**
   * Used for ECDSA keys.
   * @return value or {@code null} for none
   */
  public java.lang.String getX() {
    return x;
  }

  /**
   * Used for ECDSA keys.
   * @param x x or {@code null} for none
   */
  public Jwk setX(java.lang.String x) {
    this.x = x;
    return this;
  }

  /**
   * Used for ECDSA keys.
   * @return value or {@code null} for none
   */
  public java.lang.String getY() {
    return y;
  }

  /**
   * Used for ECDSA keys.
   * @param y y or {@code null} for none
   */
  public Jwk setY(java.lang.String y) {
    this.y = y;
    return this;
  }

  @Override
  public Jwk set(String fieldName, Object value) {
    return (Jwk) super.set(fieldName, value);
  }

  @Override
  public Jwk clone() {
    return (Jwk) super.clone();
  }

}
