/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * MaintenancePolicy defines the maintenance policy to be used for the cluster.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MaintenancePolicy extends com.google.api.client.json.GenericJson {

  /**
   * A hash identifying the version of this policy, so that updates to fields of the policy won't
   * accidentally undo intermediate changes (and so that users of the API unaware of some fields
   * won't accidentally remove other fields). Make a get() request to the cluster to get the current
   * resource version and include it with requests to set the policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceVersion;

  /**
   * Specifies the maintenance window in which maintenance may be performed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MaintenanceWindow window;

  /**
   * A hash identifying the version of this policy, so that updates to fields of the policy won't
   * accidentally undo intermediate changes (and so that users of the API unaware of some fields
   * won't accidentally remove other fields). Make a get() request to the cluster to get the current
   * resource version and include it with requests to set the policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceVersion() {
    return resourceVersion;
  }

  /**
   * A hash identifying the version of this policy, so that updates to fields of the policy won't
   * accidentally undo intermediate changes (and so that users of the API unaware of some fields
   * won't accidentally remove other fields). Make a get() request to the cluster to get the current
   * resource version and include it with requests to set the policy.
   * @param resourceVersion resourceVersion or {@code null} for none
   */
  public MaintenancePolicy setResourceVersion(java.lang.String resourceVersion) {
    this.resourceVersion = resourceVersion;
    return this;
  }

  /**
   * Specifies the maintenance window in which maintenance may be performed.
   * @return value or {@code null} for none
   */
  public MaintenanceWindow getWindow() {
    return window;
  }

  /**
   * Specifies the maintenance window in which maintenance may be performed.
   * @param window window or {@code null} for none
   */
  public MaintenancePolicy setWindow(MaintenanceWindow window) {
    this.window = window;
    return this;
  }

  @Override
  public MaintenancePolicy set(String fieldName, Object value) {
    return (MaintenancePolicy) super.set(fieldName, value);
  }

  @Override
  public MaintenancePolicy clone() {
    return (MaintenancePolicy) super.clone();
  }

}
