/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * NodeManagement defines the set of node management services turned on for the node pool.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NodeManagement extends com.google.api.client.json.GenericJson {

  /**
   * A flag that specifies whether the node auto-repair is enabled for the node pool. If enabled,
   * the nodes in this node pool will be monitored and, if they fail health checks too many times,
   * an automatic repair action will be triggered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoRepair;

  /**
   * A flag that specifies whether node auto-upgrade is enabled for the node pool. If enabled, node
   * auto-upgrade helps keep the nodes in your node pool up to date with the latest release version
   * of Kubernetes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoUpgrade;

  /**
   * Specifies the Auto Upgrade knobs for the node pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoUpgradeOptions upgradeOptions;

  /**
   * A flag that specifies whether the node auto-repair is enabled for the node pool. If enabled,
   * the nodes in this node pool will be monitored and, if they fail health checks too many times,
   * an automatic repair action will be triggered.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoRepair() {
    return autoRepair;
  }

  /**
   * A flag that specifies whether the node auto-repair is enabled for the node pool. If enabled,
   * the nodes in this node pool will be monitored and, if they fail health checks too many times,
   * an automatic repair action will be triggered.
   * @param autoRepair autoRepair or {@code null} for none
   */
  public NodeManagement setAutoRepair(java.lang.Boolean autoRepair) {
    this.autoRepair = autoRepair;
    return this;
  }

  /**
   * A flag that specifies whether node auto-upgrade is enabled for the node pool. If enabled, node
   * auto-upgrade helps keep the nodes in your node pool up to date with the latest release version
   * of Kubernetes.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoUpgrade() {
    return autoUpgrade;
  }

  /**
   * A flag that specifies whether node auto-upgrade is enabled for the node pool. If enabled, node
   * auto-upgrade helps keep the nodes in your node pool up to date with the latest release version
   * of Kubernetes.
   * @param autoUpgrade autoUpgrade or {@code null} for none
   */
  public NodeManagement setAutoUpgrade(java.lang.Boolean autoUpgrade) {
    this.autoUpgrade = autoUpgrade;
    return this;
  }

  /**
   * Specifies the Auto Upgrade knobs for the node pool.
   * @return value or {@code null} for none
   */
  public AutoUpgradeOptions getUpgradeOptions() {
    return upgradeOptions;
  }

  /**
   * Specifies the Auto Upgrade knobs for the node pool.
   * @param upgradeOptions upgradeOptions or {@code null} for none
   */
  public NodeManagement setUpgradeOptions(AutoUpgradeOptions upgradeOptions) {
    this.upgradeOptions = upgradeOptions;
    return this;
  }

  @Override
  public NodeManagement set(String fieldName, Object value) {
    return (NodeManagement) super.set(fieldName, value);
  }

  @Override
  public NodeManagement clone() {
    return (NodeManagement) super.clone();
  }

}
