/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * Information about operation (or operation stage) progress.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OperationProgress extends com.google.api.client.json.GenericJson {

  /**
   * Progress metric bundle, for example:   metrics: [{name: "nodes done",     int_value: 15},
   * {name: "nodes total",    int_value: 32}] or   metrics: [{name: "progress",       double_value:
   * 0.56},             {name: "progress scale", double_value: 1.0}]
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Metric> metrics;

  static {
    // hack to force ProGuard to consider Metric used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Metric.class);
  }

  /**
   * A non-parameterized string describing an operation stage. Unset for single-stage operations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Substages of an operation or a stage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OperationProgress> stages;

  /**
   * Status of an operation stage. Unset for single-stage operations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Progress metric bundle, for example:   metrics: [{name: "nodes done",     int_value: 15},
   * {name: "nodes total",    int_value: 32}] or   metrics: [{name: "progress",       double_value:
   * 0.56},             {name: "progress scale", double_value: 1.0}]
   * @return value or {@code null} for none
   */
  public java.util.List<Metric> getMetrics() {
    return metrics;
  }

  /**
   * Progress metric bundle, for example:   metrics: [{name: "nodes done",     int_value: 15},
   * {name: "nodes total",    int_value: 32}] or   metrics: [{name: "progress",       double_value:
   * 0.56},             {name: "progress scale", double_value: 1.0}]
   * @param metrics metrics or {@code null} for none
   */
  public OperationProgress setMetrics(java.util.List<Metric> metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * A non-parameterized string describing an operation stage. Unset for single-stage operations.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * A non-parameterized string describing an operation stage. Unset for single-stage operations.
   * @param name name or {@code null} for none
   */
  public OperationProgress setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Substages of an operation or a stage.
   * @return value or {@code null} for none
   */
  public java.util.List<OperationProgress> getStages() {
    return stages;
  }

  /**
   * Substages of an operation or a stage.
   * @param stages stages or {@code null} for none
   */
  public OperationProgress setStages(java.util.List<OperationProgress> stages) {
    this.stages = stages;
    return this;
  }

  /**
   * Status of an operation stage. Unset for single-stage operations.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of an operation stage. Unset for single-stage operations.
   * @param status status or {@code null} for none
   */
  public OperationProgress setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public OperationProgress set(String fieldName, Object value) {
    return (OperationProgress) super.set(fieldName, value);
  }

  @Override
  public OperationProgress clone() {
    return (OperationProgress) super.clone();
  }

}
