/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * Configuration options for private clusters.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PrivateClusterConfig extends com.google.api.client.json.GenericJson {

  /**
   * Whether the master's internal IP address is used as the cluster endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enablePrivateEndpoint;

  /**
   * Whether nodes have internal IP addresses only. If enabled, all nodes are given only RFC 1918
   * private addresses and communicate with the master via private networking.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enablePrivateNodes;

  /**
   * The IP range in CIDR notation to use for the hosted master network. This range will be used for
   * assigning internal IP addresses to the master or set of masters, as well as the ILB VIP. This
   * range must not overlap with any other ranges in use within the cluster's network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String masterIpv4CidrBlock;

  /**
   * Output only. The peering name in the customer VPC used by this cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String peeringName;

  /**
   * Output only. The internal IP address of this cluster's master endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String privateEndpoint;

  /**
   * Output only. The external IP address of this cluster's master endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publicEndpoint;

  /**
   * Whether the master's internal IP address is used as the cluster endpoint.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnablePrivateEndpoint() {
    return enablePrivateEndpoint;
  }

  /**
   * Whether the master's internal IP address is used as the cluster endpoint.
   * @param enablePrivateEndpoint enablePrivateEndpoint or {@code null} for none
   */
  public PrivateClusterConfig setEnablePrivateEndpoint(java.lang.Boolean enablePrivateEndpoint) {
    this.enablePrivateEndpoint = enablePrivateEndpoint;
    return this;
  }

  /**
   * Whether nodes have internal IP addresses only. If enabled, all nodes are given only RFC 1918
   * private addresses and communicate with the master via private networking.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnablePrivateNodes() {
    return enablePrivateNodes;
  }

  /**
   * Whether nodes have internal IP addresses only. If enabled, all nodes are given only RFC 1918
   * private addresses and communicate with the master via private networking.
   * @param enablePrivateNodes enablePrivateNodes or {@code null} for none
   */
  public PrivateClusterConfig setEnablePrivateNodes(java.lang.Boolean enablePrivateNodes) {
    this.enablePrivateNodes = enablePrivateNodes;
    return this;
  }

  /**
   * The IP range in CIDR notation to use for the hosted master network. This range will be used for
   * assigning internal IP addresses to the master or set of masters, as well as the ILB VIP. This
   * range must not overlap with any other ranges in use within the cluster's network.
   * @return value or {@code null} for none
   */
  public java.lang.String getMasterIpv4CidrBlock() {
    return masterIpv4CidrBlock;
  }

  /**
   * The IP range in CIDR notation to use for the hosted master network. This range will be used for
   * assigning internal IP addresses to the master or set of masters, as well as the ILB VIP. This
   * range must not overlap with any other ranges in use within the cluster's network.
   * @param masterIpv4CidrBlock masterIpv4CidrBlock or {@code null} for none
   */
  public PrivateClusterConfig setMasterIpv4CidrBlock(java.lang.String masterIpv4CidrBlock) {
    this.masterIpv4CidrBlock = masterIpv4CidrBlock;
    return this;
  }

  /**
   * Output only. The peering name in the customer VPC used by this cluster.
   * @return value or {@code null} for none
   */
  public java.lang.String getPeeringName() {
    return peeringName;
  }

  /**
   * Output only. The peering name in the customer VPC used by this cluster.
   * @param peeringName peeringName or {@code null} for none
   */
  public PrivateClusterConfig setPeeringName(java.lang.String peeringName) {
    this.peeringName = peeringName;
    return this;
  }

  /**
   * Output only. The internal IP address of this cluster's master endpoint.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrivateEndpoint() {
    return privateEndpoint;
  }

  /**
   * Output only. The internal IP address of this cluster's master endpoint.
   * @param privateEndpoint privateEndpoint or {@code null} for none
   */
  public PrivateClusterConfig setPrivateEndpoint(java.lang.String privateEndpoint) {
    this.privateEndpoint = privateEndpoint;
    return this;
  }

  /**
   * Output only. The external IP address of this cluster's master endpoint.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublicEndpoint() {
    return publicEndpoint;
  }

  /**
   * Output only. The external IP address of this cluster's master endpoint.
   * @param publicEndpoint publicEndpoint or {@code null} for none
   */
  public PrivateClusterConfig setPublicEndpoint(java.lang.String publicEndpoint) {
    this.publicEndpoint = publicEndpoint;
    return this;
  }

  @Override
  public PrivateClusterConfig set(String fieldName, Object value) {
    return (PrivateClusterConfig) super.set(fieldName, value);
  }

  @Override
  public PrivateClusterConfig clone() {
    return (PrivateClusterConfig) super.clone();
  }

}
