/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * Represents an arbitrary window of time that recurs.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RecurringTimeWindow extends com.google.api.client.json.GenericJson {

  /**
   * An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how this window reccurs.
   * They go on for the span of time between the start and end time.
   *
   * For example, to have something repeat every weekday, you'd use:
   * FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR To repeat some window daily (equivalent to the
   * DailyMaintenanceWindow):   FREQ=DAILY For the first weekend of every month:
   * FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU This specifies how frequently the window starts. Eg, if you
   * wanted to have a 9-5 UTC-4 window every weekday, you'd use something like:
   *
   *   start time = 2019-01-01T09:00:00-0400   end time = 2019-01-01T17:00:00-0400   recurrence =
   * FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR
   *
   * Windows can span multiple days. Eg, to make the window encompass every weekend from midnight
   * Saturday till the last minute of Sunday UTC:
   *
   *   start time = 2019-01-05T00:00:00Z   end time = 2019-01-07T23:59:00Z   recurrence =
   * FREQ=WEEKLY;BYDAY=SA
   *
   * Note the start and end time's specific dates are largely arbitrary except to specify duration
   * of the window and when it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are
   * not supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String recurrence;

  /**
   * The window of the first recurrence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeWindow window;

  /**
   * An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how this window reccurs.
   * They go on for the span of time between the start and end time.
   *
   * For example, to have something repeat every weekday, you'd use:
   * FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR To repeat some window daily (equivalent to the
   * DailyMaintenanceWindow):   FREQ=DAILY For the first weekend of every month:
   * FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU This specifies how frequently the window starts. Eg, if you
   * wanted to have a 9-5 UTC-4 window every weekday, you'd use something like:
   *
   *   start time = 2019-01-01T09:00:00-0400   end time = 2019-01-01T17:00:00-0400   recurrence =
   * FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR
   *
   * Windows can span multiple days. Eg, to make the window encompass every weekend from midnight
   * Saturday till the last minute of Sunday UTC:
   *
   *   start time = 2019-01-05T00:00:00Z   end time = 2019-01-07T23:59:00Z   recurrence =
   * FREQ=WEEKLY;BYDAY=SA
   *
   * Note the start and end time's specific dates are largely arbitrary except to specify duration
   * of the window and when it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are
   * not supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getRecurrence() {
    return recurrence;
  }

  /**
   * An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how this window reccurs.
   * They go on for the span of time between the start and end time.
   *
   * For example, to have something repeat every weekday, you'd use:
   * FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR To repeat some window daily (equivalent to the
   * DailyMaintenanceWindow):   FREQ=DAILY For the first weekend of every month:
   * FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU This specifies how frequently the window starts. Eg, if you
   * wanted to have a 9-5 UTC-4 window every weekday, you'd use something like:
   *
   *   start time = 2019-01-01T09:00:00-0400   end time = 2019-01-01T17:00:00-0400   recurrence =
   * FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR
   *
   * Windows can span multiple days. Eg, to make the window encompass every weekend from midnight
   * Saturday till the last minute of Sunday UTC:
   *
   *   start time = 2019-01-05T00:00:00Z   end time = 2019-01-07T23:59:00Z   recurrence =
   * FREQ=WEEKLY;BYDAY=SA
   *
   * Note the start and end time's specific dates are largely arbitrary except to specify duration
   * of the window and when it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are
   * not supported.
   * @param recurrence recurrence or {@code null} for none
   */
  public RecurringTimeWindow setRecurrence(java.lang.String recurrence) {
    this.recurrence = recurrence;
    return this;
  }

  /**
   * The window of the first recurrence.
   * @return value or {@code null} for none
   */
  public TimeWindow getWindow() {
    return window;
  }

  /**
   * The window of the first recurrence.
   * @param window window or {@code null} for none
   */
  public RecurringTimeWindow setWindow(TimeWindow window) {
    this.window = window;
    return this;
  }

  @Override
  public RecurringTimeWindow set(String fieldName, Object value) {
    return (RecurringTimeWindow) super.set(fieldName, value);
  }

  @Override
  public RecurringTimeWindow clone() {
    return (RecurringTimeWindow) super.clone();
  }

}
