/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * UsableSubnetwork resource returns the subnetwork name, its associated network and the primary
 * CIDR range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UsableSubnetwork extends com.google.api.client.json.GenericJson {

  /**
   * The range of internal addresses that are owned by this subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipCidrRange;

  /**
   * Network Name. Example: projects/my-project/global/networks/my-network
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * Secondary IP ranges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UsableSubnetworkSecondaryRange> secondaryIpRanges;

  /**
   * A human readable status message representing the reasons for cases where the caller cannot use
   * the secondary ranges under the subnet. For example if the secondary_ip_ranges is empty due to a
   * permission issue, an insufficient permission message will be given by status_message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statusMessage;

  /**
   * Subnetwork Name. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subnetwork;

  /**
   * The range of internal addresses that are owned by this subnetwork.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpCidrRange() {
    return ipCidrRange;
  }

  /**
   * The range of internal addresses that are owned by this subnetwork.
   * @param ipCidrRange ipCidrRange or {@code null} for none
   */
  public UsableSubnetwork setIpCidrRange(java.lang.String ipCidrRange) {
    this.ipCidrRange = ipCidrRange;
    return this;
  }

  /**
   * Network Name. Example: projects/my-project/global/networks/my-network
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * Network Name. Example: projects/my-project/global/networks/my-network
   * @param network network or {@code null} for none
   */
  public UsableSubnetwork setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * Secondary IP ranges.
   * @return value or {@code null} for none
   */
  public java.util.List<UsableSubnetworkSecondaryRange> getSecondaryIpRanges() {
    return secondaryIpRanges;
  }

  /**
   * Secondary IP ranges.
   * @param secondaryIpRanges secondaryIpRanges or {@code null} for none
   */
  public UsableSubnetwork setSecondaryIpRanges(java.util.List<UsableSubnetworkSecondaryRange> secondaryIpRanges) {
    this.secondaryIpRanges = secondaryIpRanges;
    return this;
  }

  /**
   * A human readable status message representing the reasons for cases where the caller cannot use
   * the secondary ranges under the subnet. For example if the secondary_ip_ranges is empty due to a
   * permission issue, an insufficient permission message will be given by status_message.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatusMessage() {
    return statusMessage;
  }

  /**
   * A human readable status message representing the reasons for cases where the caller cannot use
   * the secondary ranges under the subnet. For example if the secondary_ip_ranges is empty due to a
   * permission issue, an insufficient permission message will be given by status_message.
   * @param statusMessage statusMessage or {@code null} for none
   */
  public UsableSubnetwork setStatusMessage(java.lang.String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

  /**
   * Subnetwork Name. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
   * @return value or {@code null} for none
   */
  public java.lang.String getSubnetwork() {
    return subnetwork;
  }

  /**
   * Subnetwork Name. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
   * @param subnetwork subnetwork or {@code null} for none
   */
  public UsableSubnetwork setSubnetwork(java.lang.String subnetwork) {
    this.subnetwork = subnetwork;
    return this;
  }

  @Override
  public UsableSubnetwork set(String fieldName, Object value) {
    return (UsableSubnetwork) super.set(fieldName, value);
  }

  @Override
  public UsableSubnetwork clone() {
    return (UsableSubnetwork) super.clone();
  }

}
