/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * WorkloadMetadataConfig defines the metadata configuration to expose to workloads on the node
 * pool.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WorkloadMetadataConfig extends com.google.api.client.json.GenericJson {

  /**
   * Mode is the configuration for how to expose metadata to workloads running on the node pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * Mode is the configuration for how to expose metadata to workloads running on the node pool.
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * Mode is the configuration for how to expose metadata to workloads running on the node pool.
   * @param mode mode or {@code null} for none
   */
  public WorkloadMetadataConfig setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  @Override
  public WorkloadMetadataConfig set(String fieldName, Object value) {
    return (WorkloadMetadataConfig) super.set(fieldName, value);
  }

  @Override
  public WorkloadMetadataConfig clone() {
    return (WorkloadMetadataConfig) super.clone();
  }

}
