/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.container;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.container.ContainerRequest;
import com.google.api.services.container.ContainerRequestInitializer;
import com.google.api.services.container.model.CancelOperationRequest;
import com.google.api.services.container.model.Cluster;
import com.google.api.services.container.model.CompleteIPRotationRequest;
import com.google.api.services.container.model.CreateClusterRequest;
import com.google.api.services.container.model.CreateNodePoolRequest;
import com.google.api.services.container.model.Empty;
import com.google.api.services.container.model.GetJSONWebKeysResponse;
import com.google.api.services.container.model.GetOpenIDConfigResponse;
import com.google.api.services.container.model.ListClustersResponse;
import com.google.api.services.container.model.ListNodePoolsResponse;
import com.google.api.services.container.model.ListOperationsResponse;
import com.google.api.services.container.model.ListUsableSubnetworksResponse;
import com.google.api.services.container.model.NodePool;
import com.google.api.services.container.model.Operation;
import com.google.api.services.container.model.RollbackNodePoolUpgradeRequest;
import com.google.api.services.container.model.ServerConfig;
import com.google.api.services.container.model.SetAddonsConfigRequest;
import com.google.api.services.container.model.SetLabelsRequest;
import com.google.api.services.container.model.SetLegacyAbacRequest;
import com.google.api.services.container.model.SetLocationsRequest;
import com.google.api.services.container.model.SetLoggingServiceRequest;
import com.google.api.services.container.model.SetMaintenancePolicyRequest;
import com.google.api.services.container.model.SetMasterAuthRequest;
import com.google.api.services.container.model.SetMonitoringServiceRequest;
import com.google.api.services.container.model.SetNetworkPolicyRequest;
import com.google.api.services.container.model.SetNodePoolAutoscalingRequest;
import com.google.api.services.container.model.SetNodePoolManagementRequest;
import com.google.api.services.container.model.SetNodePoolSizeRequest;
import com.google.api.services.container.model.StartIPRotationRequest;
import com.google.api.services.container.model.UpdateClusterRequest;
import com.google.api.services.container.model.UpdateMasterRequest;
import com.google.api.services.container.model.UpdateNodePoolRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class Container
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://container.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://container.googleapis.com/";

    public Container(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Container(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.9 of the Kubernetes Engine API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://container.googleapis.com/", Container.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Container.DEFAULT_BATCH_PATH);
        }

        public Container build() {
            return new Container(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setContainerRequestInitializer(ContainerRequestInitializer containerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)containerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Aggregated aggregated() {
            return new Aggregated();
        }

        public Locations locations() {
            return new Locations();
        }

        public Zones zones() {
            return new Zones();
        }

        public class Zones {
            public GetServerconfig getServerconfig(String projectId, String zone) throws IOException {
                GetServerconfig result = new GetServerconfig(projectId, zone);
                Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Clusters clusters() {
                return new Clusters();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String projectId, String zone, String operationId, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(projectId, zone, operationId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String projectId, String zone, String operationId) throws IOException {
                    Get result = new Get(projectId, zone, operationId);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String projectId, String zone) throws IOException {
                    List result = new List(projectId, zone);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends ContainerRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/operations";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String parent;

                    protected List(String projectId, String zone) {
                        super(Container.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public List setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/operations/{operationId}";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String operationId;
                    @Key
                    private String name;

                    protected Get(String projectId, String zone, String operationId) {
                        super(Container.this, "GET", REST_PATH, null, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.operationId = (String)Preconditions.checkNotNull((Object)operationId, (Object)"Required parameter operationId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Get setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getOperationId() {
                        return this.operationId;
                    }

                    public Get setOperationId(String operationId) {
                        this.operationId = operationId;
                        return this;
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends ContainerRequest<Empty> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/operations/{operationId}:cancel";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String operationId;

                    protected Cancel(String projectId, String zone, String operationId, CancelOperationRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.operationId = (String)Preconditions.checkNotNull((Object)operationId, (Object)"Required parameter operationId must be specified.");
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Cancel setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Cancel setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getOperationId() {
                        return this.operationId;
                    }

                    public Cancel setOperationId(String operationId) {
                        this.operationId = operationId;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Clusters {
                public Addons addons(String projectId, String zone, String clusterId, SetAddonsConfigRequest content) throws IOException {
                    Addons result = new Addons(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public CompleteIpRotation completeIpRotation(String projectId, String zone, String clusterId, CompleteIPRotationRequest content) throws IOException {
                    CompleteIpRotation result = new CompleteIpRotation(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(String projectId, String zone, CreateClusterRequest content) throws IOException {
                    Create result = new Create(projectId, zone, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String projectId, String zone, String clusterId) throws IOException {
                    Delete result = new Delete(projectId, zone, clusterId);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String projectId, String zone, String clusterId) throws IOException {
                    Get result = new Get(projectId, zone, clusterId);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public LegacyAbac legacyAbac(String projectId, String zone, String clusterId, SetLegacyAbacRequest content) throws IOException {
                    LegacyAbac result = new LegacyAbac(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String projectId, String zone) throws IOException {
                    List result = new List(projectId, zone);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Locations locations(String projectId, String zone, String clusterId, SetLocationsRequest content) throws IOException {
                    Locations result = new Locations(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Logging logging(String projectId, String zone, String clusterId, SetLoggingServiceRequest content) throws IOException {
                    Logging result = new Logging(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Master master(String projectId, String zone, String clusterId, UpdateMasterRequest content) throws IOException {
                    Master result = new Master(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Monitoring monitoring(String projectId, String zone, String clusterId, SetMonitoringServiceRequest content) throws IOException {
                    Monitoring result = new Monitoring(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ResourceLabels resourceLabels(String projectId, String zone, String clusterId, SetLabelsRequest content) throws IOException {
                    ResourceLabels result = new ResourceLabels(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetMaintenancePolicy setMaintenancePolicy(String projectId, String zone, String clusterId, SetMaintenancePolicyRequest content) throws IOException {
                    SetMaintenancePolicy result = new SetMaintenancePolicy(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetMasterAuth setMasterAuth(String projectId, String zone, String clusterId, SetMasterAuthRequest content) throws IOException {
                    SetMasterAuth result = new SetMasterAuth(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetNetworkPolicy setNetworkPolicy(String projectId, String zone, String clusterId, SetNetworkPolicyRequest content) throws IOException {
                    SetNetworkPolicy result = new SetNetworkPolicy(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public StartIpRotation startIpRotation(String projectId, String zone, String clusterId, StartIPRotationRequest content) throws IOException {
                    StartIpRotation result = new StartIpRotation(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Update update(String projectId, String zone, String clusterId, UpdateClusterRequest content) throws IOException {
                    Update result = new Update(projectId, zone, clusterId, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public NodePools nodePools() {
                    return new NodePools();
                }

                public class NodePools {
                    public Autoscaling autoscaling(String projectId, String zone, String clusterId, String nodePoolId, SetNodePoolAutoscalingRequest content) throws IOException {
                        Autoscaling result = new Autoscaling(projectId, zone, clusterId, nodePoolId, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Create create(String projectId, String zone, String clusterId, CreateNodePoolRequest content) throws IOException {
                        Create result = new Create(projectId, zone, clusterId, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String projectId, String zone, String clusterId, String nodePoolId) throws IOException {
                        Delete result = new Delete(projectId, zone, clusterId, nodePoolId);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String projectId, String zone, String clusterId, String nodePoolId) throws IOException {
                        Get result = new Get(projectId, zone, clusterId, nodePoolId);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String projectId, String zone, String clusterId) throws IOException {
                        List result = new List(projectId, zone, clusterId);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Rollback rollback(String projectId, String zone, String clusterId, String nodePoolId, RollbackNodePoolUpgradeRequest content) throws IOException {
                        Rollback result = new Rollback(projectId, zone, clusterId, nodePoolId, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetManagement setManagement(String projectId, String zone, String clusterId, String nodePoolId, SetNodePoolManagementRequest content) throws IOException {
                        SetManagement result = new SetManagement(projectId, zone, clusterId, nodePoolId, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetSize setSize(String projectId, String zone, String clusterId, String nodePoolId, SetNodePoolSizeRequest content) throws IOException {
                        SetSize result = new SetSize(projectId, zone, clusterId, nodePoolId, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Update update(String projectId, String zone, String clusterId, String nodePoolId, UpdateNodePoolRequest content) throws IOException {
                        Update result = new Update(projectId, zone, clusterId, nodePoolId, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Update
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/update";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected Update(String projectId, String zone, String clusterId, String nodePoolId, UpdateNodePoolRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)nodePoolId, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public Update set$Xgafv(String $Xgafv) {
                            return (Update)super.set$Xgafv($Xgafv);
                        }

                        public Update setAccessToken(String accessToken) {
                            return (Update)super.setAccessToken(accessToken);
                        }

                        public Update setAlt(String alt) {
                            return (Update)super.setAlt(alt);
                        }

                        public Update setCallback(String callback) {
                            return (Update)super.setCallback(callback);
                        }

                        public Update setFields(String fields) {
                            return (Update)super.setFields(fields);
                        }

                        public Update setKey(String key) {
                            return (Update)super.setKey(key);
                        }

                        public Update setOauthToken(String oauthToken) {
                            return (Update)super.setOauthToken(oauthToken);
                        }

                        public Update setPrettyPrint(Boolean prettyPrint) {
                            return (Update)super.setPrettyPrint(prettyPrint);
                        }

                        public Update setQuotaUser(String quotaUser) {
                            return (Update)super.setQuotaUser(quotaUser);
                        }

                        public Update setUploadType(String uploadType) {
                            return (Update)super.setUploadType(uploadType);
                        }

                        public Update setUploadProtocol(String uploadProtocol) {
                            return (Update)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Update setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Update setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Update setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Update setNodePoolId(String nodePoolId) {
                            this.nodePoolId = nodePoolId;
                            return this;
                        }

                        @Override
                        public Update set(String parameterName, Object value) {
                            return (Update)super.set(parameterName, value);
                        }
                    }

                    public class SetSize
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setSize";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected SetSize(String projectId, String zone, String clusterId, String nodePoolId, SetNodePoolSizeRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)nodePoolId, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public SetSize set$Xgafv(String $Xgafv) {
                            return (SetSize)super.set$Xgafv($Xgafv);
                        }

                        public SetSize setAccessToken(String accessToken) {
                            return (SetSize)super.setAccessToken(accessToken);
                        }

                        public SetSize setAlt(String alt) {
                            return (SetSize)super.setAlt(alt);
                        }

                        public SetSize setCallback(String callback) {
                            return (SetSize)super.setCallback(callback);
                        }

                        public SetSize setFields(String fields) {
                            return (SetSize)super.setFields(fields);
                        }

                        public SetSize setKey(String key) {
                            return (SetSize)super.setKey(key);
                        }

                        public SetSize setOauthToken(String oauthToken) {
                            return (SetSize)super.setOauthToken(oauthToken);
                        }

                        public SetSize setPrettyPrint(Boolean prettyPrint) {
                            return (SetSize)super.setPrettyPrint(prettyPrint);
                        }

                        public SetSize setQuotaUser(String quotaUser) {
                            return (SetSize)super.setQuotaUser(quotaUser);
                        }

                        public SetSize setUploadType(String uploadType) {
                            return (SetSize)super.setUploadType(uploadType);
                        }

                        public SetSize setUploadProtocol(String uploadProtocol) {
                            return (SetSize)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public SetSize setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public SetSize setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public SetSize setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public SetSize setNodePoolId(String nodePoolId) {
                            this.nodePoolId = nodePoolId;
                            return this;
                        }

                        @Override
                        public SetSize set(String parameterName, Object value) {
                            return (SetSize)super.set(parameterName, value);
                        }
                    }

                    public class SetManagement
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setManagement";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected SetManagement(String projectId, String zone, String clusterId, String nodePoolId, SetNodePoolManagementRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)nodePoolId, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public SetManagement set$Xgafv(String $Xgafv) {
                            return (SetManagement)super.set$Xgafv($Xgafv);
                        }

                        public SetManagement setAccessToken(String accessToken) {
                            return (SetManagement)super.setAccessToken(accessToken);
                        }

                        public SetManagement setAlt(String alt) {
                            return (SetManagement)super.setAlt(alt);
                        }

                        public SetManagement setCallback(String callback) {
                            return (SetManagement)super.setCallback(callback);
                        }

                        public SetManagement setFields(String fields) {
                            return (SetManagement)super.setFields(fields);
                        }

                        public SetManagement setKey(String key) {
                            return (SetManagement)super.setKey(key);
                        }

                        public SetManagement setOauthToken(String oauthToken) {
                            return (SetManagement)super.setOauthToken(oauthToken);
                        }

                        public SetManagement setPrettyPrint(Boolean prettyPrint) {
                            return (SetManagement)super.setPrettyPrint(prettyPrint);
                        }

                        public SetManagement setQuotaUser(String quotaUser) {
                            return (SetManagement)super.setQuotaUser(quotaUser);
                        }

                        public SetManagement setUploadType(String uploadType) {
                            return (SetManagement)super.setUploadType(uploadType);
                        }

                        public SetManagement setUploadProtocol(String uploadProtocol) {
                            return (SetManagement)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public SetManagement setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public SetManagement setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public SetManagement setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public SetManagement setNodePoolId(String nodePoolId) {
                            this.nodePoolId = nodePoolId;
                            return this;
                        }

                        @Override
                        public SetManagement set(String parameterName, Object value) {
                            return (SetManagement)super.set(parameterName, value);
                        }
                    }

                    public class Rollback
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}:rollback";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected Rollback(String projectId, String zone, String clusterId, String nodePoolId, RollbackNodePoolUpgradeRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)nodePoolId, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public Rollback set$Xgafv(String $Xgafv) {
                            return (Rollback)super.set$Xgafv($Xgafv);
                        }

                        public Rollback setAccessToken(String accessToken) {
                            return (Rollback)super.setAccessToken(accessToken);
                        }

                        public Rollback setAlt(String alt) {
                            return (Rollback)super.setAlt(alt);
                        }

                        public Rollback setCallback(String callback) {
                            return (Rollback)super.setCallback(callback);
                        }

                        public Rollback setFields(String fields) {
                            return (Rollback)super.setFields(fields);
                        }

                        public Rollback setKey(String key) {
                            return (Rollback)super.setKey(key);
                        }

                        public Rollback setOauthToken(String oauthToken) {
                            return (Rollback)super.setOauthToken(oauthToken);
                        }

                        public Rollback setPrettyPrint(Boolean prettyPrint) {
                            return (Rollback)super.setPrettyPrint(prettyPrint);
                        }

                        public Rollback setQuotaUser(String quotaUser) {
                            return (Rollback)super.setQuotaUser(quotaUser);
                        }

                        public Rollback setUploadType(String uploadType) {
                            return (Rollback)super.setUploadType(uploadType);
                        }

                        public Rollback setUploadProtocol(String uploadProtocol) {
                            return (Rollback)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Rollback setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Rollback setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Rollback setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Rollback setNodePoolId(String nodePoolId) {
                            this.nodePoolId = nodePoolId;
                            return this;
                        }

                        @Override
                        public Rollback set(String parameterName, Object value) {
                            return (Rollback)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends ContainerRequest<ListNodePoolsResponse> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String parent;

                        protected List(String projectId, String zone, String clusterId) {
                            super(Container.this, "GET", REST_PATH, null, ListNodePoolsResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public List setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public List setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public List setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends ContainerRequest<NodePool> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;
                        @Key
                        private String name;

                        protected Get(String projectId, String zone, String clusterId, String nodePoolId) {
                            super(Container.this, "GET", REST_PATH, null, NodePool.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)nodePoolId, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Get setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Get setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Get setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Get setNodePoolId(String nodePoolId) {
                            this.nodePoolId = nodePoolId;
                            return this;
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;
                        @Key
                        private String name;

                        protected Delete(String projectId, String zone, String clusterId, String nodePoolId) {
                            super(Container.this, "DELETE", REST_PATH, null, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)nodePoolId, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Delete setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Delete setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Delete setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Delete setNodePoolId(String nodePoolId) {
                            this.nodePoolId = nodePoolId;
                            return this;
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;

                        protected Create(String projectId, String zone, String clusterId, CreateNodePoolRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Create setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Create setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Create setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }

                    public class Autoscaling
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/autoscaling";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected Autoscaling(String projectId, String zone, String clusterId, String nodePoolId, SetNodePoolAutoscalingRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)nodePoolId, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public Autoscaling set$Xgafv(String $Xgafv) {
                            return (Autoscaling)super.set$Xgafv($Xgafv);
                        }

                        public Autoscaling setAccessToken(String accessToken) {
                            return (Autoscaling)super.setAccessToken(accessToken);
                        }

                        public Autoscaling setAlt(String alt) {
                            return (Autoscaling)super.setAlt(alt);
                        }

                        public Autoscaling setCallback(String callback) {
                            return (Autoscaling)super.setCallback(callback);
                        }

                        public Autoscaling setFields(String fields) {
                            return (Autoscaling)super.setFields(fields);
                        }

                        public Autoscaling setKey(String key) {
                            return (Autoscaling)super.setKey(key);
                        }

                        public Autoscaling setOauthToken(String oauthToken) {
                            return (Autoscaling)super.setOauthToken(oauthToken);
                        }

                        public Autoscaling setPrettyPrint(Boolean prettyPrint) {
                            return (Autoscaling)super.setPrettyPrint(prettyPrint);
                        }

                        public Autoscaling setQuotaUser(String quotaUser) {
                            return (Autoscaling)super.setQuotaUser(quotaUser);
                        }

                        public Autoscaling setUploadType(String uploadType) {
                            return (Autoscaling)super.setUploadType(uploadType);
                        }

                        public Autoscaling setUploadProtocol(String uploadProtocol) {
                            return (Autoscaling)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Autoscaling setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Autoscaling setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Autoscaling setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Autoscaling setNodePoolId(String nodePoolId) {
                            this.nodePoolId = nodePoolId;
                            return this;
                        }

                        @Override
                        public Autoscaling set(String parameterName, Object value) {
                            return (Autoscaling)super.set(parameterName, value);
                        }
                    }
                }

                public class Update
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Update(String projectId, String zone, String clusterId, UpdateClusterRequest content) {
                        super(Container.this, "PUT", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Update set$Xgafv(String $Xgafv) {
                        return (Update)super.set$Xgafv($Xgafv);
                    }

                    public Update setAccessToken(String accessToken) {
                        return (Update)super.setAccessToken(accessToken);
                    }

                    public Update setAlt(String alt) {
                        return (Update)super.setAlt(alt);
                    }

                    public Update setCallback(String callback) {
                        return (Update)super.setCallback(callback);
                    }

                    public Update setFields(String fields) {
                        return (Update)super.setFields(fields);
                    }

                    public Update setKey(String key) {
                        return (Update)super.setKey(key);
                    }

                    public Update setOauthToken(String oauthToken) {
                        return (Update)super.setOauthToken(oauthToken);
                    }

                    public Update setPrettyPrint(Boolean prettyPrint) {
                        return (Update)super.setPrettyPrint(prettyPrint);
                    }

                    public Update setQuotaUser(String quotaUser) {
                        return (Update)super.setQuotaUser(quotaUser);
                    }

                    public Update setUploadType(String uploadType) {
                        return (Update)super.setUploadType(uploadType);
                    }

                    public Update setUploadProtocol(String uploadProtocol) {
                        return (Update)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Update setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Update setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Update setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public Update set(String parameterName, Object value) {
                        return (Update)super.set(parameterName, value);
                    }
                }

                public class StartIpRotation
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:startIpRotation";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected StartIpRotation(String projectId, String zone, String clusterId, StartIPRotationRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public StartIpRotation set$Xgafv(String $Xgafv) {
                        return (StartIpRotation)super.set$Xgafv($Xgafv);
                    }

                    public StartIpRotation setAccessToken(String accessToken) {
                        return (StartIpRotation)super.setAccessToken(accessToken);
                    }

                    public StartIpRotation setAlt(String alt) {
                        return (StartIpRotation)super.setAlt(alt);
                    }

                    public StartIpRotation setCallback(String callback) {
                        return (StartIpRotation)super.setCallback(callback);
                    }

                    public StartIpRotation setFields(String fields) {
                        return (StartIpRotation)super.setFields(fields);
                    }

                    public StartIpRotation setKey(String key) {
                        return (StartIpRotation)super.setKey(key);
                    }

                    public StartIpRotation setOauthToken(String oauthToken) {
                        return (StartIpRotation)super.setOauthToken(oauthToken);
                    }

                    public StartIpRotation setPrettyPrint(Boolean prettyPrint) {
                        return (StartIpRotation)super.setPrettyPrint(prettyPrint);
                    }

                    public StartIpRotation setQuotaUser(String quotaUser) {
                        return (StartIpRotation)super.setQuotaUser(quotaUser);
                    }

                    public StartIpRotation setUploadType(String uploadType) {
                        return (StartIpRotation)super.setUploadType(uploadType);
                    }

                    public StartIpRotation setUploadProtocol(String uploadProtocol) {
                        return (StartIpRotation)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public StartIpRotation setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public StartIpRotation setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public StartIpRotation setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public StartIpRotation set(String parameterName, Object value) {
                        return (StartIpRotation)super.set(parameterName, value);
                    }
                }

                public class SetNetworkPolicy
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setNetworkPolicy";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected SetNetworkPolicy(String projectId, String zone, String clusterId, SetNetworkPolicyRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public SetNetworkPolicy set$Xgafv(String $Xgafv) {
                        return (SetNetworkPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetNetworkPolicy setAccessToken(String accessToken) {
                        return (SetNetworkPolicy)super.setAccessToken(accessToken);
                    }

                    public SetNetworkPolicy setAlt(String alt) {
                        return (SetNetworkPolicy)super.setAlt(alt);
                    }

                    public SetNetworkPolicy setCallback(String callback) {
                        return (SetNetworkPolicy)super.setCallback(callback);
                    }

                    public SetNetworkPolicy setFields(String fields) {
                        return (SetNetworkPolicy)super.setFields(fields);
                    }

                    public SetNetworkPolicy setKey(String key) {
                        return (SetNetworkPolicy)super.setKey(key);
                    }

                    public SetNetworkPolicy setOauthToken(String oauthToken) {
                        return (SetNetworkPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetNetworkPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetNetworkPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetNetworkPolicy setQuotaUser(String quotaUser) {
                        return (SetNetworkPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetNetworkPolicy setUploadType(String uploadType) {
                        return (SetNetworkPolicy)super.setUploadType(uploadType);
                    }

                    public SetNetworkPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetNetworkPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public SetNetworkPolicy setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public SetNetworkPolicy setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public SetNetworkPolicy setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public SetNetworkPolicy set(String parameterName, Object value) {
                        return (SetNetworkPolicy)super.set(parameterName, value);
                    }
                }

                public class SetMasterAuth
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMasterAuth";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected SetMasterAuth(String projectId, String zone, String clusterId, SetMasterAuthRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public SetMasterAuth set$Xgafv(String $Xgafv) {
                        return (SetMasterAuth)super.set$Xgafv($Xgafv);
                    }

                    public SetMasterAuth setAccessToken(String accessToken) {
                        return (SetMasterAuth)super.setAccessToken(accessToken);
                    }

                    public SetMasterAuth setAlt(String alt) {
                        return (SetMasterAuth)super.setAlt(alt);
                    }

                    public SetMasterAuth setCallback(String callback) {
                        return (SetMasterAuth)super.setCallback(callback);
                    }

                    public SetMasterAuth setFields(String fields) {
                        return (SetMasterAuth)super.setFields(fields);
                    }

                    public SetMasterAuth setKey(String key) {
                        return (SetMasterAuth)super.setKey(key);
                    }

                    public SetMasterAuth setOauthToken(String oauthToken) {
                        return (SetMasterAuth)super.setOauthToken(oauthToken);
                    }

                    public SetMasterAuth setPrettyPrint(Boolean prettyPrint) {
                        return (SetMasterAuth)super.setPrettyPrint(prettyPrint);
                    }

                    public SetMasterAuth setQuotaUser(String quotaUser) {
                        return (SetMasterAuth)super.setQuotaUser(quotaUser);
                    }

                    public SetMasterAuth setUploadType(String uploadType) {
                        return (SetMasterAuth)super.setUploadType(uploadType);
                    }

                    public SetMasterAuth setUploadProtocol(String uploadProtocol) {
                        return (SetMasterAuth)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public SetMasterAuth setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public SetMasterAuth setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public SetMasterAuth setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public SetMasterAuth set(String parameterName, Object value) {
                        return (SetMasterAuth)super.set(parameterName, value);
                    }
                }

                public class SetMaintenancePolicy
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMaintenancePolicy";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected SetMaintenancePolicy(String projectId, String zone, String clusterId, SetMaintenancePolicyRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public SetMaintenancePolicy set$Xgafv(String $Xgafv) {
                        return (SetMaintenancePolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetMaintenancePolicy setAccessToken(String accessToken) {
                        return (SetMaintenancePolicy)super.setAccessToken(accessToken);
                    }

                    public SetMaintenancePolicy setAlt(String alt) {
                        return (SetMaintenancePolicy)super.setAlt(alt);
                    }

                    public SetMaintenancePolicy setCallback(String callback) {
                        return (SetMaintenancePolicy)super.setCallback(callback);
                    }

                    public SetMaintenancePolicy setFields(String fields) {
                        return (SetMaintenancePolicy)super.setFields(fields);
                    }

                    public SetMaintenancePolicy setKey(String key) {
                        return (SetMaintenancePolicy)super.setKey(key);
                    }

                    public SetMaintenancePolicy setOauthToken(String oauthToken) {
                        return (SetMaintenancePolicy)super.setOauthToken(oauthToken);
                    }

                    public SetMaintenancePolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetMaintenancePolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetMaintenancePolicy setQuotaUser(String quotaUser) {
                        return (SetMaintenancePolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetMaintenancePolicy setUploadType(String uploadType) {
                        return (SetMaintenancePolicy)super.setUploadType(uploadType);
                    }

                    public SetMaintenancePolicy setUploadProtocol(String uploadProtocol) {
                        return (SetMaintenancePolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public SetMaintenancePolicy setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public SetMaintenancePolicy setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public SetMaintenancePolicy setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public SetMaintenancePolicy set(String parameterName, Object value) {
                        return (SetMaintenancePolicy)super.set(parameterName, value);
                    }
                }

                public class ResourceLabels
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/resourceLabels";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected ResourceLabels(String projectId, String zone, String clusterId, SetLabelsRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public ResourceLabels set$Xgafv(String $Xgafv) {
                        return (ResourceLabels)super.set$Xgafv($Xgafv);
                    }

                    public ResourceLabels setAccessToken(String accessToken) {
                        return (ResourceLabels)super.setAccessToken(accessToken);
                    }

                    public ResourceLabels setAlt(String alt) {
                        return (ResourceLabels)super.setAlt(alt);
                    }

                    public ResourceLabels setCallback(String callback) {
                        return (ResourceLabels)super.setCallback(callback);
                    }

                    public ResourceLabels setFields(String fields) {
                        return (ResourceLabels)super.setFields(fields);
                    }

                    public ResourceLabels setKey(String key) {
                        return (ResourceLabels)super.setKey(key);
                    }

                    public ResourceLabels setOauthToken(String oauthToken) {
                        return (ResourceLabels)super.setOauthToken(oauthToken);
                    }

                    public ResourceLabels setPrettyPrint(Boolean prettyPrint) {
                        return (ResourceLabels)super.setPrettyPrint(prettyPrint);
                    }

                    public ResourceLabels setQuotaUser(String quotaUser) {
                        return (ResourceLabels)super.setQuotaUser(quotaUser);
                    }

                    public ResourceLabels setUploadType(String uploadType) {
                        return (ResourceLabels)super.setUploadType(uploadType);
                    }

                    public ResourceLabels setUploadProtocol(String uploadProtocol) {
                        return (ResourceLabels)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public ResourceLabels setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public ResourceLabels setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public ResourceLabels setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public ResourceLabels set(String parameterName, Object value) {
                        return (ResourceLabels)super.set(parameterName, value);
                    }
                }

                public class Monitoring
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/monitoring";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Monitoring(String projectId, String zone, String clusterId, SetMonitoringServiceRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Monitoring set$Xgafv(String $Xgafv) {
                        return (Monitoring)super.set$Xgafv($Xgafv);
                    }

                    public Monitoring setAccessToken(String accessToken) {
                        return (Monitoring)super.setAccessToken(accessToken);
                    }

                    public Monitoring setAlt(String alt) {
                        return (Monitoring)super.setAlt(alt);
                    }

                    public Monitoring setCallback(String callback) {
                        return (Monitoring)super.setCallback(callback);
                    }

                    public Monitoring setFields(String fields) {
                        return (Monitoring)super.setFields(fields);
                    }

                    public Monitoring setKey(String key) {
                        return (Monitoring)super.setKey(key);
                    }

                    public Monitoring setOauthToken(String oauthToken) {
                        return (Monitoring)super.setOauthToken(oauthToken);
                    }

                    public Monitoring setPrettyPrint(Boolean prettyPrint) {
                        return (Monitoring)super.setPrettyPrint(prettyPrint);
                    }

                    public Monitoring setQuotaUser(String quotaUser) {
                        return (Monitoring)super.setQuotaUser(quotaUser);
                    }

                    public Monitoring setUploadType(String uploadType) {
                        return (Monitoring)super.setUploadType(uploadType);
                    }

                    public Monitoring setUploadProtocol(String uploadProtocol) {
                        return (Monitoring)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Monitoring setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Monitoring setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Monitoring setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public Monitoring set(String parameterName, Object value) {
                        return (Monitoring)super.set(parameterName, value);
                    }
                }

                public class Master
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/master";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Master(String projectId, String zone, String clusterId, UpdateMasterRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Master set$Xgafv(String $Xgafv) {
                        return (Master)super.set$Xgafv($Xgafv);
                    }

                    public Master setAccessToken(String accessToken) {
                        return (Master)super.setAccessToken(accessToken);
                    }

                    public Master setAlt(String alt) {
                        return (Master)super.setAlt(alt);
                    }

                    public Master setCallback(String callback) {
                        return (Master)super.setCallback(callback);
                    }

                    public Master setFields(String fields) {
                        return (Master)super.setFields(fields);
                    }

                    public Master setKey(String key) {
                        return (Master)super.setKey(key);
                    }

                    public Master setOauthToken(String oauthToken) {
                        return (Master)super.setOauthToken(oauthToken);
                    }

                    public Master setPrettyPrint(Boolean prettyPrint) {
                        return (Master)super.setPrettyPrint(prettyPrint);
                    }

                    public Master setQuotaUser(String quotaUser) {
                        return (Master)super.setQuotaUser(quotaUser);
                    }

                    public Master setUploadType(String uploadType) {
                        return (Master)super.setUploadType(uploadType);
                    }

                    public Master setUploadProtocol(String uploadProtocol) {
                        return (Master)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Master setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Master setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Master setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public Master set(String parameterName, Object value) {
                        return (Master)super.set(parameterName, value);
                    }
                }

                public class Logging
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/logging";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Logging(String projectId, String zone, String clusterId, SetLoggingServiceRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Logging set$Xgafv(String $Xgafv) {
                        return (Logging)super.set$Xgafv($Xgafv);
                    }

                    public Logging setAccessToken(String accessToken) {
                        return (Logging)super.setAccessToken(accessToken);
                    }

                    public Logging setAlt(String alt) {
                        return (Logging)super.setAlt(alt);
                    }

                    public Logging setCallback(String callback) {
                        return (Logging)super.setCallback(callback);
                    }

                    public Logging setFields(String fields) {
                        return (Logging)super.setFields(fields);
                    }

                    public Logging setKey(String key) {
                        return (Logging)super.setKey(key);
                    }

                    public Logging setOauthToken(String oauthToken) {
                        return (Logging)super.setOauthToken(oauthToken);
                    }

                    public Logging setPrettyPrint(Boolean prettyPrint) {
                        return (Logging)super.setPrettyPrint(prettyPrint);
                    }

                    public Logging setQuotaUser(String quotaUser) {
                        return (Logging)super.setQuotaUser(quotaUser);
                    }

                    public Logging setUploadType(String uploadType) {
                        return (Logging)super.setUploadType(uploadType);
                    }

                    public Logging setUploadProtocol(String uploadProtocol) {
                        return (Logging)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Logging setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Logging setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Logging setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public Logging set(String parameterName, Object value) {
                        return (Logging)super.set(parameterName, value);
                    }
                }

                public class Locations
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/locations";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Locations(String projectId, String zone, String clusterId, SetLocationsRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Locations set$Xgafv(String $Xgafv) {
                        return (Locations)super.set$Xgafv($Xgafv);
                    }

                    public Locations setAccessToken(String accessToken) {
                        return (Locations)super.setAccessToken(accessToken);
                    }

                    public Locations setAlt(String alt) {
                        return (Locations)super.setAlt(alt);
                    }

                    public Locations setCallback(String callback) {
                        return (Locations)super.setCallback(callback);
                    }

                    public Locations setFields(String fields) {
                        return (Locations)super.setFields(fields);
                    }

                    public Locations setKey(String key) {
                        return (Locations)super.setKey(key);
                    }

                    public Locations setOauthToken(String oauthToken) {
                        return (Locations)super.setOauthToken(oauthToken);
                    }

                    public Locations setPrettyPrint(Boolean prettyPrint) {
                        return (Locations)super.setPrettyPrint(prettyPrint);
                    }

                    public Locations setQuotaUser(String quotaUser) {
                        return (Locations)super.setQuotaUser(quotaUser);
                    }

                    public Locations setUploadType(String uploadType) {
                        return (Locations)super.setUploadType(uploadType);
                    }

                    public Locations setUploadProtocol(String uploadProtocol) {
                        return (Locations)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Locations setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Locations setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Locations setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public Locations set(String parameterName, Object value) {
                        return (Locations)super.set(parameterName, value);
                    }
                }

                public class List
                extends ContainerRequest<ListClustersResponse> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String parent;

                    protected List(String projectId, String zone) {
                        super(Container.this, "GET", REST_PATH, null, ListClustersResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public List setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class LegacyAbac
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/legacyAbac";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected LegacyAbac(String projectId, String zone, String clusterId, SetLegacyAbacRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public LegacyAbac set$Xgafv(String $Xgafv) {
                        return (LegacyAbac)super.set$Xgafv($Xgafv);
                    }

                    public LegacyAbac setAccessToken(String accessToken) {
                        return (LegacyAbac)super.setAccessToken(accessToken);
                    }

                    public LegacyAbac setAlt(String alt) {
                        return (LegacyAbac)super.setAlt(alt);
                    }

                    public LegacyAbac setCallback(String callback) {
                        return (LegacyAbac)super.setCallback(callback);
                    }

                    public LegacyAbac setFields(String fields) {
                        return (LegacyAbac)super.setFields(fields);
                    }

                    public LegacyAbac setKey(String key) {
                        return (LegacyAbac)super.setKey(key);
                    }

                    public LegacyAbac setOauthToken(String oauthToken) {
                        return (LegacyAbac)super.setOauthToken(oauthToken);
                    }

                    public LegacyAbac setPrettyPrint(Boolean prettyPrint) {
                        return (LegacyAbac)super.setPrettyPrint(prettyPrint);
                    }

                    public LegacyAbac setQuotaUser(String quotaUser) {
                        return (LegacyAbac)super.setQuotaUser(quotaUser);
                    }

                    public LegacyAbac setUploadType(String uploadType) {
                        return (LegacyAbac)super.setUploadType(uploadType);
                    }

                    public LegacyAbac setUploadProtocol(String uploadProtocol) {
                        return (LegacyAbac)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public LegacyAbac setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public LegacyAbac setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public LegacyAbac setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public LegacyAbac set(String parameterName, Object value) {
                        return (LegacyAbac)super.set(parameterName, value);
                    }
                }

                public class Get
                extends ContainerRequest<Cluster> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;
                    @Key
                    private String name;

                    protected Get(String projectId, String zone, String clusterId) {
                        super(Container.this, "GET", REST_PATH, null, Cluster.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Get setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Get setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;
                    @Key
                    private String name;

                    protected Delete(String projectId, String zone, String clusterId) {
                        super(Container.this, "DELETE", REST_PATH, null, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Delete setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Delete setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected Create(String projectId, String zone, CreateClusterRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Create setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class CompleteIpRotation
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:completeIpRotation";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected CompleteIpRotation(String projectId, String zone, String clusterId, CompleteIPRotationRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public CompleteIpRotation set$Xgafv(String $Xgafv) {
                        return (CompleteIpRotation)super.set$Xgafv($Xgafv);
                    }

                    public CompleteIpRotation setAccessToken(String accessToken) {
                        return (CompleteIpRotation)super.setAccessToken(accessToken);
                    }

                    public CompleteIpRotation setAlt(String alt) {
                        return (CompleteIpRotation)super.setAlt(alt);
                    }

                    public CompleteIpRotation setCallback(String callback) {
                        return (CompleteIpRotation)super.setCallback(callback);
                    }

                    public CompleteIpRotation setFields(String fields) {
                        return (CompleteIpRotation)super.setFields(fields);
                    }

                    public CompleteIpRotation setKey(String key) {
                        return (CompleteIpRotation)super.setKey(key);
                    }

                    public CompleteIpRotation setOauthToken(String oauthToken) {
                        return (CompleteIpRotation)super.setOauthToken(oauthToken);
                    }

                    public CompleteIpRotation setPrettyPrint(Boolean prettyPrint) {
                        return (CompleteIpRotation)super.setPrettyPrint(prettyPrint);
                    }

                    public CompleteIpRotation setQuotaUser(String quotaUser) {
                        return (CompleteIpRotation)super.setQuotaUser(quotaUser);
                    }

                    public CompleteIpRotation setUploadType(String uploadType) {
                        return (CompleteIpRotation)super.setUploadType(uploadType);
                    }

                    public CompleteIpRotation setUploadProtocol(String uploadProtocol) {
                        return (CompleteIpRotation)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public CompleteIpRotation setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public CompleteIpRotation setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public CompleteIpRotation setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public CompleteIpRotation set(String parameterName, Object value) {
                        return (CompleteIpRotation)super.set(parameterName, value);
                    }
                }

                public class Addons
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/addons";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Addons(String projectId, String zone, String clusterId, SetAddonsConfigRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Addons set$Xgafv(String $Xgafv) {
                        return (Addons)super.set$Xgafv($Xgafv);
                    }

                    public Addons setAccessToken(String accessToken) {
                        return (Addons)super.setAccessToken(accessToken);
                    }

                    public Addons setAlt(String alt) {
                        return (Addons)super.setAlt(alt);
                    }

                    public Addons setCallback(String callback) {
                        return (Addons)super.setCallback(callback);
                    }

                    public Addons setFields(String fields) {
                        return (Addons)super.setFields(fields);
                    }

                    public Addons setKey(String key) {
                        return (Addons)super.setKey(key);
                    }

                    public Addons setOauthToken(String oauthToken) {
                        return (Addons)super.setOauthToken(oauthToken);
                    }

                    public Addons setPrettyPrint(Boolean prettyPrint) {
                        return (Addons)super.setPrettyPrint(prettyPrint);
                    }

                    public Addons setQuotaUser(String quotaUser) {
                        return (Addons)super.setQuotaUser(quotaUser);
                    }

                    public Addons setUploadType(String uploadType) {
                        return (Addons)super.setUploadType(uploadType);
                    }

                    public Addons setUploadProtocol(String uploadProtocol) {
                        return (Addons)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Addons setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Addons setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Addons setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public Addons set(String parameterName, Object value) {
                        return (Addons)super.set(parameterName, value);
                    }
                }
            }

            public class GetServerconfig
            extends ContainerRequest<ServerConfig> {
                private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/serverconfig";
                @Key
                private String projectId;
                @Key
                private String zone;
                @Key
                private String name;

                protected GetServerconfig(String projectId, String zone) {
                    super(Container.this, "GET", REST_PATH, null, ServerConfig.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetServerconfig set$Xgafv(String $Xgafv) {
                    return (GetServerconfig)super.set$Xgafv($Xgafv);
                }

                public GetServerconfig setAccessToken(String accessToken) {
                    return (GetServerconfig)super.setAccessToken(accessToken);
                }

                public GetServerconfig setAlt(String alt) {
                    return (GetServerconfig)super.setAlt(alt);
                }

                public GetServerconfig setCallback(String callback) {
                    return (GetServerconfig)super.setCallback(callback);
                }

                public GetServerconfig setFields(String fields) {
                    return (GetServerconfig)super.setFields(fields);
                }

                public GetServerconfig setKey(String key) {
                    return (GetServerconfig)super.setKey(key);
                }

                public GetServerconfig setOauthToken(String oauthToken) {
                    return (GetServerconfig)super.setOauthToken(oauthToken);
                }

                public GetServerconfig setPrettyPrint(Boolean prettyPrint) {
                    return (GetServerconfig)super.setPrettyPrint(prettyPrint);
                }

                public GetServerconfig setQuotaUser(String quotaUser) {
                    return (GetServerconfig)super.setQuotaUser(quotaUser);
                }

                public GetServerconfig setUploadType(String uploadType) {
                    return (GetServerconfig)super.setUploadType(uploadType);
                }

                public GetServerconfig setUploadProtocol(String uploadProtocol) {
                    return (GetServerconfig)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public GetServerconfig setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getZone() {
                    return this.zone;
                }

                public GetServerconfig setZone(String zone) {
                    this.zone = zone;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public GetServerconfig setName(String name) {
                    this.name = name;
                    return this;
                }

                @Override
                public GetServerconfig set(String parameterName, Object value) {
                    return (GetServerconfig)super.set(parameterName, value);
                }
            }
        }

        public class Locations {
            public GetServerConfig getServerConfig(String name) throws IOException {
                GetServerConfig result = new GetServerConfig(name);
                Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Clusters clusters() {
                return new Clusters();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends ContainerRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/operations";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected List(String parent) {
                        super(Container.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public List setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String operationId;
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected Get(String name) {
                        super(Container.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getOperationId() {
                        return this.operationId;
                    }

                    public Get setOperationId(String operationId) {
                        this.operationId = operationId;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Get setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends ContainerRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Clusters {
                public CompleteIpRotation completeIpRotation(String name, CompleteIPRotationRequest content) throws IOException {
                    CompleteIpRotation result = new CompleteIpRotation(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(String parent, CreateClusterRequest content) throws IOException {
                    Create result = new Create(parent, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetJwks getJwks(String parent) throws IOException {
                    GetJwks result = new GetJwks(parent);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetAddons setAddons(String name, SetAddonsConfigRequest content) throws IOException {
                    SetAddons result = new SetAddons(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetLegacyAbac setLegacyAbac(String name, SetLegacyAbacRequest content) throws IOException {
                    SetLegacyAbac result = new SetLegacyAbac(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetLocations setLocations(String name, SetLocationsRequest content) throws IOException {
                    SetLocations result = new SetLocations(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetLogging setLogging(String name, SetLoggingServiceRequest content) throws IOException {
                    SetLogging result = new SetLogging(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetMaintenancePolicy setMaintenancePolicy(String name, SetMaintenancePolicyRequest content) throws IOException {
                    SetMaintenancePolicy result = new SetMaintenancePolicy(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetMasterAuth setMasterAuth(String name, SetMasterAuthRequest content) throws IOException {
                    SetMasterAuth result = new SetMasterAuth(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetMonitoring setMonitoring(String name, SetMonitoringServiceRequest content) throws IOException {
                    SetMonitoring result = new SetMonitoring(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetNetworkPolicy setNetworkPolicy(String name, SetNetworkPolicyRequest content) throws IOException {
                    SetNetworkPolicy result = new SetNetworkPolicy(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetResourceLabels setResourceLabels(String name, SetLabelsRequest content) throws IOException {
                    SetResourceLabels result = new SetResourceLabels(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public StartIpRotation startIpRotation(String name, StartIPRotationRequest content) throws IOException {
                    StartIpRotation result = new StartIpRotation(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Update update(String name, UpdateClusterRequest content) throws IOException {
                    Update result = new Update(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public UpdateMaster updateMaster(String name, UpdateMasterRequest content) throws IOException {
                    UpdateMaster result = new UpdateMaster(name, content);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public NodePools nodePools() {
                    return new NodePools();
                }

                public WellKnown wellKnown() {
                    return new WellKnown();
                }

                public class WellKnown {
                    public GetOpenidConfiguration getOpenidConfiguration(String parent) throws IOException {
                        GetOpenidConfiguration result = new GetOpenidConfiguration(parent);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class GetOpenidConfiguration
                    extends ContainerRequest<GetOpenIDConfigResponse> {
                        private static final String REST_PATH = "v1/{+parent}/.well-known/openid-configuration";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected GetOpenidConfiguration(String parent) {
                            super(Container.this, "GET", REST_PATH, null, GetOpenIDConfigResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetOpenidConfiguration set$Xgafv(String $Xgafv) {
                            return (GetOpenidConfiguration)super.set$Xgafv($Xgafv);
                        }

                        public GetOpenidConfiguration setAccessToken(String accessToken) {
                            return (GetOpenidConfiguration)super.setAccessToken(accessToken);
                        }

                        public GetOpenidConfiguration setAlt(String alt) {
                            return (GetOpenidConfiguration)super.setAlt(alt);
                        }

                        public GetOpenidConfiguration setCallback(String callback) {
                            return (GetOpenidConfiguration)super.setCallback(callback);
                        }

                        public GetOpenidConfiguration setFields(String fields) {
                            return (GetOpenidConfiguration)super.setFields(fields);
                        }

                        public GetOpenidConfiguration setKey(String key) {
                            return (GetOpenidConfiguration)super.setKey(key);
                        }

                        public GetOpenidConfiguration setOauthToken(String oauthToken) {
                            return (GetOpenidConfiguration)super.setOauthToken(oauthToken);
                        }

                        public GetOpenidConfiguration setPrettyPrint(Boolean prettyPrint) {
                            return (GetOpenidConfiguration)super.setPrettyPrint(prettyPrint);
                        }

                        public GetOpenidConfiguration setQuotaUser(String quotaUser) {
                            return (GetOpenidConfiguration)super.setQuotaUser(quotaUser);
                        }

                        public GetOpenidConfiguration setUploadType(String uploadType) {
                            return (GetOpenidConfiguration)super.setUploadType(uploadType);
                        }

                        public GetOpenidConfiguration setUploadProtocol(String uploadProtocol) {
                            return (GetOpenidConfiguration)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public GetOpenidConfiguration setParent(String parent) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public GetOpenidConfiguration set(String parameterName, Object value) {
                            return (GetOpenidConfiguration)super.set(parameterName, value);
                        }
                    }
                }

                public class NodePools {
                    public Create create(String parent, CreateNodePoolRequest content) throws IOException {
                        Create result = new Create(parent, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Rollback rollback(String name, RollbackNodePoolUpgradeRequest content) throws IOException {
                        Rollback result = new Rollback(name, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetAutoscaling setAutoscaling(String name, SetNodePoolAutoscalingRequest content) throws IOException {
                        SetAutoscaling result = new SetAutoscaling(name, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetManagement setManagement(String name, SetNodePoolManagementRequest content) throws IOException {
                        SetManagement result = new SetManagement(name, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetSize setSize(String name, SetNodePoolSizeRequest content) throws IOException {
                        SetSize result = new SetSize(name, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Update update(String name, UpdateNodePoolRequest content) throws IOException {
                        Update result = new Update(name, content);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Update
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Update(String name, UpdateNodePoolRequest content) {
                            super(Container.this, "PUT", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public Update set$Xgafv(String $Xgafv) {
                            return (Update)super.set$Xgafv($Xgafv);
                        }

                        public Update setAccessToken(String accessToken) {
                            return (Update)super.setAccessToken(accessToken);
                        }

                        public Update setAlt(String alt) {
                            return (Update)super.setAlt(alt);
                        }

                        public Update setCallback(String callback) {
                            return (Update)super.setCallback(callback);
                        }

                        public Update setFields(String fields) {
                            return (Update)super.setFields(fields);
                        }

                        public Update setKey(String key) {
                            return (Update)super.setKey(key);
                        }

                        public Update setOauthToken(String oauthToken) {
                            return (Update)super.setOauthToken(oauthToken);
                        }

                        public Update setPrettyPrint(Boolean prettyPrint) {
                            return (Update)super.setPrettyPrint(prettyPrint);
                        }

                        public Update setQuotaUser(String quotaUser) {
                            return (Update)super.setQuotaUser(quotaUser);
                        }

                        public Update setUploadType(String uploadType) {
                            return (Update)super.setUploadType(uploadType);
                        }

                        public Update setUploadProtocol(String uploadProtocol) {
                            return (Update)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Update setName(String name) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Update set(String parameterName, Object value) {
                            return (Update)super.set(parameterName, value);
                        }
                    }

                    public class SetSize
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:setSize";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected SetSize(String name, SetNodePoolSizeRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public SetSize set$Xgafv(String $Xgafv) {
                            return (SetSize)super.set$Xgafv($Xgafv);
                        }

                        public SetSize setAccessToken(String accessToken) {
                            return (SetSize)super.setAccessToken(accessToken);
                        }

                        public SetSize setAlt(String alt) {
                            return (SetSize)super.setAlt(alt);
                        }

                        public SetSize setCallback(String callback) {
                            return (SetSize)super.setCallback(callback);
                        }

                        public SetSize setFields(String fields) {
                            return (SetSize)super.setFields(fields);
                        }

                        public SetSize setKey(String key) {
                            return (SetSize)super.setKey(key);
                        }

                        public SetSize setOauthToken(String oauthToken) {
                            return (SetSize)super.setOauthToken(oauthToken);
                        }

                        public SetSize setPrettyPrint(Boolean prettyPrint) {
                            return (SetSize)super.setPrettyPrint(prettyPrint);
                        }

                        public SetSize setQuotaUser(String quotaUser) {
                            return (SetSize)super.setQuotaUser(quotaUser);
                        }

                        public SetSize setUploadType(String uploadType) {
                            return (SetSize)super.setUploadType(uploadType);
                        }

                        public SetSize setUploadProtocol(String uploadProtocol) {
                            return (SetSize)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public SetSize setName(String name) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public SetSize set(String parameterName, Object value) {
                            return (SetSize)super.set(parameterName, value);
                        }
                    }

                    public class SetManagement
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:setManagement";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected SetManagement(String name, SetNodePoolManagementRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public SetManagement set$Xgafv(String $Xgafv) {
                            return (SetManagement)super.set$Xgafv($Xgafv);
                        }

                        public SetManagement setAccessToken(String accessToken) {
                            return (SetManagement)super.setAccessToken(accessToken);
                        }

                        public SetManagement setAlt(String alt) {
                            return (SetManagement)super.setAlt(alt);
                        }

                        public SetManagement setCallback(String callback) {
                            return (SetManagement)super.setCallback(callback);
                        }

                        public SetManagement setFields(String fields) {
                            return (SetManagement)super.setFields(fields);
                        }

                        public SetManagement setKey(String key) {
                            return (SetManagement)super.setKey(key);
                        }

                        public SetManagement setOauthToken(String oauthToken) {
                            return (SetManagement)super.setOauthToken(oauthToken);
                        }

                        public SetManagement setPrettyPrint(Boolean prettyPrint) {
                            return (SetManagement)super.setPrettyPrint(prettyPrint);
                        }

                        public SetManagement setQuotaUser(String quotaUser) {
                            return (SetManagement)super.setQuotaUser(quotaUser);
                        }

                        public SetManagement setUploadType(String uploadType) {
                            return (SetManagement)super.setUploadType(uploadType);
                        }

                        public SetManagement setUploadProtocol(String uploadProtocol) {
                            return (SetManagement)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public SetManagement setName(String name) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public SetManagement set(String parameterName, Object value) {
                            return (SetManagement)super.set(parameterName, value);
                        }
                    }

                    public class SetAutoscaling
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:setAutoscaling";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected SetAutoscaling(String name, SetNodePoolAutoscalingRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public SetAutoscaling set$Xgafv(String $Xgafv) {
                            return (SetAutoscaling)super.set$Xgafv($Xgafv);
                        }

                        public SetAutoscaling setAccessToken(String accessToken) {
                            return (SetAutoscaling)super.setAccessToken(accessToken);
                        }

                        public SetAutoscaling setAlt(String alt) {
                            return (SetAutoscaling)super.setAlt(alt);
                        }

                        public SetAutoscaling setCallback(String callback) {
                            return (SetAutoscaling)super.setCallback(callback);
                        }

                        public SetAutoscaling setFields(String fields) {
                            return (SetAutoscaling)super.setFields(fields);
                        }

                        public SetAutoscaling setKey(String key) {
                            return (SetAutoscaling)super.setKey(key);
                        }

                        public SetAutoscaling setOauthToken(String oauthToken) {
                            return (SetAutoscaling)super.setOauthToken(oauthToken);
                        }

                        public SetAutoscaling setPrettyPrint(Boolean prettyPrint) {
                            return (SetAutoscaling)super.setPrettyPrint(prettyPrint);
                        }

                        public SetAutoscaling setQuotaUser(String quotaUser) {
                            return (SetAutoscaling)super.setQuotaUser(quotaUser);
                        }

                        public SetAutoscaling setUploadType(String uploadType) {
                            return (SetAutoscaling)super.setUploadType(uploadType);
                        }

                        public SetAutoscaling setUploadProtocol(String uploadProtocol) {
                            return (SetAutoscaling)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public SetAutoscaling setName(String name) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public SetAutoscaling set(String parameterName, Object value) {
                            return (SetAutoscaling)super.set(parameterName, value);
                        }
                    }

                    public class Rollback
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:rollback";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Rollback(String name, RollbackNodePoolUpgradeRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public Rollback set$Xgafv(String $Xgafv) {
                            return (Rollback)super.set$Xgafv($Xgafv);
                        }

                        public Rollback setAccessToken(String accessToken) {
                            return (Rollback)super.setAccessToken(accessToken);
                        }

                        public Rollback setAlt(String alt) {
                            return (Rollback)super.setAlt(alt);
                        }

                        public Rollback setCallback(String callback) {
                            return (Rollback)super.setCallback(callback);
                        }

                        public Rollback setFields(String fields) {
                            return (Rollback)super.setFields(fields);
                        }

                        public Rollback setKey(String key) {
                            return (Rollback)super.setKey(key);
                        }

                        public Rollback setOauthToken(String oauthToken) {
                            return (Rollback)super.setOauthToken(oauthToken);
                        }

                        public Rollback setPrettyPrint(Boolean prettyPrint) {
                            return (Rollback)super.setPrettyPrint(prettyPrint);
                        }

                        public Rollback setQuotaUser(String quotaUser) {
                            return (Rollback)super.setQuotaUser(quotaUser);
                        }

                        public Rollback setUploadType(String uploadType) {
                            return (Rollback)super.setUploadType(uploadType);
                        }

                        public Rollback setUploadProtocol(String uploadProtocol) {
                            return (Rollback)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Rollback setName(String name) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Rollback set(String parameterName, Object value) {
                            return (Rollback)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends ContainerRequest<ListNodePoolsResponse> {
                        private static final String REST_PATH = "v1/{+parent}/nodePools";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String clusterId;
                        @Key
                        private String projectId;
                        @Key
                        private String zone;

                        protected List(String parent) {
                            super(Container.this, "GET", REST_PATH, null, ListNodePoolsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public List setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public List setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public List setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends ContainerRequest<NodePool> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;
                        @Key
                        private String projectId;
                        @Key
                        private String zone;

                        protected Get(String name) {
                            super(Container.this, "GET", REST_PATH, null, NodePool.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Get setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Get setNodePoolId(String nodePoolId) {
                            this.nodePoolId = nodePoolId;
                            return this;
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Get setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Get setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;
                        @Key
                        private String projectId;
                        @Key
                        private String zone;

                        protected Delete(String name) {
                            super(Container.this, "DELETE", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Delete setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Delete setNodePoolId(String nodePoolId) {
                            this.nodePoolId = nodePoolId;
                            return this;
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Delete setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Delete setZone(String zone) {
                            this.zone = zone;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+parent}/nodePools";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Create(String parent, CreateNodePoolRequest content) {
                            super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class UpdateMaster
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:updateMaster";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected UpdateMaster(String name, UpdateMasterRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public UpdateMaster set$Xgafv(String $Xgafv) {
                        return (UpdateMaster)super.set$Xgafv($Xgafv);
                    }

                    public UpdateMaster setAccessToken(String accessToken) {
                        return (UpdateMaster)super.setAccessToken(accessToken);
                    }

                    public UpdateMaster setAlt(String alt) {
                        return (UpdateMaster)super.setAlt(alt);
                    }

                    public UpdateMaster setCallback(String callback) {
                        return (UpdateMaster)super.setCallback(callback);
                    }

                    public UpdateMaster setFields(String fields) {
                        return (UpdateMaster)super.setFields(fields);
                    }

                    public UpdateMaster setKey(String key) {
                        return (UpdateMaster)super.setKey(key);
                    }

                    public UpdateMaster setOauthToken(String oauthToken) {
                        return (UpdateMaster)super.setOauthToken(oauthToken);
                    }

                    public UpdateMaster setPrettyPrint(Boolean prettyPrint) {
                        return (UpdateMaster)super.setPrettyPrint(prettyPrint);
                    }

                    public UpdateMaster setQuotaUser(String quotaUser) {
                        return (UpdateMaster)super.setQuotaUser(quotaUser);
                    }

                    public UpdateMaster setUploadType(String uploadType) {
                        return (UpdateMaster)super.setUploadType(uploadType);
                    }

                    public UpdateMaster setUploadProtocol(String uploadProtocol) {
                        return (UpdateMaster)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public UpdateMaster setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public UpdateMaster set(String parameterName, Object value) {
                        return (UpdateMaster)super.set(parameterName, value);
                    }
                }

                public class Update
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Update(String name, UpdateClusterRequest content) {
                        super(Container.this, "PUT", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public Update set$Xgafv(String $Xgafv) {
                        return (Update)super.set$Xgafv($Xgafv);
                    }

                    public Update setAccessToken(String accessToken) {
                        return (Update)super.setAccessToken(accessToken);
                    }

                    public Update setAlt(String alt) {
                        return (Update)super.setAlt(alt);
                    }

                    public Update setCallback(String callback) {
                        return (Update)super.setCallback(callback);
                    }

                    public Update setFields(String fields) {
                        return (Update)super.setFields(fields);
                    }

                    public Update setKey(String key) {
                        return (Update)super.setKey(key);
                    }

                    public Update setOauthToken(String oauthToken) {
                        return (Update)super.setOauthToken(oauthToken);
                    }

                    public Update setPrettyPrint(Boolean prettyPrint) {
                        return (Update)super.setPrettyPrint(prettyPrint);
                    }

                    public Update setQuotaUser(String quotaUser) {
                        return (Update)super.setQuotaUser(quotaUser);
                    }

                    public Update setUploadType(String uploadType) {
                        return (Update)super.setUploadType(uploadType);
                    }

                    public Update setUploadProtocol(String uploadProtocol) {
                        return (Update)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Update setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Update set(String parameterName, Object value) {
                        return (Update)super.set(parameterName, value);
                    }
                }

                public class StartIpRotation
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:startIpRotation";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected StartIpRotation(String name, StartIPRotationRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public StartIpRotation set$Xgafv(String $Xgafv) {
                        return (StartIpRotation)super.set$Xgafv($Xgafv);
                    }

                    public StartIpRotation setAccessToken(String accessToken) {
                        return (StartIpRotation)super.setAccessToken(accessToken);
                    }

                    public StartIpRotation setAlt(String alt) {
                        return (StartIpRotation)super.setAlt(alt);
                    }

                    public StartIpRotation setCallback(String callback) {
                        return (StartIpRotation)super.setCallback(callback);
                    }

                    public StartIpRotation setFields(String fields) {
                        return (StartIpRotation)super.setFields(fields);
                    }

                    public StartIpRotation setKey(String key) {
                        return (StartIpRotation)super.setKey(key);
                    }

                    public StartIpRotation setOauthToken(String oauthToken) {
                        return (StartIpRotation)super.setOauthToken(oauthToken);
                    }

                    public StartIpRotation setPrettyPrint(Boolean prettyPrint) {
                        return (StartIpRotation)super.setPrettyPrint(prettyPrint);
                    }

                    public StartIpRotation setQuotaUser(String quotaUser) {
                        return (StartIpRotation)super.setQuotaUser(quotaUser);
                    }

                    public StartIpRotation setUploadType(String uploadType) {
                        return (StartIpRotation)super.setUploadType(uploadType);
                    }

                    public StartIpRotation setUploadProtocol(String uploadProtocol) {
                        return (StartIpRotation)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public StartIpRotation setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public StartIpRotation set(String parameterName, Object value) {
                        return (StartIpRotation)super.set(parameterName, value);
                    }
                }

                public class SetResourceLabels
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setResourceLabels";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetResourceLabels(String name, SetLabelsRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetResourceLabels set$Xgafv(String $Xgafv) {
                        return (SetResourceLabels)super.set$Xgafv($Xgafv);
                    }

                    public SetResourceLabels setAccessToken(String accessToken) {
                        return (SetResourceLabels)super.setAccessToken(accessToken);
                    }

                    public SetResourceLabels setAlt(String alt) {
                        return (SetResourceLabels)super.setAlt(alt);
                    }

                    public SetResourceLabels setCallback(String callback) {
                        return (SetResourceLabels)super.setCallback(callback);
                    }

                    public SetResourceLabels setFields(String fields) {
                        return (SetResourceLabels)super.setFields(fields);
                    }

                    public SetResourceLabels setKey(String key) {
                        return (SetResourceLabels)super.setKey(key);
                    }

                    public SetResourceLabels setOauthToken(String oauthToken) {
                        return (SetResourceLabels)super.setOauthToken(oauthToken);
                    }

                    public SetResourceLabels setPrettyPrint(Boolean prettyPrint) {
                        return (SetResourceLabels)super.setPrettyPrint(prettyPrint);
                    }

                    public SetResourceLabels setQuotaUser(String quotaUser) {
                        return (SetResourceLabels)super.setQuotaUser(quotaUser);
                    }

                    public SetResourceLabels setUploadType(String uploadType) {
                        return (SetResourceLabels)super.setUploadType(uploadType);
                    }

                    public SetResourceLabels setUploadProtocol(String uploadProtocol) {
                        return (SetResourceLabels)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetResourceLabels setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public SetResourceLabels set(String parameterName, Object value) {
                        return (SetResourceLabels)super.set(parameterName, value);
                    }
                }

                public class SetNetworkPolicy
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setNetworkPolicy";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetNetworkPolicy(String name, SetNetworkPolicyRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetNetworkPolicy set$Xgafv(String $Xgafv) {
                        return (SetNetworkPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetNetworkPolicy setAccessToken(String accessToken) {
                        return (SetNetworkPolicy)super.setAccessToken(accessToken);
                    }

                    public SetNetworkPolicy setAlt(String alt) {
                        return (SetNetworkPolicy)super.setAlt(alt);
                    }

                    public SetNetworkPolicy setCallback(String callback) {
                        return (SetNetworkPolicy)super.setCallback(callback);
                    }

                    public SetNetworkPolicy setFields(String fields) {
                        return (SetNetworkPolicy)super.setFields(fields);
                    }

                    public SetNetworkPolicy setKey(String key) {
                        return (SetNetworkPolicy)super.setKey(key);
                    }

                    public SetNetworkPolicy setOauthToken(String oauthToken) {
                        return (SetNetworkPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetNetworkPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetNetworkPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetNetworkPolicy setQuotaUser(String quotaUser) {
                        return (SetNetworkPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetNetworkPolicy setUploadType(String uploadType) {
                        return (SetNetworkPolicy)super.setUploadType(uploadType);
                    }

                    public SetNetworkPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetNetworkPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetNetworkPolicy setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public SetNetworkPolicy set(String parameterName, Object value) {
                        return (SetNetworkPolicy)super.set(parameterName, value);
                    }
                }

                public class SetMonitoring
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setMonitoring";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetMonitoring(String name, SetMonitoringServiceRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetMonitoring set$Xgafv(String $Xgafv) {
                        return (SetMonitoring)super.set$Xgafv($Xgafv);
                    }

                    public SetMonitoring setAccessToken(String accessToken) {
                        return (SetMonitoring)super.setAccessToken(accessToken);
                    }

                    public SetMonitoring setAlt(String alt) {
                        return (SetMonitoring)super.setAlt(alt);
                    }

                    public SetMonitoring setCallback(String callback) {
                        return (SetMonitoring)super.setCallback(callback);
                    }

                    public SetMonitoring setFields(String fields) {
                        return (SetMonitoring)super.setFields(fields);
                    }

                    public SetMonitoring setKey(String key) {
                        return (SetMonitoring)super.setKey(key);
                    }

                    public SetMonitoring setOauthToken(String oauthToken) {
                        return (SetMonitoring)super.setOauthToken(oauthToken);
                    }

                    public SetMonitoring setPrettyPrint(Boolean prettyPrint) {
                        return (SetMonitoring)super.setPrettyPrint(prettyPrint);
                    }

                    public SetMonitoring setQuotaUser(String quotaUser) {
                        return (SetMonitoring)super.setQuotaUser(quotaUser);
                    }

                    public SetMonitoring setUploadType(String uploadType) {
                        return (SetMonitoring)super.setUploadType(uploadType);
                    }

                    public SetMonitoring setUploadProtocol(String uploadProtocol) {
                        return (SetMonitoring)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetMonitoring setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public SetMonitoring set(String parameterName, Object value) {
                        return (SetMonitoring)super.set(parameterName, value);
                    }
                }

                public class SetMasterAuth
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setMasterAuth";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetMasterAuth(String name, SetMasterAuthRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetMasterAuth set$Xgafv(String $Xgafv) {
                        return (SetMasterAuth)super.set$Xgafv($Xgafv);
                    }

                    public SetMasterAuth setAccessToken(String accessToken) {
                        return (SetMasterAuth)super.setAccessToken(accessToken);
                    }

                    public SetMasterAuth setAlt(String alt) {
                        return (SetMasterAuth)super.setAlt(alt);
                    }

                    public SetMasterAuth setCallback(String callback) {
                        return (SetMasterAuth)super.setCallback(callback);
                    }

                    public SetMasterAuth setFields(String fields) {
                        return (SetMasterAuth)super.setFields(fields);
                    }

                    public SetMasterAuth setKey(String key) {
                        return (SetMasterAuth)super.setKey(key);
                    }

                    public SetMasterAuth setOauthToken(String oauthToken) {
                        return (SetMasterAuth)super.setOauthToken(oauthToken);
                    }

                    public SetMasterAuth setPrettyPrint(Boolean prettyPrint) {
                        return (SetMasterAuth)super.setPrettyPrint(prettyPrint);
                    }

                    public SetMasterAuth setQuotaUser(String quotaUser) {
                        return (SetMasterAuth)super.setQuotaUser(quotaUser);
                    }

                    public SetMasterAuth setUploadType(String uploadType) {
                        return (SetMasterAuth)super.setUploadType(uploadType);
                    }

                    public SetMasterAuth setUploadProtocol(String uploadProtocol) {
                        return (SetMasterAuth)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetMasterAuth setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public SetMasterAuth set(String parameterName, Object value) {
                        return (SetMasterAuth)super.set(parameterName, value);
                    }
                }

                public class SetMaintenancePolicy
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setMaintenancePolicy";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetMaintenancePolicy(String name, SetMaintenancePolicyRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetMaintenancePolicy set$Xgafv(String $Xgafv) {
                        return (SetMaintenancePolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetMaintenancePolicy setAccessToken(String accessToken) {
                        return (SetMaintenancePolicy)super.setAccessToken(accessToken);
                    }

                    public SetMaintenancePolicy setAlt(String alt) {
                        return (SetMaintenancePolicy)super.setAlt(alt);
                    }

                    public SetMaintenancePolicy setCallback(String callback) {
                        return (SetMaintenancePolicy)super.setCallback(callback);
                    }

                    public SetMaintenancePolicy setFields(String fields) {
                        return (SetMaintenancePolicy)super.setFields(fields);
                    }

                    public SetMaintenancePolicy setKey(String key) {
                        return (SetMaintenancePolicy)super.setKey(key);
                    }

                    public SetMaintenancePolicy setOauthToken(String oauthToken) {
                        return (SetMaintenancePolicy)super.setOauthToken(oauthToken);
                    }

                    public SetMaintenancePolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetMaintenancePolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetMaintenancePolicy setQuotaUser(String quotaUser) {
                        return (SetMaintenancePolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetMaintenancePolicy setUploadType(String uploadType) {
                        return (SetMaintenancePolicy)super.setUploadType(uploadType);
                    }

                    public SetMaintenancePolicy setUploadProtocol(String uploadProtocol) {
                        return (SetMaintenancePolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetMaintenancePolicy setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public SetMaintenancePolicy set(String parameterName, Object value) {
                        return (SetMaintenancePolicy)super.set(parameterName, value);
                    }
                }

                public class SetLogging
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setLogging";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetLogging(String name, SetLoggingServiceRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetLogging set$Xgafv(String $Xgafv) {
                        return (SetLogging)super.set$Xgafv($Xgafv);
                    }

                    public SetLogging setAccessToken(String accessToken) {
                        return (SetLogging)super.setAccessToken(accessToken);
                    }

                    public SetLogging setAlt(String alt) {
                        return (SetLogging)super.setAlt(alt);
                    }

                    public SetLogging setCallback(String callback) {
                        return (SetLogging)super.setCallback(callback);
                    }

                    public SetLogging setFields(String fields) {
                        return (SetLogging)super.setFields(fields);
                    }

                    public SetLogging setKey(String key) {
                        return (SetLogging)super.setKey(key);
                    }

                    public SetLogging setOauthToken(String oauthToken) {
                        return (SetLogging)super.setOauthToken(oauthToken);
                    }

                    public SetLogging setPrettyPrint(Boolean prettyPrint) {
                        return (SetLogging)super.setPrettyPrint(prettyPrint);
                    }

                    public SetLogging setQuotaUser(String quotaUser) {
                        return (SetLogging)super.setQuotaUser(quotaUser);
                    }

                    public SetLogging setUploadType(String uploadType) {
                        return (SetLogging)super.setUploadType(uploadType);
                    }

                    public SetLogging setUploadProtocol(String uploadProtocol) {
                        return (SetLogging)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetLogging setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public SetLogging set(String parameterName, Object value) {
                        return (SetLogging)super.set(parameterName, value);
                    }
                }

                public class SetLocations
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setLocations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetLocations(String name, SetLocationsRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetLocations set$Xgafv(String $Xgafv) {
                        return (SetLocations)super.set$Xgafv($Xgafv);
                    }

                    public SetLocations setAccessToken(String accessToken) {
                        return (SetLocations)super.setAccessToken(accessToken);
                    }

                    public SetLocations setAlt(String alt) {
                        return (SetLocations)super.setAlt(alt);
                    }

                    public SetLocations setCallback(String callback) {
                        return (SetLocations)super.setCallback(callback);
                    }

                    public SetLocations setFields(String fields) {
                        return (SetLocations)super.setFields(fields);
                    }

                    public SetLocations setKey(String key) {
                        return (SetLocations)super.setKey(key);
                    }

                    public SetLocations setOauthToken(String oauthToken) {
                        return (SetLocations)super.setOauthToken(oauthToken);
                    }

                    public SetLocations setPrettyPrint(Boolean prettyPrint) {
                        return (SetLocations)super.setPrettyPrint(prettyPrint);
                    }

                    public SetLocations setQuotaUser(String quotaUser) {
                        return (SetLocations)super.setQuotaUser(quotaUser);
                    }

                    public SetLocations setUploadType(String uploadType) {
                        return (SetLocations)super.setUploadType(uploadType);
                    }

                    public SetLocations setUploadProtocol(String uploadProtocol) {
                        return (SetLocations)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetLocations setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public SetLocations set(String parameterName, Object value) {
                        return (SetLocations)super.set(parameterName, value);
                    }
                }

                public class SetLegacyAbac
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setLegacyAbac";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetLegacyAbac(String name, SetLegacyAbacRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetLegacyAbac set$Xgafv(String $Xgafv) {
                        return (SetLegacyAbac)super.set$Xgafv($Xgafv);
                    }

                    public SetLegacyAbac setAccessToken(String accessToken) {
                        return (SetLegacyAbac)super.setAccessToken(accessToken);
                    }

                    public SetLegacyAbac setAlt(String alt) {
                        return (SetLegacyAbac)super.setAlt(alt);
                    }

                    public SetLegacyAbac setCallback(String callback) {
                        return (SetLegacyAbac)super.setCallback(callback);
                    }

                    public SetLegacyAbac setFields(String fields) {
                        return (SetLegacyAbac)super.setFields(fields);
                    }

                    public SetLegacyAbac setKey(String key) {
                        return (SetLegacyAbac)super.setKey(key);
                    }

                    public SetLegacyAbac setOauthToken(String oauthToken) {
                        return (SetLegacyAbac)super.setOauthToken(oauthToken);
                    }

                    public SetLegacyAbac setPrettyPrint(Boolean prettyPrint) {
                        return (SetLegacyAbac)super.setPrettyPrint(prettyPrint);
                    }

                    public SetLegacyAbac setQuotaUser(String quotaUser) {
                        return (SetLegacyAbac)super.setQuotaUser(quotaUser);
                    }

                    public SetLegacyAbac setUploadType(String uploadType) {
                        return (SetLegacyAbac)super.setUploadType(uploadType);
                    }

                    public SetLegacyAbac setUploadProtocol(String uploadProtocol) {
                        return (SetLegacyAbac)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetLegacyAbac setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public SetLegacyAbac set(String parameterName, Object value) {
                        return (SetLegacyAbac)super.set(parameterName, value);
                    }
                }

                public class SetAddons
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setAddons";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetAddons(String name, SetAddonsConfigRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetAddons set$Xgafv(String $Xgafv) {
                        return (SetAddons)super.set$Xgafv($Xgafv);
                    }

                    public SetAddons setAccessToken(String accessToken) {
                        return (SetAddons)super.setAccessToken(accessToken);
                    }

                    public SetAddons setAlt(String alt) {
                        return (SetAddons)super.setAlt(alt);
                    }

                    public SetAddons setCallback(String callback) {
                        return (SetAddons)super.setCallback(callback);
                    }

                    public SetAddons setFields(String fields) {
                        return (SetAddons)super.setFields(fields);
                    }

                    public SetAddons setKey(String key) {
                        return (SetAddons)super.setKey(key);
                    }

                    public SetAddons setOauthToken(String oauthToken) {
                        return (SetAddons)super.setOauthToken(oauthToken);
                    }

                    public SetAddons setPrettyPrint(Boolean prettyPrint) {
                        return (SetAddons)super.setPrettyPrint(prettyPrint);
                    }

                    public SetAddons setQuotaUser(String quotaUser) {
                        return (SetAddons)super.setQuotaUser(quotaUser);
                    }

                    public SetAddons setUploadType(String uploadType) {
                        return (SetAddons)super.setUploadType(uploadType);
                    }

                    public SetAddons setUploadProtocol(String uploadProtocol) {
                        return (SetAddons)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetAddons setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public SetAddons set(String parameterName, Object value) {
                        return (SetAddons)super.set(parameterName, value);
                    }
                }

                public class List
                extends ContainerRequest<ListClustersResponse> {
                    private static final String REST_PATH = "v1/{+parent}/clusters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected List(String parent) {
                        super(Container.this, "GET", REST_PATH, null, ListClustersResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public List setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetJwks
                extends ContainerRequest<GetJSONWebKeysResponse> {
                    private static final String REST_PATH = "v1/{+parent}/jwks";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected GetJwks(String parent) {
                        super(Container.this, "GET", REST_PATH, null, GetJSONWebKeysResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetJwks set$Xgafv(String $Xgafv) {
                        return (GetJwks)super.set$Xgafv($Xgafv);
                    }

                    public GetJwks setAccessToken(String accessToken) {
                        return (GetJwks)super.setAccessToken(accessToken);
                    }

                    public GetJwks setAlt(String alt) {
                        return (GetJwks)super.setAlt(alt);
                    }

                    public GetJwks setCallback(String callback) {
                        return (GetJwks)super.setCallback(callback);
                    }

                    public GetJwks setFields(String fields) {
                        return (GetJwks)super.setFields(fields);
                    }

                    public GetJwks setKey(String key) {
                        return (GetJwks)super.setKey(key);
                    }

                    public GetJwks setOauthToken(String oauthToken) {
                        return (GetJwks)super.setOauthToken(oauthToken);
                    }

                    public GetJwks setPrettyPrint(Boolean prettyPrint) {
                        return (GetJwks)super.setPrettyPrint(prettyPrint);
                    }

                    public GetJwks setQuotaUser(String quotaUser) {
                        return (GetJwks)super.setQuotaUser(quotaUser);
                    }

                    public GetJwks setUploadType(String uploadType) {
                        return (GetJwks)super.setUploadType(uploadType);
                    }

                    public GetJwks setUploadProtocol(String uploadProtocol) {
                        return (GetJwks)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public GetJwks setParent(String parent) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public GetJwks set(String parameterName, Object value) {
                        return (GetJwks)super.set(parameterName, value);
                    }
                }

                public class Get
                extends ContainerRequest<Cluster> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String clusterId;
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected Get(String name) {
                        super(Container.this, "GET", REST_PATH, null, Cluster.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Get setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Get setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String clusterId;
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected Delete(String name) {
                        super(Container.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Delete setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Delete setZone(String zone) {
                        this.zone = zone;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/clusters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, CreateClusterRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class CompleteIpRotation
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:completeIpRotation";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected CompleteIpRotation(String name, CompleteIPRotationRequest content) {
                        super(Container.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public CompleteIpRotation set$Xgafv(String $Xgafv) {
                        return (CompleteIpRotation)super.set$Xgafv($Xgafv);
                    }

                    public CompleteIpRotation setAccessToken(String accessToken) {
                        return (CompleteIpRotation)super.setAccessToken(accessToken);
                    }

                    public CompleteIpRotation setAlt(String alt) {
                        return (CompleteIpRotation)super.setAlt(alt);
                    }

                    public CompleteIpRotation setCallback(String callback) {
                        return (CompleteIpRotation)super.setCallback(callback);
                    }

                    public CompleteIpRotation setFields(String fields) {
                        return (CompleteIpRotation)super.setFields(fields);
                    }

                    public CompleteIpRotation setKey(String key) {
                        return (CompleteIpRotation)super.setKey(key);
                    }

                    public CompleteIpRotation setOauthToken(String oauthToken) {
                        return (CompleteIpRotation)super.setOauthToken(oauthToken);
                    }

                    public CompleteIpRotation setPrettyPrint(Boolean prettyPrint) {
                        return (CompleteIpRotation)super.setPrettyPrint(prettyPrint);
                    }

                    public CompleteIpRotation setQuotaUser(String quotaUser) {
                        return (CompleteIpRotation)super.setQuotaUser(quotaUser);
                    }

                    public CompleteIpRotation setUploadType(String uploadType) {
                        return (CompleteIpRotation)super.setUploadType(uploadType);
                    }

                    public CompleteIpRotation setUploadProtocol(String uploadProtocol) {
                        return (CompleteIpRotation)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public CompleteIpRotation setName(String name) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public CompleteIpRotation set(String parameterName, Object value) {
                        return (CompleteIpRotation)super.set(parameterName, value);
                    }
                }
            }

            public class GetServerConfig
            extends ContainerRequest<ServerConfig> {
                private static final String REST_PATH = "v1/{+name}/serverConfig";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String projectId;
                @Key
                private String zone;

                protected GetServerConfig(String name) {
                    super(Container.this, "GET", REST_PATH, null, ServerConfig.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Container.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetServerConfig set$Xgafv(String $Xgafv) {
                    return (GetServerConfig)super.set$Xgafv($Xgafv);
                }

                public GetServerConfig setAccessToken(String accessToken) {
                    return (GetServerConfig)super.setAccessToken(accessToken);
                }

                public GetServerConfig setAlt(String alt) {
                    return (GetServerConfig)super.setAlt(alt);
                }

                public GetServerConfig setCallback(String callback) {
                    return (GetServerConfig)super.setCallback(callback);
                }

                public GetServerConfig setFields(String fields) {
                    return (GetServerConfig)super.setFields(fields);
                }

                public GetServerConfig setKey(String key) {
                    return (GetServerConfig)super.setKey(key);
                }

                public GetServerConfig setOauthToken(String oauthToken) {
                    return (GetServerConfig)super.setOauthToken(oauthToken);
                }

                public GetServerConfig setPrettyPrint(Boolean prettyPrint) {
                    return (GetServerConfig)super.setPrettyPrint(prettyPrint);
                }

                public GetServerConfig setQuotaUser(String quotaUser) {
                    return (GetServerConfig)super.setQuotaUser(quotaUser);
                }

                public GetServerConfig setUploadType(String uploadType) {
                    return (GetServerConfig)super.setUploadType(uploadType);
                }

                public GetServerConfig setUploadProtocol(String uploadProtocol) {
                    return (GetServerConfig)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GetServerConfig setName(String name) {
                    if (!Container.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public GetServerConfig setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getZone() {
                    return this.zone;
                }

                public GetServerConfig setZone(String zone) {
                    this.zone = zone;
                    return this;
                }

                @Override
                public GetServerConfig set(String parameterName, Object value) {
                    return (GetServerConfig)super.set(parameterName, value);
                }
            }
        }

        public class Aggregated {
            public UsableSubnetworks usableSubnetworks() {
                return new UsableSubnetworks();
            }

            public class UsableSubnetworks {
                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends ContainerRequest<ListUsableSubnetworksResponse> {
                    private static final String REST_PATH = "v1/{+parent}/aggregated/usableSubnetworks";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Container.this, "GET", REST_PATH, null, ListUsableSubnetworksResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }
        }
    }
}

