/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-07 at 05:47:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.container;

/**
 * Service definition for Container (v1).
 *
 * <p>
 * Builds and manages container-based applications, powered by the open source Kubernetes technology.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/container-engine/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link ContainerRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Container extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.25.0 of the Kubernetes Engine API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://container.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Container(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Container(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Container container = new Container(...);}
   *   {@code Container.Projects.List request = container.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Aggregated collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Container container = new Container(...);}
     *   {@code Container.Aggregated.List request = container.aggregated().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Aggregated aggregated() {
      return new Aggregated();
    }

    /**
     * The "aggregated" collection of methods.
     */
    public class Aggregated {

      /**
       * An accessor for creating requests from the UsableSubnetworks collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Container container = new Container(...);}
       *   {@code Container.UsableSubnetworks.List request = container.usableSubnetworks().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public UsableSubnetworks usableSubnetworks() {
        return new UsableSubnetworks();
      }

      /**
       * The "usableSubnetworks" collection of methods.
       */
      public class UsableSubnetworks {

        /**
         * Lists subnetworks that are usable for creating clusters in a project.
         *
         * Create a request for the method "usableSubnetworks.list".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent The parent project where subnetworks are usable.
        Specified in the format 'projects'.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends ContainerRequest<com.google.api.services.container.model.ListUsableSubnetworksResponse> {

          private static final String REST_PATH = "v1/{+parent}/aggregated/usableSubnetworks";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+$");

          /**
           * Lists subnetworks that are usable for creating clusters in a project.
           *
           * Create a request for the method "usableSubnetworks.list".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The parent project where subnetworks are usable.
        Specified in the format 'projects'.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.ListUsableSubnetworksResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The parent project where subnetworks are usable. Specified in the format 'projects'.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The parent project where subnetworks are usable. Specified in the format 'projects'.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * The parent project where subnetworks are usable. Specified in the format 'projects'.
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Filtering currently only supports equality on the networkProjectId and must be in the
           * form: "networkProjectId=[PROJECTID]", where `networkProjectId` is the project which
           * owns the listed subnetworks. This defaults to the parent project ID.
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** Filtering currently only supports equality on the networkProjectId and must be in the form:
         "networkProjectId=[PROJECTID]", where `networkProjectId` is the project which owns the listed
         subnetworks. This defaults to the parent project ID.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * Filtering currently only supports equality on the networkProjectId and must be in the
           * form: "networkProjectId=[PROJECTID]", where `networkProjectId` is the project which
           * owns the listed subnetworks. This defaults to the parent project ID.
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * Specifies a page token to use. Set this to the nextPageToken returned by previous list
           * requests to get the next page of results.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** Specifies a page token to use. Set this to the nextPageToken returned by previous list requests to
         get the next page of results.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * Specifies a page token to use. Set this to the nextPageToken returned by previous list
           * requests to get the next page of results.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /**
           * The max number of results per page that should be returned. If the number of available
           * results is larger than `page_size`, a `next_page_token` is returned which can be used
           * to get the next page of results in subsequent requests. Acceptable values are 0 to 500,
           * inclusive. (Default: 500)
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The max number of results per page that should be returned. If the number of available results is
         larger than `page_size`, a `next_page_token` is returned which can be used to get the next page of
         results in subsequent requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * The max number of results per page that should be returned. If the number of available
           * results is larger than `page_size`, a `next_page_token` is returned which can be used
           * to get the next page of results in subsequent requests. Acceptable values are 0 to 500,
           * inclusive. (Default: 500)
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
    /**
     * An accessor for creating requests from the Locations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Container container = new Container(...);}
     *   {@code Container.Locations.List request = container.locations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Locations locations() {
      return new Locations();
    }

    /**
     * The "locations" collection of methods.
     */
    public class Locations {

      /**
       * Returns configuration info about the Google Kubernetes Engine service.
       *
       * Create a request for the method "locations.getServerConfig".
       *
       * This request holds the parameters needed by the container server.  After setting any optional
       * parameters, call the {@link GetServerConfig#execute()} method to invoke the remote operation.
       *
       * @param name The name (project and location) of the server config to get,
      specified in the format
       *        'projects/locations'.
       * @return the request
       */
      public GetServerConfig getServerConfig(java.lang.String name) throws java.io.IOException {
        GetServerConfig result = new GetServerConfig(name);
        initialize(result);
        return result;
      }

      public class GetServerConfig extends ContainerRequest<com.google.api.services.container.model.ServerConfig> {

        private static final String REST_PATH = "v1/{+name}/serverConfig";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Returns configuration info about the Google Kubernetes Engine service.
         *
         * Create a request for the method "locations.getServerConfig".
         *
         * This request holds the parameters needed by the the container server.  After setting any
         * optional parameters, call the {@link GetServerConfig#execute()} method to invoke the remote
         * operation. <p> {@link GetServerConfig#initialize(com.google.api.client.googleapis.services.Abst
         * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
         * the constructor. </p>
         *
         * @param name The name (project and location) of the server config to get,
      specified in the format
       *        'projects/locations'.
         * @since 1.13
         */
        protected GetServerConfig(java.lang.String name) {
          super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.ServerConfig.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetServerConfig set$Xgafv(java.lang.String $Xgafv) {
          return (GetServerConfig) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetServerConfig setAccessToken(java.lang.String accessToken) {
          return (GetServerConfig) super.setAccessToken(accessToken);
        }

        @Override
        public GetServerConfig setAlt(java.lang.String alt) {
          return (GetServerConfig) super.setAlt(alt);
        }

        @Override
        public GetServerConfig setCallback(java.lang.String callback) {
          return (GetServerConfig) super.setCallback(callback);
        }

        @Override
        public GetServerConfig setFields(java.lang.String fields) {
          return (GetServerConfig) super.setFields(fields);
        }

        @Override
        public GetServerConfig setKey(java.lang.String key) {
          return (GetServerConfig) super.setKey(key);
        }

        @Override
        public GetServerConfig setOauthToken(java.lang.String oauthToken) {
          return (GetServerConfig) super.setOauthToken(oauthToken);
        }

        @Override
        public GetServerConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetServerConfig) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetServerConfig setQuotaUser(java.lang.String quotaUser) {
          return (GetServerConfig) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetServerConfig setUploadType(java.lang.String uploadType) {
          return (GetServerConfig) super.setUploadType(uploadType);
        }

        @Override
        public GetServerConfig setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetServerConfig) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name (project and location) of the server config to get, specified in the format
         * 'projects/locations'.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name (project and location) of the server config to get, specified in the format
       'projects/locations'.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The name (project and location) of the server config to get, specified in the format
         * 'projects/locations'.
         */
        public GetServerConfig setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Deprecated. The Google Developers Console [project ID or project
         * number](https://support.google.com/cloud/answer/6158840). This field has been deprecated
         * and replaced by the name field.
         */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** Deprecated. The Google Developers Console [project ID or project
       number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
       replaced by the name field.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /**
         * Deprecated. The Google Developers Console [project ID or project
         * number](https://support.google.com/cloud/answer/6158840). This field has been deprecated
         * and replaced by the name field.
         */
        public GetServerConfig setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /**
         * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
         * to return operations for. This field has been deprecated and replaced by the name field.
         */
        @com.google.api.client.util.Key
        private java.lang.String zone;

        /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) to return
       operations for. This field has been deprecated and replaced by the name field.
         */
        public java.lang.String getZone() {
          return zone;
        }

        /**
         * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
         * to return operations for. This field has been deprecated and replaced by the name field.
         */
        public GetServerConfig setZone(java.lang.String zone) {
          this.zone = zone;
          return this;
        }

        @Override
        public GetServerConfig set(String parameterName, Object value) {
          return (GetServerConfig) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Clusters collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Container container = new Container(...);}
       *   {@code Container.Clusters.List request = container.clusters().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Clusters clusters() {
        return new Clusters();
      }

      /**
       * The "clusters" collection of methods.
       */
      public class Clusters {

        /**
         * Completes master IP rotation.
         *
         * Create a request for the method "clusters.completeIpRotation".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link CompleteIpRotation#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster id) of the cluster to complete IP
        rotation. Specified in the
         *        format 'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.CompleteIPRotationRequest}
         * @return the request
         */
        public CompleteIpRotation completeIpRotation(java.lang.String name, com.google.api.services.container.model.CompleteIPRotationRequest content) throws java.io.IOException {
          CompleteIpRotation result = new CompleteIpRotation(name, content);
          initialize(result);
          return result;
        }

        public class CompleteIpRotation extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:completeIpRotation";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Completes master IP rotation.
           *
           * Create a request for the method "clusters.completeIpRotation".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link CompleteIpRotation#execute()} method to invoke the remote
           * operation. <p> {@link CompleteIpRotation#initialize(com.google.api.client.googleapis.services.A
           * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster id) of the cluster to complete IP
        rotation. Specified in the
         *        format 'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.CompleteIPRotationRequest}
           * @since 1.13
           */
          protected CompleteIpRotation(java.lang.String name, com.google.api.services.container.model.CompleteIPRotationRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public CompleteIpRotation set$Xgafv(java.lang.String $Xgafv) {
            return (CompleteIpRotation) super.set$Xgafv($Xgafv);
          }

          @Override
          public CompleteIpRotation setAccessToken(java.lang.String accessToken) {
            return (CompleteIpRotation) super.setAccessToken(accessToken);
          }

          @Override
          public CompleteIpRotation setAlt(java.lang.String alt) {
            return (CompleteIpRotation) super.setAlt(alt);
          }

          @Override
          public CompleteIpRotation setCallback(java.lang.String callback) {
            return (CompleteIpRotation) super.setCallback(callback);
          }

          @Override
          public CompleteIpRotation setFields(java.lang.String fields) {
            return (CompleteIpRotation) super.setFields(fields);
          }

          @Override
          public CompleteIpRotation setKey(java.lang.String key) {
            return (CompleteIpRotation) super.setKey(key);
          }

          @Override
          public CompleteIpRotation setOauthToken(java.lang.String oauthToken) {
            return (CompleteIpRotation) super.setOauthToken(oauthToken);
          }

          @Override
          public CompleteIpRotation setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (CompleteIpRotation) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public CompleteIpRotation setQuotaUser(java.lang.String quotaUser) {
            return (CompleteIpRotation) super.setQuotaUser(quotaUser);
          }

          @Override
          public CompleteIpRotation setUploadType(java.lang.String uploadType) {
            return (CompleteIpRotation) super.setUploadType(uploadType);
          }

          @Override
          public CompleteIpRotation setUploadProtocol(java.lang.String uploadProtocol) {
            return (CompleteIpRotation) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster id) of the cluster to complete IP rotation.
           * Specified in the format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster id) of the cluster to complete IP rotation. Specified in the
         format 'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster id) of the cluster to complete IP rotation.
           * Specified in the format 'projects/locations/clusters'.
           */
          public CompleteIpRotation setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public CompleteIpRotation set(String parameterName, Object value) {
            return (CompleteIpRotation) super.set(parameterName, value);
          }
        }
        /**
         * Creates a cluster, consisting of the specified number and type of Google Compute Engine
         * instances.
         *
         * By default, the cluster is created in the project's [default network](/compute/docs/networks-and-
         * firewalls#networks).
         *
         * One firewall is added for the cluster. After cluster creation, the Kubelet creates routes for
         * each node to allow the containers on that node to communicate with all other instances in the
         * cluster.
         *
         * Finally, an entry is added to the project's global metadata indicating which CIDR range the
         * cluster is using.
         *
         * Create a request for the method "clusters.create".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent The parent (project and location) where the cluster will be created.
        Specified in the format
         *        'projects/locations'.
         * @param content the {@link com.google.api.services.container.model.CreateClusterRequest}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.container.model.CreateClusterRequest content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/clusters";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a cluster, consisting of the specified number and type of Google Compute Engine
           * instances.
           *
           * By default, the cluster is created in the project's [default network](/compute/docs/networks-
           * and-firewalls#networks).
           *
           * One firewall is added for the cluster. After cluster creation, the Kubelet creates routes for
           * each node to allow the containers on that node to communicate with all other instances in the
           * cluster.
           *
           * Finally, an entry is added to the project's global metadata indicating which CIDR range the
           * cluster is using.
           *
           * Create a request for the method "clusters.create".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The parent (project and location) where the cluster will be created.
        Specified in the format
         *        'projects/locations'.
           * @param content the {@link com.google.api.services.container.model.CreateClusterRequest}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.container.model.CreateClusterRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The parent (project and location) where the cluster will be created. Specified in the
           * format 'projects/locations'.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The parent (project and location) where the cluster will be created. Specified in the format
         'projects/locations'.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * The parent (project and location) where the cluster will be created. Specified in the
           * format 'projects/locations'.
           */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes the cluster, including the Kubernetes endpoint and all worker nodes.
         *
         * Firewalls and routes that were configured during cluster creation are also deleted.
         *
         * Other Google Compute Engine resources that might be in use by the cluster, such as load balancer
         * resources, are not deleted if they weren't present when the cluster was initially created.
         *
         * Create a request for the method "clusters.delete".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster) of the cluster to delete.
        Specified in the format
         *        'projects/locations/clusters'.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Deletes the cluster, including the Kubernetes endpoint and all worker nodes.
           *
           * Firewalls and routes that were configured during cluster creation are also deleted.
           *
           * Other Google Compute Engine resources that might be in use by the cluster, such as load
           * balancer resources, are not deleted if they weren't present when the cluster was initially
           * created.
           *
           * Create a request for the method "clusters.delete".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster) of the cluster to delete.
        Specified in the format
         *        'projects/locations/clusters'.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Container.this, "DELETE", REST_PATH, null, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster) of the cluster to delete. Specified in the format
           * 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to delete. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to delete. Specified in the format
           * 'projects/locations/clusters'.
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Delete setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Delete setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to delete. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to delete. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to delete. This field has been deprecated and
           * replaced by the name field.
           */
          public Delete setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the details of a specific cluster.
         *
         * Create a request for the method "clusters.get".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster) of the cluster to retrieve.
        Specified in the format
         *        'projects/locations/clusters'.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends ContainerRequest<com.google.api.services.container.model.Cluster> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Gets the details of a specific cluster.
           *
           * Create a request for the method "clusters.get".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster) of the cluster to retrieve.
        Specified in the format
         *        'projects/locations/clusters'.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.Cluster.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster) of the cluster to retrieve. Specified in the
           * format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to retrieve. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to retrieve. Specified in the
           * format 'projects/locations/clusters'.
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to retrieve. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to retrieve. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to retrieve. This field has been deprecated and
           * replaced by the name field.
           */
          public Get setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Get setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Get setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Gets the public component of the cluster signing keys in JSON Web Key format. This API is not yet
         * intended for general use, and is not available for all clusters.
         *
         * Create a request for the method "clusters.getJwks".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link GetJwks#execute()} method to invoke the remote operation.
         *
         * @param parent The cluster (project, location, cluster id) to get keys for. Specified in
        the format
         *        'projects/locations/clusters'.
         * @return the request
         */
        public GetJwks getJwks(java.lang.String parent) throws java.io.IOException {
          GetJwks result = new GetJwks(parent);
          initialize(result);
          return result;
        }

        public class GetJwks extends ContainerRequest<com.google.api.services.container.model.GetJSONWebKeysResponse> {

          private static final String REST_PATH = "v1/{+parent}/jwks";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Gets the public component of the cluster signing keys in JSON Web Key format. This API is not
           * yet intended for general use, and is not available for all clusters.
           *
           * Create a request for the method "clusters.getJwks".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link GetJwks#execute()} method to invoke the remote operation.
           * <p> {@link
           * GetJwks#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The cluster (project, location, cluster id) to get keys for. Specified in
        the format
         *        'projects/locations/clusters'.
           * @since 1.13
           */
          protected GetJwks(java.lang.String parent) {
            super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.GetJSONWebKeysResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetJwks set$Xgafv(java.lang.String $Xgafv) {
            return (GetJwks) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetJwks setAccessToken(java.lang.String accessToken) {
            return (GetJwks) super.setAccessToken(accessToken);
          }

          @Override
          public GetJwks setAlt(java.lang.String alt) {
            return (GetJwks) super.setAlt(alt);
          }

          @Override
          public GetJwks setCallback(java.lang.String callback) {
            return (GetJwks) super.setCallback(callback);
          }

          @Override
          public GetJwks setFields(java.lang.String fields) {
            return (GetJwks) super.setFields(fields);
          }

          @Override
          public GetJwks setKey(java.lang.String key) {
            return (GetJwks) super.setKey(key);
          }

          @Override
          public GetJwks setOauthToken(java.lang.String oauthToken) {
            return (GetJwks) super.setOauthToken(oauthToken);
          }

          @Override
          public GetJwks setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetJwks) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetJwks setQuotaUser(java.lang.String quotaUser) {
            return (GetJwks) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetJwks setUploadType(java.lang.String uploadType) {
            return (GetJwks) super.setUploadType(uploadType);
          }

          @Override
          public GetJwks setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetJwks) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The cluster (project, location, cluster id) to get keys for. Specified in the format
           * 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The cluster (project, location, cluster id) to get keys for. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * The cluster (project, location, cluster id) to get keys for. Specified in the format
           * 'projects/locations/clusters'.
           */
          public GetJwks setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public GetJwks set(String parameterName, Object value) {
            return (GetJwks) super.set(parameterName, value);
          }
        }
        /**
         * Lists all clusters owned by a project in either the specified zone or all zones.
         *
         * Create a request for the method "clusters.list".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent The parent (project and location) where the clusters will be listed.
        Specified in the format
         *        'projects/locations'.
        Location "-" matches all zones and all regions.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends ContainerRequest<com.google.api.services.container.model.ListClustersResponse> {

          private static final String REST_PATH = "v1/{+parent}/clusters";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists all clusters owned by a project in either the specified zone or all zones.
           *
           * Create a request for the method "clusters.list".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The parent (project and location) where the clusters will be listed.
        Specified in the format
         *        'projects/locations'.
        Location "-" matches all zones and all regions.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.ListClustersResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The parent (project and location) where the clusters will be listed. Specified in the
           * format 'projects/locations'. Location "-" matches all zones and all regions.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The parent (project and location) where the clusters will be listed. Specified in the format
         'projects/locations'. Location "-" matches all zones and all regions.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * The parent (project and location) where the clusters will be listed. Specified in the
           * format 'projects/locations'. Location "-" matches all zones and all regions.
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the parent field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the parent field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the parent field.
           */
          public List setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides, or "-" for all zones. This field has been deprecated and
           * replaced by the parent field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides, or "-" for all zones. This field has been deprecated and replaced by the
         parent field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides, or "-" for all zones. This field has been deprecated and
           * replaced by the parent field.
           */
          public List setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Sets the addons for a specific cluster.
         *
         * Create a request for the method "clusters.setAddons".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetAddons#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster) of the cluster to set addons.
        Specified in the format
         *        'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.SetAddonsConfigRequest}
         * @return the request
         */
        public SetAddons setAddons(java.lang.String name, com.google.api.services.container.model.SetAddonsConfigRequest content) throws java.io.IOException {
          SetAddons result = new SetAddons(name, content);
          initialize(result);
          return result;
        }

        public class SetAddons extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setAddons";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Sets the addons for a specific cluster.
           *
           * Create a request for the method "clusters.setAddons".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetAddons#execute()} method to invoke the remote
           * operation. <p> {@link
           * SetAddons#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster) of the cluster to set addons.
        Specified in the format
         *        'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.SetAddonsConfigRequest}
           * @since 1.13
           */
          protected SetAddons(java.lang.String name, com.google.api.services.container.model.SetAddonsConfigRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public SetAddons set$Xgafv(java.lang.String $Xgafv) {
            return (SetAddons) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetAddons setAccessToken(java.lang.String accessToken) {
            return (SetAddons) super.setAccessToken(accessToken);
          }

          @Override
          public SetAddons setAlt(java.lang.String alt) {
            return (SetAddons) super.setAlt(alt);
          }

          @Override
          public SetAddons setCallback(java.lang.String callback) {
            return (SetAddons) super.setCallback(callback);
          }

          @Override
          public SetAddons setFields(java.lang.String fields) {
            return (SetAddons) super.setFields(fields);
          }

          @Override
          public SetAddons setKey(java.lang.String key) {
            return (SetAddons) super.setKey(key);
          }

          @Override
          public SetAddons setOauthToken(java.lang.String oauthToken) {
            return (SetAddons) super.setOauthToken(oauthToken);
          }

          @Override
          public SetAddons setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetAddons) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetAddons setQuotaUser(java.lang.String quotaUser) {
            return (SetAddons) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetAddons setUploadType(java.lang.String uploadType) {
            return (SetAddons) super.setUploadType(uploadType);
          }

          @Override
          public SetAddons setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetAddons) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster) of the cluster to set addons. Specified in the
           * format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to set addons. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to set addons. Specified in the
           * format 'projects/locations/clusters'.
           */
          public SetAddons setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetAddons set(String parameterName, Object value) {
            return (SetAddons) super.set(parameterName, value);
          }
        }
        /**
         * Enables or disables the ABAC authorization mechanism on a cluster.
         *
         * Create a request for the method "clusters.setLegacyAbac".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetLegacyAbac#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster id) of the cluster to set legacy abac.
        Specified in the format
         *        'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.SetLegacyAbacRequest}
         * @return the request
         */
        public SetLegacyAbac setLegacyAbac(java.lang.String name, com.google.api.services.container.model.SetLegacyAbacRequest content) throws java.io.IOException {
          SetLegacyAbac result = new SetLegacyAbac(name, content);
          initialize(result);
          return result;
        }

        public class SetLegacyAbac extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setLegacyAbac";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Enables or disables the ABAC authorization mechanism on a cluster.
           *
           * Create a request for the method "clusters.setLegacyAbac".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetLegacyAbac#execute()} method to invoke the remote
           * operation. <p> {@link SetLegacyAbac#initialize(com.google.api.client.googleapis.services.Abstra
           * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param name The name (project, location, cluster id) of the cluster to set legacy abac.
        Specified in the format
         *        'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.SetLegacyAbacRequest}
           * @since 1.13
           */
          protected SetLegacyAbac(java.lang.String name, com.google.api.services.container.model.SetLegacyAbacRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public SetLegacyAbac set$Xgafv(java.lang.String $Xgafv) {
            return (SetLegacyAbac) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetLegacyAbac setAccessToken(java.lang.String accessToken) {
            return (SetLegacyAbac) super.setAccessToken(accessToken);
          }

          @Override
          public SetLegacyAbac setAlt(java.lang.String alt) {
            return (SetLegacyAbac) super.setAlt(alt);
          }

          @Override
          public SetLegacyAbac setCallback(java.lang.String callback) {
            return (SetLegacyAbac) super.setCallback(callback);
          }

          @Override
          public SetLegacyAbac setFields(java.lang.String fields) {
            return (SetLegacyAbac) super.setFields(fields);
          }

          @Override
          public SetLegacyAbac setKey(java.lang.String key) {
            return (SetLegacyAbac) super.setKey(key);
          }

          @Override
          public SetLegacyAbac setOauthToken(java.lang.String oauthToken) {
            return (SetLegacyAbac) super.setOauthToken(oauthToken);
          }

          @Override
          public SetLegacyAbac setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetLegacyAbac) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetLegacyAbac setQuotaUser(java.lang.String quotaUser) {
            return (SetLegacyAbac) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetLegacyAbac setUploadType(java.lang.String uploadType) {
            return (SetLegacyAbac) super.setUploadType(uploadType);
          }

          @Override
          public SetLegacyAbac setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetLegacyAbac) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster id) of the cluster to set legacy abac. Specified
           * in the format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster id) of the cluster to set legacy abac. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster id) of the cluster to set legacy abac. Specified
           * in the format 'projects/locations/clusters'.
           */
          public SetLegacyAbac setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetLegacyAbac set(String parameterName, Object value) {
            return (SetLegacyAbac) super.set(parameterName, value);
          }
        }
        /**
         * Sets the locations for a specific cluster. Deprecated. Use [projects.locations.clusters.update
         * ](/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.update) instead.
         *
         * Create a request for the method "clusters.setLocations".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetLocations#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster) of the cluster to set locations.
        Specified in the format
         *        'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.SetLocationsRequest}
         * @return the request
         */
        public SetLocations setLocations(java.lang.String name, com.google.api.services.container.model.SetLocationsRequest content) throws java.io.IOException {
          SetLocations result = new SetLocations(name, content);
          initialize(result);
          return result;
        }

        public class SetLocations extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setLocations";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Sets the locations for a specific cluster. Deprecated. Use [projects.locations.clusters.update
           * ](/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.update) instead.
           *
           * Create a request for the method "clusters.setLocations".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetLocations#execute()} method to invoke the remote
           * operation. <p> {@link
           * SetLocations#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster) of the cluster to set locations.
        Specified in the format
         *        'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.SetLocationsRequest}
           * @since 1.13
           */
          protected SetLocations(java.lang.String name, com.google.api.services.container.model.SetLocationsRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public SetLocations set$Xgafv(java.lang.String $Xgafv) {
            return (SetLocations) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetLocations setAccessToken(java.lang.String accessToken) {
            return (SetLocations) super.setAccessToken(accessToken);
          }

          @Override
          public SetLocations setAlt(java.lang.String alt) {
            return (SetLocations) super.setAlt(alt);
          }

          @Override
          public SetLocations setCallback(java.lang.String callback) {
            return (SetLocations) super.setCallback(callback);
          }

          @Override
          public SetLocations setFields(java.lang.String fields) {
            return (SetLocations) super.setFields(fields);
          }

          @Override
          public SetLocations setKey(java.lang.String key) {
            return (SetLocations) super.setKey(key);
          }

          @Override
          public SetLocations setOauthToken(java.lang.String oauthToken) {
            return (SetLocations) super.setOauthToken(oauthToken);
          }

          @Override
          public SetLocations setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetLocations) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetLocations setQuotaUser(java.lang.String quotaUser) {
            return (SetLocations) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetLocations setUploadType(java.lang.String uploadType) {
            return (SetLocations) super.setUploadType(uploadType);
          }

          @Override
          public SetLocations setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetLocations) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster) of the cluster to set locations. Specified in the
           * format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to set locations. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to set locations. Specified in the
           * format 'projects/locations/clusters'.
           */
          public SetLocations setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetLocations set(String parameterName, Object value) {
            return (SetLocations) super.set(parameterName, value);
          }
        }
        /**
         * Sets the logging service for a specific cluster.
         *
         * Create a request for the method "clusters.setLogging".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetLogging#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster) of the cluster to set logging.
        Specified in the format
         *        'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.SetLoggingServiceRequest}
         * @return the request
         */
        public SetLogging setLogging(java.lang.String name, com.google.api.services.container.model.SetLoggingServiceRequest content) throws java.io.IOException {
          SetLogging result = new SetLogging(name, content);
          initialize(result);
          return result;
        }

        public class SetLogging extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setLogging";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Sets the logging service for a specific cluster.
           *
           * Create a request for the method "clusters.setLogging".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetLogging#execute()} method to invoke the remote
           * operation. <p> {@link
           * SetLogging#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster) of the cluster to set logging.
        Specified in the format
         *        'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.SetLoggingServiceRequest}
           * @since 1.13
           */
          protected SetLogging(java.lang.String name, com.google.api.services.container.model.SetLoggingServiceRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public SetLogging set$Xgafv(java.lang.String $Xgafv) {
            return (SetLogging) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetLogging setAccessToken(java.lang.String accessToken) {
            return (SetLogging) super.setAccessToken(accessToken);
          }

          @Override
          public SetLogging setAlt(java.lang.String alt) {
            return (SetLogging) super.setAlt(alt);
          }

          @Override
          public SetLogging setCallback(java.lang.String callback) {
            return (SetLogging) super.setCallback(callback);
          }

          @Override
          public SetLogging setFields(java.lang.String fields) {
            return (SetLogging) super.setFields(fields);
          }

          @Override
          public SetLogging setKey(java.lang.String key) {
            return (SetLogging) super.setKey(key);
          }

          @Override
          public SetLogging setOauthToken(java.lang.String oauthToken) {
            return (SetLogging) super.setOauthToken(oauthToken);
          }

          @Override
          public SetLogging setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetLogging) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetLogging setQuotaUser(java.lang.String quotaUser) {
            return (SetLogging) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetLogging setUploadType(java.lang.String uploadType) {
            return (SetLogging) super.setUploadType(uploadType);
          }

          @Override
          public SetLogging setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetLogging) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster) of the cluster to set logging. Specified in the
           * format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to set logging. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to set logging. Specified in the
           * format 'projects/locations/clusters'.
           */
          public SetLogging setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetLogging set(String parameterName, Object value) {
            return (SetLogging) super.set(parameterName, value);
          }
        }
        /**
         * Sets the maintenance policy for a cluster.
         *
         * Create a request for the method "clusters.setMaintenancePolicy".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetMaintenancePolicy#execute()} method to invoke the remote
         * operation.
         *
         * @param name The name (project, location, cluster id) of the cluster to set maintenance
        policy.
        Specified in the
         *        format 'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.SetMaintenancePolicyRequest}
         * @return the request
         */
        public SetMaintenancePolicy setMaintenancePolicy(java.lang.String name, com.google.api.services.container.model.SetMaintenancePolicyRequest content) throws java.io.IOException {
          SetMaintenancePolicy result = new SetMaintenancePolicy(name, content);
          initialize(result);
          return result;
        }

        public class SetMaintenancePolicy extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setMaintenancePolicy";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Sets the maintenance policy for a cluster.
           *
           * Create a request for the method "clusters.setMaintenancePolicy".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetMaintenancePolicy#execute()} method to invoke the
           * remote operation. <p> {@link SetMaintenancePolicy#initialize(com.google.api.client.googleapis.s
           * ervices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
           * after invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster id) of the cluster to set maintenance
        policy.
        Specified in the
         *        format 'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.SetMaintenancePolicyRequest}
           * @since 1.13
           */
          protected SetMaintenancePolicy(java.lang.String name, com.google.api.services.container.model.SetMaintenancePolicyRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public SetMaintenancePolicy set$Xgafv(java.lang.String $Xgafv) {
            return (SetMaintenancePolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetMaintenancePolicy setAccessToken(java.lang.String accessToken) {
            return (SetMaintenancePolicy) super.setAccessToken(accessToken);
          }

          @Override
          public SetMaintenancePolicy setAlt(java.lang.String alt) {
            return (SetMaintenancePolicy) super.setAlt(alt);
          }

          @Override
          public SetMaintenancePolicy setCallback(java.lang.String callback) {
            return (SetMaintenancePolicy) super.setCallback(callback);
          }

          @Override
          public SetMaintenancePolicy setFields(java.lang.String fields) {
            return (SetMaintenancePolicy) super.setFields(fields);
          }

          @Override
          public SetMaintenancePolicy setKey(java.lang.String key) {
            return (SetMaintenancePolicy) super.setKey(key);
          }

          @Override
          public SetMaintenancePolicy setOauthToken(java.lang.String oauthToken) {
            return (SetMaintenancePolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public SetMaintenancePolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetMaintenancePolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetMaintenancePolicy setQuotaUser(java.lang.String quotaUser) {
            return (SetMaintenancePolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetMaintenancePolicy setUploadType(java.lang.String uploadType) {
            return (SetMaintenancePolicy) super.setUploadType(uploadType);
          }

          @Override
          public SetMaintenancePolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetMaintenancePolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster id) of the cluster to set maintenance policy.
           * Specified in the format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster id) of the cluster to set maintenance policy. Specified in the
         format 'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster id) of the cluster to set maintenance policy.
           * Specified in the format 'projects/locations/clusters'.
           */
          public SetMaintenancePolicy setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetMaintenancePolicy set(String parameterName, Object value) {
            return (SetMaintenancePolicy) super.set(parameterName, value);
          }
        }
        /**
         * Sets master auth materials. Currently supports changing the admin password or a specific cluster,
         * either via password generation or explicitly setting the password.
         *
         * Create a request for the method "clusters.setMasterAuth".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetMasterAuth#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster) of the cluster to set auth.
        Specified in the format
         *        'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.SetMasterAuthRequest}
         * @return the request
         */
        public SetMasterAuth setMasterAuth(java.lang.String name, com.google.api.services.container.model.SetMasterAuthRequest content) throws java.io.IOException {
          SetMasterAuth result = new SetMasterAuth(name, content);
          initialize(result);
          return result;
        }

        public class SetMasterAuth extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setMasterAuth";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Sets master auth materials. Currently supports changing the admin password or a specific
           * cluster, either via password generation or explicitly setting the password.
           *
           * Create a request for the method "clusters.setMasterAuth".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetMasterAuth#execute()} method to invoke the remote
           * operation. <p> {@link SetMasterAuth#initialize(com.google.api.client.googleapis.services.Abstra
           * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param name The name (project, location, cluster) of the cluster to set auth.
        Specified in the format
         *        'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.SetMasterAuthRequest}
           * @since 1.13
           */
          protected SetMasterAuth(java.lang.String name, com.google.api.services.container.model.SetMasterAuthRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public SetMasterAuth set$Xgafv(java.lang.String $Xgafv) {
            return (SetMasterAuth) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetMasterAuth setAccessToken(java.lang.String accessToken) {
            return (SetMasterAuth) super.setAccessToken(accessToken);
          }

          @Override
          public SetMasterAuth setAlt(java.lang.String alt) {
            return (SetMasterAuth) super.setAlt(alt);
          }

          @Override
          public SetMasterAuth setCallback(java.lang.String callback) {
            return (SetMasterAuth) super.setCallback(callback);
          }

          @Override
          public SetMasterAuth setFields(java.lang.String fields) {
            return (SetMasterAuth) super.setFields(fields);
          }

          @Override
          public SetMasterAuth setKey(java.lang.String key) {
            return (SetMasterAuth) super.setKey(key);
          }

          @Override
          public SetMasterAuth setOauthToken(java.lang.String oauthToken) {
            return (SetMasterAuth) super.setOauthToken(oauthToken);
          }

          @Override
          public SetMasterAuth setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetMasterAuth) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetMasterAuth setQuotaUser(java.lang.String quotaUser) {
            return (SetMasterAuth) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetMasterAuth setUploadType(java.lang.String uploadType) {
            return (SetMasterAuth) super.setUploadType(uploadType);
          }

          @Override
          public SetMasterAuth setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetMasterAuth) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster) of the cluster to set auth. Specified in the
           * format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to set auth. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to set auth. Specified in the
           * format 'projects/locations/clusters'.
           */
          public SetMasterAuth setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetMasterAuth set(String parameterName, Object value) {
            return (SetMasterAuth) super.set(parameterName, value);
          }
        }
        /**
         * Sets the monitoring service for a specific cluster.
         *
         * Create a request for the method "clusters.setMonitoring".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetMonitoring#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster) of the cluster to set monitoring.
        Specified in the format
         *        'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.SetMonitoringServiceRequest}
         * @return the request
         */
        public SetMonitoring setMonitoring(java.lang.String name, com.google.api.services.container.model.SetMonitoringServiceRequest content) throws java.io.IOException {
          SetMonitoring result = new SetMonitoring(name, content);
          initialize(result);
          return result;
        }

        public class SetMonitoring extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setMonitoring";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Sets the monitoring service for a specific cluster.
           *
           * Create a request for the method "clusters.setMonitoring".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetMonitoring#execute()} method to invoke the remote
           * operation. <p> {@link SetMonitoring#initialize(com.google.api.client.googleapis.services.Abstra
           * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param name The name (project, location, cluster) of the cluster to set monitoring.
        Specified in the format
         *        'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.SetMonitoringServiceRequest}
           * @since 1.13
           */
          protected SetMonitoring(java.lang.String name, com.google.api.services.container.model.SetMonitoringServiceRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public SetMonitoring set$Xgafv(java.lang.String $Xgafv) {
            return (SetMonitoring) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetMonitoring setAccessToken(java.lang.String accessToken) {
            return (SetMonitoring) super.setAccessToken(accessToken);
          }

          @Override
          public SetMonitoring setAlt(java.lang.String alt) {
            return (SetMonitoring) super.setAlt(alt);
          }

          @Override
          public SetMonitoring setCallback(java.lang.String callback) {
            return (SetMonitoring) super.setCallback(callback);
          }

          @Override
          public SetMonitoring setFields(java.lang.String fields) {
            return (SetMonitoring) super.setFields(fields);
          }

          @Override
          public SetMonitoring setKey(java.lang.String key) {
            return (SetMonitoring) super.setKey(key);
          }

          @Override
          public SetMonitoring setOauthToken(java.lang.String oauthToken) {
            return (SetMonitoring) super.setOauthToken(oauthToken);
          }

          @Override
          public SetMonitoring setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetMonitoring) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetMonitoring setQuotaUser(java.lang.String quotaUser) {
            return (SetMonitoring) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetMonitoring setUploadType(java.lang.String uploadType) {
            return (SetMonitoring) super.setUploadType(uploadType);
          }

          @Override
          public SetMonitoring setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetMonitoring) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster) of the cluster to set monitoring. Specified in
           * the format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to set monitoring. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to set monitoring. Specified in
           * the format 'projects/locations/clusters'.
           */
          public SetMonitoring setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetMonitoring set(String parameterName, Object value) {
            return (SetMonitoring) super.set(parameterName, value);
          }
        }
        /**
         * Enables or disables Network Policy for a cluster.
         *
         * Create a request for the method "clusters.setNetworkPolicy".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetNetworkPolicy#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster id) of the cluster to set networking
        policy. Specified in the
         *        format 'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.SetNetworkPolicyRequest}
         * @return the request
         */
        public SetNetworkPolicy setNetworkPolicy(java.lang.String name, com.google.api.services.container.model.SetNetworkPolicyRequest content) throws java.io.IOException {
          SetNetworkPolicy result = new SetNetworkPolicy(name, content);
          initialize(result);
          return result;
        }

        public class SetNetworkPolicy extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setNetworkPolicy";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Enables or disables Network Policy for a cluster.
           *
           * Create a request for the method "clusters.setNetworkPolicy".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetNetworkPolicy#execute()} method to invoke the remote
           * operation. <p> {@link SetNetworkPolicy#initialize(com.google.api.client.googleapis.services.Abs
           * tractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster id) of the cluster to set networking
        policy. Specified in the
         *        format 'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.SetNetworkPolicyRequest}
           * @since 1.13
           */
          protected SetNetworkPolicy(java.lang.String name, com.google.api.services.container.model.SetNetworkPolicyRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public SetNetworkPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (SetNetworkPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetNetworkPolicy setAccessToken(java.lang.String accessToken) {
            return (SetNetworkPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public SetNetworkPolicy setAlt(java.lang.String alt) {
            return (SetNetworkPolicy) super.setAlt(alt);
          }

          @Override
          public SetNetworkPolicy setCallback(java.lang.String callback) {
            return (SetNetworkPolicy) super.setCallback(callback);
          }

          @Override
          public SetNetworkPolicy setFields(java.lang.String fields) {
            return (SetNetworkPolicy) super.setFields(fields);
          }

          @Override
          public SetNetworkPolicy setKey(java.lang.String key) {
            return (SetNetworkPolicy) super.setKey(key);
          }

          @Override
          public SetNetworkPolicy setOauthToken(java.lang.String oauthToken) {
            return (SetNetworkPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public SetNetworkPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetNetworkPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetNetworkPolicy setQuotaUser(java.lang.String quotaUser) {
            return (SetNetworkPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetNetworkPolicy setUploadType(java.lang.String uploadType) {
            return (SetNetworkPolicy) super.setUploadType(uploadType);
          }

          @Override
          public SetNetworkPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetNetworkPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster id) of the cluster to set networking policy.
           * Specified in the format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster id) of the cluster to set networking policy. Specified in the
         format 'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster id) of the cluster to set networking policy.
           * Specified in the format 'projects/locations/clusters'.
           */
          public SetNetworkPolicy setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetNetworkPolicy set(String parameterName, Object value) {
            return (SetNetworkPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Sets labels on a cluster.
         *
         * Create a request for the method "clusters.setResourceLabels".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetResourceLabels#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster id) of the cluster to set labels.
        Specified in the format
         *        'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.SetLabelsRequest}
         * @return the request
         */
        public SetResourceLabels setResourceLabels(java.lang.String name, com.google.api.services.container.model.SetLabelsRequest content) throws java.io.IOException {
          SetResourceLabels result = new SetResourceLabels(name, content);
          initialize(result);
          return result;
        }

        public class SetResourceLabels extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setResourceLabels";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Sets labels on a cluster.
           *
           * Create a request for the method "clusters.setResourceLabels".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetResourceLabels#execute()} method to invoke the remote
           * operation. <p> {@link SetResourceLabels#initialize(com.google.api.client.googleapis.services.Ab
           * stractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster id) of the cluster to set labels.
        Specified in the format
         *        'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.SetLabelsRequest}
           * @since 1.13
           */
          protected SetResourceLabels(java.lang.String name, com.google.api.services.container.model.SetLabelsRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public SetResourceLabels set$Xgafv(java.lang.String $Xgafv) {
            return (SetResourceLabels) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetResourceLabels setAccessToken(java.lang.String accessToken) {
            return (SetResourceLabels) super.setAccessToken(accessToken);
          }

          @Override
          public SetResourceLabels setAlt(java.lang.String alt) {
            return (SetResourceLabels) super.setAlt(alt);
          }

          @Override
          public SetResourceLabels setCallback(java.lang.String callback) {
            return (SetResourceLabels) super.setCallback(callback);
          }

          @Override
          public SetResourceLabels setFields(java.lang.String fields) {
            return (SetResourceLabels) super.setFields(fields);
          }

          @Override
          public SetResourceLabels setKey(java.lang.String key) {
            return (SetResourceLabels) super.setKey(key);
          }

          @Override
          public SetResourceLabels setOauthToken(java.lang.String oauthToken) {
            return (SetResourceLabels) super.setOauthToken(oauthToken);
          }

          @Override
          public SetResourceLabels setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetResourceLabels) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetResourceLabels setQuotaUser(java.lang.String quotaUser) {
            return (SetResourceLabels) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetResourceLabels setUploadType(java.lang.String uploadType) {
            return (SetResourceLabels) super.setUploadType(uploadType);
          }

          @Override
          public SetResourceLabels setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetResourceLabels) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster id) of the cluster to set labels. Specified in the
           * format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster id) of the cluster to set labels. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster id) of the cluster to set labels. Specified in the
           * format 'projects/locations/clusters'.
           */
          public SetResourceLabels setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetResourceLabels set(String parameterName, Object value) {
            return (SetResourceLabels) super.set(parameterName, value);
          }
        }
        /**
         * Starts master IP rotation.
         *
         * Create a request for the method "clusters.startIpRotation".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link StartIpRotation#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster id) of the cluster to start IP
        rotation. Specified in the
         *        format 'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.StartIPRotationRequest}
         * @return the request
         */
        public StartIpRotation startIpRotation(java.lang.String name, com.google.api.services.container.model.StartIPRotationRequest content) throws java.io.IOException {
          StartIpRotation result = new StartIpRotation(name, content);
          initialize(result);
          return result;
        }

        public class StartIpRotation extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:startIpRotation";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Starts master IP rotation.
           *
           * Create a request for the method "clusters.startIpRotation".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link StartIpRotation#execute()} method to invoke the remote
           * operation. <p> {@link StartIpRotation#initialize(com.google.api.client.googleapis.services.Abst
           * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param name The name (project, location, cluster id) of the cluster to start IP
        rotation. Specified in the
         *        format 'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.StartIPRotationRequest}
           * @since 1.13
           */
          protected StartIpRotation(java.lang.String name, com.google.api.services.container.model.StartIPRotationRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public StartIpRotation set$Xgafv(java.lang.String $Xgafv) {
            return (StartIpRotation) super.set$Xgafv($Xgafv);
          }

          @Override
          public StartIpRotation setAccessToken(java.lang.String accessToken) {
            return (StartIpRotation) super.setAccessToken(accessToken);
          }

          @Override
          public StartIpRotation setAlt(java.lang.String alt) {
            return (StartIpRotation) super.setAlt(alt);
          }

          @Override
          public StartIpRotation setCallback(java.lang.String callback) {
            return (StartIpRotation) super.setCallback(callback);
          }

          @Override
          public StartIpRotation setFields(java.lang.String fields) {
            return (StartIpRotation) super.setFields(fields);
          }

          @Override
          public StartIpRotation setKey(java.lang.String key) {
            return (StartIpRotation) super.setKey(key);
          }

          @Override
          public StartIpRotation setOauthToken(java.lang.String oauthToken) {
            return (StartIpRotation) super.setOauthToken(oauthToken);
          }

          @Override
          public StartIpRotation setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (StartIpRotation) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public StartIpRotation setQuotaUser(java.lang.String quotaUser) {
            return (StartIpRotation) super.setQuotaUser(quotaUser);
          }

          @Override
          public StartIpRotation setUploadType(java.lang.String uploadType) {
            return (StartIpRotation) super.setUploadType(uploadType);
          }

          @Override
          public StartIpRotation setUploadProtocol(java.lang.String uploadProtocol) {
            return (StartIpRotation) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster id) of the cluster to start IP rotation. Specified
           * in the format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster id) of the cluster to start IP rotation. Specified in the
         format 'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster id) of the cluster to start IP rotation. Specified
           * in the format 'projects/locations/clusters'.
           */
          public StartIpRotation setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public StartIpRotation set(String parameterName, Object value) {
            return (StartIpRotation) super.set(parameterName, value);
          }
        }
        /**
         * Updates the settings of a specific cluster.
         *
         * Create a request for the method "clusters.update".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster) of the cluster to update.
        Specified in the format
         *        'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.UpdateClusterRequest}
         * @return the request
         */
        public Update update(java.lang.String name, com.google.api.services.container.model.UpdateClusterRequest content) throws java.io.IOException {
          Update result = new Update(name, content);
          initialize(result);
          return result;
        }

        public class Update extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Updates the settings of a specific cluster.
           *
           * Create a request for the method "clusters.update".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
           * <p> {@link
           * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster) of the cluster to update.
        Specified in the format
         *        'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.UpdateClusterRequest}
           * @since 1.13
           */
          protected Update(java.lang.String name, com.google.api.services.container.model.UpdateClusterRequest content) {
            super(Container.this, "PUT", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public Update set$Xgafv(java.lang.String $Xgafv) {
            return (Update) super.set$Xgafv($Xgafv);
          }

          @Override
          public Update setAccessToken(java.lang.String accessToken) {
            return (Update) super.setAccessToken(accessToken);
          }

          @Override
          public Update setAlt(java.lang.String alt) {
            return (Update) super.setAlt(alt);
          }

          @Override
          public Update setCallback(java.lang.String callback) {
            return (Update) super.setCallback(callback);
          }

          @Override
          public Update setFields(java.lang.String fields) {
            return (Update) super.setFields(fields);
          }

          @Override
          public Update setKey(java.lang.String key) {
            return (Update) super.setKey(key);
          }

          @Override
          public Update setOauthToken(java.lang.String oauthToken) {
            return (Update) super.setOauthToken(oauthToken);
          }

          @Override
          public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Update) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Update setQuotaUser(java.lang.String quotaUser) {
            return (Update) super.setQuotaUser(quotaUser);
          }

          @Override
          public Update setUploadType(java.lang.String uploadType) {
            return (Update) super.setUploadType(uploadType);
          }

          @Override
          public Update setUploadProtocol(java.lang.String uploadProtocol) {
            return (Update) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster) of the cluster to update. Specified in the format
           * 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to update. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to update. Specified in the format
           * 'projects/locations/clusters'.
           */
          public Update setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Update set(String parameterName, Object value) {
            return (Update) super.set(parameterName, value);
          }
        }
        /**
         * Updates the master for a specific cluster.
         *
         * Create a request for the method "clusters.updateMaster".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link UpdateMaster#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, cluster) of the cluster to update.
        Specified in the format
         *        'projects/locations/clusters'.
         * @param content the {@link com.google.api.services.container.model.UpdateMasterRequest}
         * @return the request
         */
        public UpdateMaster updateMaster(java.lang.String name, com.google.api.services.container.model.UpdateMasterRequest content) throws java.io.IOException {
          UpdateMaster result = new UpdateMaster(name, content);
          initialize(result);
          return result;
        }

        public class UpdateMaster extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:updateMaster";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

          /**
           * Updates the master for a specific cluster.
           *
           * Create a request for the method "clusters.updateMaster".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link UpdateMaster#execute()} method to invoke the remote
           * operation. <p> {@link
           * UpdateMaster#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name (project, location, cluster) of the cluster to update.
        Specified in the format
         *        'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.UpdateMasterRequest}
           * @since 1.13
           */
          protected UpdateMaster(java.lang.String name, com.google.api.services.container.model.UpdateMasterRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
          }

          @Override
          public UpdateMaster set$Xgafv(java.lang.String $Xgafv) {
            return (UpdateMaster) super.set$Xgafv($Xgafv);
          }

          @Override
          public UpdateMaster setAccessToken(java.lang.String accessToken) {
            return (UpdateMaster) super.setAccessToken(accessToken);
          }

          @Override
          public UpdateMaster setAlt(java.lang.String alt) {
            return (UpdateMaster) super.setAlt(alt);
          }

          @Override
          public UpdateMaster setCallback(java.lang.String callback) {
            return (UpdateMaster) super.setCallback(callback);
          }

          @Override
          public UpdateMaster setFields(java.lang.String fields) {
            return (UpdateMaster) super.setFields(fields);
          }

          @Override
          public UpdateMaster setKey(java.lang.String key) {
            return (UpdateMaster) super.setKey(key);
          }

          @Override
          public UpdateMaster setOauthToken(java.lang.String oauthToken) {
            return (UpdateMaster) super.setOauthToken(oauthToken);
          }

          @Override
          public UpdateMaster setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (UpdateMaster) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public UpdateMaster setQuotaUser(java.lang.String quotaUser) {
            return (UpdateMaster) super.setQuotaUser(quotaUser);
          }

          @Override
          public UpdateMaster setUploadType(java.lang.String uploadType) {
            return (UpdateMaster) super.setUploadType(uploadType);
          }

          @Override
          public UpdateMaster setUploadProtocol(java.lang.String uploadProtocol) {
            return (UpdateMaster) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, cluster) of the cluster to update. Specified in the format
           * 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to update. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to update. Specified in the format
           * 'projects/locations/clusters'.
           */
          public UpdateMaster setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public UpdateMaster set(String parameterName, Object value) {
            return (UpdateMaster) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the NodePools collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Container container = new Container(...);}
         *   {@code Container.NodePools.List request = container.nodePools().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public NodePools nodePools() {
          return new NodePools();
        }

        /**
         * The "nodePools" collection of methods.
         */
        public class NodePools {

          /**
           * Creates a node pool for a cluster.
           *
           * Create a request for the method "nodePools.create".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation.
           *
           * @param parent The parent (project, location, cluster id) where the node pool will be
          created. Specified in the
           *        format
          'projects/locations/clusters'.
           * @param content the {@link com.google.api.services.container.model.CreateNodePoolRequest}
           * @return the request
           */
          public Create create(java.lang.String parent, com.google.api.services.container.model.CreateNodePoolRequest content) throws java.io.IOException {
            Create result = new Create(parent, content);
            initialize(result);
            return result;
          }

          public class Create extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/{+parent}/nodePools";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

            /**
             * Creates a node pool for a cluster.
             *
             * Create a request for the method "nodePools.create".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
             * <p> {@link
             * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent The parent (project, location, cluster id) where the node pool will be
          created. Specified in the
           *        format
          'projects/locations/clusters'.
             * @param content the {@link com.google.api.services.container.model.CreateNodePoolRequest}
             * @since 1.13
             */
            protected Create(java.lang.String parent, com.google.api.services.container.model.CreateNodePoolRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
              }
            }

            @Override
            public Create set$Xgafv(java.lang.String $Xgafv) {
              return (Create) super.set$Xgafv($Xgafv);
            }

            @Override
            public Create setAccessToken(java.lang.String accessToken) {
              return (Create) super.setAccessToken(accessToken);
            }

            @Override
            public Create setAlt(java.lang.String alt) {
              return (Create) super.setAlt(alt);
            }

            @Override
            public Create setCallback(java.lang.String callback) {
              return (Create) super.setCallback(callback);
            }

            @Override
            public Create setFields(java.lang.String fields) {
              return (Create) super.setFields(fields);
            }

            @Override
            public Create setKey(java.lang.String key) {
              return (Create) super.setKey(key);
            }

            @Override
            public Create setOauthToken(java.lang.String oauthToken) {
              return (Create) super.setOauthToken(oauthToken);
            }

            @Override
            public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Create) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Create setQuotaUser(java.lang.String quotaUser) {
              return (Create) super.setQuotaUser(quotaUser);
            }

            @Override
            public Create setUploadType(java.lang.String uploadType) {
              return (Create) super.setUploadType(uploadType);
            }

            @Override
            public Create setUploadProtocol(java.lang.String uploadProtocol) {
              return (Create) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The parent (project, location, cluster id) where the node pool will be created.
             * Specified in the format 'projects/locations/clusters'.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The parent (project, location, cluster id) where the node pool will be created. Specified in the
           format 'projects/locations/clusters'.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * The parent (project, location, cluster id) where the node pool will be created.
             * Specified in the format 'projects/locations/clusters'.
             */
            public Create setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
              return (Create) super.set(parameterName, value);
            }
          }
          /**
           * Deletes a node pool from a cluster.
           *
           * Create a request for the method "nodePools.delete".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param name The name (project, location, cluster, node pool id) of the node pool to
          delete. Specified in the
           *        format
          'projects/locations/clusters/nodePools'.
           * @return the request
           */
          public Delete delete(java.lang.String name) throws java.io.IOException {
            Delete result = new Delete(name);
            initialize(result);
            return result;
          }

          public class Delete extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");

            /**
             * Deletes a node pool from a cluster.
             *
             * Create a request for the method "nodePools.delete".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             * <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The name (project, location, cluster, node pool id) of the node pool to
          delete. Specified in the
           *        format
          'projects/locations/clusters/nodePools'.
             * @since 1.13
             */
            protected Delete(java.lang.String name) {
              super(Container.this, "DELETE", REST_PATH, null, com.google.api.services.container.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to delete.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name (project, location, cluster, node pool id) of the node pool to delete. Specified in the
           format 'projects/locations/clusters/nodePools'.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to delete.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            public Delete setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
              this.name = name;
              return this;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://developers.google.com/console/help/new/#projectnumber). This field has been
           deprecated and replaced by the name field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the name field.
             */
            public Delete setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            public Delete setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the name field.
             */
            public Delete setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            /**
             * Deprecated. The name of the node pool to delete. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String nodePoolId;

            /** Deprecated. The name of the node pool to delete. This field has been deprecated and replaced by the
           name field.
             */
            public java.lang.String getNodePoolId() {
              return nodePoolId;
            }

            /**
             * Deprecated. The name of the node pool to delete. This field has been deprecated and
             * replaced by the name field.
             */
            public Delete setNodePoolId(java.lang.String nodePoolId) {
              this.nodePoolId = nodePoolId;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Retrieves the requested node pool.
           *
           * Create a request for the method "nodePools.get".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name The name (project, location, cluster, node pool id) of the node pool to
          get. Specified in the format
           *        'projects/locations/clusters/nodePools'.
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends ContainerRequest<com.google.api.services.container.model.NodePool> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");

            /**
             * Retrieves the requested node pool.
             *
             * Create a request for the method "nodePools.get".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The name (project, location, cluster, node pool id) of the node pool to
          get. Specified in the format
           *        'projects/locations/clusters/nodePools'.
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.NodePool.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to get.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name (project, location, cluster, node pool id) of the node pool to get. Specified in the
           format 'projects/locations/clusters/nodePools'.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to get.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
              this.name = name;
              return this;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the name field.
             */
            public Get setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            /**
             * Deprecated. The name of the node pool. This field has been deprecated and replaced by
             * the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String nodePoolId;

            /** Deprecated. The name of the node pool. This field has been deprecated and replaced by the name
           field.
             */
            public java.lang.String getNodePoolId() {
              return nodePoolId;
            }

            /**
             * Deprecated. The name of the node pool. This field has been deprecated and replaced by
             * the name field.
             */
            public Get setNodePoolId(java.lang.String nodePoolId) {
              this.nodePoolId = nodePoolId;
              return this;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://developers.google.com/console/help/new/#projectnumber). This field has been
           deprecated and replaced by the name field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the name field.
             */
            public Get setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            public Get setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Lists the node pools for a cluster.
           *
           * Create a request for the method "nodePools.list".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent The parent (project, location, cluster id) where the node pools will be
          listed. Specified in the
           *        format 'projects/locations/clusters'.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends ContainerRequest<com.google.api.services.container.model.ListNodePoolsResponse> {

            private static final String REST_PATH = "v1/{+parent}/nodePools";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

            /**
             * Lists the node pools for a cluster.
             *
             * Create a request for the method "nodePools.list".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent The parent (project, location, cluster id) where the node pools will be
          listed. Specified in the
           *        format 'projects/locations/clusters'.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.ListNodePoolsResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The parent (project, location, cluster id) where the node pools will be listed.
             * Specified in the format 'projects/locations/clusters'.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The parent (project, location, cluster id) where the node pools will be listed. Specified in the
           format 'projects/locations/clusters'.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * The parent (project, location, cluster id) where the node pools will be listed.
             * Specified in the format 'projects/locations/clusters'.
             */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the parent field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://developers.google.com/console/help/new/#projectnumber). This field has been
           deprecated and replaced by the parent field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the parent field.
             */
            public List setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the parent field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the parent field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the parent field.
             */
            public List setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the parent field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the parent
           field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the parent field.
             */
            public List setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Rolls back a previously Aborted or Failed NodePool upgrade. This makes no changes if the last
           * upgrade successfully completed.
           *
           * Create a request for the method "nodePools.rollback".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Rollback#execute()} method to invoke the remote operation.
           *
           * @param name The name (project, location, cluster, node pool id) of the node poll to
          rollback upgrade.
          Specified
           *        in the format 'projects/locations/clusters/nodePools'.
           * @param content the {@link com.google.api.services.container.model.RollbackNodePoolUpgradeRequest}
           * @return the request
           */
          public Rollback rollback(java.lang.String name, com.google.api.services.container.model.RollbackNodePoolUpgradeRequest content) throws java.io.IOException {
            Rollback result = new Rollback(name, content);
            initialize(result);
            return result;
          }

          public class Rollback extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/{+name}:rollback";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");

            /**
             * Rolls back a previously Aborted or Failed NodePool upgrade. This makes no changes if the last
             * upgrade successfully completed.
             *
             * Create a request for the method "nodePools.rollback".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Rollback#execute()} method to invoke the remote operation.
             * <p> {@link
             * Rollback#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The name (project, location, cluster, node pool id) of the node poll to
          rollback upgrade.
          Specified
           *        in the format 'projects/locations/clusters/nodePools'.
             * @param content the {@link com.google.api.services.container.model.RollbackNodePoolUpgradeRequest}
             * @since 1.13
             */
            protected Rollback(java.lang.String name, com.google.api.services.container.model.RollbackNodePoolUpgradeRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
            }

            @Override
            public Rollback set$Xgafv(java.lang.String $Xgafv) {
              return (Rollback) super.set$Xgafv($Xgafv);
            }

            @Override
            public Rollback setAccessToken(java.lang.String accessToken) {
              return (Rollback) super.setAccessToken(accessToken);
            }

            @Override
            public Rollback setAlt(java.lang.String alt) {
              return (Rollback) super.setAlt(alt);
            }

            @Override
            public Rollback setCallback(java.lang.String callback) {
              return (Rollback) super.setCallback(callback);
            }

            @Override
            public Rollback setFields(java.lang.String fields) {
              return (Rollback) super.setFields(fields);
            }

            @Override
            public Rollback setKey(java.lang.String key) {
              return (Rollback) super.setKey(key);
            }

            @Override
            public Rollback setOauthToken(java.lang.String oauthToken) {
              return (Rollback) super.setOauthToken(oauthToken);
            }

            @Override
            public Rollback setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Rollback) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Rollback setQuotaUser(java.lang.String quotaUser) {
              return (Rollback) super.setQuotaUser(quotaUser);
            }

            @Override
            public Rollback setUploadType(java.lang.String uploadType) {
              return (Rollback) super.setUploadType(uploadType);
            }

            @Override
            public Rollback setUploadProtocol(java.lang.String uploadProtocol) {
              return (Rollback) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name (project, location, cluster, node pool id) of the node poll to rollback
             * upgrade. Specified in the format 'projects/locations/clusters/nodePools'.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name (project, location, cluster, node pool id) of the node poll to rollback upgrade. Specified
           in the format 'projects/locations/clusters/nodePools'.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name (project, location, cluster, node pool id) of the node poll to rollback
             * upgrade. Specified in the format 'projects/locations/clusters/nodePools'.
             */
            public Rollback setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Rollback set(String parameterName, Object value) {
              return (Rollback) super.set(parameterName, value);
            }
          }
          /**
           * Sets the autoscaling settings for the specified node pool.
           *
           * Create a request for the method "nodePools.setAutoscaling".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link SetAutoscaling#execute()} method to invoke the remote operation.
           *
           * @param name The name (project, location, cluster, node pool) of the node pool to set
          autoscaler settings.
           *        Specified in the format
          'projects/locations/clusters/nodePools'.
           * @param content the {@link com.google.api.services.container.model.SetNodePoolAutoscalingRequest}
           * @return the request
           */
          public SetAutoscaling setAutoscaling(java.lang.String name, com.google.api.services.container.model.SetNodePoolAutoscalingRequest content) throws java.io.IOException {
            SetAutoscaling result = new SetAutoscaling(name, content);
            initialize(result);
            return result;
          }

          public class SetAutoscaling extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/{+name}:setAutoscaling";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");

            /**
             * Sets the autoscaling settings for the specified node pool.
             *
             * Create a request for the method "nodePools.setAutoscaling".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link SetAutoscaling#execute()} method to invoke the remote
             * operation. <p> {@link SetAutoscaling#initialize(com.google.api.client.googleapis.services.Abstr
             * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
             * the constructor. </p>
             *
             * @param name The name (project, location, cluster, node pool) of the node pool to set
          autoscaler settings.
           *        Specified in the format
          'projects/locations/clusters/nodePools'.
             * @param content the {@link com.google.api.services.container.model.SetNodePoolAutoscalingRequest}
             * @since 1.13
             */
            protected SetAutoscaling(java.lang.String name, com.google.api.services.container.model.SetNodePoolAutoscalingRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
            }

            @Override
            public SetAutoscaling set$Xgafv(java.lang.String $Xgafv) {
              return (SetAutoscaling) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetAutoscaling setAccessToken(java.lang.String accessToken) {
              return (SetAutoscaling) super.setAccessToken(accessToken);
            }

            @Override
            public SetAutoscaling setAlt(java.lang.String alt) {
              return (SetAutoscaling) super.setAlt(alt);
            }

            @Override
            public SetAutoscaling setCallback(java.lang.String callback) {
              return (SetAutoscaling) super.setCallback(callback);
            }

            @Override
            public SetAutoscaling setFields(java.lang.String fields) {
              return (SetAutoscaling) super.setFields(fields);
            }

            @Override
            public SetAutoscaling setKey(java.lang.String key) {
              return (SetAutoscaling) super.setKey(key);
            }

            @Override
            public SetAutoscaling setOauthToken(java.lang.String oauthToken) {
              return (SetAutoscaling) super.setOauthToken(oauthToken);
            }

            @Override
            public SetAutoscaling setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetAutoscaling) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetAutoscaling setQuotaUser(java.lang.String quotaUser) {
              return (SetAutoscaling) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetAutoscaling setUploadType(java.lang.String uploadType) {
              return (SetAutoscaling) super.setUploadType(uploadType);
            }

            @Override
            public SetAutoscaling setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetAutoscaling) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name (project, location, cluster, node pool) of the node pool to set autoscaler
             * settings. Specified in the format 'projects/locations/clusters/nodePools'.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name (project, location, cluster, node pool) of the node pool to set autoscaler settings.
           Specified in the format 'projects/locations/clusters/nodePools'.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name (project, location, cluster, node pool) of the node pool to set autoscaler
             * settings. Specified in the format 'projects/locations/clusters/nodePools'.
             */
            public SetAutoscaling setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public SetAutoscaling set(String parameterName, Object value) {
              return (SetAutoscaling) super.set(parameterName, value);
            }
          }
          /**
           * Sets the NodeManagement options for a node pool.
           *
           * Create a request for the method "nodePools.setManagement".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link SetManagement#execute()} method to invoke the remote operation.
           *
           * @param name The name (project, location, cluster, node pool id) of the node pool to set
          management properties.
           *        Specified in the format
          'projects/locations/clusters/nodePools'.
           * @param content the {@link com.google.api.services.container.model.SetNodePoolManagementRequest}
           * @return the request
           */
          public SetManagement setManagement(java.lang.String name, com.google.api.services.container.model.SetNodePoolManagementRequest content) throws java.io.IOException {
            SetManagement result = new SetManagement(name, content);
            initialize(result);
            return result;
          }

          public class SetManagement extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/{+name}:setManagement";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");

            /**
             * Sets the NodeManagement options for a node pool.
             *
             * Create a request for the method "nodePools.setManagement".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link SetManagement#execute()} method to invoke the remote
             * operation. <p> {@link SetManagement#initialize(com.google.api.client.googleapis.services.Abstra
             * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
             * the constructor. </p>
             *
             * @param name The name (project, location, cluster, node pool id) of the node pool to set
          management properties.
           *        Specified in the format
          'projects/locations/clusters/nodePools'.
             * @param content the {@link com.google.api.services.container.model.SetNodePoolManagementRequest}
             * @since 1.13
             */
            protected SetManagement(java.lang.String name, com.google.api.services.container.model.SetNodePoolManagementRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
            }

            @Override
            public SetManagement set$Xgafv(java.lang.String $Xgafv) {
              return (SetManagement) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetManagement setAccessToken(java.lang.String accessToken) {
              return (SetManagement) super.setAccessToken(accessToken);
            }

            @Override
            public SetManagement setAlt(java.lang.String alt) {
              return (SetManagement) super.setAlt(alt);
            }

            @Override
            public SetManagement setCallback(java.lang.String callback) {
              return (SetManagement) super.setCallback(callback);
            }

            @Override
            public SetManagement setFields(java.lang.String fields) {
              return (SetManagement) super.setFields(fields);
            }

            @Override
            public SetManagement setKey(java.lang.String key) {
              return (SetManagement) super.setKey(key);
            }

            @Override
            public SetManagement setOauthToken(java.lang.String oauthToken) {
              return (SetManagement) super.setOauthToken(oauthToken);
            }

            @Override
            public SetManagement setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetManagement) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetManagement setQuotaUser(java.lang.String quotaUser) {
              return (SetManagement) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetManagement setUploadType(java.lang.String uploadType) {
              return (SetManagement) super.setUploadType(uploadType);
            }

            @Override
            public SetManagement setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetManagement) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to set
             * management properties. Specified in the format
             * 'projects/locations/clusters/nodePools'.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name (project, location, cluster, node pool id) of the node pool to set management properties.
           Specified in the format 'projects/locations/clusters/nodePools'.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to set
             * management properties. Specified in the format
             * 'projects/locations/clusters/nodePools'.
             */
            public SetManagement setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public SetManagement set(String parameterName, Object value) {
              return (SetManagement) super.set(parameterName, value);
            }
          }
          /**
           * Sets the size for a specific node pool.
           *
           * Create a request for the method "nodePools.setSize".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link SetSize#execute()} method to invoke the remote operation.
           *
           * @param name The name (project, location, cluster, node pool id) of the node pool to set
          size.
          Specified in the
           *        format 'projects/locations/clusters/nodePools'.
           * @param content the {@link com.google.api.services.container.model.SetNodePoolSizeRequest}
           * @return the request
           */
          public SetSize setSize(java.lang.String name, com.google.api.services.container.model.SetNodePoolSizeRequest content) throws java.io.IOException {
            SetSize result = new SetSize(name, content);
            initialize(result);
            return result;
          }

          public class SetSize extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/{+name}:setSize";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");

            /**
             * Sets the size for a specific node pool.
             *
             * Create a request for the method "nodePools.setSize".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link SetSize#execute()} method to invoke the remote operation.
             * <p> {@link
             * SetSize#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The name (project, location, cluster, node pool id) of the node pool to set
          size.
          Specified in the
           *        format 'projects/locations/clusters/nodePools'.
             * @param content the {@link com.google.api.services.container.model.SetNodePoolSizeRequest}
             * @since 1.13
             */
            protected SetSize(java.lang.String name, com.google.api.services.container.model.SetNodePoolSizeRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
            }

            @Override
            public SetSize set$Xgafv(java.lang.String $Xgafv) {
              return (SetSize) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetSize setAccessToken(java.lang.String accessToken) {
              return (SetSize) super.setAccessToken(accessToken);
            }

            @Override
            public SetSize setAlt(java.lang.String alt) {
              return (SetSize) super.setAlt(alt);
            }

            @Override
            public SetSize setCallback(java.lang.String callback) {
              return (SetSize) super.setCallback(callback);
            }

            @Override
            public SetSize setFields(java.lang.String fields) {
              return (SetSize) super.setFields(fields);
            }

            @Override
            public SetSize setKey(java.lang.String key) {
              return (SetSize) super.setKey(key);
            }

            @Override
            public SetSize setOauthToken(java.lang.String oauthToken) {
              return (SetSize) super.setOauthToken(oauthToken);
            }

            @Override
            public SetSize setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetSize) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetSize setQuotaUser(java.lang.String quotaUser) {
              return (SetSize) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetSize setUploadType(java.lang.String uploadType) {
              return (SetSize) super.setUploadType(uploadType);
            }

            @Override
            public SetSize setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetSize) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to set size.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name (project, location, cluster, node pool id) of the node pool to set size. Specified in the
           format 'projects/locations/clusters/nodePools'.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to set size.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            public SetSize setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public SetSize set(String parameterName, Object value) {
              return (SetSize) super.set(parameterName, value);
            }
          }
          /**
           * Updates the version and/or image type for the specified node pool.
           *
           * Create a request for the method "nodePools.update".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Update#execute()} method to invoke the remote operation.
           *
           * @param name The name (project, location, cluster, node pool) of the node pool to
          update. Specified in the format
           *        'projects/locations/clusters/nodePools'.
           * @param content the {@link com.google.api.services.container.model.UpdateNodePoolRequest}
           * @return the request
           */
          public Update update(java.lang.String name, com.google.api.services.container.model.UpdateNodePoolRequest content) throws java.io.IOException {
            Update result = new Update(name, content);
            initialize(result);
            return result;
          }

          public class Update extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");

            /**
             * Updates the version and/or image type for the specified node pool.
             *
             * Create a request for the method "nodePools.update".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
             * <p> {@link
             * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The name (project, location, cluster, node pool) of the node pool to
          update. Specified in the format
           *        'projects/locations/clusters/nodePools'.
             * @param content the {@link com.google.api.services.container.model.UpdateNodePoolRequest}
             * @since 1.13
             */
            protected Update(java.lang.String name, com.google.api.services.container.model.UpdateNodePoolRequest content) {
              super(Container.this, "PUT", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
            }

            @Override
            public Update set$Xgafv(java.lang.String $Xgafv) {
              return (Update) super.set$Xgafv($Xgafv);
            }

            @Override
            public Update setAccessToken(java.lang.String accessToken) {
              return (Update) super.setAccessToken(accessToken);
            }

            @Override
            public Update setAlt(java.lang.String alt) {
              return (Update) super.setAlt(alt);
            }

            @Override
            public Update setCallback(java.lang.String callback) {
              return (Update) super.setCallback(callback);
            }

            @Override
            public Update setFields(java.lang.String fields) {
              return (Update) super.setFields(fields);
            }

            @Override
            public Update setKey(java.lang.String key) {
              return (Update) super.setKey(key);
            }

            @Override
            public Update setOauthToken(java.lang.String oauthToken) {
              return (Update) super.setOauthToken(oauthToken);
            }

            @Override
            public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Update) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Update setQuotaUser(java.lang.String quotaUser) {
              return (Update) super.setQuotaUser(quotaUser);
            }

            @Override
            public Update setUploadType(java.lang.String uploadType) {
              return (Update) super.setUploadType(uploadType);
            }

            @Override
            public Update setUploadProtocol(java.lang.String uploadProtocol) {
              return (Update) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The name (project, location, cluster, node pool) of the node pool to update.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name (project, location, cluster, node pool) of the node pool to update. Specified in the
           format 'projects/locations/clusters/nodePools'.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name (project, location, cluster, node pool) of the node pool to update.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            public Update setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
              return (Update) super.set(parameterName, value);
            }
          }

        }
        /**
         * An accessor for creating requests from the WellKnown collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Container container = new Container(...);}
         *   {@code Container.WellKnown.List request = container.wellKnown().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public WellKnown wellKnown() {
          return new WellKnown();
        }

        /**
         * The "well-known" collection of methods.
         */
        public class WellKnown {

          /**
           * Gets the OIDC discovery document for the cluster. See the [OpenID Connect Discovery 1.0
           * specification](https://openid.net/specs/openid-connect-discovery-1_0.html) for details. This API
           * is not yet intended for general use, and is not available for all clusters.
           *
           * Create a request for the method "well-known.getOpenid-configuration".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link GetOpenidConfiguration#execute()} method to invoke the remote
           * operation.
           *
           * @param parent The cluster (project, location, cluster id) to get the discovery document
          for. Specified in the
           *        format 'projects/locations/clusters'.
           * @return the request
           */
          public GetOpenidConfiguration getOpenidConfiguration(java.lang.String parent) throws java.io.IOException {
            GetOpenidConfiguration result = new GetOpenidConfiguration(parent);
            initialize(result);
            return result;
          }

          public class GetOpenidConfiguration extends ContainerRequest<com.google.api.services.container.model.GetOpenIDConfigResponse> {

            private static final String REST_PATH = "v1/{+parent}/.well-known/openid-configuration";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");

            /**
             * Gets the OIDC discovery document for the cluster. See the [OpenID Connect Discovery 1.0
             * specification](https://openid.net/specs/openid-connect-discovery-1_0.html) for details. This
             * API is not yet intended for general use, and is not available for all clusters.
             *
             * Create a request for the method "well-known.getOpenid-configuration".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link GetOpenidConfiguration#execute()} method to invoke the
             * remote operation. <p> {@link GetOpenidConfiguration#initialize(com.google.api.client.googleapis
             * .services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
             * after invoking the constructor. </p>
             *
             * @param parent The cluster (project, location, cluster id) to get the discovery document
          for. Specified in the
           *        format 'projects/locations/clusters'.
             * @since 1.13
             */
            protected GetOpenidConfiguration(java.lang.String parent) {
              super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.GetOpenIDConfigResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public GetOpenidConfiguration set$Xgafv(java.lang.String $Xgafv) {
              return (GetOpenidConfiguration) super.set$Xgafv($Xgafv);
            }

            @Override
            public GetOpenidConfiguration setAccessToken(java.lang.String accessToken) {
              return (GetOpenidConfiguration) super.setAccessToken(accessToken);
            }

            @Override
            public GetOpenidConfiguration setAlt(java.lang.String alt) {
              return (GetOpenidConfiguration) super.setAlt(alt);
            }

            @Override
            public GetOpenidConfiguration setCallback(java.lang.String callback) {
              return (GetOpenidConfiguration) super.setCallback(callback);
            }

            @Override
            public GetOpenidConfiguration setFields(java.lang.String fields) {
              return (GetOpenidConfiguration) super.setFields(fields);
            }

            @Override
            public GetOpenidConfiguration setKey(java.lang.String key) {
              return (GetOpenidConfiguration) super.setKey(key);
            }

            @Override
            public GetOpenidConfiguration setOauthToken(java.lang.String oauthToken) {
              return (GetOpenidConfiguration) super.setOauthToken(oauthToken);
            }

            @Override
            public GetOpenidConfiguration setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (GetOpenidConfiguration) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public GetOpenidConfiguration setQuotaUser(java.lang.String quotaUser) {
              return (GetOpenidConfiguration) super.setQuotaUser(quotaUser);
            }

            @Override
            public GetOpenidConfiguration setUploadType(java.lang.String uploadType) {
              return (GetOpenidConfiguration) super.setUploadType(uploadType);
            }

            @Override
            public GetOpenidConfiguration setUploadProtocol(java.lang.String uploadProtocol) {
              return (GetOpenidConfiguration) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The cluster (project, location, cluster id) to get the discovery document for.
             * Specified in the format 'projects/locations/clusters'.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The cluster (project, location, cluster id) to get the discovery document for. Specified in the
           format 'projects/locations/clusters'.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * The cluster (project, location, cluster id) to get the discovery document for.
             * Specified in the format 'projects/locations/clusters'.
             */
            public GetOpenidConfiguration setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            @Override
            public GetOpenidConfiguration set(String parameterName, Object value) {
              return (GetOpenidConfiguration) super.set(parameterName, value);
            }
          }

        }
      }
      /**
       * An accessor for creating requests from the Operations collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Container container = new Container(...);}
       *   {@code Container.Operations.List request = container.operations().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Operations operations() {
        return new Operations();
      }

      /**
       * The "operations" collection of methods.
       */
      public class Operations {

        /**
         * Cancels the specified operation.
         *
         * Create a request for the method "operations.cancel".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, operation id) of the operation to cancel.
        Specified in the format
         *        'projects/locations/operations'.
         * @param content the {@link com.google.api.services.container.model.CancelOperationRequest}
         * @return the request
         */
        public Cancel cancel(java.lang.String name, com.google.api.services.container.model.CancelOperationRequest content) throws java.io.IOException {
          Cancel result = new Cancel(name, content);
          initialize(result);
          return result;
        }

        public class Cancel extends ContainerRequest<com.google.api.services.container.model.Empty> {

          private static final String REST_PATH = "v1/{+name}:cancel";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Cancels the specified operation.
           *
           * Create a request for the method "operations.cancel".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
           * <p> {@link
           * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name (project, location, operation id) of the operation to cancel.
        Specified in the format
         *        'projects/locations/operations'.
           * @param content the {@link com.google.api.services.container.model.CancelOperationRequest}
           * @since 1.13
           */
          protected Cancel(java.lang.String name, com.google.api.services.container.model.CancelOperationRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public Cancel set$Xgafv(java.lang.String $Xgafv) {
            return (Cancel) super.set$Xgafv($Xgafv);
          }

          @Override
          public Cancel setAccessToken(java.lang.String accessToken) {
            return (Cancel) super.setAccessToken(accessToken);
          }

          @Override
          public Cancel setAlt(java.lang.String alt) {
            return (Cancel) super.setAlt(alt);
          }

          @Override
          public Cancel setCallback(java.lang.String callback) {
            return (Cancel) super.setCallback(callback);
          }

          @Override
          public Cancel setFields(java.lang.String fields) {
            return (Cancel) super.setFields(fields);
          }

          @Override
          public Cancel setKey(java.lang.String key) {
            return (Cancel) super.setKey(key);
          }

          @Override
          public Cancel setOauthToken(java.lang.String oauthToken) {
            return (Cancel) super.setOauthToken(oauthToken);
          }

          @Override
          public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Cancel) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Cancel setQuotaUser(java.lang.String quotaUser) {
            return (Cancel) super.setQuotaUser(quotaUser);
          }

          @Override
          public Cancel setUploadType(java.lang.String uploadType) {
            return (Cancel) super.setUploadType(uploadType);
          }

          @Override
          public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
            return (Cancel) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, operation id) of the operation to cancel. Specified in the
           * format 'projects/locations/operations'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, operation id) of the operation to cancel. Specified in the format
         'projects/locations/operations'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, operation id) of the operation to cancel. Specified in the
           * format 'projects/locations/operations'.
           */
          public Cancel setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Cancel set(String parameterName, Object value) {
            return (Cancel) super.set(parameterName, value);
          }
        }
        /**
         * Gets the specified operation.
         *
         * Create a request for the method "operations.get".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name (project, location, operation id) of the operation to get.
        Specified in the format
         *        'projects/locations/operations'.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Gets the specified operation.
           *
           * Create a request for the method "operations.get".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name (project, location, operation id) of the operation to get.
        Specified in the format
         *        'projects/locations/operations'.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (project, location, operation id) of the operation to get. Specified in the
           * format 'projects/locations/operations'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, operation id) of the operation to get. Specified in the format
         'projects/locations/operations'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, operation id) of the operation to get. Specified in the
           * format 'projects/locations/operations'.
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * Deprecated. The server-assigned `name` of the operation. This field has been deprecated
           * and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String operationId;

          /** Deprecated. The server-assigned `name` of the operation. This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getOperationId() {
            return operationId;
          }

          /**
           * Deprecated. The server-assigned `name` of the operation. This field has been deprecated
           * and replaced by the name field.
           */
          public Get setOperationId(java.lang.String operationId) {
            this.operationId = operationId;
            return this;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Get setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Get setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists all operations in a project in a specific zone or all zones.
         *
         * Create a request for the method "operations.list".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent The parent (project and location) where the operations will be listed.
        Specified in the format
         *        'projects/locations'.
        Location "-" matches all zones and all regions.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends ContainerRequest<com.google.api.services.container.model.ListOperationsResponse> {

          private static final String REST_PATH = "v1/{+parent}/operations";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists all operations in a project in a specific zone or all zones.
           *
           * Create a request for the method "operations.list".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The parent (project and location) where the operations will be listed.
        Specified in the format
         *        'projects/locations'.
        Location "-" matches all zones and all regions.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.ListOperationsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The parent (project and location) where the operations will be listed. Specified in the
           * format 'projects/locations'. Location "-" matches all zones and all regions.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The parent (project and location) where the operations will be listed. Specified in the format
         'projects/locations'. Location "-" matches all zones and all regions.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * The parent (project and location) where the operations will be listed. Specified in the
           * format 'projects/locations'. Location "-" matches all zones and all regions.
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the parent field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the parent field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the parent field.
           */
          public List setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * to return operations for, or `-` for all zones. This field has been deprecated and
           * replaced by the parent field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) to return
         operations for, or `-` for all zones. This field has been deprecated and replaced by the parent
         field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * to return operations for, or `-` for all zones. This field has been deprecated and
           * replaced by the parent field.
           */
          public List setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
    /**
     * An accessor for creating requests from the Zones collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Container container = new Container(...);}
     *   {@code Container.Zones.List request = container.zones().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Zones zones() {
      return new Zones();
    }

    /**
     * The "zones" collection of methods.
     */
    public class Zones {

      /**
       * Returns configuration info about the Google Kubernetes Engine service.
       *
       * Create a request for the method "zones.getServerconfig".
       *
       * This request holds the parameters needed by the container server.  After setting any optional
       * parameters, call the {@link GetServerconfig#execute()} method to invoke the remote operation.
       *
       * @param projectId Deprecated. The Google Developers Console [project ID or project
       *        number](https://support.google.com/cloud/answer/6158840).
      This field has been deprecated
       *        and replaced by the name field.
       * @param zone Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return
       *        operations for.
      This field has been deprecated and replaced by the name field.
       * @return the request
       */
      public GetServerconfig getServerconfig(java.lang.String projectId, java.lang.String zone) throws java.io.IOException {
        GetServerconfig result = new GetServerconfig(projectId, zone);
        initialize(result);
        return result;
      }

      public class GetServerconfig extends ContainerRequest<com.google.api.services.container.model.ServerConfig> {

        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/serverconfig";

        /**
         * Returns configuration info about the Google Kubernetes Engine service.
         *
         * Create a request for the method "zones.getServerconfig".
         *
         * This request holds the parameters needed by the the container server.  After setting any
         * optional parameters, call the {@link GetServerconfig#execute()} method to invoke the remote
         * operation. <p> {@link GetServerconfig#initialize(com.google.api.client.googleapis.services.Abst
         * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
         * the constructor. </p>
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
       *        number](https://support.google.com/cloud/answer/6158840).
      This field has been deprecated
       *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return
       *        operations for.
      This field has been deprecated and replaced by the name field.
         * @since 1.13
         */
        protected GetServerconfig(java.lang.String projectId, java.lang.String zone) {
          super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.ServerConfig.class);
          this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
          this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetServerconfig set$Xgafv(java.lang.String $Xgafv) {
          return (GetServerconfig) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetServerconfig setAccessToken(java.lang.String accessToken) {
          return (GetServerconfig) super.setAccessToken(accessToken);
        }

        @Override
        public GetServerconfig setAlt(java.lang.String alt) {
          return (GetServerconfig) super.setAlt(alt);
        }

        @Override
        public GetServerconfig setCallback(java.lang.String callback) {
          return (GetServerconfig) super.setCallback(callback);
        }

        @Override
        public GetServerconfig setFields(java.lang.String fields) {
          return (GetServerconfig) super.setFields(fields);
        }

        @Override
        public GetServerconfig setKey(java.lang.String key) {
          return (GetServerconfig) super.setKey(key);
        }

        @Override
        public GetServerconfig setOauthToken(java.lang.String oauthToken) {
          return (GetServerconfig) super.setOauthToken(oauthToken);
        }

        @Override
        public GetServerconfig setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetServerconfig) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetServerconfig setQuotaUser(java.lang.String quotaUser) {
          return (GetServerconfig) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetServerconfig setUploadType(java.lang.String uploadType) {
          return (GetServerconfig) super.setUploadType(uploadType);
        }

        @Override
        public GetServerconfig setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetServerconfig) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Deprecated. The Google Developers Console [project ID or project
         * number](https://support.google.com/cloud/answer/6158840). This field has been deprecated
         * and replaced by the name field.
         */
        @com.google.api.client.util.Key
        private java.lang.String projectId;

        /** Deprecated. The Google Developers Console [project ID or project
       number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
       replaced by the name field.
         */
        public java.lang.String getProjectId() {
          return projectId;
        }

        /**
         * Deprecated. The Google Developers Console [project ID or project
         * number](https://support.google.com/cloud/answer/6158840). This field has been deprecated
         * and replaced by the name field.
         */
        public GetServerconfig setProjectId(java.lang.String projectId) {
          this.projectId = projectId;
          return this;
        }

        /**
         * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
         * to return operations for. This field has been deprecated and replaced by the name field.
         */
        @com.google.api.client.util.Key
        private java.lang.String zone;

        /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) to return
       operations for. This field has been deprecated and replaced by the name field.
         */
        public java.lang.String getZone() {
          return zone;
        }

        /**
         * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
         * to return operations for. This field has been deprecated and replaced by the name field.
         */
        public GetServerconfig setZone(java.lang.String zone) {
          this.zone = zone;
          return this;
        }

        /**
         * The name (project and location) of the server config to get, specified in the format
         * 'projects/locations'.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name (project and location) of the server config to get, specified in the format
       'projects/locations'.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The name (project and location) of the server config to get, specified in the format
         * 'projects/locations'.
         */
        public GetServerconfig setName(java.lang.String name) {
          this.name = name;
          return this;
        }

        @Override
        public GetServerconfig set(String parameterName, Object value) {
          return (GetServerconfig) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Clusters collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Container container = new Container(...);}
       *   {@code Container.Clusters.List request = container.clusters().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Clusters clusters() {
        return new Clusters();
      }

      /**
       * The "clusters" collection of methods.
       */
      public class Clusters {

        /**
         * Sets the addons for a specific cluster.
         *
         * Create a request for the method "clusters.addons".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Addons#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
         * @param content the {@link com.google.api.services.container.model.SetAddonsConfigRequest}
         * @return the request
         */
        public Addons addons(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetAddonsConfigRequest content) throws java.io.IOException {
          Addons result = new Addons(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class Addons extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/addons";

          /**
           * Sets the addons for a specific cluster.
           *
           * Create a request for the method "clusters.addons".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Addons#execute()} method to invoke the remote operation.
           * <p> {@link
           * Addons#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
           * @param content the {@link com.google.api.services.container.model.SetAddonsConfigRequest}
           * @since 1.13
           */
          protected Addons(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetAddonsConfigRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public Addons set$Xgafv(java.lang.String $Xgafv) {
            return (Addons) super.set$Xgafv($Xgafv);
          }

          @Override
          public Addons setAccessToken(java.lang.String accessToken) {
            return (Addons) super.setAccessToken(accessToken);
          }

          @Override
          public Addons setAlt(java.lang.String alt) {
            return (Addons) super.setAlt(alt);
          }

          @Override
          public Addons setCallback(java.lang.String callback) {
            return (Addons) super.setCallback(callback);
          }

          @Override
          public Addons setFields(java.lang.String fields) {
            return (Addons) super.setFields(fields);
          }

          @Override
          public Addons setKey(java.lang.String key) {
            return (Addons) super.setKey(key);
          }

          @Override
          public Addons setOauthToken(java.lang.String oauthToken) {
            return (Addons) super.setOauthToken(oauthToken);
          }

          @Override
          public Addons setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Addons) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Addons setQuotaUser(java.lang.String quotaUser) {
            return (Addons) super.setQuotaUser(quotaUser);
          }

          @Override
          public Addons setUploadType(java.lang.String uploadType) {
            return (Addons) super.setUploadType(uploadType);
          }

          @Override
          public Addons setUploadProtocol(java.lang.String uploadProtocol) {
            return (Addons) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Addons setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Addons setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          public Addons setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public Addons set(String parameterName, Object value) {
            return (Addons) super.set(parameterName, value);
          }
        }
        /**
         * Completes master IP rotation.
         *
         * Create a request for the method "clusters.completeIpRotation".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link CompleteIpRotation#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://developers.google.com/console/help/new/#projectnumber).
        This field has
         *        been deprecated and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster.
        This field has been deprecated and replaced by the name field.
         * @param content the {@link com.google.api.services.container.model.CompleteIPRotationRequest}
         * @return the request
         */
        public CompleteIpRotation completeIpRotation(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.CompleteIPRotationRequest content) throws java.io.IOException {
          CompleteIpRotation result = new CompleteIpRotation(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class CompleteIpRotation extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:completeIpRotation";

          /**
           * Completes master IP rotation.
           *
           * Create a request for the method "clusters.completeIpRotation".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link CompleteIpRotation#execute()} method to invoke the remote
           * operation. <p> {@link CompleteIpRotation#initialize(com.google.api.client.googleapis.services.A
           * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://developers.google.com/console/help/new/#projectnumber).
        This field has
         *        been deprecated and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster.
        This field has been deprecated and replaced by the name field.
           * @param content the {@link com.google.api.services.container.model.CompleteIPRotationRequest}
           * @since 1.13
           */
          protected CompleteIpRotation(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.CompleteIPRotationRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public CompleteIpRotation set$Xgafv(java.lang.String $Xgafv) {
            return (CompleteIpRotation) super.set$Xgafv($Xgafv);
          }

          @Override
          public CompleteIpRotation setAccessToken(java.lang.String accessToken) {
            return (CompleteIpRotation) super.setAccessToken(accessToken);
          }

          @Override
          public CompleteIpRotation setAlt(java.lang.String alt) {
            return (CompleteIpRotation) super.setAlt(alt);
          }

          @Override
          public CompleteIpRotation setCallback(java.lang.String callback) {
            return (CompleteIpRotation) super.setCallback(callback);
          }

          @Override
          public CompleteIpRotation setFields(java.lang.String fields) {
            return (CompleteIpRotation) super.setFields(fields);
          }

          @Override
          public CompleteIpRotation setKey(java.lang.String key) {
            return (CompleteIpRotation) super.setKey(key);
          }

          @Override
          public CompleteIpRotation setOauthToken(java.lang.String oauthToken) {
            return (CompleteIpRotation) super.setOauthToken(oauthToken);
          }

          @Override
          public CompleteIpRotation setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (CompleteIpRotation) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public CompleteIpRotation setQuotaUser(java.lang.String quotaUser) {
            return (CompleteIpRotation) super.setQuotaUser(quotaUser);
          }

          @Override
          public CompleteIpRotation setUploadType(java.lang.String uploadType) {
            return (CompleteIpRotation) super.setUploadType(uploadType);
          }

          @Override
          public CompleteIpRotation setUploadProtocol(java.lang.String uploadProtocol) {
            return (CompleteIpRotation) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://developers.google.com/console/help/new/#projectnumber). This field has
           * been deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://developers.google.com/console/help/new/#projectnumber). This field has been
         deprecated and replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://developers.google.com/console/help/new/#projectnumber). This field has
           * been deprecated and replaced by the name field.
           */
          public CompleteIpRotation setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public CompleteIpRotation setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster. This field has been deprecated and replaced by the
           * name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster. This field has been deprecated and replaced by the
           * name field.
           */
          public CompleteIpRotation setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public CompleteIpRotation set(String parameterName, Object value) {
            return (CompleteIpRotation) super.set(parameterName, value);
          }
        }
        /**
         * Creates a cluster, consisting of the specified number and type of Google Compute Engine
         * instances.
         *
         * By default, the cluster is created in the project's [default network](/compute/docs/networks-and-
         * firewalls#networks).
         *
         * One firewall is added for the cluster. After cluster creation, the Kubelet creates routes for
         * each node to allow the containers on that node to communicate with all other instances in the
         * cluster.
         *
         * Finally, an entry is added to the project's global metadata indicating which CIDR range the
         * cluster is using.
         *
         * Create a request for the method "clusters.create".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the parent field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the parent field.
         * @param content the {@link com.google.api.services.container.model.CreateClusterRequest}
         * @return the request
         */
        public Create create(java.lang.String projectId, java.lang.String zone, com.google.api.services.container.model.CreateClusterRequest content) throws java.io.IOException {
          Create result = new Create(projectId, zone, content);
          initialize(result);
          return result;
        }

        public class Create extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters";

          /**
           * Creates a cluster, consisting of the specified number and type of Google Compute Engine
           * instances.
           *
           * By default, the cluster is created in the project's [default network](/compute/docs/networks-
           * and-firewalls#networks).
           *
           * One firewall is added for the cluster. After cluster creation, the Kubelet creates routes for
           * each node to allow the containers on that node to communicate with all other instances in the
           * cluster.
           *
           * Finally, an entry is added to the project's global metadata indicating which CIDR range the
           * cluster is using.
           *
           * Create a request for the method "clusters.create".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the parent field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the parent field.
           * @param content the {@link com.google.api.services.container.model.CreateClusterRequest}
           * @since 1.13
           */
          protected Create(java.lang.String projectId, java.lang.String zone, com.google.api.services.container.model.CreateClusterRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the parent field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the parent field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the parent field.
           */
          public Create setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the parent
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the parent field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the parent
           * field.
           */
          public Create setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes the cluster, including the Kubernetes endpoint and all worker nodes.
         *
         * Firewalls and routes that were configured during cluster creation are also deleted.
         *
         * Other Google Compute Engine resources that might be in use by the cluster, such as load balancer
         * resources, are not deleted if they weren't present when the cluster was initially created.
         *
         * Create a request for the method "clusters.delete".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster to delete.
        This field has been deprecated and replaced by the
         *        name field.
         * @return the request
         */
        public Delete delete(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId) throws java.io.IOException {
          Delete result = new Delete(projectId, zone, clusterId);
          initialize(result);
          return result;
        }

        public class Delete extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}";

          /**
           * Deletes the cluster, including the Kubernetes endpoint and all worker nodes.
           *
           * Firewalls and routes that were configured during cluster creation are also deleted.
           *
           * Other Google Compute Engine resources that might be in use by the cluster, such as load
           * balancer resources, are not deleted if they weren't present when the cluster was initially
           * created.
           *
           * Create a request for the method "clusters.delete".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to delete.
        This field has been deprecated and replaced by the
         *        name field.
           * @since 1.13
           */
          protected Delete(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId) {
            super(Container.this, "DELETE", REST_PATH, null, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Delete setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Delete setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to delete. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to delete. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to delete. This field has been deprecated and
           * replaced by the name field.
           */
          public Delete setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          /**
           * The name (project, location, cluster) of the cluster to delete. Specified in the format
           * 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to delete. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to delete. Specified in the format
           * 'projects/locations/clusters'.
           */
          public Delete setName(java.lang.String name) {
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the details of a specific cluster.
         *
         * Create a request for the method "clusters.get".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster to retrieve.
        This field has been deprecated and replaced by the
         *        name field.
         * @return the request
         */
        public Get get(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId) throws java.io.IOException {
          Get result = new Get(projectId, zone, clusterId);
          initialize(result);
          return result;
        }

        public class Get extends ContainerRequest<com.google.api.services.container.model.Cluster> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}";

          /**
           * Gets the details of a specific cluster.
           *
           * Create a request for the method "clusters.get".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to retrieve.
        This field has been deprecated and replaced by the
         *        name field.
           * @since 1.13
           */
          protected Get(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId) {
            super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.Cluster.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Get setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Get setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to retrieve. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to retrieve. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to retrieve. This field has been deprecated and
           * replaced by the name field.
           */
          public Get setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          /**
           * The name (project, location, cluster) of the cluster to retrieve. Specified in the
           * format 'projects/locations/clusters'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, cluster) of the cluster to retrieve. Specified in the format
         'projects/locations/clusters'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, cluster) of the cluster to retrieve. Specified in the
           * format 'projects/locations/clusters'.
           */
          public Get setName(java.lang.String name) {
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Enables or disables the ABAC authorization mechanism on a cluster.
         *
         * Create a request for the method "clusters.legacyAbac".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link LegacyAbac#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster to update.
        This field has been deprecated and replaced by the
         *        name field.
         * @param content the {@link com.google.api.services.container.model.SetLegacyAbacRequest}
         * @return the request
         */
        public LegacyAbac legacyAbac(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetLegacyAbacRequest content) throws java.io.IOException {
          LegacyAbac result = new LegacyAbac(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class LegacyAbac extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/legacyAbac";

          /**
           * Enables or disables the ABAC authorization mechanism on a cluster.
           *
           * Create a request for the method "clusters.legacyAbac".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link LegacyAbac#execute()} method to invoke the remote
           * operation. <p> {@link
           * LegacyAbac#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to update.
        This field has been deprecated and replaced by the
         *        name field.
           * @param content the {@link com.google.api.services.container.model.SetLegacyAbacRequest}
           * @since 1.13
           */
          protected LegacyAbac(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetLegacyAbacRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public LegacyAbac set$Xgafv(java.lang.String $Xgafv) {
            return (LegacyAbac) super.set$Xgafv($Xgafv);
          }

          @Override
          public LegacyAbac setAccessToken(java.lang.String accessToken) {
            return (LegacyAbac) super.setAccessToken(accessToken);
          }

          @Override
          public LegacyAbac setAlt(java.lang.String alt) {
            return (LegacyAbac) super.setAlt(alt);
          }

          @Override
          public LegacyAbac setCallback(java.lang.String callback) {
            return (LegacyAbac) super.setCallback(callback);
          }

          @Override
          public LegacyAbac setFields(java.lang.String fields) {
            return (LegacyAbac) super.setFields(fields);
          }

          @Override
          public LegacyAbac setKey(java.lang.String key) {
            return (LegacyAbac) super.setKey(key);
          }

          @Override
          public LegacyAbac setOauthToken(java.lang.String oauthToken) {
            return (LegacyAbac) super.setOauthToken(oauthToken);
          }

          @Override
          public LegacyAbac setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (LegacyAbac) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public LegacyAbac setQuotaUser(java.lang.String quotaUser) {
            return (LegacyAbac) super.setQuotaUser(quotaUser);
          }

          @Override
          public LegacyAbac setUploadType(java.lang.String uploadType) {
            return (LegacyAbac) super.setUploadType(uploadType);
          }

          @Override
          public LegacyAbac setUploadProtocol(java.lang.String uploadProtocol) {
            return (LegacyAbac) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public LegacyAbac setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public LegacyAbac setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to update. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to update. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to update. This field has been deprecated and
           * replaced by the name field.
           */
          public LegacyAbac setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public LegacyAbac set(String parameterName, Object value) {
            return (LegacyAbac) super.set(parameterName, value);
          }
        }
        /**
         * Lists all clusters owned by a project in either the specified zone or all zones.
         *
         * Create a request for the method "clusters.list".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the parent field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides, or "-" for all zones.
        This field has been deprecated and replaced by the
         *        parent field.
         * @return the request
         */
        public List list(java.lang.String projectId, java.lang.String zone) throws java.io.IOException {
          List result = new List(projectId, zone);
          initialize(result);
          return result;
        }

        public class List extends ContainerRequest<com.google.api.services.container.model.ListClustersResponse> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters";

          /**
           * Lists all clusters owned by a project in either the specified zone or all zones.
           *
           * Create a request for the method "clusters.list".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the parent field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides, or "-" for all zones.
        This field has been deprecated and replaced by the
         *        parent field.
           * @since 1.13
           */
          protected List(java.lang.String projectId, java.lang.String zone) {
            super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.ListClustersResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the parent field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the parent field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the parent field.
           */
          public List setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides, or "-" for all zones. This field has been deprecated and
           * replaced by the parent field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides, or "-" for all zones. This field has been deprecated and replaced by the
         parent field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides, or "-" for all zones. This field has been deprecated and
           * replaced by the parent field.
           */
          public List setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * The parent (project and location) where the clusters will be listed. Specified in the
           * format 'projects/locations'. Location "-" matches all zones and all regions.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The parent (project and location) where the clusters will be listed. Specified in the format
         'projects/locations'. Location "-" matches all zones and all regions.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * The parent (project and location) where the clusters will be listed. Specified in the
           * format 'projects/locations'. Location "-" matches all zones and all regions.
           */
          public List setParent(java.lang.String parent) {
            this.parent = parent;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Sets the locations for a specific cluster. Deprecated. Use [projects.locations.clusters.update
         * ](/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.update) instead.
         *
         * Create a request for the method "clusters.locations".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Locations#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
         * @param content the {@link com.google.api.services.container.model.SetLocationsRequest}
         * @return the request
         */
        public Locations locations(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetLocationsRequest content) throws java.io.IOException {
          Locations result = new Locations(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class Locations extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/locations";

          /**
           * Sets the locations for a specific cluster. Deprecated. Use [projects.locations.clusters.update
           * ](/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.update) instead.
           *
           * Create a request for the method "clusters.locations".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Locations#execute()} method to invoke the remote
           * operation. <p> {@link
           * Locations#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
           * @param content the {@link com.google.api.services.container.model.SetLocationsRequest}
           * @since 1.13
           */
          protected Locations(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetLocationsRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public Locations set$Xgafv(java.lang.String $Xgafv) {
            return (Locations) super.set$Xgafv($Xgafv);
          }

          @Override
          public Locations setAccessToken(java.lang.String accessToken) {
            return (Locations) super.setAccessToken(accessToken);
          }

          @Override
          public Locations setAlt(java.lang.String alt) {
            return (Locations) super.setAlt(alt);
          }

          @Override
          public Locations setCallback(java.lang.String callback) {
            return (Locations) super.setCallback(callback);
          }

          @Override
          public Locations setFields(java.lang.String fields) {
            return (Locations) super.setFields(fields);
          }

          @Override
          public Locations setKey(java.lang.String key) {
            return (Locations) super.setKey(key);
          }

          @Override
          public Locations setOauthToken(java.lang.String oauthToken) {
            return (Locations) super.setOauthToken(oauthToken);
          }

          @Override
          public Locations setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Locations) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Locations setQuotaUser(java.lang.String quotaUser) {
            return (Locations) super.setQuotaUser(quotaUser);
          }

          @Override
          public Locations setUploadType(java.lang.String uploadType) {
            return (Locations) super.setUploadType(uploadType);
          }

          @Override
          public Locations setUploadProtocol(java.lang.String uploadProtocol) {
            return (Locations) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Locations setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Locations setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          public Locations setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public Locations set(String parameterName, Object value) {
            return (Locations) super.set(parameterName, value);
          }
        }
        /**
         * Sets the logging service for a specific cluster.
         *
         * Create a request for the method "clusters.logging".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Logging#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
         * @param content the {@link com.google.api.services.container.model.SetLoggingServiceRequest}
         * @return the request
         */
        public Logging logging(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetLoggingServiceRequest content) throws java.io.IOException {
          Logging result = new Logging(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class Logging extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/logging";

          /**
           * Sets the logging service for a specific cluster.
           *
           * Create a request for the method "clusters.logging".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Logging#execute()} method to invoke the remote operation.
           * <p> {@link
           * Logging#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
           * @param content the {@link com.google.api.services.container.model.SetLoggingServiceRequest}
           * @since 1.13
           */
          protected Logging(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetLoggingServiceRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public Logging set$Xgafv(java.lang.String $Xgafv) {
            return (Logging) super.set$Xgafv($Xgafv);
          }

          @Override
          public Logging setAccessToken(java.lang.String accessToken) {
            return (Logging) super.setAccessToken(accessToken);
          }

          @Override
          public Logging setAlt(java.lang.String alt) {
            return (Logging) super.setAlt(alt);
          }

          @Override
          public Logging setCallback(java.lang.String callback) {
            return (Logging) super.setCallback(callback);
          }

          @Override
          public Logging setFields(java.lang.String fields) {
            return (Logging) super.setFields(fields);
          }

          @Override
          public Logging setKey(java.lang.String key) {
            return (Logging) super.setKey(key);
          }

          @Override
          public Logging setOauthToken(java.lang.String oauthToken) {
            return (Logging) super.setOauthToken(oauthToken);
          }

          @Override
          public Logging setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Logging) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Logging setQuotaUser(java.lang.String quotaUser) {
            return (Logging) super.setQuotaUser(quotaUser);
          }

          @Override
          public Logging setUploadType(java.lang.String uploadType) {
            return (Logging) super.setUploadType(uploadType);
          }

          @Override
          public Logging setUploadProtocol(java.lang.String uploadProtocol) {
            return (Logging) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Logging setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Logging setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          public Logging setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public Logging set(String parameterName, Object value) {
            return (Logging) super.set(parameterName, value);
          }
        }
        /**
         * Updates the master for a specific cluster.
         *
         * Create a request for the method "clusters.master".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Master#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
         * @param content the {@link com.google.api.services.container.model.UpdateMasterRequest}
         * @return the request
         */
        public Master master(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.UpdateMasterRequest content) throws java.io.IOException {
          Master result = new Master(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class Master extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/master";

          /**
           * Updates the master for a specific cluster.
           *
           * Create a request for the method "clusters.master".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Master#execute()} method to invoke the remote operation.
           * <p> {@link
           * Master#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
           * @param content the {@link com.google.api.services.container.model.UpdateMasterRequest}
           * @since 1.13
           */
          protected Master(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.UpdateMasterRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public Master set$Xgafv(java.lang.String $Xgafv) {
            return (Master) super.set$Xgafv($Xgafv);
          }

          @Override
          public Master setAccessToken(java.lang.String accessToken) {
            return (Master) super.setAccessToken(accessToken);
          }

          @Override
          public Master setAlt(java.lang.String alt) {
            return (Master) super.setAlt(alt);
          }

          @Override
          public Master setCallback(java.lang.String callback) {
            return (Master) super.setCallback(callback);
          }

          @Override
          public Master setFields(java.lang.String fields) {
            return (Master) super.setFields(fields);
          }

          @Override
          public Master setKey(java.lang.String key) {
            return (Master) super.setKey(key);
          }

          @Override
          public Master setOauthToken(java.lang.String oauthToken) {
            return (Master) super.setOauthToken(oauthToken);
          }

          @Override
          public Master setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Master) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Master setQuotaUser(java.lang.String quotaUser) {
            return (Master) super.setQuotaUser(quotaUser);
          }

          @Override
          public Master setUploadType(java.lang.String uploadType) {
            return (Master) super.setUploadType(uploadType);
          }

          @Override
          public Master setUploadProtocol(java.lang.String uploadProtocol) {
            return (Master) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Master setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Master setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          public Master setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public Master set(String parameterName, Object value) {
            return (Master) super.set(parameterName, value);
          }
        }
        /**
         * Sets the monitoring service for a specific cluster.
         *
         * Create a request for the method "clusters.monitoring".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Monitoring#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
         * @param content the {@link com.google.api.services.container.model.SetMonitoringServiceRequest}
         * @return the request
         */
        public Monitoring monitoring(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetMonitoringServiceRequest content) throws java.io.IOException {
          Monitoring result = new Monitoring(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class Monitoring extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/monitoring";

          /**
           * Sets the monitoring service for a specific cluster.
           *
           * Create a request for the method "clusters.monitoring".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Monitoring#execute()} method to invoke the remote
           * operation. <p> {@link
           * Monitoring#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
           * @param content the {@link com.google.api.services.container.model.SetMonitoringServiceRequest}
           * @since 1.13
           */
          protected Monitoring(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetMonitoringServiceRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public Monitoring set$Xgafv(java.lang.String $Xgafv) {
            return (Monitoring) super.set$Xgafv($Xgafv);
          }

          @Override
          public Monitoring setAccessToken(java.lang.String accessToken) {
            return (Monitoring) super.setAccessToken(accessToken);
          }

          @Override
          public Monitoring setAlt(java.lang.String alt) {
            return (Monitoring) super.setAlt(alt);
          }

          @Override
          public Monitoring setCallback(java.lang.String callback) {
            return (Monitoring) super.setCallback(callback);
          }

          @Override
          public Monitoring setFields(java.lang.String fields) {
            return (Monitoring) super.setFields(fields);
          }

          @Override
          public Monitoring setKey(java.lang.String key) {
            return (Monitoring) super.setKey(key);
          }

          @Override
          public Monitoring setOauthToken(java.lang.String oauthToken) {
            return (Monitoring) super.setOauthToken(oauthToken);
          }

          @Override
          public Monitoring setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Monitoring) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Monitoring setQuotaUser(java.lang.String quotaUser) {
            return (Monitoring) super.setQuotaUser(quotaUser);
          }

          @Override
          public Monitoring setUploadType(java.lang.String uploadType) {
            return (Monitoring) super.setUploadType(uploadType);
          }

          @Override
          public Monitoring setUploadProtocol(java.lang.String uploadProtocol) {
            return (Monitoring) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Monitoring setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Monitoring setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          public Monitoring setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public Monitoring set(String parameterName, Object value) {
            return (Monitoring) super.set(parameterName, value);
          }
        }
        /**
         * Sets labels on a cluster.
         *
         * Create a request for the method "clusters.resourceLabels".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link ResourceLabels#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://developers.google.com/console/help/new/#projectnumber).
        This field has
         *        been deprecated and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster.
        This field has been deprecated and replaced by the name field.
         * @param content the {@link com.google.api.services.container.model.SetLabelsRequest}
         * @return the request
         */
        public ResourceLabels resourceLabels(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetLabelsRequest content) throws java.io.IOException {
          ResourceLabels result = new ResourceLabels(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class ResourceLabels extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/resourceLabels";

          /**
           * Sets labels on a cluster.
           *
           * Create a request for the method "clusters.resourceLabels".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link ResourceLabels#execute()} method to invoke the remote
           * operation. <p> {@link ResourceLabels#initialize(com.google.api.client.googleapis.services.Abstr
           * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://developers.google.com/console/help/new/#projectnumber).
        This field has
         *        been deprecated and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster.
        This field has been deprecated and replaced by the name field.
           * @param content the {@link com.google.api.services.container.model.SetLabelsRequest}
           * @since 1.13
           */
          protected ResourceLabels(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetLabelsRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public ResourceLabels set$Xgafv(java.lang.String $Xgafv) {
            return (ResourceLabels) super.set$Xgafv($Xgafv);
          }

          @Override
          public ResourceLabels setAccessToken(java.lang.String accessToken) {
            return (ResourceLabels) super.setAccessToken(accessToken);
          }

          @Override
          public ResourceLabels setAlt(java.lang.String alt) {
            return (ResourceLabels) super.setAlt(alt);
          }

          @Override
          public ResourceLabels setCallback(java.lang.String callback) {
            return (ResourceLabels) super.setCallback(callback);
          }

          @Override
          public ResourceLabels setFields(java.lang.String fields) {
            return (ResourceLabels) super.setFields(fields);
          }

          @Override
          public ResourceLabels setKey(java.lang.String key) {
            return (ResourceLabels) super.setKey(key);
          }

          @Override
          public ResourceLabels setOauthToken(java.lang.String oauthToken) {
            return (ResourceLabels) super.setOauthToken(oauthToken);
          }

          @Override
          public ResourceLabels setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (ResourceLabels) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public ResourceLabels setQuotaUser(java.lang.String quotaUser) {
            return (ResourceLabels) super.setQuotaUser(quotaUser);
          }

          @Override
          public ResourceLabels setUploadType(java.lang.String uploadType) {
            return (ResourceLabels) super.setUploadType(uploadType);
          }

          @Override
          public ResourceLabels setUploadProtocol(java.lang.String uploadProtocol) {
            return (ResourceLabels) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://developers.google.com/console/help/new/#projectnumber). This field has
           * been deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://developers.google.com/console/help/new/#projectnumber). This field has been
         deprecated and replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://developers.google.com/console/help/new/#projectnumber). This field has
           * been deprecated and replaced by the name field.
           */
          public ResourceLabels setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public ResourceLabels setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster. This field has been deprecated and replaced by the
           * name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster. This field has been deprecated and replaced by the
           * name field.
           */
          public ResourceLabels setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public ResourceLabels set(String parameterName, Object value) {
            return (ResourceLabels) super.set(parameterName, value);
          }
        }
        /**
         * Sets the maintenance policy for a cluster.
         *
         * Create a request for the method "clusters.setMaintenancePolicy".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetMaintenancePolicy#execute()} method to invoke the remote
         * operation.
         *
         * @param projectId Required. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
         * @param zone Required. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
         * @param clusterId Required. The name of the cluster to update.
         * @param content the {@link com.google.api.services.container.model.SetMaintenancePolicyRequest}
         * @return the request
         */
        public SetMaintenancePolicy setMaintenancePolicy(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetMaintenancePolicyRequest content) throws java.io.IOException {
          SetMaintenancePolicy result = new SetMaintenancePolicy(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class SetMaintenancePolicy extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMaintenancePolicy";

          /**
           * Sets the maintenance policy for a cluster.
           *
           * Create a request for the method "clusters.setMaintenancePolicy".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetMaintenancePolicy#execute()} method to invoke the
           * remote operation. <p> {@link SetMaintenancePolicy#initialize(com.google.api.client.googleapis.s
           * ervices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
           * after invoking the constructor. </p>
           *
           * @param projectId Required. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
           * @param zone Required. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
           * @param clusterId Required. The name of the cluster to update.
           * @param content the {@link com.google.api.services.container.model.SetMaintenancePolicyRequest}
           * @since 1.13
           */
          protected SetMaintenancePolicy(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetMaintenancePolicyRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public SetMaintenancePolicy set$Xgafv(java.lang.String $Xgafv) {
            return (SetMaintenancePolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetMaintenancePolicy setAccessToken(java.lang.String accessToken) {
            return (SetMaintenancePolicy) super.setAccessToken(accessToken);
          }

          @Override
          public SetMaintenancePolicy setAlt(java.lang.String alt) {
            return (SetMaintenancePolicy) super.setAlt(alt);
          }

          @Override
          public SetMaintenancePolicy setCallback(java.lang.String callback) {
            return (SetMaintenancePolicy) super.setCallback(callback);
          }

          @Override
          public SetMaintenancePolicy setFields(java.lang.String fields) {
            return (SetMaintenancePolicy) super.setFields(fields);
          }

          @Override
          public SetMaintenancePolicy setKey(java.lang.String key) {
            return (SetMaintenancePolicy) super.setKey(key);
          }

          @Override
          public SetMaintenancePolicy setOauthToken(java.lang.String oauthToken) {
            return (SetMaintenancePolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public SetMaintenancePolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetMaintenancePolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetMaintenancePolicy setQuotaUser(java.lang.String quotaUser) {
            return (SetMaintenancePolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetMaintenancePolicy setUploadType(java.lang.String uploadType) {
            return (SetMaintenancePolicy) super.setUploadType(uploadType);
          }

          @Override
          public SetMaintenancePolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetMaintenancePolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840).
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840).
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Required. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840).
           */
          public SetMaintenancePolicy setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Required. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Required. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which the
         cluster resides.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Required. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides.
           */
          public SetMaintenancePolicy setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /** Required. The name of the cluster to update. */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Required. The name of the cluster to update.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /** Required. The name of the cluster to update. */
          public SetMaintenancePolicy setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public SetMaintenancePolicy set(String parameterName, Object value) {
            return (SetMaintenancePolicy) super.set(parameterName, value);
          }
        }
        /**
         * Sets master auth materials. Currently supports changing the admin password or a specific cluster,
         * either via password generation or explicitly setting the password.
         *
         * Create a request for the method "clusters.setMasterAuth".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetMasterAuth#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
         * @param content the {@link com.google.api.services.container.model.SetMasterAuthRequest}
         * @return the request
         */
        public SetMasterAuth setMasterAuth(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetMasterAuthRequest content) throws java.io.IOException {
          SetMasterAuth result = new SetMasterAuth(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class SetMasterAuth extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMasterAuth";

          /**
           * Sets master auth materials. Currently supports changing the admin password or a specific
           * cluster, either via password generation or explicitly setting the password.
           *
           * Create a request for the method "clusters.setMasterAuth".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetMasterAuth#execute()} method to invoke the remote
           * operation. <p> {@link SetMasterAuth#initialize(com.google.api.client.googleapis.services.Abstra
           * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
           * @param content the {@link com.google.api.services.container.model.SetMasterAuthRequest}
           * @since 1.13
           */
          protected SetMasterAuth(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetMasterAuthRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public SetMasterAuth set$Xgafv(java.lang.String $Xgafv) {
            return (SetMasterAuth) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetMasterAuth setAccessToken(java.lang.String accessToken) {
            return (SetMasterAuth) super.setAccessToken(accessToken);
          }

          @Override
          public SetMasterAuth setAlt(java.lang.String alt) {
            return (SetMasterAuth) super.setAlt(alt);
          }

          @Override
          public SetMasterAuth setCallback(java.lang.String callback) {
            return (SetMasterAuth) super.setCallback(callback);
          }

          @Override
          public SetMasterAuth setFields(java.lang.String fields) {
            return (SetMasterAuth) super.setFields(fields);
          }

          @Override
          public SetMasterAuth setKey(java.lang.String key) {
            return (SetMasterAuth) super.setKey(key);
          }

          @Override
          public SetMasterAuth setOauthToken(java.lang.String oauthToken) {
            return (SetMasterAuth) super.setOauthToken(oauthToken);
          }

          @Override
          public SetMasterAuth setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetMasterAuth) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetMasterAuth setQuotaUser(java.lang.String quotaUser) {
            return (SetMasterAuth) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetMasterAuth setUploadType(java.lang.String uploadType) {
            return (SetMasterAuth) super.setUploadType(uploadType);
          }

          @Override
          public SetMasterAuth setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetMasterAuth) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public SetMasterAuth setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public SetMasterAuth setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          public SetMasterAuth setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public SetMasterAuth set(String parameterName, Object value) {
            return (SetMasterAuth) super.set(parameterName, value);
          }
        }
        /**
         * Enables or disables Network Policy for a cluster.
         *
         * Create a request for the method "clusters.setNetworkPolicy".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link SetNetworkPolicy#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://developers.google.com/console/help/new/#projectnumber).
        This field has
         *        been deprecated and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster.
        This field has been deprecated and replaced by the name field.
         * @param content the {@link com.google.api.services.container.model.SetNetworkPolicyRequest}
         * @return the request
         */
        public SetNetworkPolicy setNetworkPolicy(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetNetworkPolicyRequest content) throws java.io.IOException {
          SetNetworkPolicy result = new SetNetworkPolicy(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class SetNetworkPolicy extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setNetworkPolicy";

          /**
           * Enables or disables Network Policy for a cluster.
           *
           * Create a request for the method "clusters.setNetworkPolicy".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link SetNetworkPolicy#execute()} method to invoke the remote
           * operation. <p> {@link SetNetworkPolicy#initialize(com.google.api.client.googleapis.services.Abs
           * tractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://developers.google.com/console/help/new/#projectnumber).
        This field has
         *        been deprecated and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster.
        This field has been deprecated and replaced by the name field.
           * @param content the {@link com.google.api.services.container.model.SetNetworkPolicyRequest}
           * @since 1.13
           */
          protected SetNetworkPolicy(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.SetNetworkPolicyRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public SetNetworkPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (SetNetworkPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetNetworkPolicy setAccessToken(java.lang.String accessToken) {
            return (SetNetworkPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public SetNetworkPolicy setAlt(java.lang.String alt) {
            return (SetNetworkPolicy) super.setAlt(alt);
          }

          @Override
          public SetNetworkPolicy setCallback(java.lang.String callback) {
            return (SetNetworkPolicy) super.setCallback(callback);
          }

          @Override
          public SetNetworkPolicy setFields(java.lang.String fields) {
            return (SetNetworkPolicy) super.setFields(fields);
          }

          @Override
          public SetNetworkPolicy setKey(java.lang.String key) {
            return (SetNetworkPolicy) super.setKey(key);
          }

          @Override
          public SetNetworkPolicy setOauthToken(java.lang.String oauthToken) {
            return (SetNetworkPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public SetNetworkPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetNetworkPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetNetworkPolicy setQuotaUser(java.lang.String quotaUser) {
            return (SetNetworkPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetNetworkPolicy setUploadType(java.lang.String uploadType) {
            return (SetNetworkPolicy) super.setUploadType(uploadType);
          }

          @Override
          public SetNetworkPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetNetworkPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://developers.google.com/console/help/new/#projectnumber). This field has
           * been deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://developers.google.com/console/help/new/#projectnumber). This field has been
         deprecated and replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://developers.google.com/console/help/new/#projectnumber). This field has
           * been deprecated and replaced by the name field.
           */
          public SetNetworkPolicy setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public SetNetworkPolicy setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster. This field has been deprecated and replaced by the
           * name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster. This field has been deprecated and replaced by the
           * name field.
           */
          public SetNetworkPolicy setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public SetNetworkPolicy set(String parameterName, Object value) {
            return (SetNetworkPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Starts master IP rotation.
         *
         * Create a request for the method "clusters.startIpRotation".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link StartIpRotation#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://developers.google.com/console/help/new/#projectnumber).
        This field has
         *        been deprecated and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster.
        This field has been deprecated and replaced by the name field.
         * @param content the {@link com.google.api.services.container.model.StartIPRotationRequest}
         * @return the request
         */
        public StartIpRotation startIpRotation(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.StartIPRotationRequest content) throws java.io.IOException {
          StartIpRotation result = new StartIpRotation(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class StartIpRotation extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:startIpRotation";

          /**
           * Starts master IP rotation.
           *
           * Create a request for the method "clusters.startIpRotation".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link StartIpRotation#execute()} method to invoke the remote
           * operation. <p> {@link StartIpRotation#initialize(com.google.api.client.googleapis.services.Abst
           * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://developers.google.com/console/help/new/#projectnumber).
        This field has
         *        been deprecated and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster.
        This field has been deprecated and replaced by the name field.
           * @param content the {@link com.google.api.services.container.model.StartIPRotationRequest}
           * @since 1.13
           */
          protected StartIpRotation(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.StartIPRotationRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public StartIpRotation set$Xgafv(java.lang.String $Xgafv) {
            return (StartIpRotation) super.set$Xgafv($Xgafv);
          }

          @Override
          public StartIpRotation setAccessToken(java.lang.String accessToken) {
            return (StartIpRotation) super.setAccessToken(accessToken);
          }

          @Override
          public StartIpRotation setAlt(java.lang.String alt) {
            return (StartIpRotation) super.setAlt(alt);
          }

          @Override
          public StartIpRotation setCallback(java.lang.String callback) {
            return (StartIpRotation) super.setCallback(callback);
          }

          @Override
          public StartIpRotation setFields(java.lang.String fields) {
            return (StartIpRotation) super.setFields(fields);
          }

          @Override
          public StartIpRotation setKey(java.lang.String key) {
            return (StartIpRotation) super.setKey(key);
          }

          @Override
          public StartIpRotation setOauthToken(java.lang.String oauthToken) {
            return (StartIpRotation) super.setOauthToken(oauthToken);
          }

          @Override
          public StartIpRotation setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (StartIpRotation) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public StartIpRotation setQuotaUser(java.lang.String quotaUser) {
            return (StartIpRotation) super.setQuotaUser(quotaUser);
          }

          @Override
          public StartIpRotation setUploadType(java.lang.String uploadType) {
            return (StartIpRotation) super.setUploadType(uploadType);
          }

          @Override
          public StartIpRotation setUploadProtocol(java.lang.String uploadProtocol) {
            return (StartIpRotation) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://developers.google.com/console/help/new/#projectnumber). This field has
           * been deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://developers.google.com/console/help/new/#projectnumber). This field has been
         deprecated and replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://developers.google.com/console/help/new/#projectnumber). This field has
           * been deprecated and replaced by the name field.
           */
          public StartIpRotation setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public StartIpRotation setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster. This field has been deprecated and replaced by the
           * name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster. This field has been deprecated and replaced by the
           * name field.
           */
          public StartIpRotation setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public StartIpRotation set(String parameterName, Object value) {
            return (StartIpRotation) super.set(parameterName, value);
          }
        }
        /**
         * Updates the settings of a specific cluster.
         *
         * Create a request for the method "clusters.update".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
         * @param content the {@link com.google.api.services.container.model.UpdateClusterRequest}
         * @return the request
         */
        public Update update(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.UpdateClusterRequest content) throws java.io.IOException {
          Update result = new Update(projectId, zone, clusterId, content);
          initialize(result);
          return result;
        }

        public class Update extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}";

          /**
           * Updates the settings of a specific cluster.
           *
           * Create a request for the method "clusters.update".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
           * <p> {@link
           * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to upgrade.
        This field has been deprecated and replaced by the
         *        name field.
           * @param content the {@link com.google.api.services.container.model.UpdateClusterRequest}
           * @since 1.13
           */
          protected Update(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.UpdateClusterRequest content) {
            super(Container.this, "PUT", REST_PATH, content, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
          }

          @Override
          public Update set$Xgafv(java.lang.String $Xgafv) {
            return (Update) super.set$Xgafv($Xgafv);
          }

          @Override
          public Update setAccessToken(java.lang.String accessToken) {
            return (Update) super.setAccessToken(accessToken);
          }

          @Override
          public Update setAlt(java.lang.String alt) {
            return (Update) super.setAlt(alt);
          }

          @Override
          public Update setCallback(java.lang.String callback) {
            return (Update) super.setCallback(callback);
          }

          @Override
          public Update setFields(java.lang.String fields) {
            return (Update) super.setFields(fields);
          }

          @Override
          public Update setKey(java.lang.String key) {
            return (Update) super.setKey(key);
          }

          @Override
          public Update setOauthToken(java.lang.String oauthToken) {
            return (Update) super.setOauthToken(oauthToken);
          }

          @Override
          public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Update) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Update setQuotaUser(java.lang.String quotaUser) {
            return (Update) super.setQuotaUser(quotaUser);
          }

          @Override
          public Update setUploadType(java.lang.String uploadType) {
            return (Update) super.setUploadType(uploadType);
          }

          @Override
          public Update setUploadProtocol(java.lang.String uploadProtocol) {
            return (Update) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Update setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Update setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterId;

          /** Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the
         name field.
           */
          public java.lang.String getClusterId() {
            return clusterId;
          }

          /**
           * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
           * replaced by the name field.
           */
          public Update setClusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
          }

          @Override
          public Update set(String parameterName, Object value) {
            return (Update) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the NodePools collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Container container = new Container(...);}
         *   {@code Container.NodePools.List request = container.nodePools().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public NodePools nodePools() {
          return new NodePools();
        }

        /**
         * The "nodePools" collection of methods.
         */
        public class NodePools {

          /**
           * Sets the autoscaling settings for the specified node pool.
           *
           * Create a request for the method "nodePools.autoscaling".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Autoscaling#execute()} method to invoke the remote operation.
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://support.google.com/cloud/answer/6158840).
          This field has been deprecated
           *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to upgrade.
          This field has been deprecated and replaced by the
           *        name field.
           * @param nodePoolId Deprecated. The name of the node pool to upgrade.
          This field has been deprecated and replaced by the
           *        name field.
           * @param content the {@link com.google.api.services.container.model.SetNodePoolAutoscalingRequest}
           * @return the request
           */
          public Autoscaling autoscaling(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId, com.google.api.services.container.model.SetNodePoolAutoscalingRequest content) throws java.io.IOException {
            Autoscaling result = new Autoscaling(projectId, zone, clusterId, nodePoolId, content);
            initialize(result);
            return result;
          }

          public class Autoscaling extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/autoscaling";

            /**
             * Sets the autoscaling settings for the specified node pool.
             *
             * Create a request for the method "nodePools.autoscaling".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Autoscaling#execute()} method to invoke the remote
             * operation. <p> {@link
             * Autoscaling#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://support.google.com/cloud/answer/6158840).
          This field has been deprecated
           *        and replaced by the name field.
             * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
             * @param clusterId Deprecated. The name of the cluster to upgrade.
          This field has been deprecated and replaced by the
           *        name field.
             * @param nodePoolId Deprecated. The name of the node pool to upgrade.
          This field has been deprecated and replaced by the
           *        name field.
             * @param content the {@link com.google.api.services.container.model.SetNodePoolAutoscalingRequest}
             * @since 1.13
             */
            protected Autoscaling(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId, com.google.api.services.container.model.SetNodePoolAutoscalingRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
              this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
              this.nodePoolId = com.google.api.client.util.Preconditions.checkNotNull(nodePoolId, "Required parameter nodePoolId must be specified.");
            }

            @Override
            public Autoscaling set$Xgafv(java.lang.String $Xgafv) {
              return (Autoscaling) super.set$Xgafv($Xgafv);
            }

            @Override
            public Autoscaling setAccessToken(java.lang.String accessToken) {
              return (Autoscaling) super.setAccessToken(accessToken);
            }

            @Override
            public Autoscaling setAlt(java.lang.String alt) {
              return (Autoscaling) super.setAlt(alt);
            }

            @Override
            public Autoscaling setCallback(java.lang.String callback) {
              return (Autoscaling) super.setCallback(callback);
            }

            @Override
            public Autoscaling setFields(java.lang.String fields) {
              return (Autoscaling) super.setFields(fields);
            }

            @Override
            public Autoscaling setKey(java.lang.String key) {
              return (Autoscaling) super.setKey(key);
            }

            @Override
            public Autoscaling setOauthToken(java.lang.String oauthToken) {
              return (Autoscaling) super.setOauthToken(oauthToken);
            }

            @Override
            public Autoscaling setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Autoscaling) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Autoscaling setQuotaUser(java.lang.String quotaUser) {
              return (Autoscaling) super.setQuotaUser(quotaUser);
            }

            @Override
            public Autoscaling setUploadType(java.lang.String uploadType) {
              return (Autoscaling) super.setUploadType(uploadType);
            }

            @Override
            public Autoscaling setUploadProtocol(java.lang.String uploadProtocol) {
              return (Autoscaling) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://support.google.com/cloud/answer/6158840). This field has been
             * deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
           replaced by the name field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://support.google.com/cloud/answer/6158840). This field has been
             * deprecated and replaced by the name field.
             */
            public Autoscaling setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            public Autoscaling setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the
           name field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
             * replaced by the name field.
             */
            public Autoscaling setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            /**
             * Deprecated. The name of the node pool to upgrade. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String nodePoolId;

            /** Deprecated. The name of the node pool to upgrade. This field has been deprecated and replaced by
           the name field.
             */
            public java.lang.String getNodePoolId() {
              return nodePoolId;
            }

            /**
             * Deprecated. The name of the node pool to upgrade. This field has been deprecated and
             * replaced by the name field.
             */
            public Autoscaling setNodePoolId(java.lang.String nodePoolId) {
              this.nodePoolId = nodePoolId;
              return this;
            }

            @Override
            public Autoscaling set(String parameterName, Object value) {
              return (Autoscaling) super.set(parameterName, value);
            }
          }
          /**
           * Creates a node pool for a cluster.
           *
           * Create a request for the method "nodePools.create".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation.
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://developers.google.com/console/help/new/#projectnumber).
          This field has
           *        been deprecated and replaced by the parent field.
           * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the parent field.
           * @param clusterId Deprecated. The name of the cluster.
          This field has been deprecated and replaced by the parent
           *        field.
           * @param content the {@link com.google.api.services.container.model.CreateNodePoolRequest}
           * @return the request
           */
          public Create create(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.CreateNodePoolRequest content) throws java.io.IOException {
            Create result = new Create(projectId, zone, clusterId, content);
            initialize(result);
            return result;
          }

          public class Create extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools";

            /**
             * Creates a node pool for a cluster.
             *
             * Create a request for the method "nodePools.create".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
             * <p> {@link
             * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://developers.google.com/console/help/new/#projectnumber).
          This field has
           *        been deprecated and replaced by the parent field.
             * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the parent field.
             * @param clusterId Deprecated. The name of the cluster.
          This field has been deprecated and replaced by the parent
           *        field.
             * @param content the {@link com.google.api.services.container.model.CreateNodePoolRequest}
             * @since 1.13
             */
            protected Create(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, com.google.api.services.container.model.CreateNodePoolRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
              this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
            }

            @Override
            public Create set$Xgafv(java.lang.String $Xgafv) {
              return (Create) super.set$Xgafv($Xgafv);
            }

            @Override
            public Create setAccessToken(java.lang.String accessToken) {
              return (Create) super.setAccessToken(accessToken);
            }

            @Override
            public Create setAlt(java.lang.String alt) {
              return (Create) super.setAlt(alt);
            }

            @Override
            public Create setCallback(java.lang.String callback) {
              return (Create) super.setCallback(callback);
            }

            @Override
            public Create setFields(java.lang.String fields) {
              return (Create) super.setFields(fields);
            }

            @Override
            public Create setKey(java.lang.String key) {
              return (Create) super.setKey(key);
            }

            @Override
            public Create setOauthToken(java.lang.String oauthToken) {
              return (Create) super.setOauthToken(oauthToken);
            }

            @Override
            public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Create) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Create setQuotaUser(java.lang.String quotaUser) {
              return (Create) super.setQuotaUser(quotaUser);
            }

            @Override
            public Create setUploadType(java.lang.String uploadType) {
              return (Create) super.setUploadType(uploadType);
            }

            @Override
            public Create setUploadProtocol(java.lang.String uploadProtocol) {
              return (Create) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the parent field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://developers.google.com/console/help/new/#projectnumber). This field has been
           deprecated and replaced by the parent field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the parent field.
             */
            public Create setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the parent field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the parent field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the parent field.
             */
            public Create setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the parent field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the parent
           field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the parent field.
             */
            public Create setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
              return (Create) super.set(parameterName, value);
            }
          }
          /**
           * Deletes a node pool from a cluster.
           *
           * Create a request for the method "nodePools.delete".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://developers.google.com/console/help/new/#projectnumber).
          This field has
           *        been deprecated and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster.
          This field has been deprecated and replaced by the name field.
           * @param nodePoolId Deprecated. The name of the node pool to delete.
          This field has been deprecated and replaced by the
           *        name field.
           * @return the request
           */
          public Delete delete(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId) throws java.io.IOException {
            Delete result = new Delete(projectId, zone, clusterId, nodePoolId);
            initialize(result);
            return result;
          }

          public class Delete extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}";

            /**
             * Deletes a node pool from a cluster.
             *
             * Create a request for the method "nodePools.delete".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             * <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://developers.google.com/console/help/new/#projectnumber).
          This field has
           *        been deprecated and replaced by the name field.
             * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
             * @param clusterId Deprecated. The name of the cluster.
          This field has been deprecated and replaced by the name field.
             * @param nodePoolId Deprecated. The name of the node pool to delete.
          This field has been deprecated and replaced by the
           *        name field.
             * @since 1.13
             */
            protected Delete(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId) {
              super(Container.this, "DELETE", REST_PATH, null, com.google.api.services.container.model.Operation.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
              this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
              this.nodePoolId = com.google.api.client.util.Preconditions.checkNotNull(nodePoolId, "Required parameter nodePoolId must be specified.");
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://developers.google.com/console/help/new/#projectnumber). This field has been
           deprecated and replaced by the name field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the name field.
             */
            public Delete setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            public Delete setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the name field.
             */
            public Delete setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            /**
             * Deprecated. The name of the node pool to delete. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String nodePoolId;

            /** Deprecated. The name of the node pool to delete. This field has been deprecated and replaced by the
           name field.
             */
            public java.lang.String getNodePoolId() {
              return nodePoolId;
            }

            /**
             * Deprecated. The name of the node pool to delete. This field has been deprecated and
             * replaced by the name field.
             */
            public Delete setNodePoolId(java.lang.String nodePoolId) {
              this.nodePoolId = nodePoolId;
              return this;
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to delete.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name (project, location, cluster, node pool id) of the node pool to delete. Specified in the
           format 'projects/locations/clusters/nodePools'.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to delete.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            public Delete setName(java.lang.String name) {
              this.name = name;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Retrieves the requested node pool.
           *
           * Create a request for the method "nodePools.get".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://developers.google.com/console/help/new/#projectnumber).
          This field has
           *        been deprecated and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster.
          This field has been deprecated and replaced by the name field.
           * @param nodePoolId Deprecated. The name of the node pool.
          This field has been deprecated and replaced by the name
           *        field.
           * @return the request
           */
          public Get get(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId) throws java.io.IOException {
            Get result = new Get(projectId, zone, clusterId, nodePoolId);
            initialize(result);
            return result;
          }

          public class Get extends ContainerRequest<com.google.api.services.container.model.NodePool> {

            private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}";

            /**
             * Retrieves the requested node pool.
             *
             * Create a request for the method "nodePools.get".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://developers.google.com/console/help/new/#projectnumber).
          This field has
           *        been deprecated and replaced by the name field.
             * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
             * @param clusterId Deprecated. The name of the cluster.
          This field has been deprecated and replaced by the name field.
             * @param nodePoolId Deprecated. The name of the node pool.
          This field has been deprecated and replaced by the name
           *        field.
             * @since 1.13
             */
            protected Get(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId) {
              super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.NodePool.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
              this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
              this.nodePoolId = com.google.api.client.util.Preconditions.checkNotNull(nodePoolId, "Required parameter nodePoolId must be specified.");
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://developers.google.com/console/help/new/#projectnumber). This field has been
           deprecated and replaced by the name field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the name field.
             */
            public Get setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            public Get setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the name field.
             */
            public Get setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            /**
             * Deprecated. The name of the node pool. This field has been deprecated and replaced by
             * the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String nodePoolId;

            /** Deprecated. The name of the node pool. This field has been deprecated and replaced by the name
           field.
             */
            public java.lang.String getNodePoolId() {
              return nodePoolId;
            }

            /**
             * Deprecated. The name of the node pool. This field has been deprecated and replaced by
             * the name field.
             */
            public Get setNodePoolId(java.lang.String nodePoolId) {
              this.nodePoolId = nodePoolId;
              return this;
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to get.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The name (project, location, cluster, node pool id) of the node pool to get. Specified in the
           format 'projects/locations/clusters/nodePools'.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * The name (project, location, cluster, node pool id) of the node pool to get.
             * Specified in the format 'projects/locations/clusters/nodePools'.
             */
            public Get setName(java.lang.String name) {
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Lists the node pools for a cluster.
           *
           * Create a request for the method "nodePools.list".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://developers.google.com/console/help/new/#projectnumber).
          This field has
           *        been deprecated and replaced by the parent field.
           * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the parent field.
           * @param clusterId Deprecated. The name of the cluster.
          This field has been deprecated and replaced by the parent
           *        field.
           * @return the request
           */
          public List list(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId) throws java.io.IOException {
            List result = new List(projectId, zone, clusterId);
            initialize(result);
            return result;
          }

          public class List extends ContainerRequest<com.google.api.services.container.model.ListNodePoolsResponse> {

            private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools";

            /**
             * Lists the node pools for a cluster.
             *
             * Create a request for the method "nodePools.list".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://developers.google.com/console/help/new/#projectnumber).
          This field has
           *        been deprecated and replaced by the parent field.
             * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the parent field.
             * @param clusterId Deprecated. The name of the cluster.
          This field has been deprecated and replaced by the parent
           *        field.
             * @since 1.13
             */
            protected List(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId) {
              super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.ListNodePoolsResponse.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
              this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the parent field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://developers.google.com/console/help/new/#projectnumber). This field has been
           deprecated and replaced by the parent field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://developers.google.com/console/help/new/#projectnumber). This field
             * has been deprecated and replaced by the parent field.
             */
            public List setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the parent field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the parent field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the parent field.
             */
            public List setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the parent field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster. This field has been deprecated and replaced by the parent
           field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster. This field has been deprecated and replaced by
             * the parent field.
             */
            public List setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            /**
             * The parent (project, location, cluster id) where the node pools will be listed.
             * Specified in the format 'projects/locations/clusters'.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The parent (project, location, cluster id) where the node pools will be listed. Specified in the
           format 'projects/locations/clusters'.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * The parent (project, location, cluster id) where the node pools will be listed.
             * Specified in the format 'projects/locations/clusters'.
             */
            public List setParent(java.lang.String parent) {
              this.parent = parent;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Rolls back a previously Aborted or Failed NodePool upgrade. This makes no changes if the last
           * upgrade successfully completed.
           *
           * Create a request for the method "nodePools.rollback".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Rollback#execute()} method to invoke the remote operation.
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://support.google.com/cloud/answer/6158840).
          This field has been deprecated
           *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to rollback.
          This field has been deprecated and replaced by the
           *        name field.
           * @param nodePoolId Deprecated. The name of the node pool to rollback.
          This field has been deprecated and replaced by
           *        the name field.
           * @param content the {@link com.google.api.services.container.model.RollbackNodePoolUpgradeRequest}
           * @return the request
           */
          public Rollback rollback(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId, com.google.api.services.container.model.RollbackNodePoolUpgradeRequest content) throws java.io.IOException {
            Rollback result = new Rollback(projectId, zone, clusterId, nodePoolId, content);
            initialize(result);
            return result;
          }

          public class Rollback extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}:rollback";

            /**
             * Rolls back a previously Aborted or Failed NodePool upgrade. This makes no changes if the last
             * upgrade successfully completed.
             *
             * Create a request for the method "nodePools.rollback".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Rollback#execute()} method to invoke the remote operation.
             * <p> {@link
             * Rollback#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://support.google.com/cloud/answer/6158840).
          This field has been deprecated
           *        and replaced by the name field.
             * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
             * @param clusterId Deprecated. The name of the cluster to rollback.
          This field has been deprecated and replaced by the
           *        name field.
             * @param nodePoolId Deprecated. The name of the node pool to rollback.
          This field has been deprecated and replaced by
           *        the name field.
             * @param content the {@link com.google.api.services.container.model.RollbackNodePoolUpgradeRequest}
             * @since 1.13
             */
            protected Rollback(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId, com.google.api.services.container.model.RollbackNodePoolUpgradeRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
              this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
              this.nodePoolId = com.google.api.client.util.Preconditions.checkNotNull(nodePoolId, "Required parameter nodePoolId must be specified.");
            }

            @Override
            public Rollback set$Xgafv(java.lang.String $Xgafv) {
              return (Rollback) super.set$Xgafv($Xgafv);
            }

            @Override
            public Rollback setAccessToken(java.lang.String accessToken) {
              return (Rollback) super.setAccessToken(accessToken);
            }

            @Override
            public Rollback setAlt(java.lang.String alt) {
              return (Rollback) super.setAlt(alt);
            }

            @Override
            public Rollback setCallback(java.lang.String callback) {
              return (Rollback) super.setCallback(callback);
            }

            @Override
            public Rollback setFields(java.lang.String fields) {
              return (Rollback) super.setFields(fields);
            }

            @Override
            public Rollback setKey(java.lang.String key) {
              return (Rollback) super.setKey(key);
            }

            @Override
            public Rollback setOauthToken(java.lang.String oauthToken) {
              return (Rollback) super.setOauthToken(oauthToken);
            }

            @Override
            public Rollback setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Rollback) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Rollback setQuotaUser(java.lang.String quotaUser) {
              return (Rollback) super.setQuotaUser(quotaUser);
            }

            @Override
            public Rollback setUploadType(java.lang.String uploadType) {
              return (Rollback) super.setUploadType(uploadType);
            }

            @Override
            public Rollback setUploadProtocol(java.lang.String uploadProtocol) {
              return (Rollback) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://support.google.com/cloud/answer/6158840). This field has been
             * deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
           replaced by the name field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://support.google.com/cloud/answer/6158840). This field has been
             * deprecated and replaced by the name field.
             */
            public Rollback setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            public Rollback setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster to rollback. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster to rollback. This field has been deprecated and replaced by the
           name field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster to rollback. This field has been deprecated and
             * replaced by the name field.
             */
            public Rollback setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            /**
             * Deprecated. The name of the node pool to rollback. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String nodePoolId;

            /** Deprecated. The name of the node pool to rollback. This field has been deprecated and replaced by
           the name field.
             */
            public java.lang.String getNodePoolId() {
              return nodePoolId;
            }

            /**
             * Deprecated. The name of the node pool to rollback. This field has been deprecated and
             * replaced by the name field.
             */
            public Rollback setNodePoolId(java.lang.String nodePoolId) {
              this.nodePoolId = nodePoolId;
              return this;
            }

            @Override
            public Rollback set(String parameterName, Object value) {
              return (Rollback) super.set(parameterName, value);
            }
          }
          /**
           * Sets the NodeManagement options for a node pool.
           *
           * Create a request for the method "nodePools.setManagement".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link SetManagement#execute()} method to invoke the remote operation.
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://support.google.com/cloud/answer/6158840).
          This field has been deprecated
           *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to update.
          This field has been deprecated and replaced by the
           *        name field.
           * @param nodePoolId Deprecated. The name of the node pool to update.
          This field has been deprecated and replaced by the
           *        name field.
           * @param content the {@link com.google.api.services.container.model.SetNodePoolManagementRequest}
           * @return the request
           */
          public SetManagement setManagement(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId, com.google.api.services.container.model.SetNodePoolManagementRequest content) throws java.io.IOException {
            SetManagement result = new SetManagement(projectId, zone, clusterId, nodePoolId, content);
            initialize(result);
            return result;
          }

          public class SetManagement extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setManagement";

            /**
             * Sets the NodeManagement options for a node pool.
             *
             * Create a request for the method "nodePools.setManagement".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link SetManagement#execute()} method to invoke the remote
             * operation. <p> {@link SetManagement#initialize(com.google.api.client.googleapis.services.Abstra
             * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
             * the constructor. </p>
             *
             * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://support.google.com/cloud/answer/6158840).
          This field has been deprecated
           *        and replaced by the name field.
             * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
             * @param clusterId Deprecated. The name of the cluster to update.
          This field has been deprecated and replaced by the
           *        name field.
             * @param nodePoolId Deprecated. The name of the node pool to update.
          This field has been deprecated and replaced by the
           *        name field.
             * @param content the {@link com.google.api.services.container.model.SetNodePoolManagementRequest}
             * @since 1.13
             */
            protected SetManagement(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId, com.google.api.services.container.model.SetNodePoolManagementRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
              this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
              this.nodePoolId = com.google.api.client.util.Preconditions.checkNotNull(nodePoolId, "Required parameter nodePoolId must be specified.");
            }

            @Override
            public SetManagement set$Xgafv(java.lang.String $Xgafv) {
              return (SetManagement) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetManagement setAccessToken(java.lang.String accessToken) {
              return (SetManagement) super.setAccessToken(accessToken);
            }

            @Override
            public SetManagement setAlt(java.lang.String alt) {
              return (SetManagement) super.setAlt(alt);
            }

            @Override
            public SetManagement setCallback(java.lang.String callback) {
              return (SetManagement) super.setCallback(callback);
            }

            @Override
            public SetManagement setFields(java.lang.String fields) {
              return (SetManagement) super.setFields(fields);
            }

            @Override
            public SetManagement setKey(java.lang.String key) {
              return (SetManagement) super.setKey(key);
            }

            @Override
            public SetManagement setOauthToken(java.lang.String oauthToken) {
              return (SetManagement) super.setOauthToken(oauthToken);
            }

            @Override
            public SetManagement setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetManagement) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetManagement setQuotaUser(java.lang.String quotaUser) {
              return (SetManagement) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetManagement setUploadType(java.lang.String uploadType) {
              return (SetManagement) super.setUploadType(uploadType);
            }

            @Override
            public SetManagement setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetManagement) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://support.google.com/cloud/answer/6158840). This field has been
             * deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
           replaced by the name field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://support.google.com/cloud/answer/6158840). This field has been
             * deprecated and replaced by the name field.
             */
            public SetManagement setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            public SetManagement setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster to update. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster to update. This field has been deprecated and replaced by the
           name field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster to update. This field has been deprecated and
             * replaced by the name field.
             */
            public SetManagement setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            /**
             * Deprecated. The name of the node pool to update. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String nodePoolId;

            /** Deprecated. The name of the node pool to update. This field has been deprecated and replaced by the
           name field.
             */
            public java.lang.String getNodePoolId() {
              return nodePoolId;
            }

            /**
             * Deprecated. The name of the node pool to update. This field has been deprecated and
             * replaced by the name field.
             */
            public SetManagement setNodePoolId(java.lang.String nodePoolId) {
              this.nodePoolId = nodePoolId;
              return this;
            }

            @Override
            public SetManagement set(String parameterName, Object value) {
              return (SetManagement) super.set(parameterName, value);
            }
          }
          /**
           * Sets the size for a specific node pool.
           *
           * Create a request for the method "nodePools.setSize".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link SetSize#execute()} method to invoke the remote operation.
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://support.google.com/cloud/answer/6158840).
          This field has been deprecated
           *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to update.
          This field has been deprecated and replaced by the
           *        name field.
           * @param nodePoolId Deprecated. The name of the node pool to update.
          This field has been deprecated and replaced by the
           *        name field.
           * @param content the {@link com.google.api.services.container.model.SetNodePoolSizeRequest}
           * @return the request
           */
          public SetSize setSize(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId, com.google.api.services.container.model.SetNodePoolSizeRequest content) throws java.io.IOException {
            SetSize result = new SetSize(projectId, zone, clusterId, nodePoolId, content);
            initialize(result);
            return result;
          }

          public class SetSize extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setSize";

            /**
             * Sets the size for a specific node pool.
             *
             * Create a request for the method "nodePools.setSize".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link SetSize#execute()} method to invoke the remote operation.
             * <p> {@link
             * SetSize#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://support.google.com/cloud/answer/6158840).
          This field has been deprecated
           *        and replaced by the name field.
             * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
             * @param clusterId Deprecated. The name of the cluster to update.
          This field has been deprecated and replaced by the
           *        name field.
             * @param nodePoolId Deprecated. The name of the node pool to update.
          This field has been deprecated and replaced by the
           *        name field.
             * @param content the {@link com.google.api.services.container.model.SetNodePoolSizeRequest}
             * @since 1.13
             */
            protected SetSize(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId, com.google.api.services.container.model.SetNodePoolSizeRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
              this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
              this.nodePoolId = com.google.api.client.util.Preconditions.checkNotNull(nodePoolId, "Required parameter nodePoolId must be specified.");
            }

            @Override
            public SetSize set$Xgafv(java.lang.String $Xgafv) {
              return (SetSize) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetSize setAccessToken(java.lang.String accessToken) {
              return (SetSize) super.setAccessToken(accessToken);
            }

            @Override
            public SetSize setAlt(java.lang.String alt) {
              return (SetSize) super.setAlt(alt);
            }

            @Override
            public SetSize setCallback(java.lang.String callback) {
              return (SetSize) super.setCallback(callback);
            }

            @Override
            public SetSize setFields(java.lang.String fields) {
              return (SetSize) super.setFields(fields);
            }

            @Override
            public SetSize setKey(java.lang.String key) {
              return (SetSize) super.setKey(key);
            }

            @Override
            public SetSize setOauthToken(java.lang.String oauthToken) {
              return (SetSize) super.setOauthToken(oauthToken);
            }

            @Override
            public SetSize setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetSize) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetSize setQuotaUser(java.lang.String quotaUser) {
              return (SetSize) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetSize setUploadType(java.lang.String uploadType) {
              return (SetSize) super.setUploadType(uploadType);
            }

            @Override
            public SetSize setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetSize) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://support.google.com/cloud/answer/6158840). This field has been
             * deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
           replaced by the name field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://support.google.com/cloud/answer/6158840). This field has been
             * deprecated and replaced by the name field.
             */
            public SetSize setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            public SetSize setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster to update. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster to update. This field has been deprecated and replaced by the
           name field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster to update. This field has been deprecated and
             * replaced by the name field.
             */
            public SetSize setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            /**
             * Deprecated. The name of the node pool to update. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String nodePoolId;

            /** Deprecated. The name of the node pool to update. This field has been deprecated and replaced by the
           name field.
             */
            public java.lang.String getNodePoolId() {
              return nodePoolId;
            }

            /**
             * Deprecated. The name of the node pool to update. This field has been deprecated and
             * replaced by the name field.
             */
            public SetSize setNodePoolId(java.lang.String nodePoolId) {
              this.nodePoolId = nodePoolId;
              return this;
            }

            @Override
            public SetSize set(String parameterName, Object value) {
              return (SetSize) super.set(parameterName, value);
            }
          }
          /**
           * Updates the version and/or image type for the specified node pool.
           *
           * Create a request for the method "nodePools.update".
           *
           * This request holds the parameters needed by the container server.  After setting any optional
           * parameters, call the {@link Update#execute()} method to invoke the remote operation.
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://support.google.com/cloud/answer/6158840).
          This field has been deprecated
           *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
           * @param clusterId Deprecated. The name of the cluster to upgrade.
          This field has been deprecated and replaced by the
           *        name field.
           * @param nodePoolId Deprecated. The name of the node pool to upgrade.
          This field has been deprecated and replaced by the
           *        name field.
           * @param content the {@link com.google.api.services.container.model.UpdateNodePoolRequest}
           * @return the request
           */
          public Update update(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId, com.google.api.services.container.model.UpdateNodePoolRequest content) throws java.io.IOException {
            Update result = new Update(projectId, zone, clusterId, nodePoolId, content);
            initialize(result);
            return result;
          }

          public class Update extends ContainerRequest<com.google.api.services.container.model.Operation> {

            private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/update";

            /**
             * Updates the version and/or image type for the specified node pool.
             *
             * Create a request for the method "nodePools.update".
             *
             * This request holds the parameters needed by the the container server.  After setting any
             * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
             * <p> {@link
             * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param projectId Deprecated. The Google Developers Console [project ID or project
           *        number](https://support.google.com/cloud/answer/6158840).
          This field has been deprecated
           *        and replaced by the name field.
             * @param zone Deprecated. The name of the Google Compute Engine
          [zone](/compute/docs/zones#available) in which the
           *        cluster
          resides.
          This field has been deprecated and replaced by the name field.
             * @param clusterId Deprecated. The name of the cluster to upgrade.
          This field has been deprecated and replaced by the
           *        name field.
             * @param nodePoolId Deprecated. The name of the node pool to upgrade.
          This field has been deprecated and replaced by the
           *        name field.
             * @param content the {@link com.google.api.services.container.model.UpdateNodePoolRequest}
             * @since 1.13
             */
            protected Update(java.lang.String projectId, java.lang.String zone, java.lang.String clusterId, java.lang.String nodePoolId, com.google.api.services.container.model.UpdateNodePoolRequest content) {
              super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Operation.class);
              this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
              this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
              this.clusterId = com.google.api.client.util.Preconditions.checkNotNull(clusterId, "Required parameter clusterId must be specified.");
              this.nodePoolId = com.google.api.client.util.Preconditions.checkNotNull(nodePoolId, "Required parameter nodePoolId must be specified.");
            }

            @Override
            public Update set$Xgafv(java.lang.String $Xgafv) {
              return (Update) super.set$Xgafv($Xgafv);
            }

            @Override
            public Update setAccessToken(java.lang.String accessToken) {
              return (Update) super.setAccessToken(accessToken);
            }

            @Override
            public Update setAlt(java.lang.String alt) {
              return (Update) super.setAlt(alt);
            }

            @Override
            public Update setCallback(java.lang.String callback) {
              return (Update) super.setCallback(callback);
            }

            @Override
            public Update setFields(java.lang.String fields) {
              return (Update) super.setFields(fields);
            }

            @Override
            public Update setKey(java.lang.String key) {
              return (Update) super.setKey(key);
            }

            @Override
            public Update setOauthToken(java.lang.String oauthToken) {
              return (Update) super.setOauthToken(oauthToken);
            }

            @Override
            public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Update) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Update setQuotaUser(java.lang.String quotaUser) {
              return (Update) super.setQuotaUser(quotaUser);
            }

            @Override
            public Update setUploadType(java.lang.String uploadType) {
              return (Update) super.setUploadType(uploadType);
            }

            @Override
            public Update setUploadProtocol(java.lang.String uploadProtocol) {
              return (Update) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://support.google.com/cloud/answer/6158840). This field has been
             * deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String projectId;

            /** Deprecated. The Google Developers Console [project ID or project
           number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
           replaced by the name field.
             */
            public java.lang.String getProjectId() {
              return projectId;
            }

            /**
             * Deprecated. The Google Developers Console [project ID or project
             * number](https://support.google.com/cloud/answer/6158840). This field has been
             * deprecated and replaced by the name field.
             */
            public Update setProjectId(java.lang.String projectId) {
              this.projectId = projectId;
              return this;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String zone;

            /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
           the cluster resides. This field has been deprecated and replaced by the name field.
             */
            public java.lang.String getZone() {
              return zone;
            }

            /**
             * Deprecated. The name of the Google Compute Engine
             * [zone](/compute/docs/zones#available) in which the cluster resides. This field has
             * been deprecated and replaced by the name field.
             */
            public Update setZone(java.lang.String zone) {
              this.zone = zone;
              return this;
            }

            /**
             * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String clusterId;

            /** Deprecated. The name of the cluster to upgrade. This field has been deprecated and replaced by the
           name field.
             */
            public java.lang.String getClusterId() {
              return clusterId;
            }

            /**
             * Deprecated. The name of the cluster to upgrade. This field has been deprecated and
             * replaced by the name field.
             */
            public Update setClusterId(java.lang.String clusterId) {
              this.clusterId = clusterId;
              return this;
            }

            /**
             * Deprecated. The name of the node pool to upgrade. This field has been deprecated and
             * replaced by the name field.
             */
            @com.google.api.client.util.Key
            private java.lang.String nodePoolId;

            /** Deprecated. The name of the node pool to upgrade. This field has been deprecated and replaced by
           the name field.
             */
            public java.lang.String getNodePoolId() {
              return nodePoolId;
            }

            /**
             * Deprecated. The name of the node pool to upgrade. This field has been deprecated and
             * replaced by the name field.
             */
            public Update setNodePoolId(java.lang.String nodePoolId) {
              this.nodePoolId = nodePoolId;
              return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
              return (Update) super.set(parameterName, value);
            }
          }

        }
      }
      /**
       * An accessor for creating requests from the Operations collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Container container = new Container(...);}
       *   {@code Container.Operations.List request = container.operations().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Operations operations() {
        return new Operations();
      }

      /**
       * The "operations" collection of methods.
       */
      public class Operations {

        /**
         * Cancels the specified operation.
         *
         * Create a request for the method "operations.cancel".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        operation resides.
        This field has been deprecated and replaced by the name field.
         * @param operationId Deprecated. The server-assigned `name` of the operation.
        This field has been deprecated and replaced
         *        by the name field.
         * @param content the {@link com.google.api.services.container.model.CancelOperationRequest}
         * @return the request
         */
        public Cancel cancel(java.lang.String projectId, java.lang.String zone, java.lang.String operationId, com.google.api.services.container.model.CancelOperationRequest content) throws java.io.IOException {
          Cancel result = new Cancel(projectId, zone, operationId, content);
          initialize(result);
          return result;
        }

        public class Cancel extends ContainerRequest<com.google.api.services.container.model.Empty> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/operations/{operationId}:cancel";

          /**
           * Cancels the specified operation.
           *
           * Create a request for the method "operations.cancel".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
           * <p> {@link
           * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        operation resides.
        This field has been deprecated and replaced by the name field.
           * @param operationId Deprecated. The server-assigned `name` of the operation.
        This field has been deprecated and replaced
         *        by the name field.
           * @param content the {@link com.google.api.services.container.model.CancelOperationRequest}
           * @since 1.13
           */
          protected Cancel(java.lang.String projectId, java.lang.String zone, java.lang.String operationId, com.google.api.services.container.model.CancelOperationRequest content) {
            super(Container.this, "POST", REST_PATH, content, com.google.api.services.container.model.Empty.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.operationId = com.google.api.client.util.Preconditions.checkNotNull(operationId, "Required parameter operationId must be specified.");
          }

          @Override
          public Cancel set$Xgafv(java.lang.String $Xgafv) {
            return (Cancel) super.set$Xgafv($Xgafv);
          }

          @Override
          public Cancel setAccessToken(java.lang.String accessToken) {
            return (Cancel) super.setAccessToken(accessToken);
          }

          @Override
          public Cancel setAlt(java.lang.String alt) {
            return (Cancel) super.setAlt(alt);
          }

          @Override
          public Cancel setCallback(java.lang.String callback) {
            return (Cancel) super.setCallback(callback);
          }

          @Override
          public Cancel setFields(java.lang.String fields) {
            return (Cancel) super.setFields(fields);
          }

          @Override
          public Cancel setKey(java.lang.String key) {
            return (Cancel) super.setKey(key);
          }

          @Override
          public Cancel setOauthToken(java.lang.String oauthToken) {
            return (Cancel) super.setOauthToken(oauthToken);
          }

          @Override
          public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Cancel) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Cancel setQuotaUser(java.lang.String quotaUser) {
            return (Cancel) super.setQuotaUser(quotaUser);
          }

          @Override
          public Cancel setUploadType(java.lang.String uploadType) {
            return (Cancel) super.setUploadType(uploadType);
          }

          @Override
          public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
            return (Cancel) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Cancel setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the operation resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the operation resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the operation resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Cancel setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The server-assigned `name` of the operation. This field has been deprecated
           * and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String operationId;

          /** Deprecated. The server-assigned `name` of the operation. This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getOperationId() {
            return operationId;
          }

          /**
           * Deprecated. The server-assigned `name` of the operation. This field has been deprecated
           * and replaced by the name field.
           */
          public Cancel setOperationId(java.lang.String operationId) {
            this.operationId = operationId;
            return this;
          }

          @Override
          public Cancel set(String parameterName, Object value) {
            return (Cancel) super.set(parameterName, value);
          }
        }
        /**
         * Gets the specified operation.
         *
         * Create a request for the method "operations.get".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
         * @param operationId Deprecated. The server-assigned `name` of the operation.
        This field has been deprecated and replaced
         *        by the name field.
         * @return the request
         */
        public Get get(java.lang.String projectId, java.lang.String zone, java.lang.String operationId) throws java.io.IOException {
          Get result = new Get(projectId, zone, operationId);
          initialize(result);
          return result;
        }

        public class Get extends ContainerRequest<com.google.api.services.container.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/operations/{operationId}";

          /**
           * Gets the specified operation.
           *
           * Create a request for the method "operations.get".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the name field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) in which the
         *        cluster
        resides.
        This field has been deprecated and replaced by the name field.
           * @param operationId Deprecated. The server-assigned `name` of the operation.
        This field has been deprecated and replaced
         *        by the name field.
           * @since 1.13
           */
          protected Get(java.lang.String projectId, java.lang.String zone, java.lang.String operationId) {
            super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
            this.operationId = com.google.api.client.util.Preconditions.checkNotNull(operationId, "Required parameter operationId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the name field.
           */
          public Get setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in which
         the cluster resides. This field has been deprecated and replaced by the name field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * in which the cluster resides. This field has been deprecated and replaced by the name
           * field.
           */
          public Get setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * Deprecated. The server-assigned `name` of the operation. This field has been deprecated
           * and replaced by the name field.
           */
          @com.google.api.client.util.Key
          private java.lang.String operationId;

          /** Deprecated. The server-assigned `name` of the operation. This field has been deprecated and
         replaced by the name field.
           */
          public java.lang.String getOperationId() {
            return operationId;
          }

          /**
           * Deprecated. The server-assigned `name` of the operation. This field has been deprecated
           * and replaced by the name field.
           */
          public Get setOperationId(java.lang.String operationId) {
            this.operationId = operationId;
            return this;
          }

          /**
           * The name (project, location, operation id) of the operation to get. Specified in the
           * format 'projects/locations/operations'.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (project, location, operation id) of the operation to get. Specified in the format
         'projects/locations/operations'.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (project, location, operation id) of the operation to get. Specified in the
           * format 'projects/locations/operations'.
           */
          public Get setName(java.lang.String name) {
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists all operations in a project in a specific zone or all zones.
         *
         * Create a request for the method "operations.list".
         *
         * This request holds the parameters needed by the container server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the parent field.
         * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) to return
         *        operations for, or `-` for
        all zones. This field has been deprecated and replaced by the
         *        parent field.
         * @return the request
         */
        public List list(java.lang.String projectId, java.lang.String zone) throws java.io.IOException {
          List result = new List(projectId, zone);
          initialize(result);
          return result;
        }

        public class List extends ContainerRequest<com.google.api.services.container.model.ListOperationsResponse> {

          private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/operations";

          /**
           * Lists all operations in a project in a specific zone or all zones.
           *
           * Create a request for the method "operations.list".
           *
           * This request holds the parameters needed by the the container server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Deprecated. The Google Developers Console [project ID or project
         *        number](https://support.google.com/cloud/answer/6158840).
        This field has been deprecated
         *        and replaced by the parent field.
           * @param zone Deprecated. The name of the Google Compute Engine
        [zone](/compute/docs/zones#available) to return
         *        operations for, or `-` for
        all zones. This field has been deprecated and replaced by the
         *        parent field.
           * @since 1.13
           */
          protected List(java.lang.String projectId, java.lang.String zone) {
            super(Container.this, "GET", REST_PATH, null, com.google.api.services.container.model.ListOperationsResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the parent field.
           */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Deprecated. The Google Developers Console [project ID or project
         number](https://support.google.com/cloud/answer/6158840). This field has been deprecated and
         replaced by the parent field.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /**
           * Deprecated. The Google Developers Console [project ID or project
           * number](https://support.google.com/cloud/answer/6158840). This field has been
           * deprecated and replaced by the parent field.
           */
          public List setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * to return operations for, or `-` for all zones. This field has been deprecated and
           * replaced by the parent field.
           */
          @com.google.api.client.util.Key
          private java.lang.String zone;

          /** Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) to return
         operations for, or `-` for all zones. This field has been deprecated and replaced by the parent
         field.
           */
          public java.lang.String getZone() {
            return zone;
          }

          /**
           * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available)
           * to return operations for, or `-` for all zones. This field has been deprecated and
           * replaced by the parent field.
           */
          public List setZone(java.lang.String zone) {
            this.zone = zone;
            return this;
          }

          /**
           * The parent (project and location) where the operations will be listed. Specified in the
           * format 'projects/locations'. Location "-" matches all zones and all regions.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The parent (project and location) where the operations will be listed. Specified in the format
         'projects/locations'. Location "-" matches all zones and all regions.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * The parent (project and location) where the operations will be listed. Specified in the
           * format 'projects/locations'. Location "-" matches all zones and all regions.
           */
          public List setParent(java.lang.String parent) {
            this.parent = parent;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * Builder for {@link Container}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Container}. */
    @Override
    public Container build() {
      return new Container(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link ContainerRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setContainerRequestInitializer(
        ContainerRequestInitializer containerRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(containerRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
