/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-07 at 05:47:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * AutoUpgradeOptions defines the set of options for the user to control how the Auto Upgrades will
 * proceed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoUpgradeOptions extends com.google.api.client.json.GenericJson {

  /**
   * [Output only] This field is set when upgrades are about to commence with the approximate start
   * time for the upgrades, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String autoUpgradeStartTime;

  /**
   * [Output only] This field is set when upgrades are about to commence with the description of the
   * upgrade.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output only] This field is set when upgrades are about to commence with the approximate start
   * time for the upgrades, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getAutoUpgradeStartTime() {
    return autoUpgradeStartTime;
  }

  /**
   * [Output only] This field is set when upgrades are about to commence with the approximate start
   * time for the upgrades, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
   * @param autoUpgradeStartTime autoUpgradeStartTime or {@code null} for none
   */
  public AutoUpgradeOptions setAutoUpgradeStartTime(java.lang.String autoUpgradeStartTime) {
    this.autoUpgradeStartTime = autoUpgradeStartTime;
    return this;
  }

  /**
   * [Output only] This field is set when upgrades are about to commence with the description of the
   * upgrade.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * [Output only] This field is set when upgrades are about to commence with the description of the
   * upgrade.
   * @param description description or {@code null} for none
   */
  public AutoUpgradeOptions setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  @Override
  public AutoUpgradeOptions set(String fieldName, Object value) {
    return (AutoUpgradeOptions) super.set(fieldName, value);
  }

  @Override
  public AutoUpgradeOptions clone() {
    return (AutoUpgradeOptions) super.clone();
  }

}
