/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-07 at 05:47:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoprovisioningNodePoolDefaults extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the node management options for NAP created node-pools.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NodeManagement management;

  /**
   * Scopes that are used by NAP when creating node pools. If oauth_scopes are specified,
   * service_account should be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> oauthScopes;

  /**
   * The Google Cloud Platform Service Account to be used by the node VMs. If service_account is
   * specified, scopes should be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serviceAccount;

  /**
   * Specifies the upgrade settings for NAP created node pools
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpgradeSettings upgradeSettings;

  /**
   * Specifies the node management options for NAP created node-pools.
   * @return value or {@code null} for none
   */
  public NodeManagement getManagement() {
    return management;
  }

  /**
   * Specifies the node management options for NAP created node-pools.
   * @param management management or {@code null} for none
   */
  public AutoprovisioningNodePoolDefaults setManagement(NodeManagement management) {
    this.management = management;
    return this;
  }

  /**
   * Scopes that are used by NAP when creating node pools. If oauth_scopes are specified,
   * service_account should be empty.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getOauthScopes() {
    return oauthScopes;
  }

  /**
   * Scopes that are used by NAP when creating node pools. If oauth_scopes are specified,
   * service_account should be empty.
   * @param oauthScopes oauthScopes or {@code null} for none
   */
  public AutoprovisioningNodePoolDefaults setOauthScopes(java.util.List<java.lang.String> oauthScopes) {
    this.oauthScopes = oauthScopes;
    return this;
  }

  /**
   * The Google Cloud Platform Service Account to be used by the node VMs. If service_account is
   * specified, scopes should be empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getServiceAccount() {
    return serviceAccount;
  }

  /**
   * The Google Cloud Platform Service Account to be used by the node VMs. If service_account is
   * specified, scopes should be empty.
   * @param serviceAccount serviceAccount or {@code null} for none
   */
  public AutoprovisioningNodePoolDefaults setServiceAccount(java.lang.String serviceAccount) {
    this.serviceAccount = serviceAccount;
    return this;
  }

  /**
   * Specifies the upgrade settings for NAP created node pools
   * @return value or {@code null} for none
   */
  public UpgradeSettings getUpgradeSettings() {
    return upgradeSettings;
  }

  /**
   * Specifies the upgrade settings for NAP created node pools
   * @param upgradeSettings upgradeSettings or {@code null} for none
   */
  public AutoprovisioningNodePoolDefaults setUpgradeSettings(UpgradeSettings upgradeSettings) {
    this.upgradeSettings = upgradeSettings;
    return this;
  }

  @Override
  public AutoprovisioningNodePoolDefaults set(String fieldName, Object value) {
    return (AutoprovisioningNodePoolDefaults) super.set(fieldName, value);
  }

  @Override
  public AutoprovisioningNodePoolDefaults clone() {
    return (AutoprovisioningNodePoolDefaults) super.clone();
  }

}
