/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-07 at 05:47:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * ListOperationsResponse is the result of ListOperationsRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListOperationsResponse extends com.google.api.client.json.GenericJson {

  /**
   * If any zones are listed here, the list of operations returned may be missing the operations
   * from those zones.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> missingZones;

  /**
   * A list of operations in the project in the specified zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Operation> operations;

  static {
    // hack to force ProGuard to consider Operation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Operation.class);
  }

  /**
   * If any zones are listed here, the list of operations returned may be missing the operations
   * from those zones.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getMissingZones() {
    return missingZones;
  }

  /**
   * If any zones are listed here, the list of operations returned may be missing the operations
   * from those zones.
   * @param missingZones missingZones or {@code null} for none
   */
  public ListOperationsResponse setMissingZones(java.util.List<java.lang.String> missingZones) {
    this.missingZones = missingZones;
    return this;
  }

  /**
   * A list of operations in the project in the specified zone.
   * @return value or {@code null} for none
   */
  public java.util.List<Operation> getOperations() {
    return operations;
  }

  /**
   * A list of operations in the project in the specified zone.
   * @param operations operations or {@code null} for none
   */
  public ListOperationsResponse setOperations(java.util.List<Operation> operations) {
    this.operations = operations;
    return this;
  }

  @Override
  public ListOperationsResponse set(String fieldName, Object value) {
    return (ListOperationsResponse) super.set(fieldName, value);
  }

  @Override
  public ListOperationsResponse clone() {
    return (ListOperationsResponse) super.clone();
  }

}
