/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-07 at 05:47:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * ListUsableSubnetworksResponse is the response of ListUsableSubnetworksRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListUsableSubnetworksResponse extends com.google.api.client.json.GenericJson {

  /**
   * This token allows you to get the next page of results for list requests. If the number of
   * results is larger than `page_size`, use the `next_page_token` as a value for the query
   * parameter `page_token` in the next request. The value will become empty when there are no more
   * pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * A list of usable subnetworks in the specified network project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UsableSubnetwork> subnetworks;

  /**
   * This token allows you to get the next page of results for list requests. If the number of
   * results is larger than `page_size`, use the `next_page_token` as a value for the query
   * parameter `page_token` in the next request. The value will become empty when there are no more
   * pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * This token allows you to get the next page of results for list requests. If the number of
   * results is larger than `page_size`, use the `next_page_token` as a value for the query
   * parameter `page_token` in the next request. The value will become empty when there are no more
   * pages.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListUsableSubnetworksResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * A list of usable subnetworks in the specified network project.
   * @return value or {@code null} for none
   */
  public java.util.List<UsableSubnetwork> getSubnetworks() {
    return subnetworks;
  }

  /**
   * A list of usable subnetworks in the specified network project.
   * @param subnetworks subnetworks or {@code null} for none
   */
  public ListUsableSubnetworksResponse setSubnetworks(java.util.List<UsableSubnetwork> subnetworks) {
    this.subnetworks = subnetworks;
    return this;
  }

  @Override
  public ListUsableSubnetworksResponse set(String fieldName, Object value) {
    return (ListUsableSubnetworksResponse) super.set(fieldName, value);
  }

  @Override
  public ListUsableSubnetworksResponse clone() {
    return (ListUsableSubnetworksResponse) super.clone();
  }

}
