/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-07 at 05:47:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * MaintenanceWindow defines the maintenance window to be used for the cluster.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MaintenanceWindow extends com.google.api.client.json.GenericJson {

  /**
   * DailyMaintenanceWindow specifies a daily maintenance operation window.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DailyMaintenanceWindow dailyMaintenanceWindow;

  /**
   * Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, TimeWindow> maintenanceExclusions;

  /**
   * RecurringWindow specifies some number of recurring time periods for maintenance to occur. The
   * time windows may be overlapping. If no maintenance windows are set, maintenance can occur at
   * any time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RecurringTimeWindow recurringWindow;

  /**
   * DailyMaintenanceWindow specifies a daily maintenance operation window.
   * @return value or {@code null} for none
   */
  public DailyMaintenanceWindow getDailyMaintenanceWindow() {
    return dailyMaintenanceWindow;
  }

  /**
   * DailyMaintenanceWindow specifies a daily maintenance operation window.
   * @param dailyMaintenanceWindow dailyMaintenanceWindow or {@code null} for none
   */
  public MaintenanceWindow setDailyMaintenanceWindow(DailyMaintenanceWindow dailyMaintenanceWindow) {
    this.dailyMaintenanceWindow = dailyMaintenanceWindow;
    return this;
  }

  /**
   * Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, TimeWindow> getMaintenanceExclusions() {
    return maintenanceExclusions;
  }

  /**
   * Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows.
   * @param maintenanceExclusions maintenanceExclusions or {@code null} for none
   */
  public MaintenanceWindow setMaintenanceExclusions(java.util.Map<String, TimeWindow> maintenanceExclusions) {
    this.maintenanceExclusions = maintenanceExclusions;
    return this;
  }

  /**
   * RecurringWindow specifies some number of recurring time periods for maintenance to occur. The
   * time windows may be overlapping. If no maintenance windows are set, maintenance can occur at
   * any time.
   * @return value or {@code null} for none
   */
  public RecurringTimeWindow getRecurringWindow() {
    return recurringWindow;
  }

  /**
   * RecurringWindow specifies some number of recurring time periods for maintenance to occur. The
   * time windows may be overlapping. If no maintenance windows are set, maintenance can occur at
   * any time.
   * @param recurringWindow recurringWindow or {@code null} for none
   */
  public MaintenanceWindow setRecurringWindow(RecurringTimeWindow recurringWindow) {
    this.recurringWindow = recurringWindow;
    return this;
  }

  @Override
  public MaintenanceWindow set(String fieldName, Object value) {
    return (MaintenanceWindow) super.set(fieldName, value);
  }

  @Override
  public MaintenanceWindow clone() {
    return (MaintenanceWindow) super.clone();
  }

}
