/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-07 at 05:47:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * Kubernetes taint is comprised of three fields: key, value, and effect. Effect can only be one of
 * three types:  NoSchedule, PreferNoSchedule or NoExecute.
 *
 * For more information, including usage and the valid values, see:
 * https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NodeTaint extends com.google.api.client.json.GenericJson {

  /**
   * Effect for taint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String effect;

  /**
   * Key for taint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * Value for taint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * Effect for taint.
   * @return value or {@code null} for none
   */
  public java.lang.String getEffect() {
    return effect;
  }

  /**
   * Effect for taint.
   * @param effect effect or {@code null} for none
   */
  public NodeTaint setEffect(java.lang.String effect) {
    this.effect = effect;
    return this;
  }

  /**
   * Key for taint.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * Key for taint.
   * @param key key or {@code null} for none
   */
  public NodeTaint setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * Value for taint.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * Value for taint.
   * @param value value or {@code null} for none
   */
  public NodeTaint setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public NodeTaint set(String fieldName, Object value) {
    return (NodeTaint) super.set(fieldName, value);
  }

  @Override
  public NodeTaint clone() {
    return (NodeTaint) super.clone();
  }

}
