/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-07 at 05:47:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.container.model;

/**
 * SetNetworkPolicyRequest enables/disables network policy for a cluster.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Kubernetes Engine API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SetNetworkPolicyRequest extends com.google.api.client.json.GenericJson {

  /**
   * Deprecated. The name of the cluster. This field has been deprecated and replaced by the name
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clusterId;

  /**
   * The name (project, location, cluster id) of the cluster to set networking policy. Specified in
   * the format 'projects/locations/clusters'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Required. Configuration options for the NetworkPolicy feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NetworkPolicy networkPolicy;

  /**
   * Deprecated. The Google Developers Console [project ID or project
   * number](https://developers.google.com/console/help/new/#projectnumber). This field has been
   * deprecated and replaced by the name field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in
   * which the cluster resides. This field has been deprecated and replaced by the name field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * Deprecated. The name of the cluster. This field has been deprecated and replaced by the name
   * field.
   * @return value or {@code null} for none
   */
  public java.lang.String getClusterId() {
    return clusterId;
  }

  /**
   * Deprecated. The name of the cluster. This field has been deprecated and replaced by the name
   * field.
   * @param clusterId clusterId or {@code null} for none
   */
  public SetNetworkPolicyRequest setClusterId(java.lang.String clusterId) {
    this.clusterId = clusterId;
    return this;
  }

  /**
   * The name (project, location, cluster id) of the cluster to set networking policy. Specified in
   * the format 'projects/locations/clusters'.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name (project, location, cluster id) of the cluster to set networking policy. Specified in
   * the format 'projects/locations/clusters'.
   * @param name name or {@code null} for none
   */
  public SetNetworkPolicyRequest setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Required. Configuration options for the NetworkPolicy feature.
   * @return value or {@code null} for none
   */
  public NetworkPolicy getNetworkPolicy() {
    return networkPolicy;
  }

  /**
   * Required. Configuration options for the NetworkPolicy feature.
   * @param networkPolicy networkPolicy or {@code null} for none
   */
  public SetNetworkPolicyRequest setNetworkPolicy(NetworkPolicy networkPolicy) {
    this.networkPolicy = networkPolicy;
    return this;
  }

  /**
   * Deprecated. The Google Developers Console [project ID or project
   * number](https://developers.google.com/console/help/new/#projectnumber). This field has been
   * deprecated and replaced by the name field.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * Deprecated. The Google Developers Console [project ID or project
   * number](https://developers.google.com/console/help/new/#projectnumber). This field has been
   * deprecated and replaced by the name field.
   * @param projectId projectId or {@code null} for none
   */
  public SetNetworkPolicyRequest setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in
   * which the cluster resides. This field has been deprecated and replaced by the name field.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * Deprecated. The name of the Google Compute Engine [zone](/compute/docs/zones#available) in
   * which the cluster resides. This field has been deprecated and replaced by the name field.
   * @param zone zone or {@code null} for none
   */
  public SetNetworkPolicyRequest setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public SetNetworkPolicyRequest set(String fieldName, Object value) {
    return (SetNetworkPolicyRequest) super.set(fieldName, value);
  }

  @Override
  public SetNetworkPolicyRequest clone() {
    return (SetNetworkPolicyRequest) super.clone();
  }

}
