/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for AccountStatusAccountLevelIssue.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountStatusAccountLevelIssue extends com.google.api.client.json.GenericJson {

  /**
   * Country for which this issue is reported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * The destination the issue applies to. If this field is empty then the issue applies to all
   * available destinations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destination;

  /**
   * Additional details about the issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String detail;

  /**
   * The URL of a web page to help resolving this issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String documentation;

  /**
   * Issue identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Severity of the issue.
   *
   * Acceptable values are:   - "`critical`"  - "`error`"  - "`suggestion`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String severity;

  /**
   * Short description of the issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Country for which this issue is reported.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * Country for which this issue is reported.
   * @param country country or {@code null} for none
   */
  public AccountStatusAccountLevelIssue setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * The destination the issue applies to. If this field is empty then the issue applies to all
   * available destinations.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestination() {
    return destination;
  }

  /**
   * The destination the issue applies to. If this field is empty then the issue applies to all
   * available destinations.
   * @param destination destination or {@code null} for none
   */
  public AccountStatusAccountLevelIssue setDestination(java.lang.String destination) {
    this.destination = destination;
    return this;
  }

  /**
   * Additional details about the issue.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetail() {
    return detail;
  }

  /**
   * Additional details about the issue.
   * @param detail detail or {@code null} for none
   */
  public AccountStatusAccountLevelIssue setDetail(java.lang.String detail) {
    this.detail = detail;
    return this;
  }

  /**
   * The URL of a web page to help resolving this issue.
   * @return value or {@code null} for none
   */
  public java.lang.String getDocumentation() {
    return documentation;
  }

  /**
   * The URL of a web page to help resolving this issue.
   * @param documentation documentation or {@code null} for none
   */
  public AccountStatusAccountLevelIssue setDocumentation(java.lang.String documentation) {
    this.documentation = documentation;
    return this;
  }

  /**
   * Issue identifier.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Issue identifier.
   * @param id id or {@code null} for none
   */
  public AccountStatusAccountLevelIssue setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Severity of the issue.
   *
   * Acceptable values are:   - "`critical`"  - "`error`"  - "`suggestion`"
   * @return value or {@code null} for none
   */
  public java.lang.String getSeverity() {
    return severity;
  }

  /**
   * Severity of the issue.
   *
   * Acceptable values are:   - "`critical`"  - "`error`"  - "`suggestion`"
   * @param severity severity or {@code null} for none
   */
  public AccountStatusAccountLevelIssue setSeverity(java.lang.String severity) {
    this.severity = severity;
    return this;
  }

  /**
   * Short description of the issue.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Short description of the issue.
   * @param title title or {@code null} for none
   */
  public AccountStatusAccountLevelIssue setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public AccountStatusAccountLevelIssue set(String fieldName, Object value) {
    return (AccountStatusAccountLevelIssue) super.set(fieldName, value);
  }

  @Override
  public AccountStatusAccountLevelIssue clone() {
    return (AccountStatusAccountLevelIssue) super.clone();
  }

}
