/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for AccountsListLinksResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountsListLinksResponse extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "content#accountsListLinksResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The list of available links.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LinkedAccount> links;

  /**
   * The token for the retrieval of the next page of links.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "content#accountsListLinksResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "content#accountsListLinksResponse".
   * @param kind kind or {@code null} for none
   */
  public AccountsListLinksResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The list of available links.
   * @return value or {@code null} for none
   */
  public java.util.List<LinkedAccount> getLinks() {
    return links;
  }

  /**
   * The list of available links.
   * @param links links or {@code null} for none
   */
  public AccountsListLinksResponse setLinks(java.util.List<LinkedAccount> links) {
    this.links = links;
    return this;
  }

  /**
   * The token for the retrieval of the next page of links.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The token for the retrieval of the next page of links.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public AccountsListLinksResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public AccountsListLinksResponse set(String fieldName, Object value) {
    return (AccountsListLinksResponse) super.set(fieldName, value);
  }

  @Override
  public AccountsListLinksResponse clone() {
    return (AccountsListLinksResponse) super.clone();
  }

}
