/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A batch entry encoding a single non-batch accounttax response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccounttaxCustomBatchResponseEntry extends com.google.api.client.json.GenericJson {

  /**
   * The retrieved or updated account tax settings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountTax accountTax;

  /**
   * The ID of the request entry this entry responds to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long batchId;

  /**
   * A list of errors defined if and only if the request failed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Errors errors;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "`content#accounttaxCustomBatchResponseEntry`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The retrieved or updated account tax settings.
   * @return value or {@code null} for none
   */
  public AccountTax getAccountTax() {
    return accountTax;
  }

  /**
   * The retrieved or updated account tax settings.
   * @param accountTax accountTax or {@code null} for none
   */
  public AccounttaxCustomBatchResponseEntry setAccountTax(AccountTax accountTax) {
    this.accountTax = accountTax;
    return this;
  }

  /**
   * The ID of the request entry this entry responds to.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBatchId() {
    return batchId;
  }

  /**
   * The ID of the request entry this entry responds to.
   * @param batchId batchId or {@code null} for none
   */
  public AccounttaxCustomBatchResponseEntry setBatchId(java.lang.Long batchId) {
    this.batchId = batchId;
    return this;
  }

  /**
   * A list of errors defined if and only if the request failed.
   * @return value or {@code null} for none
   */
  public Errors getErrors() {
    return errors;
  }

  /**
   * A list of errors defined if and only if the request failed.
   * @param errors errors or {@code null} for none
   */
  public AccounttaxCustomBatchResponseEntry setErrors(Errors errors) {
    this.errors = errors;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "`content#accounttaxCustomBatchResponseEntry`"
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "`content#accounttaxCustomBatchResponseEntry`"
   * @param kind kind or {@code null} for none
   */
  public AccounttaxCustomBatchResponseEntry setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public AccounttaxCustomBatchResponseEntry set(String fieldName, Object value) {
    return (AccounttaxCustomBatchResponseEntry) super.set(fieldName, value);
  }

  @Override
  public AccounttaxCustomBatchResponseEntry clone() {
    return (AccounttaxCustomBatchResponseEntry) super.clone();
  }

}
