/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A batch entry encoding a single non-batch datafeedstatuses request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DatafeedstatusesCustomBatchRequestEntry extends com.google.api.client.json.GenericJson {

  /**
   * An entry ID, unique within the batch request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long batchId;

  /**
   * The country for which to get the datafeed status. If this parameter is provided then language
   * must also be provided. Note that for multi-target datafeeds this parameter is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * The ID of the data feed to get.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger datafeedId;

  /**
   * The language for which to get the datafeed status. If this parameter is provided then country
   * must also be provided. Note that for multi-target datafeeds this parameter is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String language;

  /**
   * The ID of the managing account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger merchantId;

  /**
   * The method of the batch entry.
   *
   * Acceptable values are:   - "`get`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String method;

  /**
   * An entry ID, unique within the batch request.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBatchId() {
    return batchId;
  }

  /**
   * An entry ID, unique within the batch request.
   * @param batchId batchId or {@code null} for none
   */
  public DatafeedstatusesCustomBatchRequestEntry setBatchId(java.lang.Long batchId) {
    this.batchId = batchId;
    return this;
  }

  /**
   * The country for which to get the datafeed status. If this parameter is provided then language
   * must also be provided. Note that for multi-target datafeeds this parameter is required.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * The country for which to get the datafeed status. If this parameter is provided then language
   * must also be provided. Note that for multi-target datafeeds this parameter is required.
   * @param country country or {@code null} for none
   */
  public DatafeedstatusesCustomBatchRequestEntry setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * The ID of the data feed to get.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getDatafeedId() {
    return datafeedId;
  }

  /**
   * The ID of the data feed to get.
   * @param datafeedId datafeedId or {@code null} for none
   */
  public DatafeedstatusesCustomBatchRequestEntry setDatafeedId(java.math.BigInteger datafeedId) {
    this.datafeedId = datafeedId;
    return this;
  }

  /**
   * The language for which to get the datafeed status. If this parameter is provided then country
   * must also be provided. Note that for multi-target datafeeds this parameter is required.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguage() {
    return language;
  }

  /**
   * The language for which to get the datafeed status. If this parameter is provided then country
   * must also be provided. Note that for multi-target datafeeds this parameter is required.
   * @param language language or {@code null} for none
   */
  public DatafeedstatusesCustomBatchRequestEntry setLanguage(java.lang.String language) {
    this.language = language;
    return this;
  }

  /**
   * The ID of the managing account.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getMerchantId() {
    return merchantId;
  }

  /**
   * The ID of the managing account.
   * @param merchantId merchantId or {@code null} for none
   */
  public DatafeedstatusesCustomBatchRequestEntry setMerchantId(java.math.BigInteger merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * The method of the batch entry.
   *
   * Acceptable values are:   - "`get`"
   * @return value or {@code null} for none
   */
  public java.lang.String getMethod() {
    return method;
  }

  /**
   * The method of the batch entry.
   *
   * Acceptable values are:   - "`get`"
   * @param method method or {@code null} for none
   */
  public DatafeedstatusesCustomBatchRequestEntry setMethod(java.lang.String method) {
    this.method = method;
    return this;
  }

  @Override
  public DatafeedstatusesCustomBatchRequestEntry set(String fieldName, Object value) {
    return (DatafeedstatusesCustomBatchRequestEntry) super.set(fieldName, value);
  }

  @Override
  public DatafeedstatusesCustomBatchRequestEntry clone() {
    return (DatafeedstatusesCustomBatchRequestEntry) super.clone();
  }

}
