/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for DeliveryTime.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeliveryTime extends com.google.api.client.json.GenericJson {

  /**
   * Business days cutoff time definition. If not configured the cutoff time will be defaulted to
   * 8AM PST.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CutoffTime cutoffTime;

  /**
   * The business days during which orders can be handled. If not provided, Monday to Friday
   * business days will be assumed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BusinessDayConfig handlingBusinessDayConfig;

  /**
   * Holiday cutoff definitions. If configured, they specify order cutoff times for holiday-specific
   * shipping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HolidayCutoff> holidayCutoffs;

  /**
   * Maximum number of business days spent before an order is shipped. 0 means same day shipped, 1
   * means next day shipped. Must be greater than or equal to `minHandlingTimeInDays`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long maxHandlingTimeInDays;

  /**
   * Maximum number of business days that is spent in transit. 0 means same day delivery, 1 means
   * next day delivery. Must be greater than or equal to `minTransitTimeInDays`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long maxTransitTimeInDays;

  /**
   * Minimum number of business days spent before an order is shipped. 0 means same day shipped, 1
   * means next day shipped.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long minHandlingTimeInDays;

  /**
   * Minimum number of business days that is spent in transit. 0 means same day delivery, 1 means
   * next day delivery. Either `{min,max}TransitTimeInDays` or `transitTimeTable` must be set, but
   * not both.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long minTransitTimeInDays;

  /**
   * The business days during which orders can be in-transit. If not provided, Monday to Friday
   * business days will be assumed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BusinessDayConfig transitBusinessDayConfig;

  /**
   * Transit time table, number of business days spent in transit based on row and column
   * dimensions. Either `{min,max}TransitTimeInDays` or `transitTimeTable` can be set, but not both.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransitTable transitTimeTable;

  /**
   * Business days cutoff time definition. If not configured the cutoff time will be defaulted to
   * 8AM PST.
   * @return value or {@code null} for none
   */
  public CutoffTime getCutoffTime() {
    return cutoffTime;
  }

  /**
   * Business days cutoff time definition. If not configured the cutoff time will be defaulted to
   * 8AM PST.
   * @param cutoffTime cutoffTime or {@code null} for none
   */
  public DeliveryTime setCutoffTime(CutoffTime cutoffTime) {
    this.cutoffTime = cutoffTime;
    return this;
  }

  /**
   * The business days during which orders can be handled. If not provided, Monday to Friday
   * business days will be assumed.
   * @return value or {@code null} for none
   */
  public BusinessDayConfig getHandlingBusinessDayConfig() {
    return handlingBusinessDayConfig;
  }

  /**
   * The business days during which orders can be handled. If not provided, Monday to Friday
   * business days will be assumed.
   * @param handlingBusinessDayConfig handlingBusinessDayConfig or {@code null} for none
   */
  public DeliveryTime setHandlingBusinessDayConfig(BusinessDayConfig handlingBusinessDayConfig) {
    this.handlingBusinessDayConfig = handlingBusinessDayConfig;
    return this;
  }

  /**
   * Holiday cutoff definitions. If configured, they specify order cutoff times for holiday-specific
   * shipping.
   * @return value or {@code null} for none
   */
  public java.util.List<HolidayCutoff> getHolidayCutoffs() {
    return holidayCutoffs;
  }

  /**
   * Holiday cutoff definitions. If configured, they specify order cutoff times for holiday-specific
   * shipping.
   * @param holidayCutoffs holidayCutoffs or {@code null} for none
   */
  public DeliveryTime setHolidayCutoffs(java.util.List<HolidayCutoff> holidayCutoffs) {
    this.holidayCutoffs = holidayCutoffs;
    return this;
  }

  /**
   * Maximum number of business days spent before an order is shipped. 0 means same day shipped, 1
   * means next day shipped. Must be greater than or equal to `minHandlingTimeInDays`.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxHandlingTimeInDays() {
    return maxHandlingTimeInDays;
  }

  /**
   * Maximum number of business days spent before an order is shipped. 0 means same day shipped, 1
   * means next day shipped. Must be greater than or equal to `minHandlingTimeInDays`.
   * @param maxHandlingTimeInDays maxHandlingTimeInDays or {@code null} for none
   */
  public DeliveryTime setMaxHandlingTimeInDays(java.lang.Long maxHandlingTimeInDays) {
    this.maxHandlingTimeInDays = maxHandlingTimeInDays;
    return this;
  }

  /**
   * Maximum number of business days that is spent in transit. 0 means same day delivery, 1 means
   * next day delivery. Must be greater than or equal to `minTransitTimeInDays`.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxTransitTimeInDays() {
    return maxTransitTimeInDays;
  }

  /**
   * Maximum number of business days that is spent in transit. 0 means same day delivery, 1 means
   * next day delivery. Must be greater than or equal to `minTransitTimeInDays`.
   * @param maxTransitTimeInDays maxTransitTimeInDays or {@code null} for none
   */
  public DeliveryTime setMaxTransitTimeInDays(java.lang.Long maxTransitTimeInDays) {
    this.maxTransitTimeInDays = maxTransitTimeInDays;
    return this;
  }

  /**
   * Minimum number of business days spent before an order is shipped. 0 means same day shipped, 1
   * means next day shipped.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinHandlingTimeInDays() {
    return minHandlingTimeInDays;
  }

  /**
   * Minimum number of business days spent before an order is shipped. 0 means same day shipped, 1
   * means next day shipped.
   * @param minHandlingTimeInDays minHandlingTimeInDays or {@code null} for none
   */
  public DeliveryTime setMinHandlingTimeInDays(java.lang.Long minHandlingTimeInDays) {
    this.minHandlingTimeInDays = minHandlingTimeInDays;
    return this;
  }

  /**
   * Minimum number of business days that is spent in transit. 0 means same day delivery, 1 means
   * next day delivery. Either `{min,max}TransitTimeInDays` or `transitTimeTable` must be set, but
   * not both.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinTransitTimeInDays() {
    return minTransitTimeInDays;
  }

  /**
   * Minimum number of business days that is spent in transit. 0 means same day delivery, 1 means
   * next day delivery. Either `{min,max}TransitTimeInDays` or `transitTimeTable` must be set, but
   * not both.
   * @param minTransitTimeInDays minTransitTimeInDays or {@code null} for none
   */
  public DeliveryTime setMinTransitTimeInDays(java.lang.Long minTransitTimeInDays) {
    this.minTransitTimeInDays = minTransitTimeInDays;
    return this;
  }

  /**
   * The business days during which orders can be in-transit. If not provided, Monday to Friday
   * business days will be assumed.
   * @return value or {@code null} for none
   */
  public BusinessDayConfig getTransitBusinessDayConfig() {
    return transitBusinessDayConfig;
  }

  /**
   * The business days during which orders can be in-transit. If not provided, Monday to Friday
   * business days will be assumed.
   * @param transitBusinessDayConfig transitBusinessDayConfig or {@code null} for none
   */
  public DeliveryTime setTransitBusinessDayConfig(BusinessDayConfig transitBusinessDayConfig) {
    this.transitBusinessDayConfig = transitBusinessDayConfig;
    return this;
  }

  /**
   * Transit time table, number of business days spent in transit based on row and column
   * dimensions. Either `{min,max}TransitTimeInDays` or `transitTimeTable` can be set, but not both.
   * @return value or {@code null} for none
   */
  public TransitTable getTransitTimeTable() {
    return transitTimeTable;
  }

  /**
   * Transit time table, number of business days spent in transit based on row and column
   * dimensions. Either `{min,max}TransitTimeInDays` or `transitTimeTable` can be set, but not both.
   * @param transitTimeTable transitTimeTable or {@code null} for none
   */
  public DeliveryTime setTransitTimeTable(TransitTable transitTimeTable) {
    this.transitTimeTable = transitTimeTable;
    return this;
  }

  @Override
  public DeliveryTime set(String fieldName, Object value) {
    return (DeliveryTime) super.set(fieldName, value);
  }

  @Override
  public DeliveryTime clone() {
    return (DeliveryTime) super.clone();
  }

}
