/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for HolidayCutoff.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HolidayCutoff extends com.google.api.client.json.GenericJson {

  /**
   * Date of the order deadline, in ISO 8601 format. E.g. "2016-11-29" for 29th November 2016.
   * Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deadlineDate;

  /**
   * Hour of the day on the deadline date until which the order has to be placed to qualify for the
   * delivery guarantee. Possible values are: 0 (midnight), 1, ..., 12 (noon), 13, ..., 23.
   * Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long deadlineHour;

  /**
   * Timezone identifier for the deadline hour. A list of identifiers can be found in  the AdWords
   * API documentation. E.g. "Europe/Zurich". Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deadlineTimezone;

  /**
   * Unique identifier for the holiday. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String holidayId;

  /**
   * Date on which the deadline will become visible to consumers in ISO 8601 format. E.g.
   * "2016-10-31" for 31st October 2016. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String visibleFromDate;

  /**
   * Date of the order deadline, in ISO 8601 format. E.g. "2016-11-29" for 29th November 2016.
   * Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeadlineDate() {
    return deadlineDate;
  }

  /**
   * Date of the order deadline, in ISO 8601 format. E.g. "2016-11-29" for 29th November 2016.
   * Required.
   * @param deadlineDate deadlineDate or {@code null} for none
   */
  public HolidayCutoff setDeadlineDate(java.lang.String deadlineDate) {
    this.deadlineDate = deadlineDate;
    return this;
  }

  /**
   * Hour of the day on the deadline date until which the order has to be placed to qualify for the
   * delivery guarantee. Possible values are: 0 (midnight), 1, ..., 12 (noon), 13, ..., 23.
   * Required.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDeadlineHour() {
    return deadlineHour;
  }

  /**
   * Hour of the day on the deadline date until which the order has to be placed to qualify for the
   * delivery guarantee. Possible values are: 0 (midnight), 1, ..., 12 (noon), 13, ..., 23.
   * Required.
   * @param deadlineHour deadlineHour or {@code null} for none
   */
  public HolidayCutoff setDeadlineHour(java.lang.Long deadlineHour) {
    this.deadlineHour = deadlineHour;
    return this;
  }

  /**
   * Timezone identifier for the deadline hour. A list of identifiers can be found in  the AdWords
   * API documentation. E.g. "Europe/Zurich". Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeadlineTimezone() {
    return deadlineTimezone;
  }

  /**
   * Timezone identifier for the deadline hour. A list of identifiers can be found in  the AdWords
   * API documentation. E.g. "Europe/Zurich". Required.
   * @param deadlineTimezone deadlineTimezone or {@code null} for none
   */
  public HolidayCutoff setDeadlineTimezone(java.lang.String deadlineTimezone) {
    this.deadlineTimezone = deadlineTimezone;
    return this;
  }

  /**
   * Unique identifier for the holiday. Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getHolidayId() {
    return holidayId;
  }

  /**
   * Unique identifier for the holiday. Required.
   * @param holidayId holidayId or {@code null} for none
   */
  public HolidayCutoff setHolidayId(java.lang.String holidayId) {
    this.holidayId = holidayId;
    return this;
  }

  /**
   * Date on which the deadline will become visible to consumers in ISO 8601 format. E.g.
   * "2016-10-31" for 31st October 2016. Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getVisibleFromDate() {
    return visibleFromDate;
  }

  /**
   * Date on which the deadline will become visible to consumers in ISO 8601 format. E.g.
   * "2016-10-31" for 31st October 2016. Required.
   * @param visibleFromDate visibleFromDate or {@code null} for none
   */
  public HolidayCutoff setVisibleFromDate(java.lang.String visibleFromDate) {
    this.visibleFromDate = visibleFromDate;
    return this;
  }

  @Override
  public HolidayCutoff set(String fieldName, Object value) {
    return (HolidayCutoff) super.set(fieldName, value);
  }

  @Override
  public HolidayCutoff clone() {
    return (HolidayCutoff) super.clone();
  }

}
