/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for HolidaysHoliday.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HolidaysHoliday extends com.google.api.client.json.GenericJson {

  /**
   * The CLDR territory code of the country in which the holiday is available. E.g. "US", "DE",
   * "GB". A holiday cutoff can only be configured in a shipping settings service with matching
   * delivery country. Always present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * Date of the holiday, in ISO 8601 format. E.g. "2016-12-25" for Christmas 2016. Always present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String date;

  /**
   * Date on which the order has to arrive at the customer's, in ISO 8601 format. E.g. "2016-12-24"
   * for 24th December 2016. Always present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deliveryGuaranteeDate;

  /**
   * Hour of the day in the delivery location's timezone on the guaranteed delivery date by which
   * the order has to arrive at the customer's. Possible values are: 0 (midnight), 1, ..., 12
   * (noon), 13, ..., 23. Always present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger deliveryGuaranteeHour;

  /**
   * Unique identifier for the holiday to be used when configuring holiday cutoffs. Always present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The holiday type. Always present.
   *
   * Acceptable values are:   - "`Christmas`"  - "`Easter`"  - "`Father's Day`"  - "`Halloween`"  -
   * "`Independence Day (USA)`"  - "`Mother's Day`"  - "`Thanksgiving`"  - "`Valentine's Day`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The CLDR territory code of the country in which the holiday is available. E.g. "US", "DE",
   * "GB". A holiday cutoff can only be configured in a shipping settings service with matching
   * delivery country. Always present.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * The CLDR territory code of the country in which the holiday is available. E.g. "US", "DE",
   * "GB". A holiday cutoff can only be configured in a shipping settings service with matching
   * delivery country. Always present.
   * @param countryCode countryCode or {@code null} for none
   */
  public HolidaysHoliday setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Date of the holiday, in ISO 8601 format. E.g. "2016-12-25" for Christmas 2016. Always present.
   * @return value or {@code null} for none
   */
  public java.lang.String getDate() {
    return date;
  }

  /**
   * Date of the holiday, in ISO 8601 format. E.g. "2016-12-25" for Christmas 2016. Always present.
   * @param date date or {@code null} for none
   */
  public HolidaysHoliday setDate(java.lang.String date) {
    this.date = date;
    return this;
  }

  /**
   * Date on which the order has to arrive at the customer's, in ISO 8601 format. E.g. "2016-12-24"
   * for 24th December 2016. Always present.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeliveryGuaranteeDate() {
    return deliveryGuaranteeDate;
  }

  /**
   * Date on which the order has to arrive at the customer's, in ISO 8601 format. E.g. "2016-12-24"
   * for 24th December 2016. Always present.
   * @param deliveryGuaranteeDate deliveryGuaranteeDate or {@code null} for none
   */
  public HolidaysHoliday setDeliveryGuaranteeDate(java.lang.String deliveryGuaranteeDate) {
    this.deliveryGuaranteeDate = deliveryGuaranteeDate;
    return this;
  }

  /**
   * Hour of the day in the delivery location's timezone on the guaranteed delivery date by which
   * the order has to arrive at the customer's. Possible values are: 0 (midnight), 1, ..., 12
   * (noon), 13, ..., 23. Always present.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getDeliveryGuaranteeHour() {
    return deliveryGuaranteeHour;
  }

  /**
   * Hour of the day in the delivery location's timezone on the guaranteed delivery date by which
   * the order has to arrive at the customer's. Possible values are: 0 (midnight), 1, ..., 12
   * (noon), 13, ..., 23. Always present.
   * @param deliveryGuaranteeHour deliveryGuaranteeHour or {@code null} for none
   */
  public HolidaysHoliday setDeliveryGuaranteeHour(java.math.BigInteger deliveryGuaranteeHour) {
    this.deliveryGuaranteeHour = deliveryGuaranteeHour;
    return this;
  }

  /**
   * Unique identifier for the holiday to be used when configuring holiday cutoffs. Always present.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Unique identifier for the holiday to be used when configuring holiday cutoffs. Always present.
   * @param id id or {@code null} for none
   */
  public HolidaysHoliday setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The holiday type. Always present.
   *
   * Acceptable values are:   - "`Christmas`"  - "`Easter`"  - "`Father's Day`"  - "`Halloween`"  -
   * "`Independence Day (USA)`"  - "`Mother's Day`"  - "`Thanksgiving`"  - "`Valentine's Day`"
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The holiday type. Always present.
   *
   * Acceptable values are:   - "`Christmas`"  - "`Easter`"  - "`Father's Day`"  - "`Halloween`"  -
   * "`Independence Day (USA)`"  - "`Mother's Day`"  - "`Thanksgiving`"  - "`Valentine's Day`"
   * @param type type or {@code null} for none
   */
  public HolidaysHoliday setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public HolidaysHoliday set(String fieldName, Object value) {
    return (HolidaysHoliday) super.set(fieldName, value);
  }

  @Override
  public HolidaysHoliday clone() {
    return (HolidaysHoliday) super.clone();
  }

}
