/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for LiaPosDataProvider.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiaPosDataProvider extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the POS data provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger posDataProviderId;

  /**
   * The account ID by which this merchant is known to the POS data provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String posExternalAccountId;

  /**
   * The ID of the POS data provider.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getPosDataProviderId() {
    return posDataProviderId;
  }

  /**
   * The ID of the POS data provider.
   * @param posDataProviderId posDataProviderId or {@code null} for none
   */
  public LiaPosDataProvider setPosDataProviderId(java.math.BigInteger posDataProviderId) {
    this.posDataProviderId = posDataProviderId;
    return this;
  }

  /**
   * The account ID by which this merchant is known to the POS data provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getPosExternalAccountId() {
    return posExternalAccountId;
  }

  /**
   * The account ID by which this merchant is known to the POS data provider.
   * @param posExternalAccountId posExternalAccountId or {@code null} for none
   */
  public LiaPosDataProvider setPosExternalAccountId(java.lang.String posExternalAccountId) {
    this.posExternalAccountId = posExternalAccountId;
    return this;
  }

  @Override
  public LiaPosDataProvider set(String fieldName, Object value) {
    return (LiaPosDataProvider) super.set(fieldName, value);
  }

  @Override
  public LiaPosDataProvider clone() {
    return (LiaPosDataProvider) super.clone();
  }

}
