/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for LiasettingsGetAccessibleGmbAccountsResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiasettingsGetAccessibleGmbAccountsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the Merchant Center account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger accountId;

  /**
   * A list of GMB accounts which are available to the merchant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GmbAccountsGmbAccount> gmbAccounts;

  static {
    // hack to force ProGuard to consider GmbAccountsGmbAccount used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GmbAccountsGmbAccount.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "content#liasettingsGetAccessibleGmbAccountsResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The ID of the Merchant Center account.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getAccountId() {
    return accountId;
  }

  /**
   * The ID of the Merchant Center account.
   * @param accountId accountId or {@code null} for none
   */
  public LiasettingsGetAccessibleGmbAccountsResponse setAccountId(java.math.BigInteger accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * A list of GMB accounts which are available to the merchant.
   * @return value or {@code null} for none
   */
  public java.util.List<GmbAccountsGmbAccount> getGmbAccounts() {
    return gmbAccounts;
  }

  /**
   * A list of GMB accounts which are available to the merchant.
   * @param gmbAccounts gmbAccounts or {@code null} for none
   */
  public LiasettingsGetAccessibleGmbAccountsResponse setGmbAccounts(java.util.List<GmbAccountsGmbAccount> gmbAccounts) {
    this.gmbAccounts = gmbAccounts;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "content#liasettingsGetAccessibleGmbAccountsResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "content#liasettingsGetAccessibleGmbAccountsResponse".
   * @param kind kind or {@code null} for none
   */
  public LiasettingsGetAccessibleGmbAccountsResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public LiasettingsGetAccessibleGmbAccountsResponse set(String fieldName, Object value) {
    return (LiasettingsGetAccessibleGmbAccountsResponse) super.set(fieldName, value);
  }

  @Override
  public LiasettingsGetAccessibleGmbAccountsResponse clone() {
    return (LiasettingsGetAccessibleGmbAccountsResponse) super.clone();
  }

}
