/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Order. Production access (all methods) requires the order manager role. Sandbox access does not.
 * (== resource_for v2.orders ==) (== resource_for v2.1.orders ==)
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Order extends com.google.api.client.json.GenericJson {

  /**
   * Whether the order was acknowledged.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean acknowledged;

  /**
   * List of key-value pairs that are attached to a given order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderOrderAnnotation> annotations;

  /**
   * The billing address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrderAddress billingAddress;

  /**
   * The details of the customer who placed the order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrderCustomer customer;

  /**
   * Delivery details for shipments of type `delivery`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrderDeliveryDetails deliveryDetails;

  /**
   * The REST ID of the order. Globally unique.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#order`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Line items that are ordered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderLineItem> lineItems;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger merchantId;

  /**
   * Merchant-provided ID of the order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String merchantOrderId;

  /**
   * The net amount for the order (price part). For example, if an order was originally for $100 and
   * a refund was issued for $20, the net amount will be $80.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price netPriceAmount;

  /**
   * The net amount for the order (tax part). Note that in certain cases due to taxable base
   * adjustment `netTaxAmount` might not match to a sum of tax field across all lineItems and
   * refunds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price netTaxAmount;

  /**
   * The status of the payment.
   *
   * Acceptable values are:   - "`paymentCaptured`"  - "`paymentRejected`"  - "`paymentSecured`"  -
   * "`pendingAuthorization`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String paymentStatus;

  /**
   * Pickup details for shipments of type `pickup`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrderPickupDetails pickupDetails;

  /**
   * The date when the order was placed, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String placedDate;

  /**
   * Promotions associated with the order.
   *
   * To determine which promotions apply to which products, check the
   * `Promotions[].appliedItems[].lineItemId` field against the `LineItems[].id` field for each
   * promotion. If a promotion is applied to more than 1 offerId, divide the discount value by the
   * number of affected offers to determine how much discount to apply to each offerId.
   *
   * Examples:   - To calculate price paid by the customer for a single line item including the
   * discount: For each promotion, subtract the `LineItems[].adjustments[].priceAdjustment.value`
   * amount from the `LineItems[].Price.value`.  - To calculate price paid by the customer for a
   * single line item including the discount in case of multiple quantity: For each promotion,
   * divide the `LineItems[].adjustments[].priceAdjustment.value` by the quantity of products then
   * subtract the resulting value from the `LineItems[].Product.Price.value` for each quantity item.
   *
   * Only 1 promotion can be applied to an offerId in a given order. To refund an item which had a
   * promotion applied to it, make sure to refund the amount after first subtracting the promotion
   * discount from the item price.
   *
   * More details about the program are here.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderPromotion> promotions;

  /**
   * Refunds for the order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderRefund> refunds;

  /**
   * Shipments of the order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderShipment> shipments;

  /**
   * The total cost of shipping for all items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price shippingCost;

  /**
   * The tax for the total shipping cost.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price shippingCostTax;

  /**
   * The status of the order.
   *
   * Acceptable values are:   - "`canceled`"  - "`delivered`"  - "`inProgress`"  -
   * "`partiallyDelivered`"  - "`partiallyReturned`"  - "`partiallyShipped`"  - "`pendingShipment`"
   * - "`returned`"  - "`shipped`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The party responsible for collecting and remitting taxes.
   *
   * Acceptable values are:   - "`marketplaceFacilitator`"  - "`merchant`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String taxCollector;

  /**
   * Whether the order was acknowledged.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAcknowledged() {
    return acknowledged;
  }

  /**
   * Whether the order was acknowledged.
   * @param acknowledged acknowledged or {@code null} for none
   */
  public Order setAcknowledged(java.lang.Boolean acknowledged) {
    this.acknowledged = acknowledged;
    return this;
  }

  /**
   * List of key-value pairs that are attached to a given order.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderOrderAnnotation> getAnnotations() {
    return annotations;
  }

  /**
   * List of key-value pairs that are attached to a given order.
   * @param annotations annotations or {@code null} for none
   */
  public Order setAnnotations(java.util.List<OrderOrderAnnotation> annotations) {
    this.annotations = annotations;
    return this;
  }

  /**
   * The billing address.
   * @return value or {@code null} for none
   */
  public OrderAddress getBillingAddress() {
    return billingAddress;
  }

  /**
   * The billing address.
   * @param billingAddress billingAddress or {@code null} for none
   */
  public Order setBillingAddress(OrderAddress billingAddress) {
    this.billingAddress = billingAddress;
    return this;
  }

  /**
   * The details of the customer who placed the order.
   * @return value or {@code null} for none
   */
  public OrderCustomer getCustomer() {
    return customer;
  }

  /**
   * The details of the customer who placed the order.
   * @param customer customer or {@code null} for none
   */
  public Order setCustomer(OrderCustomer customer) {
    this.customer = customer;
    return this;
  }

  /**
   * Delivery details for shipments of type `delivery`.
   * @return value or {@code null} for none
   */
  public OrderDeliveryDetails getDeliveryDetails() {
    return deliveryDetails;
  }

  /**
   * Delivery details for shipments of type `delivery`.
   * @param deliveryDetails deliveryDetails or {@code null} for none
   */
  public Order setDeliveryDetails(OrderDeliveryDetails deliveryDetails) {
    this.deliveryDetails = deliveryDetails;
    return this;
  }

  /**
   * The REST ID of the order. Globally unique.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The REST ID of the order. Globally unique.
   * @param id id or {@code null} for none
   */
  public Order setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#order`"
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#order`"
   * @param kind kind or {@code null} for none
   */
  public Order setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Line items that are ordered.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderLineItem> getLineItems() {
    return lineItems;
  }

  /**
   * Line items that are ordered.
   * @param lineItems lineItems or {@code null} for none
   */
  public Order setLineItems(java.util.List<OrderLineItem> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getMerchantId() {
    return merchantId;
  }

  /**
   * @param merchantId merchantId or {@code null} for none
   */
  public Order setMerchantId(java.math.BigInteger merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * Merchant-provided ID of the order.
   * @return value or {@code null} for none
   */
  public java.lang.String getMerchantOrderId() {
    return merchantOrderId;
  }

  /**
   * Merchant-provided ID of the order.
   * @param merchantOrderId merchantOrderId or {@code null} for none
   */
  public Order setMerchantOrderId(java.lang.String merchantOrderId) {
    this.merchantOrderId = merchantOrderId;
    return this;
  }

  /**
   * The net amount for the order (price part). For example, if an order was originally for $100 and
   * a refund was issued for $20, the net amount will be $80.
   * @return value or {@code null} for none
   */
  public Price getNetPriceAmount() {
    return netPriceAmount;
  }

  /**
   * The net amount for the order (price part). For example, if an order was originally for $100 and
   * a refund was issued for $20, the net amount will be $80.
   * @param netPriceAmount netPriceAmount or {@code null} for none
   */
  public Order setNetPriceAmount(Price netPriceAmount) {
    this.netPriceAmount = netPriceAmount;
    return this;
  }

  /**
   * The net amount for the order (tax part). Note that in certain cases due to taxable base
   * adjustment `netTaxAmount` might not match to a sum of tax field across all lineItems and
   * refunds.
   * @return value or {@code null} for none
   */
  public Price getNetTaxAmount() {
    return netTaxAmount;
  }

  /**
   * The net amount for the order (tax part). Note that in certain cases due to taxable base
   * adjustment `netTaxAmount` might not match to a sum of tax field across all lineItems and
   * refunds.
   * @param netTaxAmount netTaxAmount or {@code null} for none
   */
  public Order setNetTaxAmount(Price netTaxAmount) {
    this.netTaxAmount = netTaxAmount;
    return this;
  }

  /**
   * The status of the payment.
   *
   * Acceptable values are:   - "`paymentCaptured`"  - "`paymentRejected`"  - "`paymentSecured`"  -
   * "`pendingAuthorization`"
   * @return value or {@code null} for none
   */
  public java.lang.String getPaymentStatus() {
    return paymentStatus;
  }

  /**
   * The status of the payment.
   *
   * Acceptable values are:   - "`paymentCaptured`"  - "`paymentRejected`"  - "`paymentSecured`"  -
   * "`pendingAuthorization`"
   * @param paymentStatus paymentStatus or {@code null} for none
   */
  public Order setPaymentStatus(java.lang.String paymentStatus) {
    this.paymentStatus = paymentStatus;
    return this;
  }

  /**
   * Pickup details for shipments of type `pickup`.
   * @return value or {@code null} for none
   */
  public OrderPickupDetails getPickupDetails() {
    return pickupDetails;
  }

  /**
   * Pickup details for shipments of type `pickup`.
   * @param pickupDetails pickupDetails or {@code null} for none
   */
  public Order setPickupDetails(OrderPickupDetails pickupDetails) {
    this.pickupDetails = pickupDetails;
    return this;
  }

  /**
   * The date when the order was placed, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlacedDate() {
    return placedDate;
  }

  /**
   * The date when the order was placed, in ISO 8601 format.
   * @param placedDate placedDate or {@code null} for none
   */
  public Order setPlacedDate(java.lang.String placedDate) {
    this.placedDate = placedDate;
    return this;
  }

  /**
   * Promotions associated with the order.
   *
   * To determine which promotions apply to which products, check the
   * `Promotions[].appliedItems[].lineItemId` field against the `LineItems[].id` field for each
   * promotion. If a promotion is applied to more than 1 offerId, divide the discount value by the
   * number of affected offers to determine how much discount to apply to each offerId.
   *
   * Examples:   - To calculate price paid by the customer for a single line item including the
   * discount: For each promotion, subtract the `LineItems[].adjustments[].priceAdjustment.value`
   * amount from the `LineItems[].Price.value`.  - To calculate price paid by the customer for a
   * single line item including the discount in case of multiple quantity: For each promotion,
   * divide the `LineItems[].adjustments[].priceAdjustment.value` by the quantity of products then
   * subtract the resulting value from the `LineItems[].Product.Price.value` for each quantity item.
   *
   * Only 1 promotion can be applied to an offerId in a given order. To refund an item which had a
   * promotion applied to it, make sure to refund the amount after first subtracting the promotion
   * discount from the item price.
   *
   * More details about the program are here.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderPromotion> getPromotions() {
    return promotions;
  }

  /**
   * Promotions associated with the order.
   *
   * To determine which promotions apply to which products, check the
   * `Promotions[].appliedItems[].lineItemId` field against the `LineItems[].id` field for each
   * promotion. If a promotion is applied to more than 1 offerId, divide the discount value by the
   * number of affected offers to determine how much discount to apply to each offerId.
   *
   * Examples:   - To calculate price paid by the customer for a single line item including the
   * discount: For each promotion, subtract the `LineItems[].adjustments[].priceAdjustment.value`
   * amount from the `LineItems[].Price.value`.  - To calculate price paid by the customer for a
   * single line item including the discount in case of multiple quantity: For each promotion,
   * divide the `LineItems[].adjustments[].priceAdjustment.value` by the quantity of products then
   * subtract the resulting value from the `LineItems[].Product.Price.value` for each quantity item.
   *
   * Only 1 promotion can be applied to an offerId in a given order. To refund an item which had a
   * promotion applied to it, make sure to refund the amount after first subtracting the promotion
   * discount from the item price.
   *
   * More details about the program are here.
   * @param promotions promotions or {@code null} for none
   */
  public Order setPromotions(java.util.List<OrderPromotion> promotions) {
    this.promotions = promotions;
    return this;
  }

  /**
   * Refunds for the order.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderRefund> getRefunds() {
    return refunds;
  }

  /**
   * Refunds for the order.
   * @param refunds refunds or {@code null} for none
   */
  public Order setRefunds(java.util.List<OrderRefund> refunds) {
    this.refunds = refunds;
    return this;
  }

  /**
   * Shipments of the order.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderShipment> getShipments() {
    return shipments;
  }

  /**
   * Shipments of the order.
   * @param shipments shipments or {@code null} for none
   */
  public Order setShipments(java.util.List<OrderShipment> shipments) {
    this.shipments = shipments;
    return this;
  }

  /**
   * The total cost of shipping for all items.
   * @return value or {@code null} for none
   */
  public Price getShippingCost() {
    return shippingCost;
  }

  /**
   * The total cost of shipping for all items.
   * @param shippingCost shippingCost or {@code null} for none
   */
  public Order setShippingCost(Price shippingCost) {
    this.shippingCost = shippingCost;
    return this;
  }

  /**
   * The tax for the total shipping cost.
   * @return value or {@code null} for none
   */
  public Price getShippingCostTax() {
    return shippingCostTax;
  }

  /**
   * The tax for the total shipping cost.
   * @param shippingCostTax shippingCostTax or {@code null} for none
   */
  public Order setShippingCostTax(Price shippingCostTax) {
    this.shippingCostTax = shippingCostTax;
    return this;
  }

  /**
   * The status of the order.
   *
   * Acceptable values are:   - "`canceled`"  - "`delivered`"  - "`inProgress`"  -
   * "`partiallyDelivered`"  - "`partiallyReturned`"  - "`partiallyShipped`"  - "`pendingShipment`"
   * - "`returned`"  - "`shipped`"
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of the order.
   *
   * Acceptable values are:   - "`canceled`"  - "`delivered`"  - "`inProgress`"  -
   * "`partiallyDelivered`"  - "`partiallyReturned`"  - "`partiallyShipped`"  - "`pendingShipment`"
   * - "`returned`"  - "`shipped`"
   * @param status status or {@code null} for none
   */
  public Order setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * The party responsible for collecting and remitting taxes.
   *
   * Acceptable values are:   - "`marketplaceFacilitator`"  - "`merchant`"
   * @return value or {@code null} for none
   */
  public java.lang.String getTaxCollector() {
    return taxCollector;
  }

  /**
   * The party responsible for collecting and remitting taxes.
   *
   * Acceptable values are:   - "`marketplaceFacilitator`"  - "`merchant`"
   * @param taxCollector taxCollector or {@code null} for none
   */
  public Order setTaxCollector(java.lang.String taxCollector) {
    this.taxCollector = taxCollector;
    return this;
  }

  @Override
  public Order set(String fieldName, Object value) {
    return (Order) super.set(fieldName, value);
  }

  @Override
  public Order clone() {
    return (Order) super.clone();
  }

}
