/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderCustomerMarketingRightsInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderCustomerMarketingRightsInfo extends com.google.api.client.json.GenericJson {

  /**
   * Last known customer selection regarding marketing preferences. In certain cases this selection
   * might not be known, so this field would be empty. If a customer selected `granted` in their
   * most recent order, they can be subscribed to marketing emails. Customers who have chosen
   * `denied` must not be subscribed, or must be unsubscribed if already opted-in.
   *
   * Acceptable values are:   - "`denied`"  - "`granted`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String explicitMarketingPreference;

  /**
   * Timestamp when last time marketing preference was updated. Could be empty, if user wasn't
   * offered a selection yet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastUpdatedTimestamp;

  /**
   * Email address that can be used for marketing purposes. The field may be empty even if
   * `explicitMarketingPreference` is 'granted'. This happens when retrieving an old order from the
   * customer who deleted their account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String marketingEmailAddress;

  /**
   * Last known customer selection regarding marketing preferences. In certain cases this selection
   * might not be known, so this field would be empty. If a customer selected `granted` in their
   * most recent order, they can be subscribed to marketing emails. Customers who have chosen
   * `denied` must not be subscribed, or must be unsubscribed if already opted-in.
   *
   * Acceptable values are:   - "`denied`"  - "`granted`"
   * @return value or {@code null} for none
   */
  public java.lang.String getExplicitMarketingPreference() {
    return explicitMarketingPreference;
  }

  /**
   * Last known customer selection regarding marketing preferences. In certain cases this selection
   * might not be known, so this field would be empty. If a customer selected `granted` in their
   * most recent order, they can be subscribed to marketing emails. Customers who have chosen
   * `denied` must not be subscribed, or must be unsubscribed if already opted-in.
   *
   * Acceptable values are:   - "`denied`"  - "`granted`"
   * @param explicitMarketingPreference explicitMarketingPreference or {@code null} for none
   */
  public OrderCustomerMarketingRightsInfo setExplicitMarketingPreference(java.lang.String explicitMarketingPreference) {
    this.explicitMarketingPreference = explicitMarketingPreference;
    return this;
  }

  /**
   * Timestamp when last time marketing preference was updated. Could be empty, if user wasn't
   * offered a selection yet.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastUpdatedTimestamp() {
    return lastUpdatedTimestamp;
  }

  /**
   * Timestamp when last time marketing preference was updated. Could be empty, if user wasn't
   * offered a selection yet.
   * @param lastUpdatedTimestamp lastUpdatedTimestamp or {@code null} for none
   */
  public OrderCustomerMarketingRightsInfo setLastUpdatedTimestamp(java.lang.String lastUpdatedTimestamp) {
    this.lastUpdatedTimestamp = lastUpdatedTimestamp;
    return this;
  }

  /**
   * Email address that can be used for marketing purposes. The field may be empty even if
   * `explicitMarketingPreference` is 'granted'. This happens when retrieving an old order from the
   * customer who deleted their account.
   * @return value or {@code null} for none
   */
  public java.lang.String getMarketingEmailAddress() {
    return marketingEmailAddress;
  }

  /**
   * Email address that can be used for marketing purposes. The field may be empty even if
   * `explicitMarketingPreference` is 'granted'. This happens when retrieving an old order from the
   * customer who deleted their account.
   * @param marketingEmailAddress marketingEmailAddress or {@code null} for none
   */
  public OrderCustomerMarketingRightsInfo setMarketingEmailAddress(java.lang.String marketingEmailAddress) {
    this.marketingEmailAddress = marketingEmailAddress;
    return this;
  }

  @Override
  public OrderCustomerMarketingRightsInfo set(String fieldName, Object value) {
    return (OrderCustomerMarketingRightsInfo) super.set(fieldName, value);
  }

  @Override
  public OrderCustomerMarketingRightsInfo clone() {
    return (OrderCustomerMarketingRightsInfo) super.clone();
  }

}
