/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderreturnsRefundOperation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderreturnsRefundOperation extends com.google.api.client.json.GenericJson {

  /**
   * If true, the item will be fully refunded. Allowed only when payment_type is FOP. Merchant can
   * choose this refund option to indicate the full remaining amount of corresponding object to be
   * refunded to the customer via FOP.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean fullRefund;

  /**
   * If this is set, the item will be partially refunded. Merchant can choose this refund option to
   * specify the customized amount that to be refunded to the customer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrderreturnsPartialRefund partialRefund;

  /**
   * The payment way of issuing refund. Default value is ORIGINAL_FOP if not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String paymentType;

  /**
   * The explanation of the reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reasonText;

  /**
   * Code of the refund reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String returnRefundReason;

  /**
   * If true, the item will be fully refunded. Allowed only when payment_type is FOP. Merchant can
   * choose this refund option to indicate the full remaining amount of corresponding object to be
   * refunded to the customer via FOP.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFullRefund() {
    return fullRefund;
  }

  /**
   * If true, the item will be fully refunded. Allowed only when payment_type is FOP. Merchant can
   * choose this refund option to indicate the full remaining amount of corresponding object to be
   * refunded to the customer via FOP.
   * @param fullRefund fullRefund or {@code null} for none
   */
  public OrderreturnsRefundOperation setFullRefund(java.lang.Boolean fullRefund) {
    this.fullRefund = fullRefund;
    return this;
  }

  /**
   * If this is set, the item will be partially refunded. Merchant can choose this refund option to
   * specify the customized amount that to be refunded to the customer.
   * @return value or {@code null} for none
   */
  public OrderreturnsPartialRefund getPartialRefund() {
    return partialRefund;
  }

  /**
   * If this is set, the item will be partially refunded. Merchant can choose this refund option to
   * specify the customized amount that to be refunded to the customer.
   * @param partialRefund partialRefund or {@code null} for none
   */
  public OrderreturnsRefundOperation setPartialRefund(OrderreturnsPartialRefund partialRefund) {
    this.partialRefund = partialRefund;
    return this;
  }

  /**
   * The payment way of issuing refund. Default value is ORIGINAL_FOP if not set.
   * @return value or {@code null} for none
   */
  public java.lang.String getPaymentType() {
    return paymentType;
  }

  /**
   * The payment way of issuing refund. Default value is ORIGINAL_FOP if not set.
   * @param paymentType paymentType or {@code null} for none
   */
  public OrderreturnsRefundOperation setPaymentType(java.lang.String paymentType) {
    this.paymentType = paymentType;
    return this;
  }

  /**
   * The explanation of the reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getReasonText() {
    return reasonText;
  }

  /**
   * The explanation of the reason.
   * @param reasonText reasonText or {@code null} for none
   */
  public OrderreturnsRefundOperation setReasonText(java.lang.String reasonText) {
    this.reasonText = reasonText;
    return this;
  }

  /**
   * Code of the refund reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getReturnRefundReason() {
    return returnRefundReason;
  }

  /**
   * Code of the refund reason.
   * @param returnRefundReason returnRefundReason or {@code null} for none
   */
  public OrderreturnsRefundOperation setReturnRefundReason(java.lang.String returnRefundReason) {
    this.returnRefundReason = returnRefundReason;
    return this;
  }

  @Override
  public OrderreturnsRefundOperation set(String fieldName, Object value) {
    return (OrderreturnsRefundOperation) super.set(fieldName, value);
  }

  @Override
  public OrderreturnsRefundOperation clone() {
    return (OrderreturnsRefundOperation) super.clone();
  }

}
