/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo extends com.google.api.client.json.GenericJson {

  /**
   * The carrier handling the shipment. See `shipments[].carrier` in the  Orders resource
   * representation for a list of acceptable values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrier;

  /**
   * Required. The ID of the shipment. This is assigned by the merchant and is unique to each
   * shipment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shipmentId;

  /**
   * The tracking ID for the shipment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String trackingId;

  /**
   * The carrier handling the shipment. See `shipments[].carrier` in the  Orders resource
   * representation for a list of acceptable values.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrier() {
    return carrier;
  }

  /**
   * The carrier handling the shipment. See `shipments[].carrier` in the  Orders resource
   * representation for a list of acceptable values.
   * @param carrier carrier or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo setCarrier(java.lang.String carrier) {
    this.carrier = carrier;
    return this;
  }

  /**
   * Required. The ID of the shipment. This is assigned by the merchant and is unique to each
   * shipment.
   * @return value or {@code null} for none
   */
  public java.lang.String getShipmentId() {
    return shipmentId;
  }

  /**
   * Required. The ID of the shipment. This is assigned by the merchant and is unique to each
   * shipment.
   * @param shipmentId shipmentId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo setShipmentId(java.lang.String shipmentId) {
    this.shipmentId = shipmentId;
    return this;
  }

  /**
   * The tracking ID for the shipment.
   * @return value or {@code null} for none
   */
  public java.lang.String getTrackingId() {
    return trackingId;
  }

  /**
   * The tracking ID for the shipment.
   * @param trackingId trackingId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo setTrackingId(java.lang.String trackingId) {
    this.trackingId = trackingId;
    return this;
  }

  @Override
  public OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo set(String fieldName, Object value) {
    return (OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo) super.set(fieldName, value);
  }

  @Override
  public OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo clone() {
    return (OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo) super.clone();
  }

}
